/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProductLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTDataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserIdentity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserUniqueSecurityName;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.DataSourceProjectLocales;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.MetadataCacheContext;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTAdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTOIDCAccessTokenParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTOIDCIdTokenParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTPasswordParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerNameParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerPortParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerProtocolParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTUserNameParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTCubeCache;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientConfig;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientFactory;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class TM1RESTConnection
extends DefaultConnection {
    public static final String DEF_SCHEMA_HTTP = "http";
    public static final int DEF_PORT = 8001;
    private static final String UNKNOWN_USER_NAME = "unknown";
    private static final String KEY_SEPARATOR = ":";
    private RESTClient mRestClient;
    private int mConnectionID = 0;
    private String mServerAdminHost = null;
    private String mServerName = null;
    private String mServerProtocol = null;
    private int mServerPort = 8001;
    private String mSessionProperties = null;
    private Locale mProductLocale = null;
    private String mUserIdentity = null;
    private Locale mRunLocale = null;
    private static final String USE_FILLER_MEMBER = "HierarchyUseFillerMember=1";
    private static final String USE_FILLER_MEMBER_KEY = "queryExecution.hierarchyUseFillerMember[@value]";
    private boolean validationReq = false;
    boolean bConnectionStatus = true;
    private final MetadataCacheContext mMetadataCacheContext;
    private final TM1RESTCubeCache mCubeCache = new TM1RESTCubeCache(this);
    private static final String SERVER_ID_KEY = "%s:%s:%%s:%s";
    private static final String SERVER_PORT_KEY = "%s:%s";
    private final String mAdminServerKey;
    private final String mServerPortKey;

    public TM1RESTConnection(TM1RESTDataProvider theDataProvider, ConnectionParameters parameters) {
        super((IOLAPDataProvider)theDataProvider);
        this.setConnectionParameters(parameters);
        int portNumber = parameters.intValueOf(TM1RESTServerPortParameter.class, 8001);
        this.mConnectionID = System.identityHashCode((Object)this);
        this.mServerName = this.getParameter(TM1RESTServerNameParameter.class);
        this.mServerAdminHost = this.getParameter(TM1RESTAdminHostParameter.class);
        this.mServerPort = portNumber;
        if (-2 == portNumber) {
            try {
                URI uri = new URI((String)parameters.valueOf(TM1RESTAdminHostParameter.class, String.class));
                this.mServerProtocol = uri.getScheme();
            }
            catch (Exception e) {
                throw new TM1RESTODPException(e);
            }
        } else {
            this.mServerProtocol = this.getParameter(TM1RESTServerProtocolParameter.class, DEF_SCHEMA_HTTP);
        }
        this.mProductLocale = this.getProductLocale();
        this.mRunLocale = this.getRunLocale();
        this.mUserIdentity = this.getParameter(CMUserIdentity.class);
        String userGroups = this.getParameter(UserClassIDsParameter.class);
        this.mAdminServerKey = String.format(SERVER_ID_KEY, this.mServerAdminHost, this.mServerPort, userGroups);
        this.mServerPortKey = String.format(SERVER_PORT_KEY, this.mServerAdminHost, this.mServerPort);
        List<String> dsProjectLocales = (List<String>)parameters.valueOf(DataSourceProjectLocales.class);
        if (null == dsProjectLocales) {
            dsProjectLocales = Collections.singletonList(this.mRunLocale.toLanguageTag());
        }
        this.mMetadataCacheContext = new MetadataCacheContext(this.mCubeCache, dsProjectLocales, this.mRunLocale.toLanguageTag());
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        this.updateConnectionTime();
        this.connect(parameters);
        String userName = this.getParameter(TM1RESTUserNameParameter.class, UNKNOWN_USER_NAME);
        String password = this.getParameter(TM1RESTPasswordParameter.class);
        String aCAMPassport = ((RequestEnvironment)env.getRequestEnvironment()).getCAMPassport();
        String aCAMCryptoHandle = this.getParameter(CAMCryptoHandleParameter.class);
        String oidcIdToken = this.getParameter(TM1RESTOIDCIdTokenParameter.class);
        TM1RESTOIDCAccessTokenParameter oidcAccessTokenParam = (TM1RESTOIDCAccessTokenParameter)parameters.get(TM1RESTOIDCAccessTokenParameter.class);
        IEncryptedObject oidcAccessToken = null;
        if (oidcAccessTokenParam != null) {
            oidcAccessToken = (IEncryptedObject)oidcAccessTokenParam.value();
        }
        String userIdentityName = "";
        CMUserIdentity cmUserIdentity = (CMUserIdentity)parameters.get(CMUserIdentity.class);
        if (cmUserIdentity != null) {
            if (-2 == portNumber) {
                userIdentityName = CMUserIdentity.getUserName((IExecutionEnvironment)env);
            }
            if (null == userIdentityName || userIdentityName.isEmpty()) {
                userIdentityName = cmUserIdentity.getDefaultName();
            }
        }
        String userUniqueSecurityName = "";
        CMUserUniqueSecurityName cmUserUniqueSecurityName = (CMUserUniqueSecurityName)parameters.get(CMUserUniqueSecurityName.class);
        if (cmUserUniqueSecurityName != null) {
            userUniqueSecurityName = cmUserUniqueSecurityName.getUniqueSecurityName();
        }
        this.mRestClient.setAuthorizationParameters(userName, password, userIdentityName, aCAMPassport, aCAMCryptoHandle, oidcIdToken, (IEncryptedObject<String>)oidcAccessToken, userUniqueSecurityName);
        TM1RESTServerSecurity.SecurityMode securityMode = TM1RESTServerSecurity.getStaticTM1ServerSecurityMode(parameters);
        this.mRestClient.getConfig().setIntegratedSecurityMode(securityMode);
        this.updateConnectionTime();
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_LOG_ON_OFF, LogLevel.TRACE, "[CONNECTION_ID=%d] Established a [%s] TM1 connection with host [%s]://[%s]:[%d], '[%s]' user='[%s]' identity='[%s]' CAMPassport='[%s]'. Connection parameters= '[%s]'.", this.mConnectionID, this.getServer().getSecurityMode().toString(), this.mServerProtocol, this.mServerAdminHost, this.mServerPort, this.mServerName, userName, userIdentityName, aCAMPassport, parameters.toString());
    }

    public void close() {
        if (null != this.mRestClient) {
            this.mRestClient.closeTM1Session();
            this.mRestClient.close();
            this.mRestClient = null;
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_LOG_ON_OFF, LogLevel.TRACE, "[CONNECTION_ID=%d] Closed a TM1 REST connection with host [%s] and server [%s].", this.mConnectionID, this.mServerAdminHost, this.mServerName);
    }

    private void addHierarchyUseFillerMember() {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (config.getBooleanProperty(USE_FILLER_MEMBER_KEY, false)) {
            this.mSessionProperties = this.mSessionProperties + USE_FILLER_MEMBER;
        }
    }

    protected void connect(ConnectionParameters parameters) {
        this.mSessionProperties = "";
        this.addHierarchyUseFillerMember();
        RESTClientConfig restClientConfig = new RESTClientConfig(this.mServerProtocol, this.mServerAdminHost, this.mServerPort, this.mRunLocale, this.mProductLocale, parameters);
        this.mRestClient = RESTClientFactory.getInstance().getClient(restClientConfig);
    }

    final String getParameter(Class<? extends IConnectionParameter<?>> parameterType, String def) {
        ConnectionParameters parameters = this.getConnectionParameters();
        String value = (String)parameters.valueOf(parameterType, String.class);
        if (value == null || value.length() == 0) {
            value = def;
        }
        return value;
    }

    final String getParameter(Class<? extends IConnectionParameter<?>> parameterType) {
        return this.getParameter(parameterType, "");
    }

    final Locale getProductLocale() {
        ConnectionParameters parameters = this.getConnectionParameters();
        return (Locale)parameters.valueOf(ProductLocaleParameter.class, Locale.class);
    }

    final Locale getRunLocale() {
        ConnectionParameters parameters = this.getConnectionParameters();
        return (Locale)parameters.valueOf(RunLocaleParameter.class, Locale.class);
    }

    public RESTClient getServer() {
        return this.mRestClient;
    }

    public Object[] getContext() {
        return new Object[]{this.mMetadataCacheContext};
    }

    public boolean isValid() {
        boolean isValid = null != this.mRestClient;
        this.validationReq = false;
        return isValid;
    }

    public void setValidationOn() {
        this.validationReq = true;
    }

    public boolean needValidation() {
        return this.validationReq;
    }

    public boolean isCubeLoaded() {
        return this.mMetadataCacheContext.isCubeLoaded();
    }

    public String getServerAdminHost() {
        return this.mServerAdminHost;
    }

    public String getServerName() {
        return this.mServerName;
    }

    public int getmServerPort() {
        return this.mServerPort;
    }

    public Locale getProductLocale1() {
        return this.mProductLocale;
    }

    public String getUserIdentity() {
        return this.mUserIdentity;
    }

    public List<XQEMessage> getConnectionDetails() {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        ODataUriBuilder uriBuilder = this.mRestClient.getUriBuilder();
        uriBuilder.entity("Configuration");
        IJsonObject config = this.mRestClient.getJsonResource(uriBuilder.toString(), env);
        String serverName = config.getStringValue("ServerName");
        String host = config.getStringValue("AdminHost");
        String version = config.getStringValue("ProductVersion");
        return this.checkAndGetDetails("TM1 Server Name: " + serverName, version, "TM1 Admin Host: " + host, version);
    }

    public List<XQEMessage> getConnectionBlackListDetails() {
        return Collections.emptyList();
    }

    public final TM1RESTCubeCache getCubeCache() {
        return this.mCubeCache;
    }

    public static boolean securityModeHasUserGroups(ConnectionParameters parameters) {
        TM1RESTServerSecurity.SecurityMode mode = TM1RESTServerSecurity.getStaticTM1ServerSecurityMode(parameters);
        return TM1RESTConnection.securityModeHasUserGroups(mode, parameters);
    }

    public final String getAdminServerKey(String cubeName, List<String> packageLocales) {
        StringBuilder keyBuilder = new StringBuilder(String.format(this.mAdminServerKey, cubeName));
        keyBuilder.append(KEY_SEPARATOR).append(String.join((CharSequence)KEY_SEPARATOR, packageLocales));
        return keyBuilder.toString();
    }

    public final String getServerPortKey() {
        return this.mServerPortKey;
    }

    private static boolean securityModeHasUserGroups(TM1RESTServerSecurity.SecurityMode mode, ConnectionParameters parameters) {
        String adminHost = (String)parameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        int port = parameters.intValueOf(TM1RESTServerPortParameter.class, 8001);
        switch (mode) {
            case BASIC: 
            case OAUTH2: {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "User groups for the host [%s] and port [%d] mode [%s] is not supported.", adminHost, port, mode.toString());
                return false;
            }
            case MIXED_BASIC: 
            case MIXED_WIA: {
                String ssoDelegationHandle = (String)parameters.valueOf(CAMCryptoHandleParameter.class, String.class);
                if (ssoDelegationHandle != null) break;
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "User groups for the host [%s] and port [%d] mode [%s] is unsupported.", adminHost, port, mode.toString());
                return false;
            }
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "User groups for the host [%s] and port [%d] mode [%s] is supported.", adminHost, port, mode.toString());
        return true;
    }

    public static UserClassIDsParameter addStaticUserGroups(ConnectionParameters params) {
        ExecutionEnvironment env = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        String userGroups = TM1RESTServerSecurity.getCachedTM1ServerUserGroups(params, (IExecutionEnvironment)env);
        UserClassIDsParameter userClassIdsParameter = null;
        if (null != userGroups && !userGroups.isEmpty()) {
            userClassIdsParameter = new UserClassIDsParameter(userGroups);
            params.put((IConnectionParameter)userClassIdsParameter);
        }
        return userClassIdsParameter;
    }
}

