/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTDataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.TrustKnownSelfSignedStrategy;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.trace.LogLevel;
import java.security.KeyStoreException;
import java.util.List;

public class TM1RESTConnectionFactory
implements IConnectionFactory {
    private TM1RESTDataProvider dataProvider;

    public TM1RESTConnectionFactory(TM1RESTDataProvider provider) {
        this.dataProvider = provider;
        try {
            TrustKnownSelfSignedStrategy.loadDefaultKeyStore();
        }
        catch (KeyStoreException e) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory(): failed to load certificates. %s", e.getLocalizedMessage());
        }
        Long maxHttpConnections = this.getMaxHttpConnections();
        Long maxPerRouteHttpConnections = this.getMaxPerRouteHttpConnections();
        RESTClientFactory.getInstance().startup(maxHttpConnections.intValue(), maxPerRouteHttpConnections.intValue());
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1RESTConnectionFactory(): constructed with maximum number of connections %d", maxHttpConnections);
    }

    public void destroyConnection(IPooledConnection pooledConnection) {
        this.destroyConnection((TM1RESTConnection)((Object)pooledConnection.getConnection()));
    }

    public void destroyConnection(TM1RESTConnection connection) {
        if (null == connection) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1RESTConnectionFactory.destroyConnection(): There is no connection to destroy.", new Object[0]);
        } else {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1RESTConnectionFactory.destroyConnection(): %s.", connection.toString());
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createConnection(ConnectionParameters connectionParameters) {
        TM1RESTConnection connection;
        block11: {
            block10: {
                connection = null;
                try {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1RESTConnectionFactory.createConnection(): attempting to create a connection.", new Object[0]);
                    connection = new TM1RESTConnection(this.dataProvider, connectionParameters);
                    if (null != connection) break block10;
                }
                catch (Throwable throwable) {
                    if (null == connection) {
                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): failed.", new Object[0]);
                    } else {
                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): passed %s.", connection.toString());
                        List<XQEMessage> blackList = connection.getConnectionBlackListDetails();
                        if (blackList != null && !blackList.isEmpty()) {
                            this.destroyConnection(connection);
                            connection = null;
                            XQEMessage message = blackList.get(0);
                            if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The driver version %s is black listed.", message.getParams()[0]);
                                throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                            }
                            if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The server version %s is black listed.", message.getParams()[1]);
                                throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                            }
                            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
                        }
                    }
                    throw throwable;
                }
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): failed.", new Object[0]);
                break block11;
            }
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.TRACE, "TM1ConnectionFactory.createConnection(): passed %s.", connection.toString());
            List<XQEMessage> blackList = connection.getConnectionBlackListDetails();
            if (blackList != null && !blackList.isEmpty()) {
                this.destroyConnection(connection);
                connection = null;
                XQEMessage message = blackList.get(0);
                if (XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI == message.getMessageKey()) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The driver version %s is black listed.", message.getParams()[0]);
                    throw new XQERuntimeException(XQEMessageKeys.DS_DriverBlacklistedTestConnectionUI, message.getParams()[0], message.getParams()[1]);
                }
                if (XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2 == message.getMessageKey()) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_FACTORY, LogLevel.ERROR, "TM1ConnectionFactory.createConnection(): The server version %s is black listed.", message.getParams()[1]);
                    throw new XQERuntimeException(XQEMessageKeys.DS_ServerBlacklistedTestConnectionUI2, message.getParams()[0], message.getParams()[1]);
                }
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        return connection;
    }

    private long getMaxHttpConnections() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return xqeConfiguration.getLongProperty("queryExecution.maxTM1RESTHttpConnections[@value]", 256L);
    }

    private long getMaxPerRouteHttpConnections() {
        XQEConfiguration xqeConfiguration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return xqeConfiguration.getLongProperty("queryExecution.maxPerRouteTM1RESTHttpConnections[@value]", -1L);
    }

    public void dispose() {
        RESTClientFactory.getInstance().shutdown();
    }
}

