/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderEnvironmentHelper;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTDataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTUserNameParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;

public class TM1RESTMetadataProvider
extends MetadataProviderEnvironmentHelper<TM1RESTConnection>
implements IOLAPMetadataProvider {
    private final Locale mLocale;

    public TM1RESTMetadataProvider(TM1RESTDataProvider tm1DataProvider, Locale locale, ConnectionParameters connParams) {
        super((OLAPDataProviderBase)tm1DataProvider, connParams);
        this.mLocale = locale;
    }

    public void releaseImpl() {
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        return null;
    }

    protected List<CatalogRecord> getCatalogs(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.CATALOGS, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getCatalogRecords(restrictions);
    }

    protected List<CubeRecord> getCubes(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.CUBES, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getCubeRecords(restrictions);
    }

    protected List<DimensionRecord> getDimensions(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.DIMENSIONS, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getDimensionRecords(restrictions);
    }

    protected List<HierarchyRecord> getHierarchies(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.HIERARCHIES, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getHierarchyRecords(restrictions);
    }

    protected List<MemberRecord> getHierarchyRootMembers(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.HIERARCHYROOTMEMBERS, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getHierarchyRootMemberRecords(restrictions);
    }

    protected List<LevelRecord> getLevels(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.LEVELS, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getLevelRecords(restrictions);
    }

    protected String getCubeDefaultMeasure(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.CUBEDEFAULTMEASURE, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getCubeDefaultMeasure(restrictions);
    }

    protected List<MemberRecord> getMembers(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.MEMBERS, (IRestrictions)restrictions);
        String mun = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        if (mun == null && treeOps != null && !treeOps.isEmpty()) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.MEMBER_UNIQUE_NAME.toString());
        }
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getMemberRecords(restrictions);
    }

    protected List<MeasureRecord> getMeasures(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.MEASURES, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getMeasureRecords(restrictions);
    }

    public List<AliasRecord> getAliases(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    protected List<PropertyRecord> getProperties(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.PROPERTIES, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getPropertyRecords(restrictions);
    }

    private boolean isRestrictionContainsCatalog(IRestrictions restrictions) {
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG, null);
        return catalogName == null;
    }

    public List<ActionRecord> getActions(IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.ACTIONS, (IRestrictions)restrictions);
        return Collections.emptyList();
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<NamedSetRecord> getNamedSets(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public List<HierarchyNamedSetRecord> getHierarchyNamedSets(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        if (configuration.getBooleanProperty("queryExecution.loadHierarchyNamedSets[@enabled]", true)) {
            TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.HIERARCHYNAMEDSETS, (IRestrictions)restrictions);
            TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
            return handler.getHierarchyNamedSetRecords(restrictions);
        }
        return Collections.emptyList();
    }

    protected List<MemberRecord> getNamedSetMembers(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.NAMEDSETS, (IRestrictions)restrictions);
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.NAMEDSETMEMBERS, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getNamedSetMemberRecords(restrictions);
    }

    public List<String> getNamedSetLevelUniqueNames(ExecutionEnvironment executionEnvironment, TM1RESTConnection connection, IRestrictions restrictions) {
        if (!this.isRestrictionContainsCatalog(restrictions)) {
            restrictions.add(RestrictionType.CATALOG, (Object)"CATALOG");
        }
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.NAMEDSETS, (IRestrictions)restrictions);
        TM1RESTMetadataProvider.validateRequiredRestrictions((MetadataOperation)MetadataOperation.NAMEDSETLEVELUNIQUENAMES, (IRestrictions)restrictions);
        TM1RESTMetadataSession handler = new TM1RESTMetadataSession(connection, this.mLocale, executionEnvironment);
        return handler.getNamedSetLevelUniqueNames(restrictions);
    }

    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    public SALContext getMetadataQueryContext(ExecutionEnvironment theEexecutionEnvironment, TM1RESTConnection connection, String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        String securityContext = null;
        ConnectionParameters connParams = connection.getConnectionParameters();
        String dim = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        TM1RESTUserNameParameter userNameParam = (TM1RESTUserNameParameter)connParams.get(TM1RESTUserNameParameter.class);
        String uId = null;
        if (userNameParam != null) {
            uId = (String)userNameParam.value();
        }
        if (uId == null) {
            CAMPassportParameter paramCamPassport = (CAMPassportParameter)connParams.get(CAMPassportParameter.class);
            uId = (String)paramCamPassport.value();
        }
        String userGroupList = uId;
        if (TM1RESTConnection.securityModeHasUserGroups(connParams)) {
            userGroupList = (String)((UserClassIDsParameter)connParams.get(UserClassIDsParameter.class)).value();
        }
        int secContexMode3 = 3;
        securityContext = securityContextMode == 3 ? (dim == null ? uId : (userGroupList != null ? userGroupList : uId)) : (securityContextMode == 2 ? (userGroupList != null ? userGroupList : uId) : uId);
        return new SALContext(securityContext, null, null);
    }

    public boolean isReplacementVariableUsedFor(IRestrictions restrictions) {
        return false;
    }
}

