/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.connection;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.ICAMCryptoSignon;
import com.cognos.xqe.data.model.ICombinedSignon;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.IDataSourceConnectionSignon;
import com.cognos.xqe.data.model.IOIDCSignon;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.ProviderManager;
import com.cognos.xqe.data.providers.connection.ConnectionStringParser;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProductLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserIdentity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserUniqueSecurityName;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.DataSourceProjectLocales;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.DataSourceTypeParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.ModelPathParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTAdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTNameSpaceParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTOIDCAccessTokenParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTOIDCIdTokenParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTPasswordParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerNameParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerPortParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerProtocolParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTUserNameParameter;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.dom4j.Element;

public final class ConnectionParameterHelper {
    private static final String CAMID_PREFIX = "CAMID(\"";
    private static final String CAMID_SUFFIX = "\")";
    public static final String DOM_REQUEST_ID = "requestID";
    private static final String DOM_VALUE = "value";
    private static final String DOM_CONNECTION = "connection";
    private static final String DOM_PASSWORD = "password";
    private static final String DOM_USERNAME = "username";
    private static final String DOM_DATA_SOURCE_TYPE = "dataSourceType";
    private static final String DOM_CATALOG = "catalog";
    private static final String DOM_CUBE = "cube";
    private static final String DOM_CAM_PASSPORT = "CAMPassport";
    private static final String DOM_SSO_DELEGATION_HANDLE = "SSODelegationHandle";
    private static final String DOM_PROD_LOCALE = "productLocale";
    private static final String DOM_RUN_LOCALE = "runLocale";
    private static final String DOM_USERCLASSIDS = "userClassIds";
    private static final String DOM_TM1_ADMIN_HOST = "TM1AdminHost";
    private static final String DOM_TM1_SERVER_NAME = "TM1ServerName";
    private static final String DOM_TM1_PROTOCOL = "TM1Protocol";
    private static final String DOM_TM1_SERVER_PORT = "TM1ServerPort";
    private static final String DOM_NAMESPACE = "namespace";
    private static final String DOM_DATA_SOURCE = "dataSource";
    private static final String DOM_MODEL_PATH = "modelPath";

    public static ConnectionParameters constructConnectionParameters(ExecutionEnvironment env, Element connectionElement, IDataSource dataSource, Locale runLocale) {
        ConnectionParameters params = ConnectionParameterHelper.constructConnectionParametersHelper(env, connectionElement, dataSource, runLocale);
        TM1RESTServerSecurity.SecurityMode securityMode = TM1RESTServerSecurity.getStaticTM1ServerSecurityMode(params);
        if (TM1RESTServerSecurity.SecurityMode.CAM != securityMode && "TMR".equals(dataSource.getType())) {
            ConnectionParameterHelper.resolveSignon(dataSource.getType(), dataSource.getDataSourceConnection().getSignon(), params, env);
        } else {
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.setConnectionParameter("SkipSignons", (Object)true);
        }
        return params;
    }

    private static void resolveMetadataProperties(IDataSource dataSource, ConnectionParameters params) {
        Object catalogName;
        Map properties = dataSource.getMetadataProperties();
        Object cubeName = properties.get(DOM_CUBE);
        if (cubeName != null) {
            params.put((IConnectionParameter)new CubeParameter(String.valueOf(cubeName), false));
        }
        if ((catalogName = properties.get(DOM_CATALOG)) != null) {
            params.put((IConnectionParameter)new CatalogParameter(String.valueOf(catalogName), false));
        }
    }

    private static void resolveNameSpace(IDataSource dataSource, ConnectionParameters params) {
        String nameSpaceString = dataSource.getDataSourceConnection().getNamespace();
        if (nameSpaceString != null) {
            if (nameSpaceString.startsWith(CAMID_PREFIX) && nameSpaceString.endsWith(CAMID_SUFFIX)) {
                params.put((IConnectionParameter)new TM1RESTNameSpaceParameter(nameSpaceString.substring(CAMID_PREFIX.length(), nameSpaceString.length() - CAMID_SUFFIX.length())));
            } else {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_PARAMETERS, LogLevel.WARN, "Unexpected namespace format in connection string [%s], expected 'namespace=CAMID(\"XXXXX\")'.", dataSource.getDataSourceConnection().getConnectionString(null));
                params.put((IConnectionParameter)new TM1RESTNameSpaceParameter(nameSpaceString));
            }
        }
    }

    public static ConnectionParameters constructConnectionParametersHelper(ExecutionEnvironment env, Element connectionElement, IDataSource dataSource, Locale runLocale) {
        ConnectionParameters params = new ConnectionParameters();
        ConnectionParameterHelper.resolveMetadataProperties(dataSource, params);
        ConnectionParameterHelper.resolveConnectionString(dataSource, params);
        ConnectionParameterHelper.resolveNameSpace(dataSource, params);
        if (connectionElement != null) {
            ConnectionParameterHelper.resolveConnectionElement(dataSource, connectionElement, params, false);
        }
        ConnectionParameterHelper.resolveLocales(env, runLocale, params);
        CAMPassportParameter.resolveCAMPassport((IExecutionEnvironment)env, (ConnectionParameters)params, (boolean)false);
        CMUserIdentity.resolveCMUserIdentity((IExecutionEnvironment)env, params, false);
        CMUserUniqueSecurityName.resolveCMUserUniqueSecurityName((IExecutionEnvironment)env, params, false);
        ConnectionParameterHelper.resolveModelPath(dataSource, env, params);
        params.put((IConnectionParameter)new DataSourceParameter(dataSource));
        Set keySet = (Set)dataSource.getMetadataProperties().get("project_locales");
        if (keySet != null) {
            ArrayList<String> projectLocales = new ArrayList<String>(keySet);
            params.put((IConnectionParameter)new DataSourceProjectLocales(projectLocales));
        }
        return params;
    }

    private static void resolveLocales(ExecutionEnvironment env, Locale runLocale, ConnectionParameters params) {
        Locale productLocale;
        if (env == null) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        if (runLocale != null) {
            params.put((IConnectionParameter)new RunLocaleParameter(runLocale, false));
        }
        if ((productLocale = ((RequestEnvironment)env.getRequestEnvironment()).getProductLocale()) != null) {
            params.put((IConnectionParameter)new ProductLocaleParameter(productLocale, false));
        }
    }

    private static void resolveSignon(String providerType, IDataSourceConnectionSignon signon, ConnectionParameters params, ExecutionEnvironment execEnv) {
        if (null != signon) {
            if (signon.getType() == IDataSourceConnectionSignon.SignonType.COMBINED) {
                IDataSourceConnectionSignon[] signons;
                for (IDataSourceConnectionSignon aSignon : signons = ((ICombinedSignon)signon).getSignons()) {
                    ConnectionParameterHelper.resolveSignon(providerType, aSignon, params, execEnv);
                }
            } else if (signon.getType() == IDataSourceConnectionSignon.SignonType.USERNAME_PASSWORD) {
                IUsernamePasswordSignon userPasswordSignon = (IUsernamePasswordSignon)signon;
                params.put((IConnectionParameter)new TM1RESTUserNameParameter(userPasswordSignon.getUserName()));
                params.put((IConnectionParameter)new TM1RESTPasswordParameter((IEncryptedObject<String>)userPasswordSignon.getPassword()));
            } else if (signon.getType() == IDataSourceConnectionSignon.SignonType.CAMCRYPTO) {
                ICAMCryptoSignon camCryptoSignon = (ICAMCryptoSignon)signon;
                params.put((IConnectionParameter)new CAMCryptoHandleParameter(camCryptoSignon.getCryptoHandle()));
            } else if (signon.getType() == IDataSourceConnectionSignon.SignonType.OIDC) {
                IOIDCSignon oidcSignon = (IOIDCSignon)signon;
                params.put((IConnectionParameter)new TM1RESTOIDCIdTokenParameter((IEncryptedObject<String>)oidcSignon.getIdToken()));
                params.put((IConnectionParameter)new TM1RESTOIDCAccessTokenParameter((IEncryptedObject<String>)oidcSignon.getAccessToken()));
            } else {
                throw new TM1RESTODPException(TM1RESTMessageKeys.CON_UNSUPPORTED_SIGNON_TYPE, signon.getType().toString());
            }
        }
    }

    private static void resolveModelPath(IDataSource dataSource, ExecutionEnvironment env, ConnectionParameters params) {
        if (!params.contains(ModelPathParameter.class)) {
            if (env == null) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            String modelPath = ((RequestEnvironment)env.getRequestEnvironment()).getModelPath();
            if (modelPath == null) {
                modelPath = ((RequestEnvironment)env.getRequestEnvironment()).getModelPathFromRequestDocument();
            }
            if (modelPath != null) {
                params.put((IConnectionParameter)new ModelPathParameter(modelPath, false));
            }
        }
    }

    private static void resolveConnectionString(IDataSource dataSource, final ConnectionParameters params) {
        String connectionString = dataSource.getDataSourceConnection().getConnectionString(null);
        if (connectionString != null) {
            ConnectionStringParser.parse((String)connectionString, (ConnectionStringParser.TokenHandler)new ConnectionStringParser.TokenHandler(){
                private ProviderManager.ProviderInfo providerInfo = null;

                public void onSimpleToken(String value) {
                    if (value.equals("TMR")) {
                        this.providerInfo = ProviderManager.getInstance().getProviderInfo(value);
                        if (this.providerInfo != null) {
                            params.put((IConnectionParameter)new DataSourceTypeParameter(this.providerInfo.getProviderName()));
                        }
                    }
                }

                public void onKeyValueToken(String key, String value) {
                    if (this.providerInfo != null) {
                        if (key.equals(ConnectionParameterHelper.DOM_TM1_ADMIN_HOST)) {
                            params.put((IConnectionParameter)new TM1RESTAdminHostParameter(value));
                        } else if (key.equals(ConnectionParameterHelper.DOM_TM1_SERVER_NAME)) {
                            params.put((IConnectionParameter)new TM1RESTServerNameParameter(value));
                        } else if (key.equals(ConnectionParameterHelper.DOM_TM1_SERVER_PORT)) {
                            int port = -1;
                            try {
                                port = Integer.parseInt(value);
                            }
                            catch (NumberFormatException e) {
                                port = -1;
                            }
                            params.put((IConnectionParameter)new TM1RESTServerPortParameter(port));
                        } else if (key.equals(ConnectionParameterHelper.DOM_TM1_PROTOCOL)) {
                            params.put((IConnectionParameter)new TM1RESTServerProtocolParameter(value));
                        }
                    }
                }
            });
        }
    }

    private static void resolveConnectionElement(IDataSource dataSource, Element connectionElement, ConnectionParameters params, boolean matchablePassport) {
        if (DOM_CONNECTION.equals(connectionElement.getName())) {
            Iterator itr = connectionElement.elementIterator();
            while (itr.hasNext()) {
                Element element = (Element)itr.next();
                String name = element.getName();
                String value = element.attributeValue(DOM_VALUE);
                if (name == null || value == null) continue;
                if (name.equals(DOM_DATA_SOURCE) && !params.contains(ModelPathParameter.class)) {
                    params.put((IConnectionParameter)new ModelPathParameter(value, false));
                    continue;
                }
                if (name.equals(DOM_CATALOG) && !params.contains(CatalogParameter.class)) {
                    params.put((IConnectionParameter)new CatalogParameter(value, false));
                    continue;
                }
                if (name.equals(DOM_CUBE) && !params.contains(CubeParameter.class)) {
                    params.put((IConnectionParameter)new CubeParameter(value, false));
                    continue;
                }
                if (name.equals(DOM_CAM_PASSPORT) && !params.contains(CAMPassportParameter.class)) {
                    params.put((IConnectionParameter)new CAMPassportParameter(value, matchablePassport));
                    continue;
                }
                if (name.equals(DOM_DATA_SOURCE_TYPE) && !params.contains(DataSourceTypeParameter.class)) {
                    params.put((IConnectionParameter)new DataSourceTypeParameter(value));
                    continue;
                }
                if (name.equals(DOM_PROD_LOCALE) && !params.contains(ProductLocaleParameter.class)) {
                    params.put((IConnectionParameter)new ProductLocaleParameter(LocaleConverter.strToLocale((String)value), false));
                    continue;
                }
                if (name.equals(DOM_RUN_LOCALE) && !params.contains(RunLocaleParameter.class)) {
                    params.put((IConnectionParameter)new RunLocaleParameter(LocaleConverter.strToLocale((String)value), false));
                    continue;
                }
                if (name.equals(DOM_TM1_ADMIN_HOST) && !params.contains(TM1RESTAdminHostParameter.class)) {
                    params.put((IConnectionParameter)new TM1RESTAdminHostParameter(value));
                    continue;
                }
                if (name.equals(DOM_TM1_SERVER_NAME) && !params.contains(TM1RESTServerNameParameter.class)) {
                    params.put((IConnectionParameter)new TM1RESTServerNameParameter(value));
                    continue;
                }
                if (name.equals(DOM_TM1_SERVER_PORT) && !params.contains(TM1RESTServerPortParameter.class)) {
                    params.put((IConnectionParameter)new TM1RESTServerPortParameter(Integer.parseInt(value)));
                    continue;
                }
                if (name.equals(DOM_TM1_PROTOCOL) && !params.contains(TM1RESTServerProtocolParameter.class)) {
                    params.put((IConnectionParameter)new TM1RESTServerProtocolParameter(value));
                    continue;
                }
                if (!name.equals(DOM_NAMESPACE) || params.contains(TM1RESTNameSpaceParameter.class)) continue;
                params.put((IConnectionParameter)new TM1RESTNameSpaceParameter(value));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(ConnectionParameters params, StringBuilder buffer, boolean forLogging) throws Exception {
        try (XMLStreamWriter writer = null;){
            StringWriter strWriter = new StringWriter();
            writer = StaxUtil.createXMLStreamWriter((Writer)strWriter);
            ConnectionParameterHelper.writeXML(params, writer, forLogging);
            writer.flush();
            buffer.append(strWriter.getBuffer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeXML(ConnectionParameters params, StringBuffer buffer, boolean forLogging) throws Exception {
        try (XMLStreamWriter writer = null;){
            StringWriter strWriter = new StringWriter();
            writer = StaxUtil.createXMLStreamWriter((Writer)strWriter);
            ConnectionParameterHelper.writeXML(params, writer, forLogging);
            writer.flush();
            buffer.append(strWriter.getBuffer());
        }
    }

    public static void writeXML(ConnectionParameters params, XMLStreamWriter writer, boolean forLogging) throws XMLStreamException {
        writer.writeStartElement(DOM_CONNECTION);
        for (IConnectionParameter param : params) {
            Class<?> paramType = param.getClass();
            Object value = param.value();
            if (null == value) continue;
            if (value instanceof IEncryptedObject) {
                value = ((IEncryptedObject)value).decrypt();
            }
            if (forLogging && !param.isLoggable()) {
                value = "*****";
            }
            if (ModelPathParameter.class == paramType) {
                writer.writeEmptyElement(DOM_MODEL_PATH);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (DataSourceTypeParameter.class == paramType) {
                writer.writeEmptyElement(DOM_DATA_SOURCE_TYPE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (TM1RESTAdminHostParameter.class == paramType) {
                writer.writeEmptyElement(DOM_TM1_ADMIN_HOST);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (TM1RESTServerNameParameter.class == paramType) {
                writer.writeEmptyElement(DOM_TM1_SERVER_NAME);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CAMPassportParameter.class == paramType) {
                writer.writeEmptyElement(DOM_CAM_PASSPORT);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CAMCryptoHandleParameter.class == paramType) {
                writer.writeEmptyElement(DOM_SSO_DELEGATION_HANDLE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (UserClassIDsParameter.class == paramType) {
                writer.writeEmptyElement(DOM_USERCLASSIDS);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (RunLocaleParameter.class == paramType) {
                writer.writeEmptyElement(DOM_RUN_LOCALE);
                writer.writeAttribute(DOM_VALUE, ConnectionParameterHelper.getNormalizedLocaleString((Locale)value));
                continue;
            }
            if (ProductLocaleParameter.class == paramType) {
                writer.writeEmptyElement(DOM_PROD_LOCALE);
                writer.writeAttribute(DOM_VALUE, ConnectionParameterHelper.getNormalizedLocaleString((Locale)value));
                continue;
            }
            if (TM1RESTUserNameParameter.class == paramType) {
                writer.writeEmptyElement(DOM_USERNAME);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (TM1RESTPasswordParameter.class == paramType) {
                writer.writeEmptyElement(DOM_PASSWORD);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CubeParameter.class == paramType) {
                writer.writeEmptyElement(DOM_CUBE);
                writer.writeAttribute(DOM_VALUE, (String)value);
                continue;
            }
            if (CatalogParameter.class != paramType) continue;
            writer.writeEmptyElement(DOM_CATALOG);
            writer.writeAttribute(DOM_VALUE, (String)value);
        }
        writer.writeEndElement();
    }

    private static String getNormalizedLocaleString(Locale locale) {
        if (locale != null) {
            return locale.toString().toLowerCase().replace("_", "-");
        }
        return null;
    }
}

