/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.connection;

import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.MetadataCacheContext;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTPasswordParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTUserNameParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.pool.connection.ISelectorContext;
import com.cognos.xqe.trace.LogLevel;

public class TM1RESTConnectionSelector
implements IConnectionSelector {
    private static final long VALIDATION_PERIOD = 10000L;

    public TM1RESTConnectionSelector() {
    }

    public TM1RESTConnectionSelector(Object securityContext) {
    }

    public IConnectionSelector.ReturnCode selectConnection(ConnectionParameters connectionParameters, ISelectorContext context, IPooledConnection pooledConnection) {
        boolean bCAMSecurityMode;
        String cubeName;
        DefaultConnection connection = (DefaultConnection)pooledConnection.getConnection();
        Integer connectionId = System.identityHashCode(connection);
        ConnectionParameters poolParameters = connection.getConnectionParameters();
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Selecting connection parameters are connection [%s] and selection [%s].", connectionId, poolParameters, connectionParameters);
        int pass = -1;
        if (null != context) {
            pass = context.getSelectionPass();
        }
        if (!poolParameters.matches(connectionParameters)) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Connection initial match pass=%d failed.", connectionId, pass);
            return IConnectionSelector.ReturnCode.NOT_MATCH;
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Connection initial match pass=%d passed.", connectionId, pass);
        if (null != context && 1 == context.getSelectionPass() && null != (cubeName = (String)connectionParameters.valueOf(CubeParameter.class, String.class))) {
            Object[] ctx = connection.getContext();
            boolean isCubeLoaded = false;
            if (ctx != null) {
                for (Object c : ctx) {
                    if (!(c instanceof MetadataCacheContext)) continue;
                    isCubeLoaded = ((MetadataCacheContext)c).isCubeLoaded(cubeName);
                }
            }
            if (!isCubeLoaded) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Skipping this connection on the first pass, metadata for cube [%s] is not loaded.", connectionId, cubeName);
                return IConnectionSelector.ReturnCode.NEXT_PASS;
            }
        }
        boolean matches = false;
        UserClassIDsParameter paramUserGroups = (UserClassIDsParameter)connectionParameters.get(UserClassIDsParameter.class);
        boolean bl = bCAMSecurityMode = paramUserGroups != null;
        if (bCAMSecurityMode) {
            UserClassIDsParameter pooledConnUserGroups = (UserClassIDsParameter)poolParameters.get(UserClassIDsParameter.class);
            if (pooledConnUserGroups != null) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matching user groups: connection=[%s] and request=[%s].", connectionId, pooledConnUserGroups, paramUserGroups);
                matches = paramUserGroups.matches((IConnectionParameter)pooledConnUserGroups);
            } else {
                CAMPassportParameter pooledCAMPassportParam = (CAMPassportParameter)poolParameters.get(CAMPassportParameter.class);
                if (pooledCAMPassportParam.isMatchable()) {
                    CAMPassportParameter camPassportParam = (CAMPassportParameter)connectionParameters.get(CAMPassportParameter.class);
                    matches = pooledCAMPassportParam.matches((IConnectionParameter)camPassportParam);
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matching CAM passport: connection=[%s] and request=[%s].", connectionId, pooledCAMPassportParam, camPassportParam);
                }
            }
        }
        if (!bCAMSecurityMode) {
            TM1RESTUserNameParameter luid = (TM1RESTUserNameParameter)connectionParameters.get(TM1RESTUserNameParameter.class);
            TM1RESTUserNameParameter ruid = (TM1RESTUserNameParameter)poolParameters.get(TM1RESTUserNameParameter.class);
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matching user names [%s] and [%s].", new Object[]{connectionId, luid, ruid});
            if (luid == null && ruid == null) {
                matches = true;
            } else if (luid != null && ruid != null && luid.matches((IConnectionParameter)ruid)) {
                TM1RESTPasswordParameter lpwd = (TM1RESTPasswordParameter)connectionParameters.get(TM1RESTPasswordParameter.class);
                TM1RESTPasswordParameter rpwd = (TM1RESTPasswordParameter)poolParameters.get(TM1RESTPasswordParameter.class);
                if (null == lpwd && null == rpwd) {
                    matches = true;
                }
                if (null != lpwd && null != rpwd && lpwd.matches((IConnectionParameter)rpwd)) {
                    matches = true;
                }
            }
        }
        boolean isValid = true;
        if (connection instanceof TM1RESTConnection) {
            TM1RESTConnection tm1Connection = (TM1RESTConnection)connection;
            long connRtnTime = pooledConnection.getLastReturnedTimeMillis();
            long current = System.currentTimeMillis();
            if (current - connRtnTime >= 10000L) {
                tm1Connection.setValidationOn();
            }
        } else {
            isValid = connection.isValid();
        }
        if (matches && !isValid) {
            connection.invalidate();
            matches = false;
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Detected an invalid connection and marked it as non-reusable.", connectionId);
        }
        if (matches) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Matched connection.", connectionId);
            return IConnectionSelector.ReturnCode.MATCH;
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.TRACE, "[CONNECTION_ID=%d] Rejected connection.", connectionId);
        return IConnectionSelector.ReturnCode.NOT_MATCH;
    }
}

