/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.providers.ProviderCellIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TMRCellFormatParser;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TMRFormatInfo;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.olap.mdx.lolapprovider.tm1.LOLAPTM1Cube;

public class TM1RESTCellIterator
extends ProviderCellIteratorBase {
    private static final String DATA = "Data";
    private static final String ERROR = "Error";
    private static final String NULL = "Null";
    private IJsonArray mJsonCellChunk;
    private long mCellNumber;
    private final String mCellSetId;
    private long mChunkOrdinal = 0L;
    private static int chunkSize = 65536;
    private static int chunkIndexMask = 65535;
    private static int chunkOrdinalShift = 16;
    private final RESTClient mRestClient;
    private final ExecutionEnvironment mExecutionEnvironment;
    private long sourceOrdinal = -1L;
    private boolean hasNext = false;
    private ProviderCellBase nextCell = null;
    private boolean nullSuppressionAllowed = false;

    public TM1RESTCellIterator(TM1RESTCubeResultSet rs, String cellSetId, XDataContext xDataContext, Integer nodeId, RESTClient restClient) {
        super((ProviderResultSetBase)rs, xDataContext, nodeId);
        this.mCellSetId = cellSetId;
        this.mRestClient = restClient;
        if (rs.getCube() instanceof LOLAPTM1Cube) {
            this.nullSuppressionAllowed = ((LOLAPTM1Cube)rs.getCube()).isNullSuppressionAllowed();
        }
        this.mExecutionEnvironment = xDataContext.getEnvironment() instanceof ExecutionEnvironment ? (ExecutionEnvironment)xDataContext.getEnvironment() : null;
        this.mJsonCellChunk = this.getCellChunk(0L);
        this.fetchNext();
        super.release();
    }

    private boolean fetchNext() {
        this.hasNext = false;
        this.nextCell = null;
        while (!this.hasNext) {
            StringValue value;
            long index;
            ++this.sourceOrdinal;
            if (this.sourceOrdinal >= this.mCellNumber) {
                return false;
            }
            long chunkOrdinal = this.sourceOrdinal >> chunkOrdinalShift;
            if (chunkOrdinal != this.mChunkOrdinal) {
                this.mJsonCellChunk = this.getCellChunk(chunkOrdinal);
            }
            if ((index = this.sourceOrdinal & (long)chunkIndexMask) >= (long)this.mJsonCellChunk.size()) {
                return false;
            }
            IJsonObject jsonCell = (IJsonObject)this.mJsonCellChunk.get((int)index);
            CellStatus status = CellStatus.strToCellStatus(jsonCell.getStringValue("Status"));
            while (CellStatus.Null == status || CellStatus.Error == status && null == jsonCell.getObject("Value")) {
                ++this.sourceOrdinal;
                if (this.sourceOrdinal >= this.mCellNumber) {
                    return false;
                }
                chunkOrdinal = this.sourceOrdinal >> chunkOrdinalShift;
                if (chunkOrdinal != this.mChunkOrdinal) {
                    this.mJsonCellChunk = this.getCellChunk(chunkOrdinal);
                }
                if ((index = this.sourceOrdinal & (long)chunkIndexMask) >= (long)this.mJsonCellChunk.size()) {
                    return false;
                }
                jsonCell = (IJsonObject)this.mJsonCellChunk.get((int)index);
                status = CellStatus.strToCellStatus(jsonCell.getStringValue("Status"));
            }
            Boolean ruleDerived = jsonCell.getBooleanValue("RuleDerived");
            FormatService service = FormatService.getInstance();
            FormatId formatId = FormatId.INVALID_FORMAT_FID;
            String formatString = jsonCell.getStringValue("FormatString");
            if (null != service) {
                TMRFormatInfo info = new TMRFormatInfo(formatString);
                formatId = service.registerTMRCellFormat((IFormatInfo)info, this.getFormatLocale());
            }
            Object tm1Value = jsonCell.getObject("Value");
            if (status == CellStatus.Data) {
                if (tm1Value instanceof Boolean) {
                    value = DataValueFactory.createBooleanValue();
                    value.set(tm1Value);
                } else if (tm1Value instanceof Double) {
                    String formatTypeName = null;
                    if (null != service) {
                        formatTypeName = service.getFormatTypeName(formatId);
                    }
                    if (formatId != null && formatTypeName != null && formatTypeName.compareTo("dateFormat") == 0) {
                        int date = TMRCellFormatParser.convertTM1DateTimeToNumericDate(this.getFormatLocale(), (Double)tm1Value);
                        value = DataValueFactory.createIntegerValue((int)date);
                    } else if (formatId != null && formatTypeName != null && formatTypeName.compareTo("timeFormat") == 0) {
                        int time = TMRCellFormatParser.convertTM1DateTimeToNumericTime((Double)tm1Value);
                        value = DataValueFactory.createIntegerValue((int)time);
                    } else {
                        value = DataValueFactory.createDoubleValue();
                        value.set(tm1Value);
                    }
                } else if (tm1Value instanceof Long || tm1Value instanceof Integer) {
                    value = DataValueFactory.createLongValue();
                    value.set(tm1Value);
                } else if (tm1Value instanceof String) {
                    if (((String)tm1Value).isEmpty()) continue;
                    value = DataValueFactory.createStringValue();
                    value.set(tm1Value);
                } else {
                    value = DataValueFactory.createStringValue();
                    value.setState(ValueState.ERROR);
                }
            } else {
                value = DataValueFactory.createStringValue();
                value.setState(ValueState.ERROR);
            }
            value.setFormatId(formatId);
            this.nextCell = new ProviderCellBase(jsonCell.getLongValue("Ordinal").longValue(), (IValue)value);
            if (ruleDerived.booleanValue() && value.isOK()) {
                value.setState(ValueState.CALC);
            }
            this.hasNext = true;
        }
        return this.hasNext;
    }

    public ICell nextImpl() {
        if (this.hasNext) {
            ProviderCellBase result = this.nextCell;
            this.currentOrdinal = result.getOrdinal();
            try {
                this.fetchNext();
            }
            catch (RuntimeException e) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
            }
            return result;
        }
        return null;
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public void releaseImpl() {
    }

    private IJsonArray getCellChunk(long chunkOrdinal) {
        this.mChunkOrdinal = chunkOrdinal;
        ODataUriBuilder uriBuilder = this.mRestClient.getUriBuilder();
        boolean employNullsFiltering = false;
        long cardinality = -1L;
        if (0L == chunkOrdinal && !this.nullSuppressionAllowed) {
            String cellsetCardinalityUri = RESTUriBuilder.getCellsetCardinalityUri(this.mCellSetId, uriBuilder);
            uriBuilder.reset();
            String textcardinality = this.mRestClient.getTextResource(cellsetCardinalityUri);
            cardinality = Long.parseLong(textcardinality);
            if (cardinality < (long)chunkSize) {
                this.mCellNumber = cardinality;
                employNullsFiltering = true;
            }
        }
        String cellSetChunkUri = employNullsFiltering ? RESTUriBuilder.getCellSetFilteredChunkUri(this.mCellSetId, chunkOrdinal * (long)chunkSize, chunkSize, uriBuilder) : RESTUriBuilder.getCellSetChunkUri(this.mCellSetId, chunkOrdinal * (long)chunkSize, chunkSize, uriBuilder);
        IJsonObject jsonCellSetChunk = this.mRestClient.getJsonResource(cellSetChunkUri, this.mExecutionEnvironment);
        if (!employNullsFiltering) {
            this.mCellNumber = jsonCellSetChunk.getLongValue("@odata.count");
        }
        return jsonCellSetChunk.getArray("value");
    }

    public static enum CellStatus {
        Data,
        Error,
        Null;


        public static CellStatus strToCellStatus(String name) {
            if (TM1RESTCellIterator.DATA.equals(name)) {
                return Data;
            }
            if (TM1RESTCellIterator.ERROR.equals(name)) {
                return Error;
            }
            if (TM1RESTCellIterator.NULL.equals(name)) {
                return Null;
            }
            return null;
        }
    }
}

