/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.ProviderScrollableCellIteratorBase;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCellIterator;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TMRCellFormatParser;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TMRFormatInfo;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.data.values.BooleanValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;

public class TM1RESTScrollableCellIterator
extends ProviderScrollableCellIteratorBase {
    private IJsonArray mJsonCellChunk;
    private ICell currentCell = null;
    private long cellsetOrdinal = -1L;
    private long logicalOrdinal = -1L;
    private long mCellNumber;
    private long sourceOrdinal = -1L;
    private final String mCellSetId;
    private long mChunkOrdinal = 0L;
    private static int chunkSize = 65536;
    private static int chunkIndexMask = 65535;
    private static int chunkOrdinalShift = 16;
    private final RESTClient mRestClient;
    private final ExecutionEnvironment mExecutionEnvironment;

    public TM1RESTScrollableCellIterator(TM1RESTCubeResultSet rs, String cellSetId, XDataContext xDataContext, Integer nodeId, RESTClient restClient) {
        super((ProviderResultSetBase)rs, xDataContext, nodeId);
        this.mCellSetId = cellSetId;
        this.mRestClient = restClient;
        this.mExecutionEnvironment = xDataContext.getEnvironment() != null && xDataContext.getEnvironment() instanceof ExecutionEnvironment ? (ExecutionEnvironment)xDataContext.getEnvironment() : null;
        this.mJsonCellChunk = this.getCellChunk(0L);
    }

    public ICell nextImpl() {
        this.currentCell = null;
        if (this.cellsetOrdinal == this.mCellNumber) {
            this.updateOrdinals(this.mCellNumber);
            return null;
        }
        if (this.cellsetOrdinal == this.logicalOrdinal && !this.moveToNext()) {
            this.updateOrdinals(this.mCellNumber);
            return null;
        }
        this.currentCell = this.readCell();
        this.updateOrdinals(this.currentCell.getOrdinal());
        return this.currentCell;
    }

    public ICell current() {
        if (this.currentCell != null) {
            return this.currentCell;
        }
        if (this.logicalOrdinal == -1L || this.logicalOrdinal >= this.mCellNumber || this.cellsetOrdinal > this.logicalOrdinal) {
            return null;
        }
        this.currentCell = this.readCell();
        return this.currentCell;
    }

    public boolean hasPrevious() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "com.cognos.xqe.data.providers.olap.tm1.data.TM1ScrollableCellIterator.hasPrevious()");
    }

    public ICell previous() {
        throw new XQERuntimeException(XQEMessageKeys.GEN_MethodNotImplemented_INTERNAL, "com.cognos.xqe.data.providers.olap.tm1.data.TM1ScrollableCellIterator.previous()");
    }

    public boolean reset() {
        this.sourceOrdinal = -1L;
        this.updateOrdinals(-1L);
        this.currentCell = null;
        return true;
    }

    public boolean hasNext() {
        if (this.logicalOrdinal == -1L) {
            return this.moveToNext();
        }
        if (this.cellsetOrdinal == this.mCellNumber) {
            return false;
        }
        if (this.cellsetOrdinal > this.logicalOrdinal) {
            return true;
        }
        return this.moveToNext();
    }

    public void releaseImpl() {
    }

    public long getIndex() {
        return this.logicalOrdinal;
    }

    private void updateOrdinals(long ordinal) {
        this.cellsetOrdinal = ordinal;
        this.logicalOrdinal = ordinal;
        this.sourceOrdinal = ordinal;
    }

    private boolean moveToNext() {
        boolean hasNext = false;
        while (!hasNext && this.sourceOrdinal < this.mCellNumber) {
            Object tm1Value;
            ++this.sourceOrdinal;
            if (this.sourceOrdinal >= this.mCellNumber) {
                this.cellsetOrdinal = this.mCellNumber;
                return false;
            }
            long chunkOrdinal = this.sourceOrdinal >> chunkOrdinalShift;
            if (chunkOrdinal != this.mChunkOrdinal) {
                this.mJsonCellChunk = this.getCellChunk(chunkOrdinal);
            }
            long index = this.sourceOrdinal & (long)chunkIndexMask;
            IJsonObject jsonCell = (IJsonObject)this.mJsonCellChunk.get((int)index);
            TM1RESTCellIterator.CellStatus status = TM1RESTCellIterator.CellStatus.strToCellStatus(jsonCell.getStringValue("Status"));
            while (status.equals((Object)TM1RESTCellIterator.CellStatus.Null)) {
                ++this.sourceOrdinal;
                if (this.sourceOrdinal >= this.mCellNumber) {
                    this.cellsetOrdinal = this.mCellNumber;
                    return false;
                }
                chunkOrdinal = this.sourceOrdinal >> chunkOrdinalShift;
                if (chunkOrdinal != this.mChunkOrdinal) {
                    this.mJsonCellChunk = this.getCellChunk(chunkOrdinal);
                }
                index = this.sourceOrdinal & (long)chunkIndexMask;
                jsonCell = (IJsonObject)this.mJsonCellChunk.get((int)index);
                status = TM1RESTCellIterator.CellStatus.strToCellStatus(jsonCell.getStringValue("Status"));
            }
            if (status == TM1RESTCellIterator.CellStatus.Data && (tm1Value = jsonCell.getObject("Value")) instanceof String && ((String)tm1Value).isEmpty()) continue;
            hasNext = true;
            this.cellsetOrdinal = this.sourceOrdinal;
        }
        return hasNext;
    }

    private ICell readCell() {
        BooleanValue value;
        long chunkOrdinal = this.sourceOrdinal >> chunkOrdinalShift;
        if (chunkOrdinal != this.mChunkOrdinal) {
            this.mJsonCellChunk = this.getCellChunk(chunkOrdinal);
        }
        long index = this.sourceOrdinal & (long)chunkIndexMask;
        IJsonObject jsonCell = (IJsonObject)this.mJsonCellChunk.get((int)index);
        TM1RESTCellIterator.CellStatus status = TM1RESTCellIterator.CellStatus.strToCellStatus(jsonCell.getStringValue("Status"));
        String formatString = jsonCell.getStringValue("FormatString");
        Boolean ruleDerived = jsonCell.getBooleanValue("RuleDerived");
        FormatId formatId = FormatId.INVALID_FORMAT_FID;
        FormatService service = FormatService.getInstance();
        if (null != service) {
            TMRFormatInfo info = new TMRFormatInfo(formatString);
            formatId = service.registerTMRCellFormat((IFormatInfo)info, this.getFormatLocale());
        }
        Object tm1Value = jsonCell.getObject("Value");
        if (status == TM1RESTCellIterator.CellStatus.Data) {
            if (tm1Value instanceof Boolean) {
                value = DataValueFactory.createBooleanValue();
                value.set(tm1Value);
            } else if (tm1Value instanceof Double) {
                String formatTypeName = null;
                if (null != service) {
                    formatTypeName = service.getFormatTypeName(formatId);
                }
                if (formatId != null && formatTypeName != null && formatTypeName.compareTo("dateFormat") == 0) {
                    int date = TMRCellFormatParser.convertTM1DateTimeToNumericDate(this.getFormatLocale(), (Double)tm1Value);
                    value = DataValueFactory.createIntegerValue((int)date);
                } else if (formatId != null && formatTypeName != null && formatTypeName.compareTo("timeFormat") == 0) {
                    int time = TMRCellFormatParser.convertTM1DateTimeToNumericTime((Double)tm1Value);
                    value = DataValueFactory.createIntegerValue((int)time);
                } else {
                    value = DataValueFactory.createDoubleValue();
                    value.set(tm1Value);
                }
            } else if (tm1Value instanceof Long || tm1Value instanceof Integer) {
                value = DataValueFactory.createLongValue();
                value.set(tm1Value);
            } else if (tm1Value instanceof String) {
                if (((String)tm1Value).isEmpty()) {
                    return null;
                }
                value = DataValueFactory.createStringValue();
                value.set(tm1Value);
            } else {
                value = DataValueFactory.createStringValue();
                value.setState(ValueState.ERROR);
            }
        } else {
            if (status == TM1RESTCellIterator.CellStatus.Null) {
                return null;
            }
            value = DataValueFactory.createStringValue();
            value.setState(ValueState.ERROR);
        }
        value.setFormatId(formatId);
        ProviderCellBase nextCell = new ProviderCellBase(this.sourceOrdinal, (IValue)value);
        if (ruleDerived.booleanValue() && value.isOK()) {
            value.setState(ValueState.CALC);
        }
        return nextCell;
    }

    public boolean absolute(long index) {
        if (index == -1L) {
            return this.reset();
        }
        if (this.mCellNumber - 1L < index) {
            return false;
        }
        this.updateOrdinals(index);
        this.currentCell = null;
        return true;
    }

    private IJsonArray getCellChunk(long chunkOrdinal) {
        this.mChunkOrdinal = chunkOrdinal;
        ODataUriBuilder uriBuilder = this.mRestClient.getUriBuilder();
        String cellSetChunkUri = RESTUriBuilder.getCellSetChunkUri(this.mCellSetId, chunkOrdinal * (long)chunkSize, chunkSize, uriBuilder);
        IJsonObject jsonTupleChunk = this.mRestClient.getJsonResource(cellSetChunkUri, this.mExecutionEnvironment);
        IJsonArray jsonTupleArray = jsonTupleChunk.getArray("value");
        this.mCellNumber = jsonTupleChunk.getLongValue("@odata.count");
        return jsonTupleArray;
    }
}

