/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.TM1RESTMember;
import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.TM1RESTTuple;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.List;

public class TM1RESTAxis {
    private static final String NUMBER_OF_TUPLES = "Number of tuples";
    private static final String AXIS = "Axis";
    long ordinal;
    private List<TM1RESTTuple> tupleList = new ArrayList<TM1RESTTuple>();

    public TM1RESTAxis(IJsonObject axis, RESTClient restClient, String cellSetId, ExecutionEnvironment execEnvironment) {
        this.ordinal = axis.getLongValue("Ordinal");
        try {
            String tuplesVerboseUri = RESTUriBuilder.getTuplesVerboseUri(cellSetId, this.ordinal, restClient.getUriBuilder());
            IJsonObject jsonTupleSet = restClient.getJsonResource(tuplesVerboseUri, execEnvironment);
            IJsonArray jsonTupleArray = jsonTupleSet.getArray("value");
            for (Object jsonTuple : jsonTupleArray) {
                TM1RESTTuple currTuple = new TM1RESTTuple((IJsonObject)jsonTuple);
                this.tupleList.add(currTuple);
            }
        }
        catch (Exception e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
        }
    }

    public int getNumberOfTuples() {
        return this.tupleList.size();
    }

    public List<TM1RESTTuple> getTupleList() {
        return this.tupleList;
    }

    public String toString(LogLevel logLevel, String indent) {
        StringBuilder sb = new StringBuilder();
        if (indent != null && !indent.isEmpty()) {
            sb.append(indent);
        }
        sb.append(AXIS);
        sb.append("(").append(" ").append("Ordinal").append("=").append(this.ordinal);
        sb.append("\n");
        if (!this.getTupleList().isEmpty()) {
            if (logLevel == LogLevel.INFO) {
                if (indent != null && !indent.isEmpty()) {
                    sb.append(indent + indent);
                }
                sb.append(NUMBER_OF_TUPLES).append("=").append(this.getTupleList().size());
                sb.append("\n");
                if (indent != null && !indent.isEmpty()) {
                    sb.append(indent + indent);
                }
                sb.append("Hierarchies").append(" ").append("{");
                sb.append("\n");
                TM1RESTTuple firstTuple = null;
                int i = 0;
                while (firstTuple == null) {
                    firstTuple = this.getTupleList().get(i++);
                }
                i = 0;
                for (TM1RESTMember currMember : firstTuple.getMemberList()) {
                    if (indent != null && !indent.isEmpty()) {
                        sb.append(indent + indent + indent);
                    }
                    if (currMember == null || currMember.getHierarchy() == null) {
                        sb.append("NULL");
                    } else {
                        sb.append(currMember.getHierarchy().getUniqueName());
                    }
                    sb.append("\n");
                }
                if (indent != null && !indent.isEmpty()) {
                    sb.append(indent + indent);
                }
                sb.append("}");
            } else {
                for (TM1RESTTuple currTuple : this.getTupleList()) {
                    if (indent != null && !indent.isEmpty()) {
                        sb.append(currTuple.toString(indent + indent));
                    } else {
                        sb.append(currTuple.toString("  "));
                    }
                    if (currTuple == this.getTupleList().get(this.getTupleList().size() - 1)) continue;
                    sb.append(",").append("\n");
                }
            }
        }
        if (indent != null && !indent.isEmpty()) {
            sb.append(indent);
        }
        sb.append("\n");
        if (indent != null && !indent.isEmpty()) {
            sb.append(indent);
        }
        sb.append(")");
        return sb.toString();
    }

    public String toString() {
        return this.toString(LogLevel.TRACE, "");
    }
}

