/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.LocalizedString;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TM1Cube
extends TM1RESTMetadata {
    private String mMeasureDUN;
    private String mTimeDUN;
    private final TM1CubeTimestamps mTimestamps;
    private final List<String> mPackageLocaleTags;
    private final String mRunLocale;
    private double mUndefVal = 0.0;
    private final Map<String, TM1Dimension> mDimensionsByDUN = new LinkedHashMap<String, TM1Dimension>();
    private boolean mIsUnderFed;

    public TM1Cube(TM1CubeTimestamps timestamps, List<String> packageLocaleTags, Locale runLocale) {
        super(null);
        this.mTimestamps = timestamps;
        this.mPackageLocaleTags = packageLocaleTags;
        this.mRunLocale = runLocale.toLanguageTag();
        this.mIsUnderFed = false;
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.CUBE;
    }

    @Override
    public String getUniqueName() {
        return this.getProviderUniqueName();
    }

    public void setMeasureDUN(String measureDUN) {
        this.mMeasureDUN = measureDUN;
    }

    public void setTimeDUN(String timeDUN) {
        this.mTimeDUN = timeDUN;
    }

    public String getMeasureDUN() {
        return this.mMeasureDUN;
    }

    public String getTimeDUN() {
        return this.mTimeDUN;
    }

    public TM1CubeTimestamps getTimestamps() {
        return this.mTimestamps;
    }

    public Date getLastSchemaUpdate() {
        if (null != this.mTimestamps) {
            return this.mTimestamps.getLastSchemaUpdate();
        }
        return null;
    }

    public Date getLastDataUpdate() {
        if (null != this.mTimestamps) {
            return this.mTimestamps.getLastDataUpdate();
        }
        return null;
    }

    public double getUndefVal() {
        return this.mUndefVal;
    }

    private void setUnderFedState(IJsonObject jsonAttributes) {
        if (null != jsonAttributes) {
            String sUnderFed = jsonAttributes.getStringValue("IsUnderFed");
            if (null != sUnderFed && sUnderFed.equalsIgnoreCase("T")) {
                this.mIsUnderFed = true;
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_CUBE, LogLevel.INFO, "The cube attribute %s is set to \"%s\" for [CUBE_NAME=%s]. The cube is under-fed.", "IsUnderFed", sUnderFed, this.mName);
            } else {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_CUBE, LogLevel.TRACE, "The cube attribute %s is set to \"%s\" for [CUBE_NAME=%s]. The cube is properly fed.", "IsUnderFed", sUnderFed, this.mName);
            }
        }
    }

    public void populate(IJsonObject cube, Locale defaultLocale) {
        IJsonObject jsonTimeDim;
        this.mProviderUniqueName = this.mName = cube.getStringValue("Name");
        this.mCaption = this.mName;
        this.mProviderCaption = this.mName;
        IJsonObject jsonMeasureDim = cube.getJsonObject("MeasuresDimension");
        if (null != jsonMeasureDim) {
            this.setMeasureDUN(jsonMeasureDim.getStringValue("UniqueName"));
        }
        if (null != (jsonTimeDim = cube.getJsonObject("TimeDimension"))) {
            this.setTimeDUN(jsonTimeDim.getStringValue("UniqueName"));
        }
        IJsonObject jsonAttributes = cube.getJsonObject("Attributes");
        this.setUnderFedState(jsonAttributes);
        this.setLocalizedCaption(cube, defaultLocale);
        if (null == this.mLocalizedCaption) {
            this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption);
        }
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Cube.printHeader(writer, indent, "TM1Cube");
        TM1Cube.printField(writer, indent, "name", this.getName());
        TM1Cube.printField(writer, indent, "caption", this.getCaption());
        TM1Cube.printField(writer, indent, "measureDUN", this.getMeasureDUN());
        TM1Cube.printField(writer, indent, "timeDUN", this.getTimeDUN());
        TM1Cube.printField(writer, indent, "lastSchemaUpdate", this.getLastSchemaUpdate().toString());
        TM1Cube.printField(writer, indent, "lastDataUpdate", this.getLastDataUpdate().toString());
        TM1Cube.printField(writer, indent, "undefVal", Double.toString(this.getUndefVal()));
        for (TM1Dimension dimension : this.getDimensions()) {
            dimension.dump(writer, indent + 2);
        }
    }

    void addDimension(TM1Dimension dimension) {
        this.mDimensionsByDUN.put(dimension.getUniqueName(), dimension);
    }

    public Collection<TM1Dimension> getDimensions() {
        return Collections.unmodifiableCollection(this.mDimensionsByDUN.values());
    }

    public TM1Dimension getMeasureDimension() {
        return this.findDimension(this.mMeasureDUN);
    }

    public TM1Dimension findDimension(String dun) {
        return this.mDimensionsByDUN.get(dun);
    }

    public boolean isUnderFed() {
        return this.mIsUnderFed;
    }

    public List<String> getPackageLocaleTags() {
        return this.mPackageLocaleTags;
    }

    public String getRunLocale() {
        return this.mRunLocale;
    }
}

