/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1NamedSet;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Constants;
import com.cognos.xqe.util.LocalizedString;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;

public class TM1Hierarchy
extends TM1RESTMetadata {
    private String mAllMemberUN;
    private String mDefaultMemberUN;
    private final Map<String, TM1Level> mLevelsByLUN = new HashMap<String, TM1Level>();
    private final List<TM1Level> mLevelsByNumber = new ArrayList<TM1Level>();
    private final Set<String> mNamedSetETags = new HashSet<String>();
    private final Map<String, TM1NamedSet> mNamedSetsByETag = new HashMap<String, TM1NamedSet>();
    private final Map<String, TM1NamedSet> mNamedSetsByNUN = new LinkedHashMap<String, TM1NamedSet>();
    private final Map<String, TM1Attribute> mAttributesByName = new LinkedHashMap<String, TM1Attribute>();
    private List<TM1Member> mAccessibleRoots = Collections.emptyList();
    private final List<String> mAliasNames = new ArrayList<String>();
    private Map<String, TM1Member> mMembersWithChildren = new LinkedHashMap<String, TM1Member>();
    private long mStructure = 0L;
    private boolean mRagged = false;
    private boolean mRaggedStateKnown = false;
    private Boolean mVisible = false;
    private boolean mBalanced = false;
    private boolean mBalancedStateKnown = false;
    private boolean mParentChild = false;
    private boolean mParentChildStateKnown = false;
    private long mCardinality;
    private long mLevelsNumber;

    public TM1Hierarchy(TM1Dimension dimension) {
        super(dimension);
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.HIERARCHY;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            this.mUniqueName = this.getProviderUniqueName();
        }
        return this.mUniqueName;
    }

    public TM1Dimension getDimension() {
        return (TM1Dimension)this.getParent();
    }

    public static String joinUniqueNames(String uname1, String uname2) {
        StringBuilder buf = new StringBuilder(uname1.length() + uname2.length() + 1);
        buf.append(uname1).append('.').append(uname2);
        return buf.toString();
    }

    public String getAllMemberUN() {
        return this.mAllMemberUN;
    }

    public String getDefaultMemberUN() {
        return this.mDefaultMemberUN;
    }

    public long getStructure() {
        return this.mStructure;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public void populate(IJsonObject hierObj, Locale defaultLocale, List<Locale> locales, Map<String, List<IJsonObject>> localizedAttributes) {
        IJsonObject jsonAllMember;
        Long lStructure;
        Long levelsNumber;
        this.mName = hierObj.getStringValue("Name");
        this.mProviderUniqueName = hierObj.getStringValue("UniqueName");
        this.mCardinality = hierObj.getLongValue("Cardinality");
        this.mVisible = hierObj.getBooleanValue("Visible");
        this.mCaption = this.mName;
        this.mProviderCaption = this.mName;
        if (null == locales || null == localizedAttributes) {
            this.setLocalizedCaption(hierObj, defaultLocale);
            if (null == this.mLocalizedCaption) {
                this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption);
            }
        } else {
            String localizedCaption = null;
            IJsonObject jsonAttributes = hierObj.getJsonObject("Attributes");
            if (jsonAttributes != null) {
                localizedCaption = jsonAttributes.getStringValue("Caption");
            }
            boolean addLocalizedCaption = !this.mCaption.equals(localizedCaption);
            this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption, addLocalizedCaption);
            if (addLocalizedCaption) {
                this.mLocalizedCaption.put(defaultLocale, localizedCaption);
            }
            List<IJsonObject> attributes = localizedAttributes.get(this.mProviderUniqueName);
            for (int i = 0; i < locales.size(); ++i) {
                this.setCaptionForLocale(locales.get(i), attributes.get(i));
            }
        }
        this.mLevelsNumber = (levelsNumber = hierObj.getLongValue("Levels@odata.count")) != null ? levelsNumber : 0L;
        IJsonArray jsonLevels = hierObj.getArray("Levels");
        if (jsonLevels != null) {
            this.mParentChild = true;
            for (int i = 0; i < jsonLevels.size(); ++i) {
                IJsonObject jsonLevel = (IJsonObject)jsonLevels.get(i);
                String mun = jsonLevel.getStringValue("UniqueName");
                Matcher defaultLUNMatcher = TM1Constants.DEFAULT_LEVEL_NAME_PATTERN.matcher(mun);
                if (defaultLUNMatcher.find()) continue;
                this.mParentChild = false;
                break;
            }
            this.mParentChildStateKnown = true;
        }
        this.mProviderCaption = this.mCaption;
        IJsonObject jsonDefMember = hierObj.getJsonObject("DefaultMember");
        if (jsonDefMember != null) {
            this.mDefaultMemberUN = jsonDefMember.getStringValue("UniqueName");
        }
        if ((lStructure = hierObj.getLongValue("Structure")) != null) {
            this.mStructure = lStructure;
            this.mBalanced = 0L == this.mStructure || 1L == this.mStructure;
            this.mBalancedStateKnown = true;
        }
        this.mAllMemberUN = (jsonAllMember = hierObj.getJsonObject("AllMember")) != null ? jsonAllMember.getStringValue("UniqueName") : "";
    }

    void addNamedSet(TM1NamedSet namedSet) {
        this.mNamedSetsByNUN.put(namedSet.getProviderUniqueName(), namedSet);
        this.mNamedSetsByETag.put(namedSet.getETag(), namedSet);
        this.mNamedSetETags.add(namedSet.getETag());
        this.getDimension().addNamedSet(namedSet);
    }

    void addNamedSetETag(String namedSetETag) {
        this.mNamedSetETags.add(namedSetETag);
    }

    Set<String> getAllNamedSetETags() {
        return this.mNamedSetETags;
    }

    void addLevel(TM1Level level) {
        this.mLevelsByLUN.put(level.getUniqueName(), level);
        long levelsToAdd = level.getLevelNumber() - (long)this.mLevelsByNumber.size() + 1L;
        if (levelsToAdd > 0L) {
            int i = 0;
            while ((long)i < levelsToAdd) {
                this.mLevelsByNumber.add(null);
                ++i;
            }
        }
        this.mLevelsByNumber.set((int)level.getLevelNumber(), level);
    }

    public Collection<TM1Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.mAttributesByName.values());
    }

    void addAttribute(TM1Attribute attribute) {
        this.mAttributesByName.put(attribute.getName(), attribute);
        if (attribute.isAlias()) {
            this.mAliasNames.add(attribute.getName());
        }
    }

    public TM1Attribute findAttribute(String name) {
        return this.mAttributesByName.get(name);
    }

    public List<String> getAliasNames() {
        return this.mAliasNames;
    }

    public Collection<TM1Level> getLevels() {
        return Collections.unmodifiableCollection(this.mLevelsByNumber);
    }

    public TM1Level findLevel(String lun) {
        return this.mLevelsByLUN.get(lun);
    }

    public TM1Level findLevel(int levelNumber) {
        if (levelNumber >= 0 && levelNumber < this.mLevelsByNumber.size()) {
            return this.mLevelsByNumber.get(levelNumber);
        }
        return null;
    }

    public TM1Level findRevLevel(int levelNumber) {
        if (levelNumber >= 0 && levelNumber < this.mLevelsByNumber.size()) {
            return this.mLevelsByNumber.get(this.mLevelsByNumber.size() - levelNumber - 1);
        }
        return null;
    }

    public Collection<TM1NamedSet> getNamedSets() {
        return Collections.unmodifiableCollection(this.mNamedSetsByNUN.values());
    }

    public TM1NamedSet getNamedSet(String nun) {
        return this.mNamedSetsByNUN.get(nun);
    }

    public TM1NamedSet getNamedSetByETag(String eTag) {
        return this.mNamedSetsByETag.get(eTag);
    }

    void setAccessibleRoots(List<TM1Member> roots) {
        this.mAccessibleRoots = roots;
    }

    public List<TM1Member> getAccessibleRoots() {
        return Collections.unmodifiableList(this.mAccessibleRoots);
    }

    public boolean isParentChild() {
        if (!this.mParentChildStateKnown) {
            this.mParentChild = true;
            for (TM1Level level : this.mLevelsByNumber) {
                String expectedLabel = String.format("level%03d", level.getLevelNumber());
                if (level.getProviderCaption().equals(expectedLabel)) continue;
                this.mParentChild = false;
                break;
            }
            this.mParentChildStateKnown = true;
        }
        return this.mParentChild;
    }

    public boolean isBalanced() {
        if (!this.mBalancedStateKnown) {
            this.mBalanced = true;
            Iterator<TM1Member> rootIter = this.mAccessibleRoots.iterator();
            if (rootIter.hasNext()) {
                long levelNumber = rootIter.next().getLevelNumber();
                while (rootIter.hasNext()) {
                    if (rootIter.next().getLevelNumber() == levelNumber) continue;
                    this.mBalanced = false;
                    break;
                }
            }
            this.mBalancedStateKnown = true;
        }
        return this.mBalanced;
    }

    public boolean isRagged() {
        if (!this.mRaggedStateKnown) {
            this.mRagged = false;
            for (TM1Member m : this.mAccessibleRoots) {
                if (m.getLevelNumber() == 0L) continue;
                this.mRagged = true;
                break;
            }
            this.mRaggedStateKnown = true;
        }
        return this.mRagged;
    }

    public boolean isVisible() {
        if (this.mVisible == null) {
            return Boolean.TRUE;
        }
        return this.mVisible;
    }

    public long getLevelsNumber() {
        return this.mLevelsNumber;
    }

    public void putMemberWithChildren(TM1Member member) {
        if (member.getChildrenCardinality() > 0L) {
            this.mMembersWithChildren.put(member.getUniqueName(), member);
        }
    }

    public TM1Member getMemberWithChildren(String mun) {
        return this.mMembersWithChildren.get(mun);
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Hierarchy.printHeader(writer, indent, "TM1Hierarchy");
        TM1Hierarchy.printField(writer, indent, "name", this.getName());
        TM1Hierarchy.printField(writer, indent, "uniqueName", this.getProviderUniqueName());
        TM1Hierarchy.printField(writer, indent, "caption", this.getCaption());
        TM1Hierarchy.printField(writer, indent, "structure", Long.toString(this.getStructure()));
        TM1Hierarchy.printField(writer, indent, "cardinality", Long.toString(this.getCardinality()));
        TM1Hierarchy.printField(writer, indent, "allMemberUN", this.getAllMemberUN());
        TM1Hierarchy.printField(writer, indent, "defaultMemberUN", this.getDefaultMemberUN());
        for (TM1Attribute attribute : this.getAttributes()) {
            attribute.dump(writer, indent + 2);
        }
        for (TM1Level level : this.getLevels()) {
            level.dump(writer, indent + 2);
        }
    }
}

