/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Constants;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;

public final class TM1Level
extends TM1RESTMetadata
implements Comparable<TM1Level> {
    private long mLevelNumber;
    private long mCardinality;
    private long mType;
    private final Map<String, TM1Attribute> mAttributesByName = new LinkedHashMap<String, TM1Attribute>();

    public TM1Level(TM1Hierarchy hierarchy) {
        super(hierarchy);
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.LEVEL;
    }

    @Override
    public String getUniqueName() {
        if (null == this.mUniqueName) {
            if (this.getHierarchy().isParentChild()) {
                Matcher defaultLUNMatcher = TM1Constants.DEFAULT_LEVEL_NAME_PATTERN.matcher(this.getProviderUniqueName());
                if (!defaultLUNMatcher.find()) {
                    throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unexpected provider LUN format: " + this.getProviderUniqueName());
                }
                String providerLUN = defaultLUNMatcher.replaceFirst('[' + this.getName() + ']');
                this.mUniqueName = providerLUN;
            } else {
                this.mUniqueName = this.getProviderUniqueName();
            }
        }
        return this.mUniqueName;
    }

    @Override
    public String getName() {
        if (this.getHierarchy().isParentChild()) {
            return String.format("ParentChildHierarchyLevel_%d", this.getLevelNumber());
        }
        return super.getName();
    }

    @Override
    public String getCaption() {
        if (this.getHierarchy().isParentChild()) {
            return String.format("ParentChildHierarchyLevel_%d", this.getLevelNumber());
        }
        return this.getProviderCaption();
    }

    public TM1Hierarchy getHierarchy() {
        return (TM1Hierarchy)this.getParent();
    }

    public long getLevelNumber() {
        return this.mLevelNumber;
    }

    public long getCardinality() {
        return this.mCardinality;
    }

    public long getLevelType() {
        return this.mType;
    }

    public void populate(IJsonObject levelObj) {
        this.mProviderCaption = this.mCaption = (this.mName = levelObj.getStringValue("Name"));
        this.mProviderUniqueName = levelObj.getStringValue("UniqueName");
        this.mLevelNumber = levelObj.getLongValue("Number");
        this.mCardinality = levelObj.getLongValue("Cardinality");
        this.mType = levelObj.getLongValue("Type");
    }

    public Collection<TM1Attribute> getAttributes() {
        return Collections.unmodifiableCollection(this.mAttributesByName.values());
    }

    void addAttribute(TM1Attribute attribute) {
        this.mAttributesByName.put(attribute.getName(), attribute);
    }

    public TM1Attribute findAttribute(String name) {
        return this.mAttributesByName.get(name);
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1Level.printHeader(writer, indent, "TM1Level");
        TM1Level.printField(writer, indent, "name", this.getName());
        TM1Level.printField(writer, indent, "caption", this.getCaption());
        TM1Level.printField(writer, indent, "uniqueName", this.getProviderUniqueName());
        TM1Level.printField(writer, indent, "levelNumber", Long.toString(this.getLevelNumber()));
        TM1Level.printField(writer, indent, "cardinality", Long.toString(this.getCardinality()));
        TM1Level.printField(writer, indent, "levelType", Long.toString(this.getLevelType()));
        for (TM1Attribute attribute : this.getAttributes()) {
            attribute.dump(writer, indent + 2);
        }
    }

    @Override
    public int compareTo(TM1Level level) {
        return (int)(this.mLevelNumber - level.mLevelNumber);
    }
}

