/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class TM1NamedSet
extends TM1RESTMetadata {
    private static final String PUBLIC = "public";
    private static final String PRIVATE = "private";
    private String mExpression;
    private List<TM1Level> mLevels = new ArrayList<TM1Level>();
    private boolean mPrivate = false;
    private String mETag;

    public TM1NamedSet(TM1Hierarchy hierarchy) {
        super(hierarchy);
    }

    @Override
    public TM1RESTMetadataType getType() {
        return TM1RESTMetadataType.NAMEDSET;
    }

    @Override
    public String getUniqueName() {
        return this.mUniqueName;
    }

    public TM1Hierarchy getHierarchy() {
        return (TM1Hierarchy)this.getParent();
    }

    public void populate(IJsonObject namedSetObj) {
        this.mName = namedSetObj.getStringValue("Name");
        this.mProviderUniqueName = this.mUniqueName = namedSetObj.getStringValue("UniqueName");
        this.mETag = namedSetObj.getStringValue("@odata.etag");
        IJsonObject jsonAttributes = namedSetObj.getJsonObject("Attributes");
        this.mCaption = null;
        if (null != jsonAttributes) {
            this.mCaption = jsonAttributes.getStringValue("Caption");
        }
        if (this.mCaption == null || this.mCaption.isEmpty()) {
            this.mCaption = this.mName;
        }
        this.mProviderCaption = this.mCaption;
        this.mExpression = namedSetObj.getStringValue("Expression");
        IJsonArray jsonElements = namedSetObj.getArray("Elements");
        if (null == jsonElements) {
            return;
        }
        HashSet<Long> seenLevels = new HashSet<Long>();
        for (int i = 0; i < jsonElements.size(); ++i) {
            IJsonObject jsonElement = (IJsonObject)jsonElements.get(i);
            long levelNumber = jsonElement.getLongValue("Level");
            if (seenLevels.contains(levelNumber)) continue;
            seenLevels.add(levelNumber);
            TM1Level level = this.getHierarchy().findRevLevel((int)levelNumber);
            if (level == null) continue;
            this.mLevels.add(level);
        }
    }

    @Override
    public void dump(PrintWriter writer, int indent) {
        TM1NamedSet.printHeader(writer, indent, "TM1Hierarchy");
        TM1NamedSet.printField(writer, indent, "name", this.getName());
        TM1NamedSet.printField(writer, indent, "uniqueName", this.getProviderUniqueName());
        TM1NamedSet.printField(writer, indent, "caption", this.getCaption());
        TM1NamedSet.printField(writer, indent, "expression", this.getExpression());
    }

    public String getExpression() {
        if (null == this.mExpression) {
            return "";
        }
        return this.mExpression;
    }

    public boolean isPrivate() {
        return this.mPrivate;
    }

    public void setPrivate(boolean bprivate) {
        this.mPrivate = bprivate;
    }

    public String getETag() {
        return this.mETag;
    }

    public String getScope() {
        if (this.isPrivate()) {
            return PRIVATE;
        }
        return PUBLIC;
    }
}

