/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeSnapshot;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.ICubeTimestamps;
import com.cognos.xqe.trace.LogLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TM1RESTCubeCache {
    private static final long DEFAULT_STALE_CHECK_INTERVAL = 5000L;
    private static final String KEY_SEPARATOR = ":";
    private final TM1RESTConnection mConnection;
    private final Map<String, TM1Cube> mCubesByKey = new HashMap<String, TM1Cube>();
    private final Map<String, TM1Cube> mStaleCubesByKey = new HashMap<String, TM1Cube>();
    private long mStaleCheckInterval = 5000L;
    private volatile long mLastStaleCheckTime = 0L;

    public TM1RESTCubeCache(TM1RESTConnection connection) {
        this.mConnection = connection;
    }

    public long getStaleCheckInterval() {
        return this.mStaleCheckInterval;
    }

    public void setStaleCheckInterval(long staleCheckInterval) {
        this.mStaleCheckInterval = staleCheckInterval;
    }

    public long getLastStaleCheckTime() {
        return this.mLastStaleCheckTime;
    }

    public synchronized boolean containsCube() {
        return !this.mCubesByKey.isEmpty();
    }

    public synchronized boolean containsCube(String cubeKey) {
        return this.mCubesByKey.containsKey(cubeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> checkStaleCubes(ExecutionEnvironment execEnv) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.mLastStaleCheckTime < this.mStaleCheckInterval) {
            return Collections.emptyList();
        }
        Integer connectionID = System.identityHashCode((Object)this.mConnection);
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_CACHE, LogLevel.TRACE, "Running a staleness check on cube cache for connection ID %d.", connectionID);
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        TM1RESTMetadataSession session = new TM1RESTMetadataSession(this.mConnection, reqEnv.getRunLocale(), execEnv);
        LinkedList<String> staleCubeKeys = new LinkedList<String>();
        this.mLastStaleCheckTime = currentTime;
        TM1RESTCubeCache tM1RESTCubeCache = this;
        synchronized (tM1RESTCubeCache) {
            for (Map.Entry<String, TM1Cube> entry : this.mCubesByKey.entrySet()) {
                String cachedCubeKey = entry.getKey();
                TM1Cube cachedCube = entry.getValue();
                try {
                    TM1CubeTimestamps cachedCubeTimestamps = cachedCube.getTimestamps();
                    String adminHostCubeKey = session.getConnection().getAdminServerKey(cachedCube.getName(), cachedCube.getPackageLocaleTags());
                    TM1CubeSnapshot cubeSnapshot = TM1RESTServerSecurity.getCubeSnapshot(adminHostCubeKey);
                    TM1CubeTimestamps cachedTimeStamps = cubeSnapshot.getCubeTimestamps();
                    StringBuilder cubeKey = new StringBuilder("TMR:");
                    cubeKey.append(cachedCube.getUniqueName());
                    if (cachedTimeStamps.compareLastCubeUpdate(cachedCubeTimestamps) <= 0) continue;
                    staleCubeKeys.add(cachedCubeKey);
                    execEnv.addMetadataCubeTimeStampsForCube(cubeKey.toString(), (ICubeTimestamps)cachedTimeStamps.clone());
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_CACHE, LogLevel.TRACE, "Flag stale cube metadata: cube %s != cached cube %s [CUBE_NAME=%s] for connection ID %d.", cachedTimeStamps.toString(), cachedCubeTimestamps.toString(), cachedCube.getName(), connectionID);
                }
                catch (TM1RESTODPException ex) {
                    staleCubeKeys.add(cachedCubeKey);
                }
            }
            for (String cubeKey : staleCubeKeys) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_CACHE, LogLevel.WARN, "Expunging stale cube metadata [CUBE_NAME=%s] [Key=%s] from cube cache for connection ID %d.", cubeKey, cubeKey, connectionID);
                this.mStaleCubesByKey.put(cubeKey, this.mCubesByKey.remove(cubeKey));
            }
        }
        return staleCubeKeys;
    }

    public synchronized void expungeCube(String cubeCacheKey) {
        TM1Cube cube = this.mCubesByKey.get(cubeCacheKey);
        if (cube != null) {
            Integer connectionID = System.identityHashCode((Object)this.mConnection);
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_CACHE, LogLevel.WARN, "Expunging cube metadata [CUBE_NAME=%s] [Key=%s] from cube cache for connection ID %d.", cube.getName(), cubeCacheKey, connectionID);
        }
    }

    public synchronized TM1Cube getCube(String cubeCacheKey) {
        return this.mCubesByKey.get(cubeCacheKey);
    }

    public synchronized void putCube(String cubeCacheKey, TM1Cube cube) {
        this.mStaleCubesByKey.put(cubeCacheKey, this.mCubesByKey.put(cubeCacheKey, cube));
    }

    public static String getCubeCacheKey(String cubeName, List<String> packageLocales) {
        StringBuilder keyBuilder = new StringBuilder(cubeName);
        keyBuilder.append(KEY_SEPARATOR).append(String.join((CharSequence)KEY_SEPARATOR, packageLocales));
        return keyBuilder.toString();
    }
}

