/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataType;
import com.cognos.xqe.util.LocalizedString;
import java.io.PrintWriter;
import java.util.Locale;

public abstract class TM1RESTMetadata {
    public static final String EMPTY_STRING = "";
    protected static final int INDENT_INCREMENT = 2;
    protected static final String PRINT_FIELD_PREFIX = " + ";
    protected static final String PRINT_FIELD_EQUALS = " = ";
    private final TM1RESTMetadata mParent;
    protected String mName;
    protected String mProviderUniqueName;
    protected String mUniqueName;
    protected String mProviderCaption;
    protected String mCaption;
    LocalizedString mLocalizedCaption;

    protected TM1RESTMetadata(TM1RESTMetadata parent) {
        this.mParent = parent;
    }

    public abstract TM1RESTMetadataType getType();

    public final TM1RESTMetadata getParent() {
        return this.mParent;
    }

    public String getName() {
        return this.mName;
    }

    public final String getProviderUniqueName() {
        return this.mProviderUniqueName;
    }

    public abstract String getUniqueName();

    public LocalizedString getLocalizedCaption() {
        if (this.mLocalizedCaption == null) {
            this.mLocalizedCaption = new LocalizedString("Default", EMPTY_STRING);
        }
        return this.mLocalizedCaption;
    }

    public String getProviderCaption() {
        if (this.mProviderCaption == null) {
            return EMPTY_STRING;
        }
        return this.mProviderCaption;
    }

    public String getCaption() {
        return this.getProviderCaption();
    }

    public final void dump(PrintWriter writer) {
        this.dump(writer, 0);
    }

    public abstract void dump(PrintWriter var1, int var2);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result;
        if (this.mProviderUniqueName != null) {
            result += this.mProviderUniqueName.hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TM1RESTMetadata other = (TM1RESTMetadata)obj;
        return !(this.mProviderUniqueName == null ? other.mProviderUniqueName != null : !this.mProviderUniqueName.equals(other.mProviderUniqueName));
    }

    protected static void printHeader(PrintWriter writer, int indent, String header) {
        TM1RESTMetadata.printIndentation(writer, indent);
        writer.println(header);
    }

    protected static void printField(PrintWriter writer, int indent, String fieldName, String fieldValue) {
        TM1RESTMetadata.printIndentation(writer, indent);
        writer.append(PRINT_FIELD_PREFIX).append(fieldName).append(PRINT_FIELD_EQUALS).append(fieldValue);
        writer.println();
    }

    protected static void printIndentation(PrintWriter writer, int size) {
        for (int i = 0; i < size; ++i) {
            writer.append(' ');
        }
    }

    protected void setLocalizedCaption(IJsonObject jsonObj, Locale defaultLocale) {
        IJsonArray jsonLocalizedAttributes;
        if (jsonObj.containsKey("LocalizedAttributes") && !(jsonLocalizedAttributes = jsonObj.getArray("LocalizedAttributes")).isEmpty()) {
            IJsonObject jsonLocalizedAtt;
            String localeID;
            String dls = defaultLocale.toString();
            for (Object localizedAtt : jsonLocalizedAttributes) {
                if (localizedAtt == null || "Default".equals(localeID = (jsonLocalizedAtt = (IJsonObject)localizedAtt).getStringValue("LocaleID")) || !dls.equals(localeID)) continue;
                IJsonObject localizedAttributes = jsonLocalizedAtt.getJsonObject("Attributes");
                this.setCaptionForLocale(defaultLocale, localizedAttributes);
                break;
            }
            if (null == this.mLocalizedCaption) {
                this.mLocalizedCaption = new LocalizedString(defaultLocale, this.mCaption);
            }
            for (Object localizedAtt : jsonLocalizedAttributes) {
                Locale currLocale;
                if (localizedAtt == null || "Default".equals(localeID = (jsonLocalizedAtt = (IJsonObject)localizedAtt).getStringValue("LocaleID")) || (currLocale = new Locale(localeID)).equals(defaultLocale)) continue;
                IJsonObject localizedAttributes = jsonLocalizedAtt.getJsonObject("Attributes");
                this.setCaptionForLocale(currLocale, localizedAttributes);
            }
        }
    }

    protected void setCaptionForLocale(Locale locale, IJsonObject localizedAttributes) {
        String localizedCaption;
        if (null != localizedAttributes && null != (localizedCaption = (String)localizedAttributes.get("Caption"))) {
            if (this.mLocalizedCaption == null) {
                this.mLocalizedCaption = new LocalizedString(locale, localizedCaption);
            } else {
                this.mLocalizedCaption.put(locale, localizedCaption);
            }
        }
    }
}

