/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata;

import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.json.BIJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Attribute;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeSnapshot;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Level;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Member;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1NamedSet;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTCubeCache;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadata;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.JsonArrayStream;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.JsonAttributeFilter;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.MemberSearchMdxBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.QueryMode;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTStateEnum;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Constants;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Utils;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TreeOperator;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.ma.MAMunValidationException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.concurrent.Gate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.stream.Collectors;

public class TM1RESTMetadataLoader {
    private static final String[] DEFAULT_MEMBER_PROPERTIES = new String[]{TM1Member.TM1MemberProperty.PARENT_UNIQUE_NAME.name(), TM1Member.TM1MemberProperty.PARENT_LEVEL.name()};
    private static final String MDX_QUERY_INFO_MSG = "MDX query string: \n%s";
    private static final String FAILED_TO_GET_THE_RESOURCE_FROM_THE_SERVER = "Failed to get the resource [%s] from the [%s]";
    private static final String FAILED_TO_LOAD_THE_NAMEDSET_LEVELS = "Failed to load the named set [%s] levels. [%s].";
    private static final String FAILED_TO_LOAD_THE_ANCESTORS = "Failed to load the ancestors of the member [%s] levels. [%s].";
    private static final String FAILED_TO_LOAD_THE_DESCENDANTS = "Failed to load the descendants of the member [%s]. [%s].";
    private static final String FAILED_TO_GET_THE_RESOURCE_REASON = "Failed to get the resource [%s]. Reason=[%s].";
    private static final String FOUND_CACHED_CUBE = "Found a cached TM1 cube [CUBE_NAME=%s].";
    private static final String CANCEL_TRACE_MSG = "The server successfully cancelled the current query [CONNECTION_ID=%d] - query completed.";
    private static final String BEGAN_QUERY_EXECUTION_MSG = "Began query execution [CONNECTION_ID=%d, SubsetName=%s].";
    private static final String SUBSET_NOT_A_MEMBER_SET = "Subset is not a hierarchy member set [CONNECTION_ID=%d, SubsetName=%s].";
    public static final String CONTAINS = "contains";
    public static final String STARSTWITH = "startswith";
    public static final String ENDSWITH = "endswith";
    public static final String EQ = "eq";
    public static final String NEQ = "neq";
    public static final String AND = "and";
    public static final String OR = "or";
    private final TM1RESTMetadataSession mSession;
    private final Locale mLocale;
    private final ExecutionEnvironment execEnvironment;
    private final boolean mValidatePASubsets;
    private final boolean mUseFillerMemberConfig;
    private final String mExecuteMDXForSubsetLevelsUri;
    private final String mExecuteMDXSetExpressionForMetadataQueryMembersUri;
    private final String mExecuteMDXSetExpressionForDataQueryMembersUri;
    private static final String ID_JSON_KEY = "ID";
    private static final String MDX_JSON_KEY = "MDX";
    private static final String SUBSET_TO_MEMBERS_MDX_TEMPLATE = "SELECT {TM1SubsetToSet([%s].[%s], '%s', '%s')} ON AXIS(0) FROM [%s]";
    private static final String SUBSET_TO_SET_MDX_TEMPLATE = "{TM1SubsetToSet([%s].[%s], '%s', '%s')}";
    private static final String SUBSET_TO_SET_ASCENDANTS_MDX_TEMPLATE = "{GENERATE( {TM1SubsetToSet([%s].[%s], '%s', '%s')}, EXCEPT ( ASCENDANTS( [%s].CurrentMember ), {[%s].CurrentMember}) )}";
    private static final String MEMBER_ANCESTORS_EXPRESSION_MDX_TEMPLATE = "{%s.Ancestors}";
    private static final String MEMBER_SELF_ANCESTORS_EXPRESSION_MDX_TEMPLATE = "{%s, %s.Ancestors}";
    private static final String SUBSET_LEVEL_EXPRESSION_MDX_TEMPLATE = "HEAD({FILTER({TM1SubsetToSet([%s].[%s],'%s', '%s')}, [%s].CurrentMember.Level.Ordinal = %d)})";
    private static final IJsonFactory TM1_JSON_FACTORY = BIJsonFactory.getInstance();
    private final boolean mUseRootMembersConfig;
    private static final ConcurrentHashMap<String, Gate> CUBE_CACHE_GATE = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> PA_SERVER_VERSION = new ConcurrentHashMap();
    private static final long CUBE_CACHE_GATE_WAIT_TIME = 120L;
    private List<String> mLocales = Collections.emptyList();

    TM1RESTMetadataLoader(TM1RESTMetadataSession session, Locale locale, ExecutionEnvironment aExecEnvironment) {
        this.mSession = session;
        this.execEnvironment = aExecEnvironment;
        this.mLocale = locale;
        this.mValidatePASubsets = TM1RESTMetadataLoader.getValidatePASubsetsConfig();
        this.mUseFillerMemberConfig = RESTClient.getPAUseFillerMemberConfig();
        this.mUseRootMembersConfig = RESTClient.getPAUseRootMembersConfig();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        this.mExecuteMDXForSubsetLevelsUri = RESTUriBuilder.getExecuteMDXForSubsetLevelsUri(uriBuilder).toString();
        uriBuilder.reset();
        this.mExecuteMDXSetExpressionForMetadataQueryMembersUri = RESTUriBuilder.getExecuteMDXSetExpressionMembers(uriBuilder, false).toString();
        uriBuilder.reset();
        this.mExecuteMDXSetExpressionForDataQueryMembersUri = RESTUriBuilder.getExecuteMDXSetExpressionMembers(uriBuilder, true).toString();
    }

    public TM1Cube loadCube(String cubeName, TM1RESTCubeCache cubeCache) {
        return this.loadCube(cubeName, cubeCache, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TM1Cube loadCube(String cubeName, TM1RESTCubeCache cubeCache, boolean reload) {
        int connectionId = System.identityHashCode((Object)this.getSession().getConnection());
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, "Loading a TM1 cube [CUBE_NAME=%s] from cache or data source.", cubeName);
        if (null == cubeCache) return this.bulkLoadCube(cubeName);
        String cubeCacheKey = TM1RESTCubeCache.getCubeCacheKey(cubeName, this.mLocales);
        TM1Cube cube = cubeCache.getCube(cubeCacheKey);
        if (null == cube || reload) {
            if (reload) {
                cube = null;
            }
            Gate newGate = new Gate();
            newGate.close();
            Gate gate = CUBE_CACHE_GATE.putIfAbsent(cubeCacheKey, newGate);
            if (gate != null) {
                try {
                    gate.await(120L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                cube = cubeCache.getCube(cubeCacheKey);
                if (null != cube) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, FOUND_CACHED_CUBE, cubeName);
                }
            }
            try {
                if (null != cube) return cube;
                cube = this.bulkLoadCube(cubeName);
                if (null != cube) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "Putting new TM1 cube [CUBE_NAME=%s] [Key=%s] [CONNECTION_ID=%d] into cache.", cubeName, cubeCacheKey, connectionId);
                    cubeCache.putCube(cubeCacheKey, cube);
                    return cube;
                }
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to load the TM1 cube [CUBE_NAME=%s].", cubeName);
                return cube;
            }
            finally {
                gate = CUBE_CACHE_GATE.remove(cubeCacheKey);
                if (gate != null) {
                    gate.open();
                }
            }
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, FOUND_CACHED_CUBE, cubeName);
        return cube;
    }

    public boolean isStaleCube(TM1Cube cachedCube, IJsonObject jsonCube) {
        IJsonArray cubeDims = jsonCube.getArray("value");
        if (null == cubeDims) {
            return false;
        }
        for (int i = 0; i < cubeDims.size(); ++i) {
            IJsonObject jsonDim = (IJsonObject)cubeDims.get(i);
            String dun = jsonDim.getStringValue("UniqueName");
            TM1Dimension cachedDimension = cachedCube.findDimension(dun);
            IJsonArray jsonHierarchies = jsonDim.getArray("Hierarchies");
            for (int j = 0; j < jsonHierarchies.size(); ++j) {
                IJsonObject jsonHierarchy = (IJsonObject)jsonHierarchies.get(j);
                String hierarchyName = jsonHierarchy.getStringValue("UniqueName");
                TM1Hierarchy cachedHierarchy = cachedDimension.findHierarchy(hierarchyName);
                if (null == cachedHierarchy || !this.isStaleHierarhy(cachedHierarchy, jsonHierarchy)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isStaleHierarhy(TM1Hierarchy cachedHierarchy, IJsonObject jsonHierarchy) {
        IJsonArray jsonSubsets = jsonHierarchy.getArray("Subsets");
        IJsonArray jsonPrivateSubsets = jsonHierarchy.getArray("PrivateSubsets");
        jsonSubsets.addAll(jsonPrivateSubsets);
        return this.isStaleSubsets(cachedHierarchy, jsonSubsets);
    }

    private boolean isStaleSubsets(TM1Hierarchy cachedHierarchy, IJsonArray jsonSubsets) {
        Set<String> cachedNamedSetETags = cachedHierarchy.getAllNamedSetETags();
        HashSet<String> namedSetETags = new HashSet<String>();
        for (int i = 0; i < jsonSubsets.size(); ++i) {
            IJsonObject jsonSubset = (IJsonObject)jsonSubsets.get(i);
            if (TM1RESTMetadataLoader.isControlSubset(jsonSubset)) continue;
            String eTag = jsonSubset.getStringValue("@odata.etag");
            if (!cachedNamedSetETags.contains(eTag)) {
                return true;
            }
            namedSetETags.add(eTag);
        }
        return !cachedNamedSetETags.equals(namedSetETags);
    }

    private TM1Cube bulkLoadCube(String cubeName) throws TM1RESTODPException {
        if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
            int connectionId = System.identityHashCode((Object)this.getSession().getConnection());
            String locales = "--";
            if (this.mLocales != null) {
                locales = String.join((CharSequence)", ", this.mLocales);
            }
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "Bulk-loading a TM1 cube [CUBE_NAME=%s] [CONNECTION_ID=%d] from data source for Locales [%s, %s]", cubeName, connectionId, locales, this.mLocale.toLanguageTag());
        }
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cubeName).expand("MeasuresDimension").expand("TimeDimension").expand("LocalizedAttributes");
        String adminHostCubeKey = this.getSession().getConnection().getAdminServerKey(cubeName, this.mLocales);
        TM1CubeSnapshot cubeSnapshot = TM1RESTServerSecurity.getCubeSnapshot(adminHostCubeKey);
        if (null == cubeSnapshot) {
            Date currentUTCDate = TM1Utils.getCurrentTimestampValue().getDate();
            TM1CubeTimestamps timestamps = new TM1CubeTimestamps(currentUTCDate, currentUTCDate);
            Set<String> eTags = this.createCubeSnapshot(cubeName);
            cubeSnapshot = new TM1CubeSnapshot(timestamps, this.mLocales);
            cubeSnapshot.create(eTags);
            if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                String camPassport = this.getSession().getConnection().getUserIdentity();
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "NEW_UTC [CUBE_NAME=%s] [Schema=%s] [Data=%s] [Key=%s] [CAM=%s]", cubeName, timestamps.getLastSchemaUpdate().toString(), timestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
            }
            cubeSnapshot = TM1RESTServerSecurity.getOrSetCubeSnapshot(adminHostCubeKey, cubeSnapshot);
        }
        TM1CubeTimestamps cubeTimestamp = cubeSnapshot.getCubeTimestamps();
        IJsonObject jsonCubeResource = null;
        jsonCubeResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
        if (!RESTClientResponse.validateAndLog(jsonCubeResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
            return null;
        }
        uriBuilder.reset();
        uriBuilder.entityId("Cubes", cubeName).entity("Dimensions").expand("Hierarchies").push().expand("DefaultMember").expand("AllMember").expand("Subsets").expand("PrivateSubsets").expand("ElementAttributes").expand("Levels").push().count().pop().pop().expand("DefaultHierarchy").push().select("UniqueName").pop().expand("LocalizedAttributes");
        TM1Cube cube = new TM1Cube(cubeTimestamp, this.mLocales, this.mLocale);
        IJsonObject jsonResource = null;
        try {
            if (TM1RESTMetadataLoader.isHierarchyLocalizationEnabled()) {
                String runLocaleTag = this.mLocale.toLanguageTag();
                List<String> cubeLocales = this.mLocales.stream().skip(1L).collect(Collectors.toList());
                if (!this.mLocales.contains(runLocaleTag)) {
                    cubeLocales.add(runLocaleTag);
                }
                Locale defLocale = TM1Utils.getNormalizedLocale(this.mLocales.get(0));
                jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, defLocale, "application/json", false);
                if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                    return null;
                }
                Map<String, List<IJsonObject>> localizedAttributes = this.collectLocalizedAttributes(cubeName, cubeLocales);
                ArrayList<Locale> locales = new ArrayList<Locale>();
                for (String localeTag : cubeLocales) {
                    locales.add(TM1Utils.getNormalizedLocale(localeTag));
                }
                cube.populate(jsonCubeResource, defLocale);
                IJsonArray cubeDims = jsonResource.getArray("value");
                this.bulkLoadDimensions(cube, cubeDims, defLocale, locales, localizedAttributes);
            } else {
                jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale, "application/json", false);
                if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                    return null;
                }
                cube.populate(jsonCubeResource, this.mLocale);
                IJsonArray cubeDims = jsonResource.getArray("value");
                this.bulkLoadDimensions(cube, cubeDims, this.mLocale, null, null);
            }
            if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                int connectionId = System.identityHashCode((Object)this.getSession().getConnection());
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "Loaded TM1 cube [CUBE_NAME=%s] [Schema=%s] [Data=%s] [Key=%s] [CONNECTION_ID=%d]", cubeName, cubeTimestamp.getLastSchemaUpdate().toString(), cubeTimestamp.getLastDataUpdate().toString(), adminHostCubeKey, connectionId);
            }
        }
        catch (TM1RESTODPException ex) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_FROM_THE_SERVER, uriBuilder.toString(), this.getSession().getConnection().getServerName());
            return cube;
        }
        this.bulkLoadDefaultAttributes(cube);
        return cube;
    }

    public TM1RESTMetadataSession getSession() {
        return this.mSession;
    }

    private void bulkLoadDimensions(TM1Cube cube, IJsonArray cubeDims, Locale defaultLocale, List<Locale> locales, Map<String, List<IJsonObject>> localizedAttributes) {
        for (int i = 0; i < cubeDims.size(); ++i) {
            IJsonObject jsonDim = (IJsonObject)cubeDims.get(i);
            TM1Dimension dimension = new TM1Dimension(cube);
            dimension.populate(jsonDim, defaultLocale, locales, localizedAttributes);
            cube.addDimension(dimension);
            IJsonArray jsonHierarchies = jsonDim.getArray("Hierarchies");
            this.bulkLoadHierarchies(dimension, jsonHierarchies, defaultLocale, locales, localizedAttributes);
            IJsonObject defHierObj = jsonDim.getJsonObject("DefaultHierarchy");
            dimension.setDefaultHierarchy(defHierObj.getStringValue("UniqueName"));
        }
    }

    private void bulkLoadHierarchies(TM1Dimension dimension, IJsonArray jsonHierarchies, Locale defaultLocale, List<Locale> locales, Map<String, List<IJsonObject>> localizedAttributes) {
        boolean bAddDimensionAttribute = true;
        for (int i = 0; i < jsonHierarchies.size(); ++i) {
            IJsonObject jsonHierarchyFresh;
            IJsonObject jsonHierarchy = (IJsonObject)jsonHierarchies.get(i);
            String hierarchyName = jsonHierarchy.getStringValue("Name");
            if (hierarchyName.equals(dimension.getAllLeavesHierarchyName())) continue;
            TM1Hierarchy hierarchy = new TM1Hierarchy(dimension);
            hierarchy.populate(jsonHierarchy, defaultLocale, locales, localizedAttributes);
            if ((null == hierarchy.getDefaultMemberUN() || hierarchy.getDefaultMemberUN().isEmpty()) && (jsonHierarchyFresh = this.getHierarchyResource(dimension, hierarchyName)) != null) {
                hierarchy.populate(jsonHierarchyFresh, defaultLocale, locales, localizedAttributes);
            }
            dimension.addHierarchy(hierarchy);
            IJsonArray jsonLevels = jsonHierarchy.getArray("Levels");
            this.bulkLoadLevels(hierarchy, jsonLevels);
            IJsonArray jsonSubsets = jsonHierarchy.getArray("Subsets");
            this.bulkLoadSubsets(hierarchy, jsonSubsets, false);
            IJsonArray jsonPrivateSubsets = jsonHierarchy.getArray("PrivateSubsets");
            this.bulkLoadSubsets(hierarchy, jsonPrivateSubsets, true);
            IJsonArray jsonAttributes = jsonHierarchy.getArray("ElementAttributes");
            if (null != jsonAttributes) {
                this.bulkLoadCustomAttributesEx(hierarchy, jsonAttributes);
                if (bAddDimensionAttribute) {
                    bAddDimensionAttribute = false;
                    this.loadDimensionCustomAttributes(dimension, jsonAttributes);
                }
            }
            if (dimension.isMeasureDimension()) {
                this.loadMeasureMembers(hierarchy);
                continue;
            }
            this.loadAccessibleRootMembers(hierarchy);
        }
    }

    private void bulkLoadSubsets(TM1Hierarchy hierarchy, IJsonArray jsonSubsets, boolean bprivate) {
        for (int i = 0; i < jsonSubsets.size(); ++i) {
            IJsonObject jsonSubset = (IJsonObject)jsonSubsets.get(i);
            if (TM1RESTMetadataLoader.isControlSubset(jsonSubset)) continue;
            TM1NamedSet namedSet = new TM1NamedSet(hierarchy);
            namedSet.setPrivate(bprivate);
            namedSet.populate(jsonSubset);
            if (!this.mValidatePASubsets || this.isSubsetSupported(namedSet)) {
                hierarchy.addNamedSet(namedSet);
                continue;
            }
            hierarchy.addNamedSetETag(namedSet.getETag());
            int connectionId = System.identityHashCode((Object)this.getSession().getConnection());
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.WARN, SUBSET_NOT_A_MEMBER_SET, connectionId, namedSet.getName());
        }
    }

    private void bulkLoadLevels(TM1Hierarchy hierarchy, IJsonArray jsonLevels) {
        for (int i = 0; i < jsonLevels.size(); ++i) {
            IJsonObject jsonLevel = (IJsonObject)jsonLevels.get(i);
            TM1Level level = new TM1Level(hierarchy);
            level.populate(jsonLevel);
            hierarchy.addLevel(level);
        }
    }

    private void bulkLoadDefaultAttributes(TM1Cube cube) {
        for (TM1Dimension dimension : cube.getDimensions()) {
            for (TM1Hierarchy hierarchy : dimension.getHierarchies()) {
                TM1Attribute attribute = TM1Attribute.createHierarchyBusinessKey(hierarchy, this.mLocale, this.mLocales);
                hierarchy.addAttribute(attribute);
                if (hierarchy.isParentChild()) continue;
                for (TM1Level level : hierarchy.getLevels()) {
                    attribute = TM1Attribute.createLevelBusinessKey(level, this.mLocale, this.mLocales);
                    level.addAttribute(attribute);
                }
            }
        }
    }

    private void bulkLoadCustomAttributesEx(TM1Hierarchy hierarchy, IJsonArray jsonAttributes) {
        for (int i = 0; i < jsonAttributes.size(); ++i) {
            IJsonObject jsonAttribute = (IJsonObject)jsonAttributes.get(i);
            TM1Attribute hierarchyAttribute = new TM1Attribute(hierarchy, RoleTypeEnum.MEMBER_CUSTOM_PROPERTY);
            hierarchyAttribute.populate(jsonAttribute);
            if (TM1RESTMetadataLoader.canSkipAttribute(hierarchyAttribute)) continue;
            hierarchy.addAttribute(hierarchyAttribute);
            if (hierarchy.isParentChild()) continue;
            for (TM1Level level : hierarchy.getLevels()) {
                TM1Attribute levelAttribute = new TM1Attribute(level, RoleTypeEnum.MEMBER_CUSTOM_PROPERTY);
                levelAttribute.populate(jsonAttribute);
                level.addAttribute(levelAttribute);
            }
        }
    }

    private void loadDimensionCustomAttributes(TM1Dimension dimension, IJsonArray jsonAttributes) {
        for (int j = 0; j < jsonAttributes.size(); ++j) {
            IJsonObject jsonAttribute = (IJsonObject)jsonAttributes.get(j);
            TM1Attribute dimensionAttribute = new TM1Attribute(dimension, RoleTypeEnum.MEMBER_CUSTOM_PROPERTY);
            dimensionAttribute.populate(jsonAttribute);
            if (TM1RESTMetadataLoader.canSkipAttribute(dimensionAttribute)) continue;
            dimension.addAttribute(dimensionAttribute);
        }
    }

    private String executeSubsetMembersMDX(String dimensionName, String hierarchyName, String subsetName, String scope, String cubeName) throws IOException {
        String mdxText = String.format(SUBSET_TO_MEMBERS_MDX_TEMPLATE, dimensionName, hierarchyName, subsetName, scope, cubeName);
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, MDX_QUERY_INFO_MSG, mdxText);
        IJsonObject mdxJsonObj = TM1_JSON_FACTORY.createObject();
        mdxJsonObj.put(MDX_JSON_KEY, mdxText);
        RESTClient restClient = this.getSession().getConnection().getServer();
        IJsonObject jsonResponse = restClient.createResourceAsync(restClient.getExecuteMDXUri(), "application/json", mdxJsonObj, this.execEnvironment);
        RESTClientResponse.validateAndThrow(jsonResponse, mdxText, TM1RESTMessageKeys.ERR_MDX_EXECUTION_FAILURE);
        return jsonResponse.getStringValue(ID_JSON_KEY);
    }

    public List<TM1Member> loadAccessibleRootMembers(TM1Hierarchy hierarchy) {
        ArrayList<TM1Member> roots = new ArrayList<TM1Member>();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName());
        if (this.mUseFillerMemberConfig) {
            uriBuilder.entityId("Levels", 0L);
            uriBuilder.entity("Members");
        }
        if (!this.mUseFillerMemberConfig) {
            if (this.mUseRootMembersConfig) {
                uriBuilder.action("RootMembers()");
            } else {
                uriBuilder.entity("Members");
                uriBuilder.filterEq("Parent", "null");
            }
            uriBuilder.expand("Level").push().select("Number").pop();
        }
        uriBuilder.expand("LocalizedAttributes").expand("Children/$count");
        if (dimension.isMeasureDimension()) {
            uriBuilder.expand("Element");
        }
        try {
            IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
            if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                return Collections.emptyList();
            }
            IJsonArray jsonMembers = jsonResource.getArray("value");
            String[] dimProperties = TM1Utils.getDimenstionProperties(dimension.getUniqueName());
            TM1Level levelOne = hierarchy.findLevel(0);
            for (int i = 0; i < jsonMembers.size(); ++i) {
                TM1Member member;
                IJsonObject jsonMember = (IJsonObject)jsonMembers.get(i);
                if (this.mUseFillerMemberConfig) {
                    member = new TM1Member(levelOne);
                } else {
                    IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
                    long levelNumber = jsonLevel.getLongValue("Number");
                    TM1Level level = hierarchy.findLevel((int)levelNumber);
                    member = new TM1Member(level);
                }
                member.populate(jsonMember, dimProperties, this.mLocale);
                roots.add(member);
            }
            hierarchy.setAccessibleRoots(roots);
        }
        catch (TM1RESTODPException ex) {
            this.logTM1RESTODPException(uriBuilder.toString(), ex);
            return Collections.emptyList();
        }
        return roots;
    }

    public void loadMeasureMembers(TM1Hierarchy hierarchy) {
        TM1Dimension dimension = hierarchy.getDimension();
        if (!dimension.isMeasureDimension()) {
            throw new IllegalArgumentException("Dimension isn't a measure dimension.");
        }
        ArrayList<TM1Member> roots = new ArrayList<TM1Member>();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entity("Members").expand("Level").push().select("Number").pop().expand("Parent").push().select("UniqueName").pop().expand("Element").push().select("Type").pop().expand("Children/$count");
        try {
            int i;
            String runLocaleTag = this.mLocale.toLanguageTag();
            List<String> cubeLocales = this.mLocales;
            if (!this.mLocales.contains(runLocaleTag)) {
                cubeLocales = new ArrayList<String>(this.mLocales);
                cubeLocales.add(runLocaleTag);
            }
            Locale defLocale = new Locale(this.mLocales.get(0));
            IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, defLocale);
            if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                return;
            }
            IJsonArray jsonMembers = jsonResource.getArray("value");
            String[] dimProperties = TM1Utils.getDimenstionProperties(dimension.getUniqueName());
            ArrayList<Locale> locales = new ArrayList<Locale>();
            ArrayList<IJsonArray> localizedCaptions = new ArrayList<IJsonArray>();
            if (cubeLocales.size() > 1) {
                uriBuilder.reset();
                uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entity("Members").select("Attributes/Caption");
                for (i = 1; i < cubeLocales.size(); ++i) {
                    String localeTag = cubeLocales.get(i);
                    Locale locale = new Locale(localeTag);
                    locales.add(locale);
                    IJsonObject jsonLocalizedResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, locale);
                    if (!RESTClientResponse.validateAndLog(jsonLocalizedResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) continue;
                    localizedCaptions.add(jsonLocalizedResource.getArray("value"));
                }
            }
            for (i = 0; i < jsonMembers.size(); ++i) {
                IJsonObject jsonMember = (IJsonObject)jsonMembers.get(i);
                IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
                long levelNumber = jsonLevel.getLongValue("Number");
                TM1Level level = hierarchy.findLevel((int)levelNumber);
                TM1Member member = new TM1Member(level);
                member.populate(jsonMember, dimProperties, this.mLocale);
                for (int j = 0; j < locales.size(); ++j) {
                    IJsonObject jsonLocalizedMember = (IJsonObject)((IJsonArray)localizedCaptions.get(j)).get(i);
                    IJsonObject jsonLocalizedAttributes = jsonLocalizedMember.getJsonObject("Attributes");
                    member.setCaptionForLocale((Locale)locales.get(j), jsonLocalizedAttributes);
                }
                if (null == member.getParentMUN()) {
                    roots.add(member);
                } else {
                    TM1Member parent = hierarchy.getMemberWithChildren(member.getParentMUN());
                    parent.addChild(member);
                }
                hierarchy.putMemberWithChildren(member);
            }
            hierarchy.setAccessibleRoots(roots);
        }
        catch (TM1RESTODPException ex) {
            this.logTM1RESTODPException(uriBuilder.toString(), ex);
        }
    }

    public TM1Member loadSingleMember(TM1Hierarchy hierarchy, String mun, String[] dimProperties) {
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entityId("Members", mun).expand("Level").push().select("Number").pop().expand("Parent").push().select("UniqueName").pop().expand("LocalizedAttributes").expand("Children/$count");
        if (dimension.isMeasureDimension()) {
            uriBuilder.expand("Element");
        }
        try {
            IJsonObject jsonMember = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
            if (!RESTClientResponse.validateAndLog(jsonMember, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                return null;
            }
            IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
            long levelNumber = jsonLevel.getLongValue("Number");
            TM1Level level = hierarchy.findLevel((int)levelNumber);
            TM1Member member = new TM1Member(level);
            member.populate(jsonMember, dimProperties, this.mLocale);
            return member;
        }
        catch (TM1RESTODPException ex) {
            this.logTM1RESTODPException(uriBuilder.toString(), ex);
            return null;
        }
    }

    public void loadHierarchyMembers(TM1Hierarchy hierarchy, String[] dimProperties, int rangeFrom, int rangeSize, List<TM1Member> result) {
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entity("Members").expand("Level").push().select("Number").pop().expand("Parent").push().select("UniqueName").pop().expand("Children/$count");
        if (dimension.isMeasureDimension()) {
            uriBuilder.expand("Element");
        }
        this.addRange(uriBuilder, rangeFrom, rangeSize);
        try {
            IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
            if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                return;
            }
            IJsonArray jsonMembers = jsonResource.getArray("value");
            for (int i = 0; i < jsonMembers.size(); ++i) {
                IJsonObject jsonMember = (IJsonObject)jsonMembers.get(i);
                IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
                long levelNumber = jsonLevel.getLongValue("Number");
                TM1Level level = hierarchy.findLevel((int)levelNumber);
                result.add(this.createMember(jsonMember, level, dimProperties));
            }
        }
        catch (TM1RESTODPException ex) {
            this.logTM1RESTODPException(uriBuilder.toString(), ex);
        }
    }

    public void loadLevelMembers(TM1Level level, String[] dimProperties, int rangeFrom, int rangeSize, boolean dataQuery, List<TM1Member> result) {
        TM1Hierarchy hierarchy = level.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entityId("Levels", level.getLevelNumber()).entity("Members").expand("Parent").push().select("UniqueName").pop();
        if (!dataQuery) {
            uriBuilder.expand("LocalizedAttributes");
        }
        uriBuilder.expand("Children/$count");
        try {
            if (0 == rangeFrom && Integer.MAX_VALUE == rangeSize) {
                long cardinality = -1L;
                JsonArrayStream jsonStream = new JsonArrayStream(client, this.execEnvironment, uriBuilder.toString(), cardinality, this.mLocale);
                for (IJsonObject jsonMember : jsonStream) {
                    TM1Member member = new TM1Member(level);
                    member.populate(jsonMember, dimProperties, this.mLocale);
                    result.add(member);
                }
            } else {
                this.addRange(uriBuilder, rangeFrom, rangeSize);
                IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale, "application/json;odata.metadata=none");
                IJsonArray jsonMembers = jsonResource.getArray("value");
                for (int i = 0; i < jsonMembers.size(); ++i) {
                    IJsonObject jsonMember = (IJsonObject)jsonMembers.get(i);
                    TM1Member member = new TM1Member(level);
                    member.populate(jsonMember, dimProperties, this.mLocale);
                    result.add(member);
                }
            }
        }
        catch (TM1RESTODPException ex) {
            this.logTM1RESTODPException(uriBuilder.toString(), ex);
        }
    }

    public void loadNamedSetMembers(TM1NamedSet namedSet, int rangeFrom, int rangeSize, List<TM1Member> result) {
        TM1Hierarchy hierarchy = namedSet.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        String subsetNavigation = TM1RESTMetadataLoader.getSubsetNavigationProperty(namedSet);
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entityId(subsetNavigation, namedSet.getName()).select("Name", "Expression");
        IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
        if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
            return;
        }
        String subsetName = jsonResource.getStringValue("Name");
        int connectionId = System.identityHashCode((Object)this.getSession().getConnection());
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, BEGAN_QUERY_EXECUTION_MSG, connectionId, subsetName);
        String cellSetId = null;
        long startTime = System.currentTimeMillis();
        try {
            cellSetId = this.executeSubsetMembersMDX(dimension.getName(), hierarchy.getName(), subsetName, namedSet.getScope(), cube.getName());
        }
        catch (TM1RESTODPException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
        if (this.execEnvironment.getCancelManager().isRequestCancelled()) {
            client.deleteCellset(cellSetId);
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, CANCEL_TRACE_MSG, connectionId);
            throw new OperationCanceledException();
        }
        if (cellSetId != null && !cellSetId.isEmpty()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, "Finished query execution [CONNECTION_ID=%d, SubsetName=%s] in %d milliseconds.", connectionId, subsetName, elapsedTime);
            Locale aLocale = null;
            if (this.execEnvironment.getRequestEnvironment() != null && ((RequestEnvironment)this.execEnvironment.getRequestEnvironment()).getRunLocale() != null) {
                aLocale = ((RequestEnvironment)this.execEnvironment.getRequestEnvironment()).getRunLocale();
            }
            RESTClient restClient = this.getSession().getConnection().getServer();
            try {
                IJsonArray jsonAxisArray;
                String axesUri = RESTUriBuilder.getAxesUri(cellSetId, restClient.getUriBuilder());
                IJsonObject jsonAxisSet = restClient.getJsonResource(axesUri, this.execEnvironment, aLocale);
                if (jsonAxisSet != null && !jsonAxisSet.isEmpty() && (jsonAxisArray = jsonAxisSet.getArray("value")) != null && !jsonAxisArray.isEmpty()) {
                    uriBuilder.reset();
                    RESTUriBuilder.getTuplesMembersUri(cellSetId, 0L, uriBuilder);
                    this.addRange(uriBuilder, rangeFrom, rangeSize);
                    String tuplesUri = uriBuilder.toString();
                    IJsonObject jsonTupleSet = restClient.getJsonResource(tuplesUri, this.execEnvironment);
                    String[] dimProperties = TM1Utils.getDimenstionProperties(dimension.getUniqueName());
                    IJsonArray jsonTupleArray = jsonTupleSet.getArray("value");
                    for (Object objTuple : jsonTupleArray) {
                        IJsonObject jsonTuple = (IJsonObject)objTuple;
                        IJsonArray memberArray = jsonTuple.getArray("Members");
                        for (Object objMember : memberArray) {
                            IJsonObject jsonMember = (IJsonObject)objMember;
                            IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
                            long levelNumber = jsonLevel.getLongValue("Number");
                            TM1Level level = hierarchy.findLevel((int)levelNumber);
                            TM1Member member = this.createMember(jsonMember, level, dimProperties);
                            result.add(member);
                        }
                    }
                }
                restClient.deleteCellset(cellSetId);
            }
            catch (TM1RESTODPException e) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to get the cell set [%s].", cellSetId);
            }
        } else {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Query execution [CONNECTION_ID=%d, SubsetName=%s] failed returning an invalid cellCetID.", connectionId, subsetName);
        }
    }

    public void loadNamedSetMembersEx(TM1NamedSet namedSet, int rangeFrom, int rangeSize, boolean ascendants, List<TM1Member> result) {
        TM1Hierarchy hierarchy = namedSet.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        RESTClient client = this.getSession().getConnection().getServer();
        int connectionId = System.identityHashCode((Object)this.getSession().getConnection());
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, BEGAN_QUERY_EXECUTION_MSG, connectionId, namedSet.getName());
        String mdxText = ascendants ? String.format(SUBSET_TO_SET_ASCENDANTS_MDX_TEMPLATE, dimension.getName(), hierarchy.getName(), namedSet.getName(), namedSet.getScope(), dimension.getName(), dimension.getName()) : String.format(SUBSET_TO_SET_MDX_TEMPLATE, dimension.getName(), hierarchy.getName(), namedSet.getName(), namedSet.getScope());
        IJsonObject mdxJsonObj = TM1_JSON_FACTORY.createObject();
        mdxJsonObj.put(MDX_JSON_KEY, mdxText);
        try {
            IJsonObject jsonResource = client.createResourceAsync(this.getExecuteMDXSetExpressionForMembersUri(true), "application/json", mdxJsonObj, this.execEnvironment);
            IJsonArray jsonTuples = jsonResource.getArray("Tuples");
            String[] dimProperties = TM1Utils.getDimenstionProperties(dimension.getUniqueName());
            this.collectTupleMembers(jsonTuples, hierarchy, dimProperties, result);
        }
        catch (TM1RESTODPException | IOException ex) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_LOAD_THE_NAMEDSET_LEVELS, namedSet.getName(), ((Throwable)ex).getLocalizedMessage());
        }
        if (this.execEnvironment.getCancelManager().isRequestCancelled()) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, CANCEL_TRACE_MSG, connectionId);
            throw new OperationCanceledException();
        }
    }

    public void loadNamedSetLevels(TM1NamedSet namedSet, List<String> result) {
        TM1Hierarchy hierarchy = namedSet.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        String subsetNavigation = TM1RESTMetadataLoader.getSubsetNavigationProperty(namedSet);
        int iLevel = 0;
        while ((long)iLevel < hierarchy.getLevelsNumber()) {
            uriBuilder.reset();
            uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName()).entityId(subsetNavigation, namedSet.getName()).expand("Elements").push().select("Level").filterEq("Level", iLevel).top(1L).pop();
            try {
                IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
                if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                    return;
                }
                IJsonArray jsonElements = jsonResource.getArray("Elements");
                if (!jsonElements.isEmpty()) {
                    TM1Level level = hierarchy.findRevLevel(iLevel);
                    result.add(level.getUniqueName());
                }
            }
            catch (TM1RESTODPException ex) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, FAILED_TO_LOAD_THE_NAMEDSET_LEVELS, namedSet.getName(), ex.getLocalizedMessage());
                return;
            }
            ++iLevel;
        }
    }

    public void loadNamedSetLevelsEx(TM1NamedSet namedSet, List<String> result) {
        TM1Hierarchy hierarchy = namedSet.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        RESTClient client = this.getSession().getConnection().getServer();
        StringJoiner mdxText = new StringJoiner(",", "{", "}");
        for (long iLevel = 0L; iLevel < hierarchy.getLevelsNumber(); ++iLevel) {
            mdxText.add(String.format(SUBSET_LEVEL_EXPRESSION_MDX_TEMPLATE, dimension.getName(), hierarchy.getName(), namedSet.getName(), namedSet.getScope(), dimension.getName(), iLevel));
        }
        IJsonObject mdxJsonObj = TM1_JSON_FACTORY.createObject();
        mdxJsonObj.put(MDX_JSON_KEY, mdxText.toString());
        try {
            StringBuilder sb;
            IJsonObject jsonResource = client.createResourceAsync(this.mExecuteMDXForSubsetLevelsUri, "application/json", mdxJsonObj, this.execEnvironment);
            RESTStateEnum state = RESTStateEnum.getState(jsonResource);
            Long statusCode = RESTStateEnum.getStatusCode(jsonResource);
            Object errorObject = jsonResource.get("error");
            if (RESTStateEnum.FAILED == state || errorObject != null) {
                if (null == errorObject) {
                    errorObject = mdxText;
                }
                sb = new StringBuilder("Status: ");
                sb.append(statusCode.toString());
                sb.append("Error: ");
                sb.append(errorObject.toString());
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_LOAD_THE_NAMEDSET_LEVELS, namedSet.getName(), sb.toString());
            } else if (RESTStateEnum.UNKNOWN == state) {
                sb = new StringBuilder("Status: ");
                sb.append(statusCode.toString());
                sb.append("MDX: ");
                sb.append(mdxText);
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_LOAD_THE_NAMEDSET_LEVELS, namedSet.getName(), sb.toString());
            }
            IJsonArray jsonTuples = jsonResource.getArray("Tuples");
            for (int iTuple = 0; iTuple < jsonTuples.size(); ++iTuple) {
                IJsonObject jsonTuple = (IJsonObject)jsonTuples.get(iTuple);
                IJsonArray jsonMembers = jsonTuple.getArray("Members");
                if (jsonMembers.isEmpty()) continue;
                IJsonObject jsonMember = (IJsonObject)jsonMembers.get(0);
                IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
                long levelNumber = jsonLevel.getLongValue("Number");
                TM1Level level = hierarchy.findLevel((int)levelNumber);
                result.add(level.getUniqueName());
            }
        }
        catch (TM1RESTODPException | IOException ex) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_LOAD_THE_NAMEDSET_LEVELS, namedSet.getName(), ((Throwable)ex).getLocalizedMessage());
        }
    }

    public void loadMembersTreeOp(TM1Hierarchy hierarchy, String memberName, Set<TreeOperator> treeOps, Set<QueryMode> queryModes, String[] dimProperties, int rangeFrom, int rangeSize, List<TM1Member> result) {
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        if (null != treeOps && treeOps.contains((Object)TreeOperator.Ancestors) && memberName != null) {
            String mun = UniqueNameGenerator.createUniqueName((String)dimension.getName(), (String)hierarchy.getName(), (String)memberName);
            String mdxText = treeOps.contains((Object)TreeOperator.Self) ? String.format(MEMBER_SELF_ANCESTORS_EXPRESSION_MDX_TEMPLATE, mun, mun) : String.format(MEMBER_ANCESTORS_EXPRESSION_MDX_TEMPLATE, mun);
            IJsonObject mdxJsonObj = TM1_JSON_FACTORY.createObject();
            mdxJsonObj.put(MDX_JSON_KEY, mdxText);
            try {
                String uri = this.getExecuteMDXSetExpressionForMembersUri(queryModes.contains((Object)QueryMode.DataQuery));
                IJsonObject jsonResource = client.createResourceAsync(uri, "application/json", mdxJsonObj, this.execEnvironment);
                IJsonArray jsonTuples = jsonResource.getArray("Tuples");
                this.collectTupleMembers(jsonTuples, hierarchy, dimProperties, result);
            }
            catch (TM1RESTODPException | IOException ex) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, FAILED_TO_LOAD_THE_ANCESTORS, mun, ((Throwable)ex).getLocalizedMessage());
            }
            return;
        }
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName());
        if (null == memberName) {
            uriBuilder.entity("Members");
        } else {
            uriBuilder.entityId("Members", memberName);
        }
        this.addTreeOpsAndLevelNumber(treeOps, queryModes, uriBuilder, hierarchy, memberName, null);
        if (dimension.isMeasureDimension()) {
            uriBuilder.expand("Element");
        }
        this.addRange(uriBuilder, rangeFrom, rangeSize);
        this.getTreeOpMembers(hierarchy, memberName, treeOps, queryModes, null, uriBuilder.toString(), dimProperties, result);
    }

    private void getTreeOpMembers(TM1Hierarchy hierarchy, String mun, Set<TreeOperator> treeOps, Set<QueryMode> queryModes, MASearchCriteria searchCriteria, String uri, String[] dimProperties, List<TM1Member> result) {
        RESTClient client = this.getSession().getConnection().getServer();
        try {
            if (null == mun) {
                IJsonObject jsonResource = client.getJsonResource(uri, this.mSession.getExecutionEnvironment(), this.mLocale, "application/json", false);
                if (!RESTClientResponse.validateAndLog(jsonResource, uri, this.getSession().getConnection().getServerName())) {
                    return;
                }
                IJsonArray jsonMembers = jsonResource.getArray("value");
                for (int i = 0; i < jsonMembers.size(); ++i) {
                    IJsonObject jsonMember = (IJsonObject)jsonMembers.get(i);
                    TM1Level level = this.findLevel(jsonMember, hierarchy);
                    result.add(this.createMember(jsonMember, level, dimProperties));
                }
            } else {
                IJsonObject jsonParent;
                IJsonObject jsonMember = this.getMemberWithRetryOnElementName(mun, uri, client, queryModes);
                if (!RESTClientResponse.validateAndLog(jsonMember, uri, this.getSession().getConnection().getServerName())) {
                    return;
                }
                TM1Level level = this.findLevel(jsonMember, hierarchy);
                if (null == treeOps || treeOps.isEmpty() || treeOps.contains((Object)TreeOperator.Self)) {
                    result.add(this.createMember(jsonMember, level, dimProperties));
                }
                if (null != treeOps && treeOps.contains((Object)TreeOperator.Children)) {
                    IJsonArray children = jsonMember.getArray("Children");
                    for (int i = 0; i < children.size(); ++i) {
                        IJsonObject jsonChildMember = (IJsonObject)children.get(i);
                        level = this.findLevel(jsonChildMember, hierarchy);
                        result.add(this.createMember(jsonChildMember, level, dimProperties));
                    }
                }
                if (null != treeOps && treeOps.contains((Object)TreeOperator.Siblings) && (jsonParent = jsonMember.getJsonObject("Parent")) != null) {
                    IJsonArray children = jsonParent.getArray("Children");
                    for (int i = 0; i < children.size(); ++i) {
                        IJsonObject jsonChildMember = (IJsonObject)children.get(i);
                        level = this.findLevel(jsonChildMember, hierarchy);
                        result.add(this.createMember(jsonChildMember, level, dimProperties));
                    }
                }
                if (null != treeOps && treeOps.contains((Object)TreeOperator.Parent) && (jsonParent = jsonMember.getJsonObject("Parent")) != null) {
                    level = this.findLevel(jsonParent, hierarchy);
                    result.add(this.createMember(jsonParent, level, dimProperties));
                }
                if (null != treeOps && treeOps.contains((Object)TreeOperator.Ancestors)) {
                    for (jsonParent = jsonMember.getJsonObject("Parent"); jsonParent != null; jsonParent = jsonParent.getJsonObject("Parent")) {
                        level = this.findLevel(jsonParent, hierarchy);
                        result.add(this.createMember(jsonParent, level, dimProperties));
                    }
                }
                if (null != treeOps && treeOps.contains((Object)TreeOperator.Descendants)) {
                    IJsonArray jsonChildren = jsonMember.getArray("Children");
                    JsonAttributeFilter filter = new JsonAttributeFilter(searchCriteria);
                    this.buildDescendantsMembers(jsonChildren, hierarchy, filter, dimProperties, result);
                }
            }
        }
        catch (TM1RESTODPException ex) {
            this.logTM1RESTODPException(uri, ex);
        }
    }

    public void loadMemberSearch(TM1RESTMetadata metadata, MASearchCriteria searchCriteria, Set<TreeOperator> treeOps, Set<QueryMode> queryModes, String[] dimProperties, int rangeFrom, int rangeSize, List<TM1Member> result) {
        if (null == searchCriteria) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Member search criteria was not specified.");
        }
        TM1Hierarchy hierarchy = null;
        TM1Level level = null;
        TM1Member member = null;
        switch (metadata.getType()) {
            case HIERARCHY: {
                hierarchy = (TM1Hierarchy)metadata;
                break;
            }
            case LEVEL: {
                level = (TM1Level)metadata;
                hierarchy = level.getHierarchy();
                break;
            }
            case MEMBER: {
                member = (TM1Member)metadata;
                level = member.getLevel();
                hierarchy = level.getHierarchy();
                break;
            }
            default: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalError_INTERNAL);
            }
        }
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        if (member != null) {
            result.add(member);
            RESTUriBuilder.getExecuteMDXSetExpressionMembers(uriBuilder, false);
            this.addRange(uriBuilder, rangeFrom, rangeSize);
            String mdxText = MemberSearchMdxBuilder.buildMdxAtMember(member.getUniqueName(), hierarchy, searchCriteria, treeOps);
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, MDX_QUERY_INFO_MSG, mdxText);
            IJsonObject mdxJsonObj = TM1_JSON_FACTORY.createObject();
            mdxJsonObj.put(MDX_JSON_KEY, mdxText);
            try {
                IJsonObject jsonResource = client.createResourceAsync(uriBuilder.toString(), "application/json", mdxJsonObj, this.execEnvironment);
                IJsonArray jsonTuples = jsonResource.getArray("Tuples");
                this.collectTupleMembers(jsonTuples, hierarchy, dimProperties, result);
            }
            catch (TM1RESTODPException | IOException ex) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_LOAD_THE_DESCENDANTS, member.getUniqueName(), ((Throwable)ex).getLocalizedMessage());
            }
            return;
        }
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchy.getName());
        if (level != null) {
            uriBuilder.entityId("Levels", level.getLevelNumber());
        }
        String mun = null;
        uriBuilder.entity("Members");
        this.addTreeOpsAndLevelNumber(treeOps, queryModes, uriBuilder, hierarchy, mun, searchCriteria);
        this.addSearchCriteria(searchCriteria, uriBuilder);
        this.addRange(uriBuilder, rangeFrom, rangeSize);
        this.getTreeOpMembers(hierarchy, mun, treeOps, queryModes, searchCriteria, uriBuilder.toString(), dimProperties, result);
    }

    public static boolean isDefaultProperty(String propName) {
        for (String field : DEFAULT_MEMBER_PROPERTIES) {
            if (!field.equals(propName)) continue;
            return true;
        }
        return false;
    }

    public void setLocalesRestriction(List<String> locales) {
        this.mLocales = locales;
    }

    public Set<String> createCubeSnapshot(String cubeName) {
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        RESTUriBuilder.getSubsetsETagsUri(cubeName, uriBuilder);
        IJsonObject jsonCubeResource = null;
        jsonCubeResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
        RESTClientResponse.validateAndThrow(jsonCubeResource, cubeName, TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_CODE_AND_MESSAGE);
        return this.createCubeSnapshot(jsonCubeResource);
    }

    public Set<String> createCubeSnapshot(IJsonObject jsonCube) {
        LinkedHashSet<String> snapshot = new LinkedHashSet<String>();
        IJsonArray cubeDims = jsonCube.getArray("value");
        for (int i = 0; i < cubeDims.size(); ++i) {
            IJsonObject jsonDim = (IJsonObject)cubeDims.get(i);
            IJsonArray jsonHierarchies = jsonDim.getArray("Hierarchies");
            for (int j = 0; j < jsonHierarchies.size(); ++j) {
                IJsonObject jsonHierarchy = (IJsonObject)jsonHierarchies.get(j);
                IJsonArray jsonSubsets = jsonHierarchy.getArray("Subsets");
                this.collectSubsetETags(jsonSubsets, snapshot);
                IJsonArray jsonPrivateSubsets = jsonHierarchy.getArray("PrivateSubsets");
                this.collectSubsetETags(jsonPrivateSubsets, snapshot);
            }
        }
        return snapshot;
    }

    public String getServerVersion() {
        String serverPortKey = this.getSession().getConnection().getServerPortKey();
        String serverVersion = PA_SERVER_VERSION.get(serverPortKey);
        if (null == serverVersion) {
            RESTClient client = this.getSession().getConnection().getServer();
            ODataUriBuilder uriBuilder = client.getUriBuilder();
            uriBuilder.entity("Configuration");
            IJsonObject config = client.getJsonResource(uriBuilder.toString(), this.execEnvironment);
            serverVersion = config.getStringValue("ProductVersion");
            PA_SERVER_VERSION.putIfAbsent(serverPortKey, serverVersion);
            uriBuilder.reset();
        }
        return serverVersion;
    }

    private ODataUriBuilder addSearchCriteria(MASearchCriteria searchCriteria, ODataUriBuilder uriBuilder) {
        if (null == searchCriteria) {
            return uriBuilder;
        }
        String condition = null;
        MASearchCriteria.SearchCondition searchCondition = searchCriteria.getSearchCondition();
        boolean isCaseInsensitive = searchCriteria.getCaseInsensitive();
        MABlockConstraint.Operation operation = searchCriteria.getOperator();
        List sv = searchCriteria.getSearchValues();
        switch (searchCondition) {
            case CONTAINS: {
                condition = CONTAINS;
                break;
            }
            case STARTS_WITH: {
                condition = STARSTWITH;
                break;
            }
            case ENDS_WITH: {
                condition = ENDSWITH;
                break;
            }
            case EQUALS: {
                condition = EQ;
                break;
            }
            case NOTEQUAL: {
                condition = NEQ;
                break;
            }
            default: {
                throw new XQERuntimeException();
            }
        }
        String operator = null;
        if (operation != null) {
            switch (operation) {
                case AND: {
                    operator = AND;
                    break;
                }
                case OR: {
                    operator = OR;
                    break;
                }
                case NOT_DEFINED: {
                    break;
                }
                default: {
                    throw new XQERuntimeException();
                }
            }
        }
        uriBuilder.filterAttributes("Caption", condition, operator, sv, isCaseInsensitive);
        return uriBuilder;
    }

    private void addTreeOpsAndLevelNumber(Set<TreeOperator> treeOps, Set<QueryMode> queryModes, ODataUriBuilder uriBuilder, TM1Hierarchy hierarchy, String mun, MASearchCriteria searchCriteria) {
        if (null != treeOps && treeOps.contains((Object)TreeOperator.Children)) {
            RESTUriBuilder.addLevelParentInfo(uriBuilder);
            if (!queryModes.contains((Object)QueryMode.DataQuery)) {
                uriBuilder.expand("LocalizedAttributes");
            }
            uriBuilder.expand("Children").push();
            RESTUriBuilder.addLevelParentChildrenCardinalityInfo(uriBuilder).count();
            if (null != mun) {
                this.addSearchCriteria(searchCriteria, uriBuilder);
            }
            uriBuilder.pop();
        } else if (null != treeOps && treeOps.contains((Object)TreeOperator.Siblings)) {
            uriBuilder.expand("Parent").push().expand("Children").push();
            RESTUriBuilder.addLevelParentChildrenCardinalityInfo(uriBuilder).filterNe("Name", mun).pop().pop();
            RESTUriBuilder.addLevelChildrenInfo(uriBuilder);
        } else if (null != treeOps && treeOps.contains((Object)TreeOperator.Parent)) {
            uriBuilder.expand("Parent").push();
            RESTUriBuilder.addLevelParentChildrenCardinalityInfo(uriBuilder).pop().expand("Level").push().select("Number").pop();
        } else if (null != treeOps && treeOps.contains((Object)TreeOperator.Ancestors)) {
            if (hierarchy.getLevelsNumber() > 0L) {
                this.buildAncestorsUri(uriBuilder, hierarchy.getLevelsNumber(), treeOps, queryModes);
                RESTUriBuilder.addLevelChildrenInfo(uriBuilder);
                if (!queryModes.contains((Object)QueryMode.DataQuery)) {
                    uriBuilder.expand("LocalizedAttributes");
                }
            }
        } else if (null != treeOps && treeOps.contains((Object)TreeOperator.Descendants)) {
            if (hierarchy.getLevelsNumber() > 0L) {
                this.buildDescendantsUri(uriBuilder, hierarchy.getLevelsNumber(), treeOps, queryModes);
                RESTUriBuilder.addLevelParentInfo(uriBuilder);
                if (!queryModes.contains((Object)QueryMode.DataQuery)) {
                    uriBuilder.expand("LocalizedAttributes");
                }
            }
        } else {
            RESTUriBuilder.addLevelParentInfo(uriBuilder);
            if (!queryModes.contains((Object)QueryMode.DataQuery)) {
                uriBuilder.expand("LocalizedAttributes");
            }
            RESTUriBuilder.addChildrenInfo(uriBuilder);
        }
    }

    private ODataUriBuilder addRange(ODataUriBuilder uriBuilder, int rangeFrom, int rangeSize) {
        if (rangeFrom > 0) {
            uriBuilder.skip(rangeFrom);
        }
        if (rangeSize != Integer.MAX_VALUE) {
            uriBuilder.top(rangeSize);
        }
        return uriBuilder;
    }

    private ODataUriBuilder buildAncestorsUri(ODataUriBuilder uriBuilder, long levels, Set<TreeOperator> treeOps, Set<QueryMode> queryModes) {
        if (0L == levels) {
            return uriBuilder;
        }
        uriBuilder.expand("Parent").push().expand("Level").push().select("Number").pop();
        if (!queryModes.contains((Object)QueryMode.DataQuery)) {
            uriBuilder.expand("LocalizedAttributes");
        }
        uriBuilder.expand("Children/$count");
        this.buildAncestorsUri(uriBuilder, levels - 1L, treeOps, queryModes).pop();
        return uriBuilder;
    }

    private TM1Member createMember(IJsonObject jsonMember, TM1Level level, String[] dimProperties) {
        TM1Member member = new TM1Member(level);
        member.populate(jsonMember, dimProperties, this.mLocale);
        return member;
    }

    private TM1Level findLevel(IJsonObject jsonMember, TM1Hierarchy hierarchy) {
        IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
        long levelNumber = jsonLevel.getLongValue("Number");
        return hierarchy.findLevel((int)levelNumber);
    }

    private ODataUriBuilder buildDescendantsUri(ODataUriBuilder uriBuilder, long levels, Set<TreeOperator> treeOps, Set<QueryMode> queryModes) {
        if (0L == levels) {
            return uriBuilder;
        }
        uriBuilder.expand("Children").push();
        RESTUriBuilder.addLevelParentInfo(uriBuilder);
        if (!queryModes.contains((Object)QueryMode.DataQuery)) {
            uriBuilder.expand("LocalizedAttributes");
        }
        this.buildDescendantsUri(uriBuilder, levels - 1L, treeOps, queryModes).count().pop();
        return uriBuilder;
    }

    private void buildDescendantsMembers(IJsonArray jsonChildren, TM1Hierarchy hierarchy, JsonAttributeFilter filter, String[] dimProperties, List<TM1Member> result) {
        if (jsonChildren == null || jsonChildren.isEmpty()) {
            return;
        }
        for (int i = 0; i < jsonChildren.size(); ++i) {
            IJsonObject jsonChild = (IJsonObject)jsonChildren.get(i);
            TM1Level level = this.findLevel(jsonChild, hierarchy);
            if (filter.matches(jsonChild, "Caption")) {
                result.add(this.createMember(jsonChild, level, dimProperties));
            }
            IJsonArray jsonGrandChildren = jsonChild.getArray("Children");
            this.buildDescendantsMembers(jsonGrandChildren, hierarchy, filter, dimProperties, result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSubsetSupported(TM1NamedSet namedSet) {
        long startTime;
        int connectionId;
        String subsetName;
        block31: {
            block30: {
                RESTClient restClient;
                ODataUriBuilder uriBuilder;
                String cellSetId;
                block27: {
                    IJsonArray jsonHierarchies;
                    TM1Hierarchy hierarchy;
                    block29: {
                        IJsonObject jsonAxis;
                        block28: {
                            IJsonObject jsonAxisSet;
                            block26: {
                                block25: {
                                    boolean bl;
                                    hierarchy = namedSet.getHierarchy();
                                    TM1Dimension dimension = hierarchy.getDimension();
                                    TM1Cube cube = dimension.getCube();
                                    RESTClient client = this.getSession().getConnection().getServer();
                                    subsetName = namedSet.getName();
                                    connectionId = System.identityHashCode((Object)this.getSession().getConnection());
                                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, "Began subset validation [CONNECTION_ID=%d, SubsetName=%s].", connectionId, subsetName);
                                    cellSetId = null;
                                    startTime = System.currentTimeMillis();
                                    try {
                                        cellSetId = this.executeSubsetMembersMDX(dimension.getName(), hierarchy.getName(), subsetName, namedSet.getScope(), cube.getName());
                                    }
                                    catch (TM1RESTODPException e) {
                                        throw e;
                                    }
                                    catch (IOException e) {
                                        throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
                                    }
                                    catch (RuntimeException e) {
                                        throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
                                    }
                                    if (cellSetId == null || cellSetId.isEmpty()) break block30;
                                    Locale aLocale = null;
                                    if (this.execEnvironment.getRequestEnvironment() != null && ((RequestEnvironment)this.execEnvironment.getRequestEnvironment()).getRunLocale() != null) {
                                        aLocale = ((RequestEnvironment)this.execEnvironment.getRequestEnvironment()).getRunLocale();
                                    }
                                    uriBuilder = client.getUriBuilder();
                                    restClient = this.getSession().getConnection().getServer();
                                    try {
                                        String axesUri = RESTUriBuilder.getAxesUri(cellSetId, restClient.getUriBuilder());
                                        jsonAxisSet = restClient.getJsonResource(axesUri, this.execEnvironment, aLocale);
                                        if (RESTClientResponse.validateAndLog(jsonAxisSet, axesUri, this.getSession().getConnection().getServerName())) break block25;
                                        bl = false;
                                        uriBuilder.reset().entityId("Cellsets", cellSetId);
                                    }
                                    catch (Throwable throwable) {
                                        uriBuilder.reset().entityId("Cellsets", cellSetId);
                                        try {
                                            restClient.deleteResource(uriBuilder.toString());
                                        }
                                        catch (IOException e) {
                                            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                                        }
                                        throw throwable;
                                    }
                                    try {
                                        restClient.deleteResource(uriBuilder.toString());
                                    }
                                    catch (IOException e) {
                                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                                    }
                                    return bl;
                                }
                                if (null != jsonAxisSet && !jsonAxisSet.isEmpty()) break block26;
                                boolean bl = false;
                                uriBuilder.reset().entityId("Cellsets", cellSetId);
                                try {
                                    restClient.deleteResource(uriBuilder.toString());
                                }
                                catch (IOException e) {
                                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                                }
                                return bl;
                            }
                            IJsonArray jsonAxisArray = jsonAxisSet.getArray("value");
                            if (jsonAxisArray == null || jsonAxisArray.isEmpty()) break block27;
                            uriBuilder.reset();
                            uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", 0L).expand("Hierarchies").push().select("UniqueName").pop().select("Cardinality");
                            jsonAxis = restClient.getJsonResource(uriBuilder.toString(), this.execEnvironment);
                            long axisCardinality = jsonAxis.getLongValue("Cardinality");
                            if (0L != axisCardinality) break block28;
                            boolean bl = false;
                            uriBuilder.reset().entityId("Cellsets", cellSetId);
                            try {
                                restClient.deleteResource(uriBuilder.toString());
                            }
                            catch (IOException e) {
                                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                            }
                            return bl;
                        }
                        jsonHierarchies = jsonAxis.getArray("Hierarchies");
                        if (jsonHierarchies.size() == 1) break block29;
                        boolean e = false;
                        uriBuilder.reset().entityId("Cellsets", cellSetId);
                        try {
                            restClient.deleteResource(uriBuilder.toString());
                        }
                        catch (IOException e2) {
                            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                        }
                        return e;
                    }
                    IJsonObject jsonHierarchy = (IJsonObject)jsonHierarchies.get(0);
                    if (hierarchy.getUniqueName().equals(jsonHierarchy.getStringValue("UniqueName"))) break block27;
                    boolean bl = false;
                    uriBuilder.reset().entityId("Cellsets", cellSetId);
                    try {
                        restClient.deleteResource(uriBuilder.toString());
                    }
                    catch (IOException e) {
                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                    }
                    return bl;
                }
                uriBuilder.reset().entityId("Cellsets", cellSetId);
                try {
                    restClient.deleteResource(uriBuilder.toString());
                }
                catch (IOException e) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Failed to delete the Cell set resource [%s].", cellSetId);
                }
                break block31;
            }
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, "Subset validation [CONNECTION_ID=%d, SubsetName=%s] failed returning an invalid cellCetID.", connectionId, subsetName);
            return false;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, "Finished subset validation [CONNECTION_ID=%d, SubsetName=%s] in %d milliseconds.", connectionId, subsetName, elapsedTime);
        return true;
    }

    private IJsonObject getHierarchyResource(TM1Dimension dimension, String hierarchyName) {
        TM1Cube cube = dimension.getCube();
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cube.getName()).entityId("Dimensions", dimension.getName()).entityId("Hierarchies", hierarchyName).expand("DefaultMember").expand("AllMember").expand("Subsets").expand("PrivateSubsets").expand("ElementAttributes").expand("Levels").push().count().pop().expand("LocalizedAttributes");
        try {
            IJsonObject jsonHierResource = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, this.mLocale);
            if (!RESTClientResponse.validateAndLog(jsonHierResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                return null;
            }
            return jsonHierResource;
        }
        catch (TM1RESTODPException ex) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_FROM_THE_SERVER, uriBuilder.toString(), this.getSession().getConnection().getServerName());
            return null;
        }
    }

    private String getExecuteMDXSetExpressionForMembersUri(boolean dataQuery) {
        if (dataQuery) {
            return this.mExecuteMDXSetExpressionForDataQueryMembersUri;
        }
        return this.mExecuteMDXSetExpressionForMetadataQueryMembersUri;
    }

    private static boolean canSkipAttribute(TM1Attribute attribute) {
        if ("Format".equals(attribute.getName())) {
            return true;
        }
        return ("DESCRIPTION".equals(attribute.getName()) || "Caption".equals(attribute.getName())) && !attribute.isAlias();
    }

    private static String getSubsetNavigationProperty(TM1NamedSet namedSet) {
        if (namedSet.isPrivate()) {
            return "PrivateSubsets";
        }
        return "Subsets";
    }

    private static boolean getValidatePASubsetsConfig() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("queryExecution.validateTM1RESTPASubsets[@enabled]", false);
    }

    private static boolean isHierarchyLocalizationEnabled() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("queryExecution.paEnableHierarchyLocalization[@enabled]", false);
    }

    private static boolean isControlSubset(IJsonObject jsonSubset) {
        String subsetName = jsonSubset.getStringValue("Name");
        return null == subsetName || subsetName.charAt(0) == '}';
    }

    private void collectSubsetETags(IJsonArray jsonSubsets, Set<String> eTags) {
        for (int i = 0; i < jsonSubsets.size(); ++i) {
            IJsonObject jsonSubset = (IJsonObject)jsonSubsets.get(i);
            if (TM1RESTMetadataLoader.isControlSubset(jsonSubset)) continue;
            eTags.add(jsonSubset.getStringValue("@odata.etag"));
        }
    }

    private void collectTupleMembers(IJsonArray jsonTuples, TM1Hierarchy hierarchy, String[] dimProperties, List<TM1Member> result) {
        for (int iTuple = 0; iTuple < jsonTuples.size(); ++iTuple) {
            IJsonObject jsonTuple = (IJsonObject)jsonTuples.get(iTuple);
            IJsonArray jsonMembers = jsonTuple.getArray("Members");
            for (int iMember = 0; iMember < jsonMembers.size(); ++iMember) {
                IJsonObject jsonMember = (IJsonObject)jsonMembers.get(iMember);
                IJsonObject jsonLevel = jsonMember.getJsonObject("Level");
                long levelNumber = jsonLevel.getLongValue("Number");
                TM1Level level = hierarchy.findLevel((int)levelNumber);
                TM1Member member = this.createMember(jsonMember, level, dimProperties);
                result.add(member);
            }
        }
    }

    private Map<String, List<IJsonObject>> collectLocalizedAttributes(String cubeName, List<String> locales) {
        if (locales.isEmpty()) {
            return Collections.emptyMap();
        }
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entityId("Cubes", cubeName).entity("Dimensions").select("UniqueName").select("Attributes").expand("Hierarchies").push().select("UniqueName").select("Attributes").pop();
        HashMap<String, List<IJsonObject>> localizedAttributes = new HashMap<String, List<IJsonObject>>();
        for (String localeTag : locales) {
            Locale locale = new Locale(localeTag);
            IJsonObject jsonLocalizedCubeAttributes = client.getJsonResource(uriBuilder.toString(), this.execEnvironment, locale);
            IJsonArray cubeDims = jsonLocalizedCubeAttributes.getArray("value");
            for (int i = 0; i < cubeDims.size(); ++i) {
                IJsonObject jsonDim = (IJsonObject)cubeDims.get(i);
                String dun = jsonDim.getStringValue("UniqueName");
                List attributes = localizedAttributes.computeIfAbsent(dun, k -> new ArrayList());
                attributes.add(jsonDim.getJsonObject("Attributes"));
                IJsonArray jsonHierarchies = jsonDim.getArray("Hierarchies");
                for (int j = 0; j < jsonHierarchies.size(); ++j) {
                    IJsonObject jsonHierarchy = (IJsonObject)jsonHierarchies.get(j);
                    String hun = jsonHierarchy.getStringValue("UniqueName");
                    attributes = localizedAttributes.computeIfAbsent(hun, k -> new ArrayList());
                    attributes.add(jsonHierarchy.getJsonObject("Attributes"));
                }
            }
        }
        return localizedAttributes;
    }

    private IJsonObject getMemberWithRetryOnElementName(String memberName, String uri, RESTClient client, Set<QueryMode> queryModes) {
        IJsonObject jsonMember = null;
        boolean bRetryWithElementName = false;
        try {
            jsonMember = client.getJsonResource(uri, this.execEnvironment, this.mLocale);
        }
        catch (TM1RESTODPException ex) {
            int index = memberName.lastIndexOf(94);
            if (ex.getStatusCode() == 404L && index != -1 && index < memberName.length() - 1) {
                bRetryWithElementName = true;
            }
            if (queryModes.contains((Object)QueryMode.MunValidationQuery)) {
                throw new MAMunValidationException(MAMunValidationException.Status.MemberNotFound, ex.getLocalizedMessage());
            }
            throw ex;
        }
        if (bRetryWithElementName) {
            String elementName = TM1RESTMetadataLoader.getElementNameFromMemberName(memberName);
            Matcher matcher = TM1Constants.URI_MEMBERS_ENTITY_PATTERN.matcher(uri);
            if (elementName != null && matcher.find()) {
                StringBuilder buffer = new StringBuilder("Members('");
                buffer.append(ODataUriBuilder.encodeUriEntity(elementName)).append("')");
                String elemUri = matcher.replaceFirst(buffer.toString());
                try {
                    jsonMember = client.getJsonResource(elemUri, this.execEnvironment, this.mLocale);
                }
                catch (TM1RESTODPException ex) {
                    if (queryModes.contains((Object)QueryMode.MunValidationQuery)) {
                        throw new MAMunValidationException(MAMunValidationException.Status.MemberNotFound, ex.getLocalizedMessage());
                    }
                    throw ex;
                }
            }
        }
        return jsonMember;
    }

    private static String getElementNameFromMemberName(String memberName) {
        int parentsMarker = memberName.lastIndexOf(94);
        if (-1 == parentsMarker || parentsMarker == memberName.length() - 1) {
            return null;
        }
        return memberName.substring(parentsMarker + 1);
    }

    private void logTM1RESTODPException(String uri, TM1RESTODPException ex) {
        if (ex.getStatusCode() != 404L) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_REASON, uri, ex.getLocalizedMessage());
        }
    }
}

