/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeSnapshot;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeTimestamps;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTCubeCache;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Utils;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class CubeRecordQuery
extends MetadataQuery<CubeRecord> {
    private static final String FAILED_TO_GET_THE_CUBE_RESOURCE = "Failed to get the [%s] cube resource from the server [%s:%d].";
    private String mCubeName = null;
    private boolean mRefresh = false;

    public CubeRecordQuery(TM1RESTMetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setRefresh(boolean refresh) {
        this.mRefresh = refresh;
    }

    @Override
    public List<CubeRecord> execute() {
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        if (null != this.mCubeName) {
            CubeRecord record = this.executeOneCubeRecord(this.mCubeName);
            if (null == record || !this.isInRange(0)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(record);
        }
        return this.executeAllCubeRecords();
    }

    private CubeRecord buildRecord(IJsonObject cube, CachedCubeStatus status) {
        CubeRecord record = new CubeRecord();
        record.setCatalogName("CATALOG");
        String cubeName = cube.getStringValue("Name");
        record.setName(cubeName);
        record.setUniqueName(cubeName);
        record.setDescription(cubeName);
        IJsonObject attributes = cube.getJsonObject("Attributes");
        String caption = attributes.getStringValue("Caption");
        LocalizedString localizedCaption = this.getLocalizedCaption(cube, this.mLocale, caption);
        record.setCaption((ILocalizedString)localizedCaption);
        String camPassport = this.getSession().getConnection().getUserIdentity();
        String adminHostCubeKey = this.getSession().getConnection().getAdminServerKey(cubeName, this.getCubeLocales());
        TM1CubeTimestamps cachedCubeTimestamp = null;
        TM1CubeSnapshot cachedCubeSnapshot = TM1RESTServerSecurity.getCubeSnapshot(adminHostCubeKey);
        if (cachedCubeSnapshot != null) {
            cachedCubeTimestamp = cachedCubeSnapshot.getCubeTimestamps();
        }
        switch (status) {
            case NEW: {
                Date currentUTCDate = TM1Utils.getCurrentTimestampValue().getDate();
                TM1CubeTimestamps timestamps = new TM1CubeTimestamps(currentUTCDate, currentUTCDate);
                Set<String> eTags = cachedCubeSnapshot != null ? cachedCubeSnapshot.getSnapshot() : this.getLoader(this.getCubeLocales()).createCubeSnapshot(cubeName);
                TM1CubeSnapshot cubeSnapshot = new TM1CubeSnapshot(timestamps, this.getCubeLocales());
                cubeSnapshot.create(eTags);
                if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "NEW_UTC [CUBE_NAME=%s] [Schema=%s] [Data=%s] [Key=%s] [CAM=%s]", cubeName, timestamps.getLastSchemaUpdate().toString(), timestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
                }
                cubeSnapshot = TM1RESTServerSecurity.getOrSetCubeSnapshot(adminHostCubeKey, cubeSnapshot);
                this.setTimes(record, cubeSnapshot.getCubeTimestamps(), adminHostCubeKey, camPassport);
                break;
            }
            case FRESH: {
                TM1CubeTimestamps cubeTimestamps = this.getCubeTimestamps(cube);
                if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "FRESH [CUBE_NAME=%s] [CachedSchema=%s] [CachedData=%s] [CubeSchema=%s] [CubeData=%s] [Key=%s] [CAM=%s]", cubeName, cachedCubeTimestamp.getLastSchemaUpdate().toString(), cachedCubeTimestamp.getLastDataUpdate().toString(), cubeTimestamps.getLastSchemaUpdate().toString(), cubeTimestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
                }
                if (cachedCubeTimestamp.compareLastCubeUpdate(cubeTimestamps) >= 0) {
                    this.setTimes(record, cachedCubeTimestamp, adminHostCubeKey, camPassport);
                    break;
                }
                List<String> cubeLocales = cachedCubeSnapshot.getCubeLocales();
                cubeTimestamps.setLastSchemaUpdate(cachedCubeTimestamp.getLastSchemaUpdate());
                if (cachedCubeTimestamp.getLastDataUpdate().compareTo(cubeTimestamps.getLastDataUpdate()) > 0) {
                    cubeTimestamps.setLastDataUpdate(cachedCubeTimestamp.getLastDataUpdate());
                }
                TM1CubeSnapshot cubeSnapshot = new TM1CubeSnapshot(cubeTimestamps, cubeLocales);
                Set<String> eTags = this.getLoader(cubeLocales).createCubeSnapshot(cubeName);
                cubeSnapshot.create(eTags);
                cubeTimestamps = TM1RESTServerSecurity.setCubeSnapshot(adminHostCubeKey, cubeSnapshot).getCubeTimestamps();
                this.setTimes(record, cubeTimestamps, adminHostCubeKey, camPassport);
                break;
            }
            case RELOAD: {
                TM1RESTCubeCache cubeCache;
                TM1CubeTimestamps cubeTimestamps = this.getCubeTimestamps(cube);
                if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "RELOAD [CUBE_NAME=%s] [CachedSchema=%s] [CachedData=%s] [CubeSchema=%s] [CubeData=%s] [Key=%s] [CAM=%s]", cubeName, cachedCubeTimestamp.getLastSchemaUpdate().toString(), cachedCubeTimestamp.getLastDataUpdate().toString(), cubeTimestamps.getLastSchemaUpdate().toString(), cubeTimestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
                }
                if (null != (cubeCache = this.getCubeCache())) {
                    String cubeKey = TM1RESTCubeCache.getCubeCacheKey(cubeName, this.getCubeLocales());
                    cubeCache.expungeCube(cubeKey);
                    this.getSession().getLoader(this.getCubeLocales()).loadCube(cubeName, cubeCache, true);
                }
                this.setTimes(record, cachedCubeTimestamp, adminHostCubeKey, camPassport);
                break;
            }
            case STALE: {
                Date currentUTCDate = TM1Utils.getCurrentTimestampValue().getDate();
                TM1CubeTimestamps timestamps = new TM1CubeTimestamps(currentUTCDate, currentUTCDate);
                TM1CubeTimestamps cubeTimestamps = this.getCubeTimestamps(cube);
                timestamps.refresh(cubeTimestamps);
                List<String> cubeLocales = cachedCubeSnapshot.getCubeLocales();
                TM1CubeSnapshot cubeSnapshot = new TM1CubeSnapshot(timestamps, cubeLocales);
                Set<String> eTags = this.getLoader(cubeLocales).createCubeSnapshot(cubeName);
                cubeSnapshot.create(eTags);
                if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "STALE [CUBE_NAME=%s] [Schema=%s] [Data=%s] [CubeSchema=%s] [CubeData=%s] [Key=%s] [CAM=%s]", cubeName, timestamps.getLastSchemaUpdate().toString(), timestamps.getLastDataUpdate().toString(), cubeTimestamps.getLastSchemaUpdate().toString(), cubeTimestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
                }
                timestamps = TM1RESTServerSecurity.setCubeSnapshot(adminHostCubeKey, cubeSnapshot).getCubeTimestamps();
                TM1RESTCubeCache cubeCache = this.getCubeCache();
                if (null != cubeCache) {
                    String cubeKey = TM1RESTCubeCache.getCubeCacheKey(cubeName, this.getCubeLocales());
                    cubeCache.expungeCube(cubeKey);
                    this.getSession().getLoader(cubeLocales).loadCube(cubeName, cubeCache, true);
                }
                this.setTimes(record, timestamps, adminHostCubeKey, camPassport);
                break;
            }
            case SNAP: {
                TM1CubeTimestamps cubeTimestamps = this.getCubeTimestamps(cube);
                if (cachedCubeTimestamp != null && cachedCubeTimestamp.compareLastCubeUpdate(cubeTimestamps) >= 0) {
                    cubeTimestamps = cachedCubeTimestamp;
                }
                if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "SNAP [CUBE_NAME=%s] [Schema=%s] [Data=%s] [Key=%s] [CAM=%s]", cubeName, cubeTimestamps.getLastSchemaUpdate().toString(), cubeTimestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
                }
                this.setTimes(record, cubeTimestamps, adminHostCubeKey, camPassport);
                break;
            }
        }
        String sUnderFed = attributes.getStringValue("IsUnderFed");
        if (null != sUnderFed && sUnderFed.equalsIgnoreCase("T")) {
            record.setDynamicFieldAsBoolean("IsUnderFed", Boolean.valueOf(true));
        } else {
            record.setDynamicFieldAsBoolean("IsUnderFed", Boolean.valueOf(false));
        }
        String serverVersion = this.getLoader(this.getCubeLocales()).getServerVersion();
        record.setDynamicFieldAsString("TM1ServerVersion", serverVersion);
        return record;
    }

    protected LocalizedString getLocalizedCaption(IJsonObject jsonObj, Locale defaultLocale, String caption) {
        IJsonArray jsonLocalizedAttributes;
        LocalizedString localizedCaption = null;
        if (jsonObj.containsKey("LocalizedAttributes") && !(jsonLocalizedAttributes = jsonObj.getArray("LocalizedAttributes")).isEmpty()) {
            IJsonObject jsonLocalizedAtt;
            String localeID;
            String dls = defaultLocale.toString();
            for (Object localizedAtt : jsonLocalizedAttributes) {
                String locCaption;
                if (localizedAtt == null || "Default".equals(localeID = (jsonLocalizedAtt = (IJsonObject)localizedAtt).getStringValue("LocaleID")) || !dls.equals(localeID)) continue;
                IJsonObject locAttributes = jsonLocalizedAtt.getJsonObject("Attributes");
                if (null == locAttributes || null == (locCaption = (String)locAttributes.get("Caption"))) break;
                if (localizedCaption == null) {
                    localizedCaption = new LocalizedString(defaultLocale, locCaption);
                    break;
                }
                localizedCaption.put(defaultLocale, locCaption);
                break;
            }
            if (null == localizedCaption) {
                localizedCaption = new LocalizedString(defaultLocale, caption);
            }
            for (Object localizedAtt : jsonLocalizedAttributes) {
                String locCaption;
                IJsonObject locAttributes;
                Locale currLocale;
                if (localizedAtt == null || "Default".equals(localeID = (jsonLocalizedAtt = (IJsonObject)localizedAtt).getStringValue("LocaleID")) || (currLocale = new Locale(localeID)).equals(defaultLocale) || null == (locAttributes = jsonLocalizedAtt.getJsonObject("Attributes")) || null == (locCaption = (String)locAttributes.get("Caption"))) continue;
                if (localizedCaption == null) {
                    localizedCaption = new LocalizedString(defaultLocale, locCaption);
                    continue;
                }
                localizedCaption.put(defaultLocale, locCaption);
            }
        }
        if (null == localizedCaption) {
            localizedCaption = new LocalizedString(defaultLocale, caption);
        }
        return localizedCaption;
    }

    private CubeRecord executeOneCubeRecord(String cubeName) {
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder cubeUri = client.getUriBuilder();
        cubeUri.entityId("Cubes", cubeName).expand("LocalizedAttributes");
        try {
            TM1RESTCubeCache cubeCache;
            IJsonObject jsonCube = client.getJsonResource(cubeUri.toString(), this.getSession().getExecutionEnvironment(), this.mLocale);
            if (!RESTClientResponse.validateAndLog(jsonCube, cubeUri.toString(), this.getSession().getConnection().getServerName())) {
                return null;
            }
            TM1CubeTimestamps cubeTimestamps = this.getCubeTimestamps(jsonCube);
            CachedCubeStatus status = this.getCurrentCachedCubeStatus(cubeName, jsonCube);
            if (this.mRefresh && !status.isNew() && null != (cubeCache = this.getCubeCache())) {
                String cubeKey = TM1RESTCubeCache.getCubeCacheKey(cubeName, this.getCubeLocales());
                TM1Cube cachedCube = cubeCache.getCube(cubeKey);
                boolean stale = this.isStale(cubeCache, cubeName, cubeTimestamps);
                if (stale) {
                    status = CachedCubeStatus.STALE;
                }
            }
            return this.buildRecord(jsonCube, status);
        }
        catch (TM1RESTODPException ex) {
            RESTClientResponse.validateAndLog(ex.getJsonError(), TM1RESTLog.META_LOADER, FAILED_TO_GET_THE_CUBE_RESOURCE, cubeName, this.getSession().getConnection().getServerAdminHost(), this.getSession().getConnection().getmServerPort());
            return null;
        }
    }

    private List<CubeRecord> executeAllCubeRecords() {
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        uriBuilder.entity("Cubes").expand("LocalizedAttributes");
        try {
            IJsonObject jsonResource = client.getJsonResource(uriBuilder.toString(), this.getSession().getExecutionEnvironment(), this.mLocale);
            if (!RESTClientResponse.validateAndLog(jsonResource, uriBuilder.toString(), this.getSession().getConnection().getServerName())) {
                return Collections.emptyList();
            }
            IJsonArray allCubes = jsonResource.getArray("value");
            int effectiveSize = Math.min(this.mRangeSize, allCubes.size() - this.mRangeFrom);
            if (effectiveSize <= 0) {
                return Collections.emptyList();
            }
            ArrayList<CubeRecord> records = new ArrayList<CubeRecord>(effectiveSize);
            int iRecorded = 0;
            for (int i = this.mRangeFrom; i < allCubes.size() && iRecorded < effectiveSize; ++i) {
                IJsonObject jsonCube = (IJsonObject)allCubes.get(i);
                String cubeName = jsonCube.getStringValue("Name");
                if (cubeName.charAt(0) == '}') continue;
                records.add(this.buildRecord(jsonCube, CachedCubeStatus.SNAP));
                ++iRecorded;
            }
            return records;
        }
        catch (TM1RESTODPException ex) {
            return Collections.emptyList();
        }
    }

    private boolean isStale(TM1RESTCubeCache cubeCache, String cubeName, TM1CubeTimestamps serverCubeTimestamps) {
        String adminHostCubeKey = this.getSession().getConnection().getAdminServerKey(cubeName, this.getCubeLocales());
        TM1CubeTimestamps tm1RESTCubeCacheTimestamps = null;
        TM1CubeSnapshot cubeSnapshot = TM1RESTServerSecurity.getCubeSnapshot(adminHostCubeKey);
        if (cubeSnapshot != null && !cubeSnapshot.needToCheck()) {
            return false;
        }
        if (cubeSnapshot != null) {
            cubeSnapshot.resetLastStaleCheckTime();
            tm1RESTCubeCacheTimestamps = cubeSnapshot.getCubeTimestamps();
        }
        if (serverCubeTimestamps != null && tm1RESTCubeCacheTimestamps != null && serverCubeTimestamps.compareLastSchemaUpdate(tm1RESTCubeCacheTimestamps) > 0) {
            return true;
        }
        String cubeKey = TM1RESTCubeCache.getCubeCacheKey(cubeName, this.getCubeLocales());
        TM1Cube cachedCube = cubeCache.getCube(cubeKey);
        if (null == cachedCube) {
            if (cubeSnapshot != null) {
                Set<String> eTags = this.getLoader(this.getCubeLocales()).createCubeSnapshot(cubeName);
                return !cubeSnapshot.isSame(eTags);
            }
            return false;
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "Start screening a TM1 cube [CUBE_NAME=%s] from data source.", cubeName);
        RESTClient client = this.getSession().getConnection().getServer();
        ODataUriBuilder uriBuilder = client.getUriBuilder();
        RESTUriBuilder.getSubsetsETagsUri(cubeName, uriBuilder);
        IJsonObject jsonResource = null;
        jsonResource = client.getJsonResource(uriBuilder.toString(), this.getSession().getExecutionEnvironment(), this.mLocale);
        RESTClientResponse.validateAndThrow(jsonResource, cubeName, TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_CODE_AND_MESSAGE);
        return this.getSession().getLoader(this.getCubeLocales()).isStaleCube(cachedCube, jsonResource);
    }

    private void setTimes(CubeRecord record, TM1CubeTimestamps timestamps, String adminHostCubeKey, String camPassport) {
        record.setCreatedDate((DateTimeValue)TM1Utils.getTimestampValue(timestamps.getLastSchemaUpdate()));
        record.setDataUpdateDate((DateTimeValue)TM1Utils.getTimestampValue(timestamps.getLastDataUpdate()));
        record.setSchemaUpdateDate((DateTimeValue)TM1Utils.getTimestampValue(timestamps.getLastSchemaUpdate()));
        if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "SET [CUBE_NAME=%s] [Schema=%s] [Data=%s] [Key=%s] [CAM=%s]", record.getName(), timestamps.getLastSchemaUpdate().toString(), timestamps.getLastDataUpdate().toString(), adminHostCubeKey, camPassport);
        }
    }

    private CachedCubeStatus getCurrentCachedCubeStatus(String cubeName, IJsonObject jsonCube) {
        String adminHostCubeKey = this.getSession().getConnection().getAdminServerKey(cubeName, this.getCubeLocales());
        TM1CubeSnapshot cubeSnapshot = TM1RESTServerSecurity.getCubeSnapshot(adminHostCubeKey);
        if (null == cubeSnapshot) {
            return CachedCubeStatus.NEW;
        }
        if (!cubeSnapshot.needToCheck()) {
            return CachedCubeStatus.FRESH;
        }
        cubeSnapshot.resetLastStaleCheckTime();
        TM1CubeTimestamps cubeTimestamps = this.getCubeTimestamps(jsonCube);
        TM1CubeTimestamps cubeSnapshotTimestamps = cubeSnapshot.getCubeTimestamps();
        if (cubeTimestamps.compareLastSchemaUpdate(cubeSnapshotTimestamps) > 0) {
            return CachedCubeStatus.STALE;
        }
        TM1RESTCubeCache cubeCache = this.getCubeCache();
        String cubeKey = TM1RESTCubeCache.getCubeCacheKey(cubeName, this.getCubeLocales());
        if (null == cubeCache || !cubeCache.containsCube(cubeKey)) {
            Set<String> eTags = this.getLoader(this.getCubeLocales()).createCubeSnapshot(cubeName);
            if (!cubeSnapshot.isSame(eTags)) {
                return CachedCubeStatus.STALE;
            }
            return CachedCubeStatus.FRESH;
        }
        TM1Cube cachedCube = cubeCache.getCube(cubeKey);
        if (cachedCube != null && cubeSnapshotTimestamps.compareLastSchemaUpdate(cachedCube.getTimestamps()) > 0) {
            return CachedCubeStatus.RELOAD;
        }
        Set<String> eTags = this.getLoader(this.getCubeLocales()).createCubeSnapshot(cubeName);
        if (!cubeSnapshot.isSame(eTags)) {
            return CachedCubeStatus.STALE;
        }
        return CachedCubeStatus.FRESH;
    }

    private TM1CubeTimestamps getCubeTimestamps(IJsonObject jsonCube) {
        String lastSchemaUpdate = jsonCube.getStringValue("LastSchemaUpdate");
        String lastDataUpdate = jsonCube.getStringValue("LastDataUpdate");
        if (TM1RESTLog.META_LOADER.isOn(LogLevel.INFO)) {
            String cubeName = jsonCube.getStringValue("Name");
            String adminHostCubeKey = this.getSession().getConnection().getAdminServerKey(cubeName, this.getCubeLocales());
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.INFO, "CUBE_TIMESTAMPS [Key=%s]  [CubeSchema=%s] [CubeData=%s]", adminHostCubeKey, lastSchemaUpdate, lastDataUpdate);
        }
        return new TM1CubeTimestamps(TM1Utils.getDateValue(lastSchemaUpdate), TM1Utils.getDateValue(lastDataUpdate));
    }

    static enum CachedCubeStatus {
        NEW,
        FRESH,
        RELOAD,
        STALE,
        SNAP;


        private boolean isNew() {
            return this == NEW;
        }
    }
}

