/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTCubeCache;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.LocaleConverter;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public abstract class MetadataQuery<RESULT_TYPE>
implements IReleasable {
    protected static final Locale DEFAULT_LOCALE = LocaleConverter.strToLocale((String)"en-us");
    public static final String[] EMPTY_PROPERTY_ARRAY = new String[0];
    private final TM1RESTMetadataSession mSession;
    protected Locale mLocale = DEFAULT_LOCALE;
    protected int mRangeFrom = 0;
    protected int mRangeSize = Integer.MAX_VALUE;
    protected List<String> mCubeLocales;

    protected MetadataQuery(TM1RESTMetadataSession session) {
        this.mSession = session;
    }

    public final void setLocale(Locale locale) {
        this.mLocale = null == locale ? DEFAULT_LOCALE : locale;
    }

    public final void setCubeLocales(List<String> cubeLocales) {
        this.mCubeLocales = cubeLocales;
    }

    public final List<String> getCubeLocales() {
        if (null == this.mCubeLocales) {
            return Collections.emptyList();
        }
        return this.mCubeLocales;
    }

    public final void setRangeFrom(int from) {
        this.mRangeFrom = from;
    }

    public final void setRangeSize(int size) {
        this.mRangeSize = size;
    }

    protected final boolean isInRange(int index) {
        return index >= this.mRangeFrom && index < this.mRangeFrom + this.mRangeSize;
    }

    protected final TM1RESTMetadataSession getSession() {
        return this.mSession;
    }

    protected final TM1RESTConnection getConnection() {
        return this.mSession.getConnection();
    }

    protected final TM1RESTMetadataLoader getLoader(List<String> locales) {
        return this.mSession.getLoader(locales);
    }

    protected final TM1RESTCubeCache getCubeCache() {
        return this.getConnection().getCubeCache();
    }

    protected void checkRangeRestrictions() {
        if (this.mRangeFrom < 0 || this.mRangeSize < 0) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Illegal from/size restriction range.");
        }
    }

    protected static void throwRestrictionMissing(RestrictionType restrictionType) {
        throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, restrictionType.toString());
    }

    public abstract List<RESULT_TYPE> execute();

    public void release() {
    }
}

