/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.metadata.query;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Cube;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Dimension;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1Hierarchy;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1NamedSet;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataSession;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.query.MetadataQuery;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.TM1Utils;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NamedSetRecordQuery
extends MetadataQuery<HierarchyNamedSetRecord> {
    private String mCubeName = null;
    private String mDUN = null;
    private String mHUN = null;
    private String mNSUN = null;

    public NamedSetRecordQuery(TM1RESTMetadataSession session) {
        super(session);
    }

    public void setCubeName(String cubeName) {
        this.mCubeName = cubeName;
    }

    public void setDUN(String dun) {
        this.mDUN = dun;
    }

    public void setHUN(String hun) {
        this.mHUN = hun;
    }

    public void setNSUN(String nsun) {
        this.mNSUN = nsun;
    }

    @Override
    public List<HierarchyNamedSetRecord> execute() {
        this.checkRangeRestrictions();
        if (null == this.mCubeName) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "A cube name was not specified.");
        }
        if (this.mRangeSize < 1) {
            return Collections.emptyList();
        }
        TM1Cube cube = this.getLoader(this.getCubeLocales()).loadCube(this.mCubeName, this.getCubeCache());
        if (null == cube) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_CANNOT_FIND_CUBE, this.mCubeName);
        }
        ArrayList<TM1NamedSet> namedsetsFound = new ArrayList<TM1NamedSet>();
        if (null != this.mNSUN) {
            TM1NamedSet namedSet = TM1Utils.findNamedSet(cube, this.mNSUN, false);
            if (null != namedSet) {
                namedsetsFound.add(namedSet);
            }
        } else if (null != this.mHUN) {
            TM1Hierarchy hierarchy = TM1Utils.findHierarchy(cube, this.mHUN, false);
            if (null != hierarchy) {
                namedsetsFound.addAll(hierarchy.getNamedSets());
            }
        } else if (null != this.mDUN) {
            TM1Dimension dimension = TM1Utils.findDimension(cube, this.mDUN, false);
            if (null != dimension) {
                namedsetsFound.addAll(dimension.getNamedSets());
            }
        } else {
            for (TM1Dimension dimension : cube.getDimensions()) {
                namedsetsFound.addAll(dimension.getNamedSets());
            }
        }
        int effectiveSize = Math.min(this.mRangeSize, namedsetsFound.size() - this.mRangeFrom);
        if (effectiveSize <= 0) {
            return Collections.emptyList();
        }
        ArrayList<HierarchyNamedSetRecord> records = new ArrayList<HierarchyNamedSetRecord>(effectiveSize);
        for (int i = this.mRangeFrom; i < this.mRangeFrom + effectiveSize; ++i) {
            records.add(this.buildRecord((TM1NamedSet)namedsetsFound.get(i)));
        }
        return records;
    }

    private HierarchyNamedSetRecord buildRecord(TM1NamedSet namedSet) {
        TM1Hierarchy hierarchy = namedSet.getHierarchy();
        TM1Dimension dimension = hierarchy.getDimension();
        TM1Cube cube = dimension.getCube();
        HierarchyNamedSetRecord record = new HierarchyNamedSetRecord();
        record.setCatalogName("CATALOG");
        record.setCubeName(cube.getName());
        record.setUniqueName(namedSet.getUniqueName());
        record.setName(namedSet.getUniqueName());
        record.setCaption((ILocalizedString)new LocalizedString(this.mLocale, namedSet.getCaption()));
        record.setExpression(namedSet.getExpression());
        record.setLocalizedDisplayPath((ILocalizedString)new LocalizedString(this.getConnection().getProductLocale1(), "Sets"));
        record.setUniqueId(RecordType.NAMEDSET, namedSet.getUniqueName());
        record.setDimensionName(dimension.getUniqueName());
        record.setHierarchyName(hierarchy.getUniqueName());
        return record;
    }
}

