/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserIdentity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserUniqueSecurityName;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTOIDCAccessTokenParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTOIDCIdTokenParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTPasswordParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerPortParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTUserNameParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.json.BIJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.FutureTaskResponseHandler;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientAsyncRequest;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientConfig;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTStateEnum;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.security.IEncryptedObject;
import com.cognos.xqe.trace.LogLevel;
import java.io.Closeable;
import java.io.IOException;
import java.net.HttpCookie;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpRequestFutureTask;

public class RESTClient
implements Closeable {
    private static final int FIVE_ATTEMPTS = 5;
    private static final String EQUALS_PARAM_STRING = "= '[%s]'";
    public static final String BAD_REQUEST_MSG_FORMAT = "[%d] %s";
    private static final String ACCEPT_LANGUAGE_HEADER = "Accept-Language";
    private static final String TM1_USE_FILLER_MEMBERS = "TM1-UseFillerMembers";
    private static final long UNKNOWN_STATUS_CODE = -1L;
    private static final int UNDEFINED_PORT = -1;
    public static final int OAUTH2_PORT = -2;
    public static final String WWW_AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String NEGOTIATE = "Negotiate";
    public static final String BASIC_REALM_TM1 = "Basic realm=\"TM1\"";
    public static final String CAM_PASSPORT = "CAMPassport";
    public static final String BEARER = "Bearer";
    public static final String AUTHORIZATION_HEADER = "Authorization";
    public static final String TM1_SESSION_ID = "TM1SessionId";
    public static final String BASIC_AUTHORIZATION = "Basic ";
    private static final String CAMPASSPORT_AUTHORIZATION = "CAMPassport ";
    private static final String NEGOTIATE_AUTHORIZATION = "Negotiate ";
    private static final String OIDC_ID_TOKEN = "OIDC-Id-Token";
    private static final String BEARER_TOKEN = "Bearer ";
    private static final String QUESTION_MARK = "?";
    private static final String COLON_MARK = ":";
    private static final String UNKNOWN = "unknown";
    private HttpCookie mTM1SessionIdCookie = null;
    private List<HttpCookie> mSetCookies = null;
    private final String mExecuteMDXUri;
    private String mRequestCAMPassport = null;
    protected CloseableHttpClient client;
    protected RESTClientConfig config;
    private final IJsonFactory mIJsonFactory = BIJsonFactory.getInstance();
    private final boolean mUseFillerMemberConfig;
    private final FutureRequestExecutionService futureRequestExecutionService;

    protected RESTClient(CloseableHttpClient aClient, RESTClientConfig aConfig, FutureRequestExecutionService aFutureRequestExecutionService) {
        this.client = aClient;
        this.config = aConfig;
        ODataUriBuilder uriBuilder = this.getUriBuilder();
        this.mExecuteMDXUri = uriBuilder.entity("ExecuteMDX").toString();
        this.mUseFillerMemberConfig = RESTClient.getPAUseFillerMemberConfig();
        this.futureRequestExecutionService = aFutureRequestExecutionService;
    }

    public IJsonFactory getJsonFactory() {
        return this.mIJsonFactory;
    }

    public ODataUriBuilder getUriBuilder() {
        return new ODataUriBuilder(this.config.getServiceRoot());
    }

    public IJsonObject getJsonResource(String path, ExecutionEnvironment aExecEnvironment) {
        Locale aLocale = null;
        if (aExecEnvironment != null && aExecEnvironment.getRequestEnvironment() != null && ((RequestEnvironment)aExecEnvironment.getRequestEnvironment()).getRunLocale() != null) {
            aLocale = ((RequestEnvironment)aExecEnvironment.getRequestEnvironment()).getRunLocale();
        }
        return this.getJsonResource(path, aExecEnvironment, aLocale);
    }

    public IJsonObject getJsonResource(String path, ExecutionEnvironment aExecEnvironment, Locale aLocale) {
        this.accept("application/json");
        return this.getJsonResource(path, aExecEnvironment, aLocale, "application/json");
    }

    public IJsonObject getJsonResource(String path, ExecutionEnvironment aExecEnvironment, Locale aLocale, String acceptHdr) {
        return this.getJsonResource(path, aExecEnvironment, aLocale, acceptHdr, this.mUseFillerMemberConfig);
    }

    public IJsonObject getJsonResource(String path, ExecutionEnvironment aExecEnvironment, Locale aLocale, String acceptHdr, boolean useFillerMembers) {
        this.accept(acceptHdr);
        this.mRequestCAMPassport = ((RequestEnvironment)aExecEnvironment.getRequestEnvironment()).getCAMPassport();
        this.setAuthorization(this.mRequestCAMPassport);
        this.setUseFillerMembers(useFillerMembers);
        if (aLocale != null) {
            this.setLocale(aLocale.toString());
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.TRACE, "Accept-Language= '[%s]'", aLocale.toString());
        } else {
            this.setLocale(this.config.getRunLocale());
        }
        HttpRequestBase method = this.createGetRequest(path);
        int iAttempt = 1;
        while (true) {
            RESTClientResponse clientResponse = null;
            try {
                clientResponse = this.executeMethod(method);
                IJsonObject iJsonObject = clientResponse.getJSONResponse();
                return iJsonObject;
            }
            catch (IOException e) {
                String errMessage = e.getLocalizedMessage();
                this.close();
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_GET_RESOURCE_FAILED, path, (Object)this.config.getServer(), (Object)errMessage);
            }
            catch (TM1RESTODPException providerException) {
                if (providerException.getStatusCode() >= 500L) {
                    if (RESTClient.noMoreAttempts(method, clientResponse, (Exception)((Object)providerException), iAttempt)) {
                        this.close();
                        throw providerException;
                    }
                    ++iAttempt;
                    continue;
                }
                this.close();
                throw providerException;
            }
            finally {
                if (clientResponse == null) continue;
                clientResponse.close();
                continue;
            }
            break;
        }
    }

    public String getTextResource(String path) {
        this.accept("text/plain");
        this.setAuthorization();
        this.setLocale(this.config.getRunLocale());
        HttpRequestBase method = this.createGetRequest(path);
        String textResource = null;
        try (RESTClientResponse clientResponse = null;){
            clientResponse = this.executeMethod(method, true, true);
            textResource = clientResponse.getStringResponse();
        }
        return textResource;
    }

    public IJsonObject getJsonResourceAsync(final String path, final ExecutionEnvironment executionEnvironment) {
        IJsonObject jsonObject;
        Callable<IJsonObject> asyncTask = new Callable<IJsonObject>(){

            @Override
            public IJsonObject call() throws Exception {
                return RESTClient.this.getJsonResource(path, executionEnvironment);
            }
        };
        RESTClientAsyncRequest<1> request = new RESTClientAsyncRequest<1>(this, asyncTask, executionEnvironment);
        try {
            jsonObject = request.call();
        }
        catch (IOException e) {
            this.close();
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_GET_RESOURCE_FAILED, path, (Object)this.config.getServer(), (Object)e.getLocalizedMessage());
        }
        return jsonObject;
    }

    public RESTClientResponse executeMethod(HttpRequestBase httpMethod, boolean throwOnError) throws IOException {
        return this.executeMethod(httpMethod, throwOnError, true);
    }

    public RESTClientResponse executeMethod(HttpRequestBase httpMethod, boolean throwOnError, boolean processUnauthorized) throws IOException {
        String userNameOrCAMPassport;
        TM1RESTServerSecurity.SecurityMode securityMode;
        long startTime = System.currentTimeMillis();
        RESTClientResponse httpResponse = this.executeRequest(httpMethod);
        long statusCode = httpResponse.getStatusCode();
        if (processUnauthorized && statusCode == 401L) {
            securityMode = this.config.getIntegratedSecurityMode();
            if (TM1RESTServerSecurity.SecurityMode.OAUTH2 != securityMode) {
                securityMode = TM1RESTServerSecurity.getSecurityModeFromHeader(this, httpResponse);
            }
            if (securityMode != this.config.getIntegratedSecurityMode()) {
                securityMode = TM1RESTServerSecurity.resetStaticTM1ServerSecurityMode(this.config.getServer(), this.config.getPort(), securityMode);
                this.config.setIntegratedSecurityMode(securityMode);
                this.config.setCAMPassport(this.mRequestCAMPassport);
                this.setAuthorization(this.mRequestCAMPassport);
                this.setTM1SessionIdCookie(null);
                this.setRequestHeaders(httpMethod);
                httpResponse.close();
                httpResponse = this.executeRequest(httpMethod);
                statusCode = httpResponse.getStatusCode();
            }
            if (statusCode == 401L && TM1RESTServerSecurity.SecurityMode.BASIC == securityMode) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_LOG_ON_OFF, LogLevel.ERROR, "Unauthorized to Execute: [%s] to [%s] by [%s] locale [%s] HttpStatus [%d]", httpMethod.getClass().getSimpleName(), httpMethod.getURI().toString(), this.config.getUserName(), this.config.getRequestHeader(ACCEPT_LANGUAGE_HEADER), statusCode);
                String contextInfo = TM1RESTODPException.getContextInformation(this.getConfig().getServer(), Integer.toString(this.getConfig().getPort()), this.getConfig().getProductLocale());
                TM1RESTODPException providerException = new TM1RESTODPException(TM1RESTMessageKeys.CON_CANNOT_LOGIN, Long.toString(statusCode), contextInfo);
                IDataSource ds = this.getConfig().getDataSource();
                IDataSourceConnection dsConnection = ds.getDataSourceConnection();
                dsConnection.invalidateResolvedSignon();
                throw new LogonFailureException(ds, LogonFailureException.SubCodeEnum.UNAUTHORIZED, (Throwable)((Object)providerException));
            }
        }
        securityMode = this.config.getIntegratedSecurityMode();
        if (statusCode < 400L) {
            List<HttpCookie> setCookies = httpResponse.getSetCookies();
            this.setSetCookies(setCookies);
            if (null == this.getTM1SessionIdCookie()) {
                for (HttpCookie cookie : setCookies) {
                    String cookieName = cookie.getName();
                    if (cookieName == null || !cookieName.startsWith(TM1_SESSION_ID) || cookie.getValue() == null) continue;
                    this.setTM1SessionIdCookie(cookie);
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.TRACE, "Set TM1Session: cookie [%s]", cookie.getValue());
                    break;
                }
            }
        }
        switch (securityMode) {
            case CAM: {
                userNameOrCAMPassport = this.config.getCAMPassport();
                break;
            }
            case OIDC: 
            case OAUTH2: {
                userNameOrCAMPassport = this.config.getUserIdentityName();
                break;
            }
            default: {
                userNameOrCAMPassport = this.config.getUserName();
            }
        }
        if (throwOnError && statusCode >= 400L) {
            LogLevel logLevel = LogLevel.ERROR;
            if (404L == statusCode) {
                logLevel = LogLevel.INFO;
            }
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, logLevel, "Failed to Execute: [%s] to [%s] by [%s] locale [%s] HttpStatus [%d]", httpMethod.getClass().getSimpleName(), httpMethod.getURI().toString(), userNameOrCAMPassport, this.config.getRequestHeader(ACCEPT_LANGUAGE_HEADER), statusCode);
            String reasonPhrase = httpResponse.getStatusLine().getReasonPhrase();
            IJsonObject jsonError = httpResponse.getJSONResponse();
            httpResponse.close();
            if (statusCode != 404L) {
                this.setTM1SessionIdCookie(null);
            }
            TM1RESTODPException ex = new TM1RESTODPException(TM1RESTMessageKeys.ERR_BAD_REQUEST, String.format(BAD_REQUEST_MSG_FORMAT, statusCode, reasonPhrase));
            ex.setJsonError(jsonError);
            ex.setStatusCode(statusCode);
            throw ex;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.TRACE, "Executed: [%s] to [%s] by [%s] locale [%s] in %d milliseconds.", httpMethod.getClass().getSimpleName(), httpMethod.getURI().toString(), userNameOrCAMPassport, this.config.getRequestHeader(ACCEPT_LANGUAGE_HEADER), elapsedTime);
        return httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJsonObject createResource(String path, String mediaType, IJsonObject model) throws IOException {
        IJsonObject jsonResponse = null;
        HttpRequestBase method = this.createPostRequest(path, mediaType, model);
        try (RESTClientResponse clientResponse = null;){
            clientResponse = this.executeMethod(method, false);
            jsonResponse = clientResponse.getJSONResponse();
        }
        return jsonResponse;
    }

    public IJsonObject createResourceAsync(final String path, final String mediaType, final IJsonObject model, final ExecutionEnvironment executionEnvironment) throws IOException {
        IJsonObject jsonObject;
        Callable<IJsonObject> asyncTask = new Callable<IJsonObject>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IJsonObject call() throws Exception {
                Locale aLocale = null;
                if (executionEnvironment != null && executionEnvironment.getRequestEnvironment() != null) {
                    RESTClient.this.mRequestCAMPassport = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getCAMPassport();
                    aLocale = ((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale();
                }
                RESTClient.this.setAuthorization(RESTClient.this.mRequestCAMPassport);
                HttpRequestBase method = RESTClient.this.createPostRequest(path, mediaType, model);
                if (aLocale != null && path.startsWith(RESTClient.this.mExecuteMDXUri)) {
                    method.removeHeaders(RESTClient.ACCEPT_LANGUAGE_HEADER);
                    method.addHeader(RESTClient.ACCEPT_LANGUAGE_HEADER, aLocale.toString());
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_MDX, LogLevel.TRACE, "Accept-Language= '[%s]'", aLocale.toString());
                }
                IJsonObject jsonResponse = null;
                RESTClientResponse clientResponse = null;
                boolean bStop = false;
                int iAttempt = 1;
                while (true) {
                    try {
                        clientResponse = RESTClient.this.executeMethod(method, false);
                        long respCode = clientResponse.getStatusCode();
                        if (200L != respCode && 201L != respCode && !RESTClient.isMemberNotFoundError(clientResponse)) {
                            bStop = RESTClient.noMoreAttempts(method, clientResponse, null, iAttempt);
                            if (!bStop) {
                                ++iAttempt;
                                continue;
                            }
                            jsonResponse = clientResponse.getJSONResponse();
                            if (null == jsonResponse) {
                                jsonResponse = RESTClient.this.createFailureObject(RESTStateEnum.FAILED, respCode);
                            }
                            RESTClient.this.close();
                            IJsonObject iJsonObject = jsonResponse;
                            return iJsonObject;
                        }
                        jsonResponse = clientResponse.getJSONResponse();
                    }
                    catch (Exception exception) {
                        if (bStop) {
                            IJsonObject iJsonObject = RESTClient.this.createFailureObject(exception);
                            return iJsonObject;
                        }
                        bStop = RESTClient.noMoreAttempts(method, clientResponse, exception, iAttempt);
                        if (bStop) continue;
                        ++iAttempt;
                        continue;
                    }
                    finally {
                        if (clientResponse == null) continue;
                        clientResponse.close();
                        continue;
                    }
                    break;
                }
                return jsonResponse;
            }
        };
        RESTClientAsyncRequest<2> request = new RESTClientAsyncRequest<2>(this, asyncTask, executionEnvironment);
        try {
            jsonObject = request.call();
        }
        catch (IOException e) {
            this.close();
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_GET_RESOURCE_FAILED, path, (Object)this.config.getServer(), (Object)e.getLocalizedMessage());
        }
        return jsonObject;
    }

    private static boolean noMoreAttempts(HttpRequestBase method, RESTClientResponse response, Exception exception, int attempt) {
        if (attempt < 5) {
            String reason = UNKNOWN;
            if (response != null) {
                Long respCode = response.getStatusCode();
                String respCodeString = respCode.toString();
                String respErrorMsg = UNKNOWN;
                String errorMsg = response.getErrorMessage();
                if (errorMsg != null) {
                    respErrorMsg = errorMsg;
                }
                reason = String.format("Status code: [%s], Response: [%s]", respCodeString, respErrorMsg);
            }
            if (exception != null) {
                reason = String.format("Reason: %s", exception.getLocalizedMessage());
            }
            try {
                Thread.sleep(RESTClientFactory.getInstance().getKeepAliveMilliSeconds());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.WARN, "Failed to Execute: [%s] to [%s]. [%s]. Retry attempt [%d] of [%d].", method.getClass().getSimpleName(), method.getURI().toString(), reason, attempt + 1, 5);
            return false;
        }
        return true;
    }

    private static boolean isMemberNotFoundError(RESTClientResponse response) {
        if (null == response || response.getErrorMessage() == null) {
            return false;
        }
        return response.getErrorMessage().contains("member not found");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long deleteResource(String path) throws IOException {
        this.setRequestHeader("Prefer", "respond-async");
        HttpRequestBase method = this.createDeleteRequest(path, "application/json", this.config.getRunLocale());
        RESTClientResponse clientResponse = null;
        try {
            clientResponse = this.executeMethod(method, false);
            long l = clientResponse.getStatusCode();
            return l;
        }
        catch (IOException e) {
            this.close();
        }
        finally {
            this.setRequestHeader("Prefer", null);
            if (clientResponse != null) {
                clientResponse.close();
            }
        }
        return 400L;
    }

    public void setRequestHeader(String name, String value) {
        this.config.setRequestHeader(name, value);
    }

    public void setRequestCookie(HttpCookie cookie) {
        this.config.setCookie(cookie);
    }

    public HttpRequestBase createGetRequest(String path) {
        HttpGet httpGet = new HttpGet();
        this.setupMethod((HttpRequestBase)httpGet, path);
        return httpGet;
    }

    @Override
    public void close() {
    }

    public void accept(String mediaType) {
        this.setRequestHeader("Accept", mediaType);
    }

    public void setAuthorization() {
        this.setAuthorization(null);
    }

    public void setAuthorization(String camPassport) {
        switch (this.config.getIntegratedSecurityMode()) {
            case BASIC: 
            case MIXED_BASIC: {
                if (this.getTM1SessionIdCookie() != null) {
                    this.setRequestCookie(this.getTM1SessionIdCookie());
                    break;
                }
                if (this.config.getUserName().isEmpty()) {
                    throw new TM1RESTODPException(TM1RESTMessageKeys.CON_SIGNON_MISSING_PARAMETERS, this.config.getServer());
                }
                String logon = RESTClient.safeString(this.config.getUserName()) + COLON_MARK + RESTClient.safeString(this.config.getPassword());
                byte[] encodedBytes = Base64.encodeBase64((byte[])logon.getBytes());
                this.setRequestHeader(AUTHORIZATION_HEADER, BASIC_AUTHORIZATION + new String(encodedBytes));
                break;
            }
            case CAM: {
                if (null != camPassport) {
                    this.setRequestHeader(AUTHORIZATION_HEADER, CAMPASSPORT_AUTHORIZATION + camPassport);
                }
                if (this.getTM1SessionIdCookie() != null) {
                    this.setRequestCookie(this.getTM1SessionIdCookie());
                    break;
                }
                if (null == camPassport && this.config.getCAMPassport().isEmpty()) {
                    throw new TM1RESTODPException(TM1RESTMessageKeys.CON_SIGNON_MISSING_PARAMETERS, this.config.getServer());
                }
                if (null != camPassport) break;
                this.setRequestHeader(AUTHORIZATION_HEADER, CAMPASSPORT_AUTHORIZATION + this.config.getCAMPassport());
                break;
            }
            case DISTRIBUTED: {
                throw new XQERuntimeException(XQEMessageKeys.GEN_NotYetSupported_INTERNAL, "connectDistributed()");
            }
            case WIA: 
            case MIXED_WIA: {
                String token = this.config.getCAMCryptoHandle();
                if (token.isEmpty()) {
                    throw new TM1RESTODPException(TM1RESTMessageKeys.CON_SIGNON_MISSING_PARAMETERS, this.config.getServer());
                }
                byte[] encodedBytes = Base64.encodeBase64((byte[])token.getBytes());
                this.setRequestHeader(AUTHORIZATION_HEADER, NEGOTIATE_AUTHORIZATION + new String(encodedBytes));
                break;
            }
            case OIDC: {
                if (this.config.getOIDCAccessToken() != null) {
                    this.setRequestHeader(AUTHORIZATION_HEADER, BEARER_TOKEN + this.config.getOIDCAccessToken());
                }
                if (this.config.getOIDCIdToken() != null) {
                    this.setRequestHeader(OIDC_ID_TOKEN, this.config.getOIDCIdToken());
                }
                if (this.getTM1SessionIdCookie() == null) break;
                this.setRequestCookie(this.getTM1SessionIdCookie());
                break;
            }
            case OAUTH2: {
                String oauth2Token = this.config.getOAuth2Token(this.client);
                this.setRequestHeader(AUTHORIZATION_HEADER, BEARER_TOKEN + oauth2Token);
                List<HttpCookie> setCookies = this.mSetCookies;
                if (setCookies == null) break;
                for (HttpCookie cookie : setCookies) {
                    this.setRequestCookie(cookie);
                }
                break;
            }
            default: {
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, "IntegratedSecurityMode?");
            }
        }
    }

    public void setLocale(String locale) {
        this.setRequestHeader(ACCEPT_LANGUAGE_HEADER, locale);
    }

    public void setUseFillerMembers() {
        this.setUseFillerMembers(this.mUseFillerMemberConfig);
    }

    public void setUseFillerMembers(boolean enable) {
        this.setRequestHeader(TM1_USE_FILLER_MEMBERS, Boolean.toString(enable));
    }

    public String toString() {
        return this.config.toString();
    }

    public TM1RESTServerSecurity.SecurityMode getSecurityMode() {
        return this.config.getIntegratedSecurityMode();
    }

    public void setAuthorizationParameters(String aUserName, String aPassword, String aUserIdentityName, String aCAMPassport, String aCAMCryptoHandle, String aOIDCIdToken, IEncryptedObject<String> aOIDCAccessToken, String aUserUniqueSecurityName) {
        this.config.setUserName(aUserName);
        this.config.setPassword(aPassword);
        this.config.setCAMPassport(aCAMPassport);
        this.config.setCAMCryptoHandle(aCAMCryptoHandle);
        this.config.setOIDCIdToken(aOIDCIdToken);
        this.config.setOIDCAccessToken(aOIDCAccessToken);
        this.config.setUserIdentityName(aUserIdentityName);
        this.config.setUserUniqueSecurityName(aUserUniqueSecurityName);
    }

    public void setAuthorizationParameters(ConnectionParameters connParams, IExecutionEnvironment execEnv) {
        int portNumber = connParams.intValueOf(TM1RESTServerPortParameter.class, 8001);
        this.config.setUserName((String)connParams.valueOf(TM1RESTUserNameParameter.class, String.class));
        this.config.setPassword((String)connParams.valueOf(TM1RESTPasswordParameter.class, String.class));
        this.config.setCAMPassport((String)connParams.valueOf(CAMPassportParameter.class, String.class));
        this.config.setCAMCryptoHandle((String)connParams.valueOf(CAMCryptoHandleParameter.class, String.class));
        this.config.setOIDCIdToken((String)connParams.valueOf(TM1RESTOIDCIdTokenParameter.class, String.class));
        TM1RESTOIDCAccessTokenParameter oidcAccessToken = (TM1RESTOIDCAccessTokenParameter)connParams.get(TM1RESTOIDCAccessTokenParameter.class);
        IEncryptedObject token = null;
        if (oidcAccessToken != null) {
            token = (IEncryptedObject)oidcAccessToken.value();
        }
        this.config.setOIDCAccessToken((IEncryptedObject<String>)token);
        String userIdentityName = "";
        CMUserIdentity cmUserIdentity = (CMUserIdentity)connParams.get(CMUserIdentity.class);
        if (cmUserIdentity != null) {
            if (-2 == portNumber) {
                userIdentityName = CMUserIdentity.getUserName(execEnv);
            }
            if (null == userIdentityName || userIdentityName.isEmpty()) {
                userIdentityName = cmUserIdentity.getDefaultName();
            }
        }
        this.config.setUserIdentityName(userIdentityName);
        String userUniqueSecurityName = "";
        CMUserUniqueSecurityName cmUserUniqueSecurityName = (CMUserUniqueSecurityName)connParams.get(CMUserUniqueSecurityName.class);
        if (cmUserUniqueSecurityName != null) {
            userUniqueSecurityName = cmUserUniqueSecurityName.getUniqueSecurityName();
        }
        this.config.setUserUniqueSecurityName(userUniqueSecurityName);
    }

    public RESTClientConfig getConfig() {
        return this.config;
    }

    private HttpRequestBase createPostRequest(String path, String mediaType, IJsonObject resource) {
        HttpPost httpPost = new HttpPost();
        this.accept(mediaType);
        this.setupMethod((HttpRequestBase)httpPost, path);
        StringEntity inputStreamEntity = new StringEntity(resource.toString(), "UTF-8");
        inputStreamEntity.setContentType(mediaType);
        httpPost.setEntity((HttpEntity)inputStreamEntity);
        return httpPost;
    }

    private HttpRequestBase createDeleteRequest(String path, String mediaType, String locale) {
        HttpDelete httpDelete = new HttpDelete();
        this.accept(mediaType);
        this.setAuthorization();
        this.setLocale(locale);
        this.setupMethod((HttpRequestBase)httpDelete, path);
        return httpDelete;
    }

    private URI buildURI(String uri) throws URISyntaxException {
        String path;
        String query = null;
        int qPos = uri.lastIndexOf(QUESTION_MARK);
        if (-1 == qPos) {
            path = uri;
        } else {
            path = uri.substring(0, qPos);
            query = uri.substring(qPos + 1);
        }
        if (-1 == this.config.getPort() || -2 == this.config.getPort()) {
            URI aUri = new URI(this.config.getHostConnectionParam());
            StringBuilder sb = new StringBuilder(aUri.getPath());
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
                sb.append(path.substring(1));
            } else {
                sb.append(path);
            }
            URI pathURI = new URI(aUri.getScheme(), null, aUri.getHost(), aUri.getPort(), sb.toString(), null, null);
            if (null == query) {
                return pathURI;
            }
            return URI.create(pathURI.toString() + QUESTION_MARK + query);
        }
        URI pathURI = new URI(this.config.getScheme(), null, this.config.getServer(), this.config.getPort(), path, null, null);
        if (null == query) {
            return pathURI;
        }
        return URI.create(pathURI.toString() + QUESTION_MARK + query);
    }

    private Collection<Header> getRequestHeaders() {
        return this.config.getRequestHeaders();
    }

    private RESTClientResponse executeMethod(HttpRequestBase httpMethod) throws IOException {
        return this.executeMethod(httpMethod, true);
    }

    private void setupMethod(HttpRequestBase httpMethod, String path) {
        try {
            this.close();
            httpMethod.setURI(this.buildURI(path));
            this.copyRequestHeaders(httpMethod);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void copyRequestHeaders(HttpRequestBase request) {
        for (Header header : this.getRequestHeaders()) {
            request.addHeader(header);
        }
    }

    private void setRequestHeaders(HttpRequestBase request) {
        for (Header header : this.getRequestHeaders()) {
            request.setHeader(header);
        }
    }

    private RESTClientResponse executeRequest(HttpRequestBase httpMethod) throws ClientProtocolException, IOException {
        RESTClientResponse clientResponse;
        if (null == this.futureRequestExecutionService) {
            clientResponse = new RESTClientResponse((HttpResponse)this.client.execute((HttpUriRequest)httpMethod));
        } else {
            FutureTaskResponseHandler handler = new FutureTaskResponseHandler();
            HttpRequestFutureTask task = this.futureRequestExecutionService.execute((HttpUriRequest)httpMethod, null, (ResponseHandler)handler);
            try {
                task.get();
            }
            catch (InterruptedException iEx) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_BAD_REQUEST, String.format(BAD_REQUEST_MSG_FORMAT, 400, iEx.getLocalizedMessage()));
            }
            catch (ExecutionException eEx) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_BAD_REQUEST, String.format(BAD_REQUEST_MSG_FORMAT, 400, eEx.getLocalizedMessage()));
            }
            clientResponse = handler.getClientResponse();
        }
        return clientResponse;
    }

    public HttpCookie getTM1SessionIdCookie() {
        return this.mTM1SessionIdCookie;
    }

    public void setTM1SessionIdCookie(HttpCookie tm1SessionIdCookie) {
        if (this.mTM1SessionIdCookie != null) {
            this.closeTM1Session();
        }
        this.mTM1SessionIdCookie = tm1SessionIdCookie;
    }

    private void setSetCookies(List<HttpCookie> setCookies) {
        this.mSetCookies = setCookies;
    }

    public String getExecuteMDXUri() {
        return this.mExecuteMDXUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeTM1Session() {
        if (null == this.mTM1SessionIdCookie) {
            return;
        }
        this.setRequestCookie(this.mTM1SessionIdCookie);
        ODataUriBuilder uriBuilder = new ODataUriBuilder();
        uriBuilder.entity("ActiveSession").action("Close");
        IJsonObject jsonObj = this.mIJsonFactory.createObject();
        HttpRequestBase method = this.createPostRequest(uriBuilder.toString(), "application/json", jsonObj);
        RESTClientResponse clientResponse = null;
        try {
            clientResponse = this.executeMethod(method, false);
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.TRACE, "Close TM1Session: cookie [%s]", this.mTM1SessionIdCookie.getValue());
        }
        catch (Exception ex) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.TRACE, ex, "Failed to close TM1Session: cookie [%s]", this.mTM1SessionIdCookie.getValue());
            this.close();
        }
        finally {
            this.mTM1SessionIdCookie = null;
            if (clientResponse != null) {
                clientResponse.close();
            }
            RESTClientFactory.getInstance().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    public static ODataUriBuilder getDefaultUriBuilder() {
        return new ODataUriBuilder(RESTClientConfig.getDefaultServiceRoot());
    }

    IJsonObject createFailureObject(Exception e) {
        IJsonObject jExceptionObj = this.createFailureObject(RESTStateEnum.FAILED);
        jExceptionObj.put("error", e.getLocalizedMessage());
        return jExceptionObj;
    }

    IJsonObject createFailureObject(RESTStateEnum state) {
        return this.createFailureObject(state, -1L);
    }

    IJsonObject createFailureObject(RESTStateEnum state, long statusCode) {
        IJsonObject jsonFailureObj = this.getJsonFactory().createObject();
        RESTStateEnum.setState(state, jsonFailureObj);
        RESTStateEnum.setStatusCode(statusCode, jsonFailureObj);
        return jsonFailureObj;
    }

    static String safeString(String string) {
        if (null == string) {
            return "";
        }
        return string;
    }

    public void deleteCellset(String cellSetId) {
        if (null == cellSetId) {
            return;
        }
        ODataUriBuilder uriBuilder = this.getUriBuilder();
        uriBuilder.reset();
        uriBuilder.entityId("Cellsets", cellSetId);
        try {
            long respCode = this.deleteResource(uriBuilder.toString());
            if (204L == respCode) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_QUERY_RESULTSET, LogLevel.TRACE, "Cell set has been removed [%s].", cellSetId);
            } else {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_QUERY_RESULTSET, LogLevel.TRACE, "Cell set had been removed [%s]. Response code=%d.", cellSetId, respCode);
            }
        }
        catch (IOException e) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_QUERY_RESULTSET, LogLevel.ERROR, "Failed to remove the Cell set [%s]. Reason: [%s].", cellSetId, e.getLocalizedMessage());
        }
    }

    public static boolean getPAUseFillerMemberConfig() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("queryExecution.paUseFillerMember[@enabled]", true);
    }

    public static boolean getPAUseRootMembersConfig() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        return configuration.getBooleanProperty("queryExecution.paUseRootMembers[@enabled]", false);
    }
}

