/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTStateEnum;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class RESTClientAsyncRequest<T extends Callable<IJsonObject>> {
    private static final int ITERATION_WAIT_TIME = 5000;
    private final RESTClient mClient;
    private final T mTask;
    private final ExecutionEnvironment mEnvironment;

    RESTClientAsyncRequest(RESTClient client, T task, ExecutionEnvironment executionEnvironment) {
        this.mClient = client;
        this.mTask = task;
        this.mEnvironment = executionEnvironment;
    }

    IJsonObject call() throws IOException {
        IJsonObject jsonObject;
        FutureTask task = new FutureTask(this.mTask);
        RESTClientFactory.getInstance().getServiceExecutor().execute(task);
        boolean bContinue = true;
        do {
            try {
                jsonObject = (IJsonObject)task.get(5000L, TimeUnit.MILLISECONDS);
                bContinue = false;
            }
            catch (InterruptedException e) {
                jsonObject = this.mClient.createFailureObject(e);
                bContinue = false;
            }
            catch (ExecutionException e) {
                jsonObject = this.mClient.createFailureObject(e);
                bContinue = false;
            }
            catch (TimeoutException e) {
                jsonObject = null;
            }
            if (this.mEnvironment == null || !this.mEnvironment.getCancelManager().isRequestCancelled()) continue;
            return this.mClient.createFailureObject(RESTStateEnum.CANCELLED);
        } while (bContinue);
        RESTStateEnum state = RESTStateEnum.getState(jsonObject);
        if (RESTStateEnum.UNKNOWN == state) {
            jsonObject = this.mClient.createFailureObject(RESTStateEnum.UNKNOWN);
        } else if (RESTStateEnum.FAILED != state) {
            RESTStateEnum.setState(RESTStateEnum.COMPLETED, jsonObject);
        }
        return jsonObject;
    }
}

