/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProductLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTAdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerPortParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerProtocolParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.BaseHttpClientConfig;
import com.cognos.xqe.data.providers.olap.tm1rest.security.OAuth2Token;
import com.cognos.xqe.data.providers.olap.tm1rest.security.OAuth2Utils;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.security.IEncryptedObject;
import java.net.URI;
import java.util.Locale;
import org.apache.http.impl.client.CloseableHttpClient;

public class RESTClientConfig
extends BaseHttpClientConfig {
    private static final int MAGIC_80 = 80;
    private static final String DEF_API_VERSION = "v1";
    private static final String API_ROOT_FORMAT = "/api/%s/";
    private static final String OAUTH2_PATH = "/oauth2/token";
    private final String mHostConnectionParam;
    private String mScheme = "http";
    private String mServer = "localhost";
    private String mUserName = null;
    private String mPassword = null;
    private String mUserIdentityName = null;
    private String mUserUniqueSecurityName = null;
    private String mRunLocale = null;
    private Locale mProductLocale = null;
    private String mCAMPassport = null;
    private String mCAMCryptoHandle = null;
    private String mOIDCIdToken = null;
    private IEncryptedObject<String> mOIDCAccessToken = null;
    private OAuth2Token mOAuth2Token = null;
    private String mOAuth2IdentityProvider = null;
    private final String mServiceRoot;
    private int port = 80;
    private TM1RESTServerSecurity.SecurityMode integratedSecurityMode = TM1RESTServerSecurity.SecurityMode.BASIC;
    private boolean detectSecurityMode = false;
    private IDataSource mDataSource;
    private String context = "/";

    public RESTClientConfig(String ascheme, String aserver, int aport, Locale runLocale, Locale productLocale, ConnectionParameters connectionParameters) {
        this.mHostConnectionParam = (String)connectionParameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        this.mScheme = ascheme;
        this.mServer = aserver;
        this.port = aport;
        this.setRunLocale(runLocale);
        this.setProductLocale(productLocale);
        this.mServiceRoot = String.format(API_ROOT_FORMAT, DEF_API_VERSION);
        this.mDataSource = (IDataSource)connectionParameters.valueOf(DataSourceParameter.class, IDataSource.class);
        if (-2 == aport) {
            try {
                URI uri = new URI(this.mServer);
                this.mOAuth2IdentityProvider = new URI(uri.getScheme(), null, uri.getAuthority(), uri.getPort(), OAUTH2_PATH, null, null).toString();
            }
            catch (Exception e) {
                throw new TM1RESTODPException(e);
            }
        }
    }

    public RESTClientConfig(ConnectionParameters connectionParameters) {
        int portNumber = connectionParameters.intValueOf(TM1RESTServerPortParameter.class, 8001);
        this.mHostConnectionParam = (String)connectionParameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        if (-2 == portNumber) {
            try {
                URI uri = new URI((String)connectionParameters.valueOf(TM1RESTAdminHostParameter.class, String.class));
                this.mScheme = uri.getScheme();
                this.mServer = uri.getAuthority();
                this.mOAuth2IdentityProvider = new URI(this.mScheme, null, this.mServer, uri.getPort(), OAUTH2_PATH, null, null).toString();
            }
            catch (Exception e) {
                throw new TM1RESTODPException(e);
            }
        } else {
            this.mScheme = (String)connectionParameters.valueOf(TM1RESTServerProtocolParameter.class, String.class);
            this.mServer = (String)connectionParameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        }
        this.port = portNumber;
        this.setRunLocale((Locale)connectionParameters.valueOf(RunLocaleParameter.class, Locale.class));
        this.setProductLocale((Locale)connectionParameters.valueOf(ProductLocaleParameter.class, Locale.class));
        this.mServiceRoot = String.format(API_ROOT_FORMAT, DEF_API_VERSION);
        this.mDataSource = (IDataSource)connectionParameters.valueOf(DataSourceParameter.class, IDataSource.class);
    }

    public String getHostConnectionParam() {
        return this.mHostConnectionParam;
    }

    public String getScheme() {
        return this.mScheme;
    }

    public String getServer() {
        return this.mServer;
    }

    public int getPort() {
        return this.port;
    }

    public String getUserName() {
        return this.mUserName;
    }

    public void setUserName(String userName) {
        this.mUserName = userName;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String password) {
        this.mPassword = password;
    }

    public String getCAMPassport() {
        return this.mCAMPassport;
    }

    public void setCAMPassport(String camPassport) {
        this.mCAMPassport = camPassport;
    }

    public String getCAMCryptoHandle() {
        return this.mCAMCryptoHandle;
    }

    public void setCAMCryptoHandle(String camCryptoHandle) {
        this.mCAMCryptoHandle = camCryptoHandle;
    }

    public String getContext() {
        return this.context;
    }

    public void setIntegratedSecurityMode(TM1RESTServerSecurity.SecurityMode aSecurityMode) {
        this.integratedSecurityMode = aSecurityMode;
    }

    public TM1RESTServerSecurity.SecurityMode getIntegratedSecurityMode() {
        return this.integratedSecurityMode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mScheme).append("-").append(this.mServer).append("-").append(this.port);
        return sb.toString();
    }

    public String getRunLocale() {
        return this.mRunLocale;
    }

    public void setRunLocale(Locale locale) {
        this.mRunLocale = locale.toString();
    }

    public Locale getProductLocale() {
        return this.mProductLocale;
    }

    public void setProductLocale(Locale locale) {
        this.mProductLocale = locale;
    }

    public boolean getDetectSecurityMode() {
        return this.detectSecurityMode;
    }

    public String getServiceRoot() {
        return this.mServiceRoot;
    }

    public IDataSource getDataSource() {
        return this.mDataSource;
    }

    public static String getDefaultServiceRoot() {
        return String.format(API_ROOT_FORMAT, DEF_API_VERSION);
    }

    public String getOIDCIdToken() {
        return this.mOIDCIdToken;
    }

    public void setOIDCIdToken(String aOIDCIdToken) {
        this.mOIDCIdToken = aOIDCIdToken;
    }

    public String getOIDCAccessToken() {
        if (null == this.mOIDCAccessToken) {
            return "";
        }
        return (String)this.mOIDCAccessToken.decrypt();
    }

    public void setOIDCAccessToken(IEncryptedObject<String> aOIDCAccessToken) {
        this.mOIDCAccessToken = aOIDCAccessToken;
    }

    public String getUserIdentityName() {
        return this.mUserIdentityName;
    }

    public void setUserIdentityName(String aUserIdentityName) {
        this.mUserIdentityName = aUserIdentityName;
    }

    public String getUserUniqueSecurityName() {
        return this.mUserUniqueSecurityName;
    }

    public void setUserUniqueSecurityName(String aUserUniqueSecurityName) {
        this.mUserUniqueSecurityName = aUserUniqueSecurityName;
    }

    public synchronized String getOAuth2Token(CloseableHttpClient client) {
        if (null == this.mOAuth2Token || this.mOAuth2Token.hasExpired()) {
            this.mOAuth2Token = OAuth2Utils.retrieveOAuth2Bearer(client, this.getOAuth2IDPTokenEndpointURL(), this.getUserIdentityName(), this.getUserUniqueSecurityName());
        }
        return this.mOAuth2Token.getAccessToken();
    }

    public String getOAuth2IDPTokenEndpointURL() {
        return this.mOAuth2IdentityProvider;
    }

    public boolean needsOAuth2Authentication() {
        return this.mOAuth2IdentityProvider != null;
    }
}

