/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientConfig;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientFactoryConfig;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.TrustKnownSelfSignedStrategy;
import com.cognos.xqe.trace.LogLevel;
import java.net.SocketException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HeaderElement;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NoHttpResponseException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionMetrics;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;

public class RESTClientFactory {
    private static final String REST_CLIENT_FACTORY_HAS_NOT_BEEN_INITIALIZED = "RESTClientFactory has not been initialized";
    private static final RESTClientFactory INSTANCE = new RESTClientFactory();
    protected static final int DEFAULT_MAX_CONNECTIONS = 256;
    private static final String TLSV1_2 = "TLSv1.2";
    private CloseableHttpClient httpClient;
    private FutureRequestExecutionService futureRequestExecutionService = null;
    private PoolingHttpClientConnectionManager connectionMgr;
    private ExecutorService serviceExecutor = null;
    private ScheduledExecutorService scheduledExecutorService = null;
    private ScheduledFuture<?> staleMonitorFuture = null;
    private int warnConnectionsThreshold = 0;
    private int rejectConnectionsThreshold = 0;
    private int keepAliveMilliSeconds;

    public static RESTClientFactory getInstance() {
        return INSTANCE;
    }

    @Deprecated
    public RESTClient getClient(String ascheme, String aserver, int aport, String userName, String password, Locale locale, Locale productLocale) {
        if (this.getConnectionMgr() == null || this.getHttpClient() == null) {
            throw new RuntimeException(REST_CLIENT_FACTORY_HAS_NOT_BEEN_INITIALIZED);
        }
        RESTClientConfig restClientConfig = new RESTClientConfig(ascheme, aserver, aport, locale, productLocale, null);
        restClientConfig.setUserName(userName);
        restClientConfig.setPassword(password);
        return new RESTClient(this.httpClient, restClientConfig, null);
    }

    public RESTClient getClient(RESTClientConfig config) {
        if (this.getConnectionMgr() == null || this.getHttpClient() == null) {
            throw new RuntimeException(REST_CLIENT_FACTORY_HAS_NOT_BEEN_INITIALIZED);
        }
        if (this.futureRequestExecutionService != null) {
            FutureRequestExecutionMetrics metrics = this.futureRequestExecutionService.metrics();
            this.logConnectionPoolMetrics(metrics);
            if (metrics.getActiveConnectionCount() + metrics.getScheduledConnectionCount() > (long)this.rejectConnectionsThreshold) {
                String errMsg = String.format("New TMR connection rejected: threshold value of [%d] pooled HTTP Connections has been reached.", metrics.getActiveConnectionCount() + metrics.getScheduledConnectionCount());
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.ERROR, errMsg, new Object[0]);
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_BAD_REQUEST, errMsg);
            }
        }
        return new RESTClient(this.httpClient, config, this.getFutureRequestExecutionService());
    }

    public synchronized void startup(int imaxConnections, int imaxPerRouteConnections) {
        if (this.getConnectionMgr() == null || this.getHttpClient() == null) {
            SSLContext sslcontext = null;
            try {
                sslcontext = SSLContexts.custom().loadTrustMaterial((TrustStrategy)new TrustKnownSelfSignedStrategy()).build();
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                sslcontext = null;
            }
            SSLConnectionSocketFactory sslsf = null;
            if (sslcontext != null) {
                sslsf = new SSLConnectionSocketFactory(sslcontext, new String[]{TLSV1_2}, null, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
            }
            RegistryBuilder regBuilder = RegistryBuilder.create();
            regBuilder.register("http", (Object)PlainConnectionSocketFactory.getSocketFactory());
            if (sslsf != null) {
                regBuilder.register("https", (Object)sslsf);
            }
            Registry registry = regBuilder.build();
            this.connectionMgr = new PoolingHttpClientConnectionManager(registry);
            int maxConnections = imaxConnections;
            if (-1 == imaxConnections) {
                maxConnections = 256;
            }
            this.connectionMgr.setMaxTotal(maxConnections);
            this.warnConnectionsThreshold = maxConnections * 80 / 100;
            this.rejectConnectionsThreshold = maxConnections * 90 / 100;
            int maxPerRouteConnections = imaxPerRouteConnections;
            if (-1 == maxPerRouteConnections) {
                maxPerRouteConnections = maxConnections;
            }
            this.connectionMgr.setDefaultMaxPerRoute(maxPerRouteConnections);
            RequestConfig reqConfig = RequestConfig.custom().setCookieSpec("ignoreCookies").setConnectTimeout(RESTClientFactoryConfig.getHttpClientConnectionTimeout()).setConnectionRequestTimeout(RESTClientFactoryConfig.getHttpClientConnectionTimeout()).setSocketTimeout(RESTClientFactoryConfig.getHttpClientSocketTimeout()).build();
            HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)this.connectionMgr).setDefaultRequestConfig(reqConfig).setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            if (RESTClientFactoryConfig.useEnhancedNetworkErrorsHandling()) {
                httpClientBuilder.setRetryHandler(this.buildHttpRequestRetryHandler()).setKeepAliveStrategy(this.buildKeepAliveStrategy());
            }
            if (RESTClientFactoryConfig.useFiddlerProxyForTM1RESTClient()) {
                httpClientBuilder.setProxy(new HttpHost("localhost", 8888));
            }
            this.httpClient = httpClientBuilder.build();
            ExecutorService executorService = Executors.newFixedThreadPool(maxConnections);
            this.futureRequestExecutionService = new FutureRequestExecutionService((HttpClient)this.httpClient, executorService);
            this.serviceExecutor = Executors.newCachedThreadPool();
            if (RESTClientFactoryConfig.useEnhancedNetworkErrorsHandling()) {
                this.keepAliveMilliSeconds = RESTClientFactoryConfig.getHttpClientIdleConnectionTimeout();
                this.scheduledExecutorService = this.getScheduledExecutorService();
                this.monitorForStaleConnections();
            }
        }
    }

    public synchronized void startup() {
        this.startup(-1, -1);
    }

    public void shutdown() {
        if (this.staleMonitorFuture != null) {
            this.staleMonitorFuture.cancel(true);
            this.staleMonitorFuture = null;
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            this.scheduledExecutorService = null;
        }
        if (this.getServiceExecutor() != null) {
            this.getServiceExecutor().shutdown();
            this.serviceExecutor = null;
        }
        if (this.getConnectionMgr() != null) {
            this.getConnectionMgr().shutdown();
            this.connectionMgr = null;
            this.httpClient = null;
        }
    }

    public int getKeepAliveMilliSeconds() {
        return this.keepAliveMilliSeconds;
    }

    protected CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected PoolingHttpClientConnectionManager getConnectionMgr() {
        return this.connectionMgr;
    }

    public ExecutorService getServiceExecutor() {
        return this.serviceExecutor;
    }

    public FutureRequestExecutionService getFutureRequestExecutionService() {
        return this.futureRequestExecutionService;
    }

    public void closeIdleConnections(long idleTimeout, TimeUnit timeUnit) {
        if (RESTClientFactoryConfig.useEnhancedNetworkErrorsHandling()) {
            this.getConnectionMgr().closeIdleConnections(idleTimeout, timeUnit);
        }
    }

    private ScheduledExecutorService getScheduledExecutorService() {
        return Executors.newSingleThreadScheduledExecutor(runnable -> {
            Thread thread = new Thread(runnable, "TMRHttpConnectionPoolCleaner");
            thread.setDaemon(true);
            return thread;
        });
    }

    private void monitorForStaleConnections() {
        this.staleMonitorFuture = this.scheduledExecutorService.scheduleWithFixedDelay(new IdleConnectionMonitor(this.connectionMgr), 5L, 5L, TimeUnit.SECONDS);
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy() {
        return (response, contest) -> {
            BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
            while (it.hasNext()) {
                HeaderElement he = it.nextElement();
                String param = he.getName();
                String value = he.getValue();
                if (value == null || !param.equalsIgnoreCase("timeout")) continue;
                try {
                    return Long.parseLong(value) * 1000L;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return this.keepAliveMilliSeconds;
        };
    }

    private HttpRequestRetryHandler buildHttpRequestRetryHandler() {
        return (exception, executionCount, context) -> {
            if (executionCount > 2) {
                return false;
            }
            if (exception instanceof NoHttpResponseException || exception instanceof SocketException) {
                try {
                    Thread.sleep(RESTClientFactory.getInstance().getKeepAliveMilliSeconds());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (TM1RESTLog.CONN_POOL_MONITOR.isOn(LogLevel.INFO)) {
                    HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
                    HttpRequest request = clientContext.getRequest();
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_POOL_MONITOR, LogLevel.INFO, () -> String.format("Failed to execute [%s]. Reason: [%s]. Retry attempt [%d].", request.toString(), exception, executionCount + 1));
                }
                return true;
            }
            return false;
        };
    }

    private void logConnectionPoolMetrics(FutureRequestExecutionMetrics metrics) {
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_POOL_MONITOR, LogLevel.TRACE, () -> String.format("HTTP Connections: active [%d], scheduled [%d], successful [%d], failed [%d]", metrics.getActiveConnectionCount(), metrics.getScheduledConnectionCount(), metrics.getSuccessfulConnectionCount(), metrics.getFailedConnectionCount()));
        if (metrics.getActiveConnectionCount() + metrics.getScheduledConnectionCount() > (long)this.warnConnectionsThreshold) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_POOL_MONITOR, LogLevel.WARN, "Threshold value of [%d] pooled HTTP Connections has been reached.", metrics.getActiveConnectionCount() + metrics.getScheduledConnectionCount());
        }
    }

    private class IdleConnectionMonitor
    implements Runnable {
        private final PoolingHttpClientConnectionManager connMgr;

        public IdleConnectionMonitor(PoolingHttpClientConnectionManager connMgr) {
            this.connMgr = connMgr;
        }

        @Override
        public void run() {
            try {
                this.connMgr.closeExpiredConnections();
                this.connMgr.closeIdleConnections((long)RESTClientFactory.this.keepAliveMilliSeconds, TimeUnit.MILLISECONDS);
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_POOL_MONITOR, LogLevel.TRACE, () -> this.connMgr.getTotalStats().toString());
            }
            catch (Exception ex) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_POOL_MONITOR, LogLevel.ERROR, ex, () -> "Unexpected exception in IdleConnectionMonitor");
            }
        }
    }
}

