/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.restclient;

import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.json.BIJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTStateEnum;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.util.EntityUtils;

public class RESTClientResponse
implements Closeable {
    private static final String FAILED_TO_GET_THE_RESOURCE_FROM_THE_SERVER = "Failed to get the resource [%s] from the [%s]";
    private static final String STATUS_AND_SERVER_ERROR = "Status: [%s]. Server error: [%s]";
    private static final String HTTP_STATUS_AND_SERVER_ERROR = "%s\nHttpStatus: [%d]. Server error: [%s]";
    private static final String SET_COOKIE = "Set-Cookie";
    private static final Header[] NO_HEADERS = new Header[0];
    private final IJsonFactory mIJsonFactory = BIJsonFactory.getInstance();
    private long mStatusCode;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private HttpResponse response;
    private IJsonObject responseAsJsonObject = null;
    private String responseAsString = null;

    public RESTClientResponse(HttpResponse aresponse) {
        Header[] headers;
        this.response = aresponse;
        this.mStatusCode = this.response.getStatusLine().getStatusCode();
        for (Header header : headers = this.response.getAllHeaders()) {
            this.responseHeaders.put(header.getName(), header.getValue());
        }
        String contentType = this.responseHeaders.get("Content-Type");
        String contentLength = this.responseHeaders.get("Content-Length");
        if (contentType != null && (null == contentLength || Long.parseLong(contentLength) > 0L)) {
            if (contentType.startsWith("application/json")) {
                this.responseAsJsonObject = this.getJSONResponse();
            } else if (contentType.startsWith("text/plain")) {
                this.responseAsString = this.getStringResponse();
            }
        }
    }

    public long getStatusCode() {
        return this.mStatusCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IJsonObject getJSONResponse() {
        if (this.responseAsJsonObject != null) {
            return this.responseAsJsonObject;
        }
        IJsonObject jsonResponse = null;
        InputStream responseStream = null;
        try {
            responseStream = this.getResponseStream();
            jsonResponse = this.mIJsonFactory.createObject(responseStream);
            if (null == jsonResponse) {
                jsonResponse = this.mIJsonFactory.createObject();
                RESTStateEnum.setState(RESTStateEnum.FAILED, jsonResponse);
            } else {
                RESTStateEnum.setState(RESTStateEnum.COMPLETED, jsonResponse);
            }
        }
        catch (IOException e) {
            jsonResponse = this.mIJsonFactory.createObject();
            RESTStateEnum.setState(RESTStateEnum.FAILED, jsonResponse);
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
                responseStream = null;
            }
        }
        RESTStateEnum.setStatusCode(this.getStatusCode(), jsonResponse);
        return jsonResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStringResponse() {
        if (this.responseAsString != null) {
            return this.responseAsString;
        }
        InputStream responseStream = null;
        InputStreamReader inReader = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            responseStream = this.getResponseStream();
            inReader = new InputStreamReader(responseStream);
            BufferedReader reader = new BufferedReader(inReader);
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (IOException e) {
            String string = "";
            return string;
        }
        finally {
            if (responseStream != null) {
                try {
                    responseStream.close();
                }
                catch (IOException iOException) {}
                responseStream = null;
            }
        }
        return sb.toString();
    }

    public String getResponseHeader(String name) {
        return this.responseHeaders.get(name);
    }

    public void setResponseHeader(String name, String value) {
        this.responseHeaders.put(name.toLowerCase(), value);
    }

    public Header[] getResponseHeaders(String name) {
        if (this.response != null) {
            return this.response.getHeaders(name);
        }
        return NO_HEADERS;
    }

    @Override
    public void close() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
            this.response = null;
        }
    }

    protected void setHeaders(Header[] headers) {
        this.responseHeaders.clear();
        for (Header header : headers) {
            this.responseHeaders.put(header.getName().toLowerCase(), header.getValue());
        }
    }

    public String getErrorMessage() {
        if (this.responseAsJsonObject != null) {
            IJsonObject errorObject = this.responseAsJsonObject.getJsonObject("error");
            if (errorObject != null) {
                return errorObject.toString();
            }
            return null;
        }
        if (this.responseAsString != null) {
            return this.responseAsString;
        }
        return null;
    }

    private HttpEntity getEntity() {
        Header[] encoding = this.response.getHeaders("Content-Encoding");
        Object respEntity = encoding != null && encoding.length > 0 && "gzip".equalsIgnoreCase(encoding[0].getValue()) ? new GzipDecompressingEntity(this.response.getEntity()) : this.response.getEntity();
        return respEntity;
    }

    public InputStream getResponseStream() throws IOException {
        if (this.getStatusCode() == 204L) {
            return new ByteArrayInputStream("{\"error\":{\"code\":\"204\",\"message\":\"No Content\"}}".getBytes());
        }
        HttpEntity httpEntity = this.getEntity();
        return httpEntity.getContent();
    }

    public List<HttpCookie> getSetCookies() {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        block2: for (Header header : this.response.getHeaders(SET_COOKIE)) {
            String[] cookieStrings;
            if (header == null || header.getValue() == null || header.getValue().isEmpty()) continue;
            for (String cookieString : cookieStrings = header.getValue().split(";")) {
                try {
                    List<HttpCookie> onecookie = HttpCookie.parse(cookieString);
                    HttpCookie cookie = onecookie.get(0);
                    cookies.add(cookie);
                    continue block2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
            }
        }
        return cookies;
    }

    public StatusLine getStatusLine() {
        return this.response.getStatusLine();
    }

    public static void validateAndThrow(IJsonObject jsonResponse, String errorMsg, IMessageKey.Param2 msgKey) {
        RESTStateEnum state = RESTStateEnum.getState(jsonResponse);
        Long statusCode = RESTStateEnum.getStatusCode(jsonResponse);
        Object errorObject = jsonResponse.get("error");
        if (RESTStateEnum.FAILED == state || errorObject != null) {
            if (null == errorObject) {
                errorObject = errorMsg;
            }
            throw new TM1RESTODPException(msgKey, statusCode.toString(), errorObject.toString());
        }
        if (RESTStateEnum.UNKNOWN == state) {
            throw new TM1RESTODPException(msgKey, statusCode.toString(), errorMsg);
        }
    }

    public static boolean validateAndLog(IJsonObject jsonResponse, String uri, String serverName) {
        RESTStateEnum state = RESTStateEnum.getState(jsonResponse);
        Long statusCode = RESTStateEnum.getStatusCode(jsonResponse);
        IJsonObject errorObject = jsonResponse.getJsonObject("error");
        if (RESTStateEnum.FAILED == state || errorObject != null) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_FROM_THE_SERVER, uri, serverName);
            if (null != errorObject) {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, STATUS_AND_SERVER_ERROR, statusCode.toString(), errorObject.toString());
            }
            return false;
        }
        if (RESTStateEnum.COMPLETED != state) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.META_LOADER, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_FROM_THE_SERVER, uri, serverName);
            return false;
        }
        return true;
    }

    public static boolean validateAndLog(IJsonObject jsonResponse, XQELogger logger, String messageFormat, Object ... params) {
        IJsonObject jsonError = jsonResponse;
        if (jsonResponse != null) {
            jsonError = jsonResponse.getJsonObject("error");
        }
        if (jsonError != null) {
            String errorMsg = String.format(messageFormat, params);
            TM1RESTLog.TM1RESTLogWrapper.log(logger, LogLevel.ERROR, HTTP_STATUS_AND_SERVER_ERROR, errorMsg, RESTStateEnum.getStatusCode(jsonResponse), jsonError.toString());
            return false;
        }
        if (RESTStateEnum.COMPLETED != RESTStateEnum.getState(jsonResponse)) {
            TM1RESTLog.TM1RESTLogWrapper.log(logger, LogLevel.ERROR, messageFormat, params);
            return false;
        }
        return true;
    }
}

