/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.security;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.data.providers.olap.tm1rest.security.OAuth2Token;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public abstract class OAuth2Utils {
    public static final String OAUTH2_ACCESS_TOKEN = "queryExecution.oauth2AccessToken[@value]";
    public static final String OAUTH2_USE_IUI = "queryExecution.oauth2UseIUI[@value]";
    public static final String OAUTH2_IUI = "queryExecution.oauth2IUI[@value]";
    static final String PA_OAUTH2_SECRET = "PAOAuth2Secret";
    private static final String ACCEPT = "Accept";
    private static final String USER_ID = "userId";
    private static final String LOGIN_ID = "loginId";
    private static final String GRANT_TYPE = "grant_type";
    private static final String CLIENT_CREDENTIALS = "client_credentials";
    private static final String SCOPE = "scope";
    private static final String SCOPE_VALUE = "tm1Context";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String EXPIRES_IN = "expires_in";

    public static OAuth2Token retrieveOAuth2Bearer(CloseableHttpClient client, String path, String userId, String iui) {
        OAuth2Token oauth2Token;
        block11: {
            XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
            boolean useIUI = configuration.getBooleanProperty(OAUTH2_USE_IUI, false);
            String uniqueSecurityName = configuration.getStringProperty(OAUTH2_IUI, iui);
            oauth2Token = null;
            ArrayList<BasicNameValuePair> form = new ArrayList<BasicNameValuePair>();
            form.add(new BasicNameValuePair(GRANT_TYPE, CLIENT_CREDENTIALS));
            form.add(new BasicNameValuePair(SCOPE, SCOPE_VALUE));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(form, Consts.UTF_8);
            HttpPost httpPost = new HttpPost(path);
            CloseableHttpResponse response = null;
            RESTClientResponse restClientResponse = null;
            try {
                httpPost.setEntity((HttpEntity)entity);
                httpPost.setHeader(ACCEPT, "application/json");
                if (useIUI) {
                    httpPost.setHeader(USER_ID, uniqueSecurityName);
                } else {
                    httpPost.setHeader(LOGIN_ID, userId);
                }
                byte[] encodedBytes = Base64.encodeBase64((byte[])System.getProperty(PA_OAUTH2_SECRET, System.getenv(PA_OAUTH2_SECRET)).getBytes());
                httpPost.setHeader("Authorization", "Basic " + new String(encodedBytes));
                long startTime = System.currentTimeMillis();
                response = client.execute((HttpUriRequest)httpPost);
                long elapsedTime = System.currentTimeMillis() - startTime;
                String infoMsg = String.format("Retrieve OAuth2Token - useIUI: %s, header 'userId': '%s', header 'loginId': '%s', path: '%s' in %d milliseconds.", useIUI, uniqueSecurityName, userId, path, elapsedTime);
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_CLIENT, LogLevel.INFO, infoMsg, new Object[0]);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 400) {
                    restClientResponse = new RESTClientResponse((HttpResponse)response);
                    IJsonObject jsonResponse = restClientResponse.getJSONResponse();
                    String bearerToken = jsonResponse.getStringValue(ACCESS_TOKEN);
                    String expiresIn = jsonResponse.getStringValue(EXPIRES_IN);
                    long expirationPeriodSeconds = Long.parseLong(expiresIn);
                    oauth2Token = new OAuth2Token(bearerToken, expirationPeriodSeconds);
                    break block11;
                }
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_BAD_REQUEST, String.format("[%d] %s", statusCode, response.getStatusLine().getReasonPhrase()));
            }
            catch (TM1RESTODPException tm1e) {
                throw tm1e;
            }
            catch (Exception e) {
                throw new TM1RESTODPException(e);
            }
            finally {
                if (null != response) {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                    response = null;
                }
                if (null != restClientResponse) {
                    restClientResponse.close();
                }
            }
        }
        return oauth2Token;
    }

    public static OAuth2Token retrieveOAuth2BearerTest(CloseableHttpClient client, String path, String userId, String iui) {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        String accessToken = configuration.getStringProperty(OAUTH2_ACCESS_TOKEN, "");
        return new OAuth2Token(accessToken, 3600L);
    }
}

