/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.utils;

import com.cognos.xqe.ast.maExp.MABlockConstraint;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.lang.StringUtils;

public class JsonAttributeFilter {
    private final boolean mMatches;
    private MASearchCriteria.SearchCondition mSearchCondition;
    private boolean mIsCaseSensitive;
    private List<String> mSearchValues;
    private MABlockConstraint.Operation mOperation;
    private List<Pattern> mPatterns;
    private static final String OPENING_BRACKET = "(";
    private static final String CLOSING_BRACKET = ")";
    private static final String QUESTION_MARK = "?";
    private static final String COLON_SIGN = ":";
    private static final String ANYTHING = ".*";
    private static final String LINE_BEGIN = "^";
    private static final String LINE_END = "$";
    private static final String CASE_INSENSITIVE = "i";

    public JsonAttributeFilter(MASearchCriteria searchCriteria) {
        boolean bl = this.mMatches = null == searchCriteria || MASearchCriteria.SearchCondition.NOT_DEFINED == searchCriteria.getSearchCondition();
        if (this.mMatches) {
            return;
        }
        this.mSearchCondition = searchCriteria.getSearchCondition();
        this.mIsCaseSensitive = searchCriteria.getCaseInsensitive();
        this.mSearchValues = searchCriteria.getSearchValues();
        this.mOperation = searchCriteria.getOperator();
        if (null == this.mOperation) {
            this.mOperation = MABlockConstraint.Operation.NOT_DEFINED;
        }
        if (MASearchCriteria.SearchCondition.EQUALS == this.mSearchCondition || MASearchCriteria.SearchCondition.NOTEQUAL == this.mSearchCondition) {
            return;
        }
        this.mPatterns = new ArrayList<Pattern>();
        block0 : switch (this.mSearchCondition) {
            case CONTAINS: {
                switch (this.mOperation) {
                    case AND: {
                        this.mPatterns = this.buildPatternAND(ANYTHING, ANYTHING);
                        break block0;
                    }
                    case OR: {
                        this.mPatterns = this.buildPatternOR(ANYTHING, ANYTHING);
                        break block0;
                    }
                    case NOT_DEFINED: {
                        this.mPatterns = this.buildPatternOR(ANYTHING, ANYTHING);
                        break block0;
                    }
                }
                throw new XQERuntimeException();
            }
            case STARTS_WITH: {
                switch (this.mOperation) {
                    case AND: {
                        this.mPatterns = this.buildPatternAND(LINE_BEGIN, ANYTHING);
                        break block0;
                    }
                    case OR: {
                        this.mPatterns = this.buildPatternOR(LINE_BEGIN, ANYTHING);
                        break block0;
                    }
                    case NOT_DEFINED: {
                        this.mPatterns = this.buildPatternOR(LINE_BEGIN, ANYTHING);
                        break block0;
                    }
                }
                throw new XQERuntimeException();
            }
            case ENDS_WITH: {
                switch (this.mOperation) {
                    case AND: {
                        this.mPatterns = this.buildPatternOR(ANYTHING, LINE_END);
                        break block0;
                    }
                    case OR: {
                        this.mPatterns = this.buildPatternOR(ANYTHING, LINE_END);
                        break block0;
                    }
                    case NOT_DEFINED: {
                        this.mPatterns = this.buildPatternOR(ANYTHING, LINE_END);
                        break block0;
                    }
                }
                throw new XQERuntimeException();
            }
            default: {
                throw new XQERuntimeException();
            }
        }
    }

    public boolean matches(IJsonObject jsonObj, String property) {
        if (this.mMatches) {
            return true;
        }
        IJsonObject jsonAttributes = jsonObj.getJsonObject("Attributes");
        if (null == jsonAttributes) {
            return true;
        }
        String value = jsonAttributes.getStringValue(property);
        if (MASearchCriteria.SearchCondition.EQUALS == this.mSearchCondition) {
            if (this.mOperation == MABlockConstraint.Operation.AND) {
                for (String searchValue : this.mSearchValues) {
                    if (this.compare(value, searchValue) == 0) continue;
                    return false;
                }
                return true;
            }
            if (this.mOperation == MABlockConstraint.Operation.OR) {
                for (String searchValue : this.mSearchValues) {
                    if (this.compare(value, searchValue) != 0) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        if (MASearchCriteria.SearchCondition.NOTEQUAL == this.mSearchCondition) {
            if (this.mOperation == MABlockConstraint.Operation.AND) {
                for (String searchValue : this.mSearchValues) {
                    if (this.compare(value, searchValue) != 0) continue;
                    return false;
                }
                return true;
            }
            if (this.mOperation == MABlockConstraint.Operation.OR) {
                for (String searchValue : this.mSearchValues) {
                    if (this.compare(value, searchValue) == 0) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        for (Pattern pattern : this.mPatterns) {
            if (pattern.matcher(value).matches()) continue;
            return false;
        }
        return true;
    }

    private ArrayList<Pattern> buildPatternOR(String prefix, String suffix) {
        Pattern pattern;
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        StringBuilder sb = new StringBuilder(prefix);
        sb.append(OPENING_BRACKET).append(QUESTION_MARK);
        if (this.mIsCaseSensitive) {
            sb.append(CASE_INSENSITIVE);
        }
        sb.append(COLON_SIGN);
        sb.append(StringUtils.join(this.mSearchValues, (char)'|'));
        sb.append(CLOSING_BRACKET);
        sb.append(suffix);
        try {
            pattern = Pattern.compile(sb.toString());
        }
        catch (PatternSyntaxException ex) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, ex.getLocalizedMessage());
        }
        if (null != pattern) {
            patterns.add(pattern);
        }
        return patterns;
    }

    private ArrayList<Pattern> buildPatternAND(String prefix, String suffix) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String value : this.mSearchValues) {
            Pattern pattern;
            StringBuilder sb = new StringBuilder(prefix);
            sb.append(OPENING_BRACKET).append(QUESTION_MARK);
            if (this.mIsCaseSensitive) {
                sb.append(CASE_INSENSITIVE);
            }
            sb.append(COLON_SIGN);
            sb.append(value);
            sb.append(CLOSING_BRACKET);
            sb.append(suffix);
            try {
                pattern = Pattern.compile(sb.toString());
            }
            catch (PatternSyntaxException ex) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, ex.getLocalizedMessage());
            }
            if (null == pattern) continue;
            patterns.add(pattern);
        }
        return patterns;
    }

    private int compare(String str1, String str2) {
        if (this.mIsCaseSensitive) {
            return str1.compareToIgnoreCase(str2);
        }
        return str1.compareTo(str2);
    }
}

