/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.utils;

import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;

public enum RESTStateEnum {
    UNKNOWN,
    RUNNING,
    COMPLETED,
    CANCELLED,
    FAILED;

    private static final String REQUEST_STATE = "request_status";
    private static final String REQUEST_STATUS_CODE = "request_status_code";

    public static RESTStateEnum getState(IJsonObject jsonObject) {
        if (null == jsonObject) {
            return UNKNOWN;
        }
        String stateValue = jsonObject.getStringValue(REQUEST_STATE);
        if (null == stateValue) {
            return UNKNOWN;
        }
        RESTStateEnum state = UNKNOWN;
        try {
            state = RESTStateEnum.valueOf(stateValue);
        }
        catch (IllegalArgumentException e) {
            state = UNKNOWN;
        }
        return state;
    }

    public static void setState(RESTStateEnum state, IJsonObject jsonObject) throws IllegalArgumentException {
        if (null == jsonObject) {
            throw new IllegalArgumentException();
        }
        jsonObject.put(REQUEST_STATE, state.name());
    }

    public static long getStatusCode(IJsonObject jsonObject) {
        if (null == jsonObject) {
            return -1L;
        }
        Long lcode = jsonObject.getLongValue(REQUEST_STATUS_CODE);
        if (null == lcode) {
            return -1L;
        }
        return lcode;
    }

    public static void setStatusCode(long statusCode, IJsonObject jsonObject) {
        jsonObject.put(REQUEST_STATUS_CODE, statusCode);
    }
}

