/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.utils;

import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;

public final class RESTUriBuilder {
    private RESTUriBuilder() {
    }

    public static String getCellSetsUri(String cellSetId, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entity("Cells").select("Ordinal", "Status", "Value").select("RuleDerived", "FormatString");
        return uriBuilder.toString();
    }

    public static String getCellSetChunkUri(String cellSetId, long skip, long top, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entity("Cells").select("Ordinal", "Status", "Value").select("RuleDerived", "FormatString").skip(skip).top(top).count();
        return uriBuilder.toString();
    }

    public static String getCellSetFilteredChunkUri(String cellSetId, long skip, long top, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entity("Cells").filterGt("Status", 0).select("Ordinal", "Status", "Value").select("RuleDerived", "FormatString").skip(skip).top(top).count();
        return uriBuilder.toString();
    }

    public static String getCellSetsUriWithFormattedValue(String cellSetId, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entity("Cells").select("Ordinal", "Status", "Value").select("RuleDerived", "FormatString").select("FormattedValue");
        return uriBuilder.toString();
    }

    public static String getAxesUri(String cellSetId, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entity("Axes").select("*");
        return uriBuilder.toString();
    }

    public static String getTuplesUri(String cellSetId, long ordinal, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", Long.toString(ordinal)).entity("Tuples").expand("Members").push().select("Name", "UniqueName", "Type", "Ordinal", "Attributes");
        RESTUriBuilder.addLevelParentInfo(uriBuilder).expand("Hierarchy").push().select("Name", "UniqueName").pop().pop();
        return uriBuilder.toString();
    }

    public static String getTuplesChunkUri(String cellSetId, long ordinal, long skip, long chunkSize, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", Long.toString(ordinal)).entity("Tuples").skip(skip).top(chunkSize).expand("Members").push().select("Name", "UniqueName", "Ordinal", "Attributes");
        RESTUriBuilder.addLevelParentInfo(uriBuilder).expand("Hierarchy").push().select("UniqueName").pop().pop();
        return uriBuilder.toString();
    }

    public static String getAxisTuplesCardinalityUri(String cellSetId, long ordinal, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", Long.toString(ordinal)).entity("Tuples").entity("$count");
        return uriBuilder.toString();
    }

    public static String getCellsetCardinalityUri(String cellSetId, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entity("Cells").entity("$count");
        return uriBuilder.toString();
    }

    public static String getTuplesMembersUri(String cellSetId, long ordinal, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", Long.toString(ordinal)).entity("Tuples").expand("Members").push().select("Name", "UniqueName", "Type", "Ordinal", "Attributes");
        RESTUriBuilder.addLevelParentInfo(uriBuilder).expand("Hierarchy").push().select("Name", "UniqueName").pop().expand("LocalizedAttributes").expand("Children/$count").pop();
        return uriBuilder.toString();
    }

    public static String getTuplesVerboseUri(String cellSetId, long ordinal, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", ordinal).entity("Tuples").expand("Members").push().select("Name", "UniqueName", "Type", "Ordinal", "Attributes").expand("Level", "Hierarchy", "Parent", "Children", "LocalizedAttributes").pop();
        return uriBuilder.toString();
    }

    public static String getHierarchyUri(String cellSetId, long ordinal, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cellsets", cellSetId).entityId("Axes", Long.toString(ordinal)).entity("Hierarchies").select("UniqueName").expand("Dimension").push().select("UniqueName").pop();
        return uriBuilder.toString();
    }

    public static ODataUriBuilder addLevelParentInfo(ODataUriBuilder uriBuilder) {
        uriBuilder.expand("Level").push().select("Number").pop().expand("Parent").push().select("UniqueName").pop();
        return uriBuilder;
    }

    public static ODataUriBuilder addLevelChildrenInfo(ODataUriBuilder uriBuilder) {
        uriBuilder.expand("Level").push().select("Number").pop().expand("Children/$count");
        return uriBuilder;
    }

    public static ODataUriBuilder addChildrenInfo(ODataUriBuilder uriBuilder) {
        uriBuilder.expand("Children/$count");
        return uriBuilder;
    }

    public static ODataUriBuilder addLevelParentChildrenCardinalityInfo(ODataUriBuilder uriBuilder) {
        RESTUriBuilder.addLevelParentInfo(uriBuilder);
        RESTUriBuilder.addChildrenInfo(uriBuilder);
        return uriBuilder;
    }

    public static ODataUriBuilder getExecuteMDXForSubsetLevelsUri(ODataUriBuilder uriBuilder) {
        uriBuilder.entity("ExecuteMDXSetExpression").expand("Tuples").push().expand("Members").push().select("Name").expand("Level").pop().pop();
        return uriBuilder;
    }

    public static ODataUriBuilder getExecuteMDXSetExpressionMembers(ODataUriBuilder uriBuilder, boolean dataQuery) {
        uriBuilder.entity("ExecuteMDXSetExpression").expand("Tuples").push().expand("Members").push().select("Name", "UniqueName", "Type", "Ordinal", "Attributes");
        RESTUriBuilder.addLevelParentInfo(uriBuilder);
        if (!dataQuery) {
            uriBuilder.expand("LocalizedAttributes");
        }
        uriBuilder.expand("Hierarchy").push().select("Name", "UniqueName").pop().expand("Children/$count").pop().pop();
        return uriBuilder;
    }

    public static ODataUriBuilder getSubsetsETagsUri(String cubeName, ODataUriBuilder uriBuilder) {
        uriBuilder.entityId("Cubes", cubeName).entity("Dimensions").select("UniqueName").expand("Hierarchies").push().select("UniqueName").expand("Subsets").push().select("Name").pop().expand("PrivateSubsets").push().select("Name").pop().pop();
        return uriBuilder;
    }
}

