/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.olap.common.MSASCommonMemberTypes;
import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.xmla.XMLACapabilities;
import com.cognos.xqe.data.providers.olap.xmla.XMLACubeResultSet;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.XMLAValueConverter;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAMember;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLATuple;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class XMLAAxisIterator
extends ProviderIteratorBase {
    private final XMLADataset.Axis axis;
    private final XMLACubeResultSet xmlaResultSet;
    private final XMLACapabilities capabilities;
    private final HierarchyPropertyCache[] propertyCaches;
    private final AtomicBoolean released = new AtomicBoolean(false);
    private boolean forceRollupToComputed = false;

    XMLAAxisIterator(XMLACubeResultSet theResultSet, XDataContext theDataContext, Integer theNodeId, XMLADataset.Axis theAxis) {
        super((ProviderResultSetBase)theResultSet, theDataContext, theNodeId);
        this.xmlaResultSet = theResultSet;
        this.capabilities = theResultSet.getConnection().getCapabilities();
        this.axis = theAxis;
        this.propertyCaches = new HierarchyPropertyCache[theAxis.getAxisInfo().numHierarchies()];
        this.cacheHierarchyProperties();
    }

    public Object nextImpl() {
        ITupleSet tupleSet = this.axis.getTupleSet();
        if (this.currentIndex + 1L >= (long)tupleSet.size()) {
            return null;
        }
        XMLATuple xmlaTuple = tupleSet.get((int)(++this.currentIndex));
        IMember[] members = new IMember[xmlaTuple.size()];
        for (int i = 0; i < members.length; ++i) {
            members[i] = this.convertXMLAMember(xmlaTuple.getMember(i));
        }
        return new Tuple(members);
    }

    public void releaseImpl() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        if (XMLALog.isOn("DataQuery", LogLevel.INFO)) {
            XMLALog.getLogger("DataQuery").log(LogLevel.INFO, "Releasing XMLAAxisIterator.");
        }
        for (int i = 0; i < this.propertyCaches.length; ++i) {
            this.propertyCaches[i] = null;
        }
    }

    private IMember convertXMLAMember(XMLAMember xmlaMember) {
        XMLAValue value;
        XMLAPropertyInfo propInfo2;
        Object memberKeyPropXMLAValue;
        XMLAValue memberTypeValue;
        XMLAValue parentCountValue;
        XMLAValue parentLevelValue;
        XMLAValue parentUniqueNameValue;
        XMLAValue childrenCardinalityValue;
        XMLAValue descriptionValue;
        XMLAValue memberCaptionValue;
        XMLAValue memberNameValue;
        Member member;
        XMLAValue munValue;
        XMLADataset.HierarchyInfo hierInfo = xmlaMember.getHierarchyInfo();
        HierarchyPropertyCache propCache = this.propertyCaches[hierInfo.getOrdinal()];
        ICube cube = this.xmlaResultSet.getCube();
        if (null == propCache.getMemberUniqueNameProp()) {
            XMLAAxisIterator.throwMissingHierarchyProperty(hierInfo.getName(), "MEMBER_UNIQUE_NAME");
        }
        if ((munValue = xmlaMember.getProperty(propCache.getMemberUniqueNameProp())).isNull()) {
            XMLAAxisIterator.throwMissingHierarchyProperty(hierInfo.getName(), "MEMBER_UNIQUE_NAME");
        }
        if (null != (member = (Member)this.xmlaResultSet.getCachedMember(munValue.getString()))) {
            return member;
        }
        member = new Member();
        member.setUniqueName(munValue.getString());
        member.setConnection(this.xmlaResultSet.getCube().getConnection());
        if (null != propCache.getMemberNameProp() && !(memberNameValue = xmlaMember.getProperty(propCache.getMemberNameProp())).isNull()) {
            member.setName(memberNameValue.getString());
        }
        if (null != propCache.getMemberCaptionProp() && !(memberCaptionValue = xmlaMember.getProperty(propCache.getMemberCaptionProp())).isNull()) {
            member.setCaption(memberCaptionValue.getString());
        }
        if (null == member.getName()) {
            member.setName(member.getCaption());
        }
        if (null == member.getCaption()) {
            member.setCaption(member.getName());
        }
        if (null != propCache.getDescriptionProp() && !(descriptionValue = xmlaMember.getProperty(propCache.getDescriptionProp())).isNull()) {
            member.setDescription(descriptionValue.getString());
        }
        if (null != propCache.getChildrenCardinalityProp() && !(childrenCardinalityValue = xmlaMember.getProperty(propCache.getChildrenCardinalityProp())).isNull()) {
            member.setChildrenCardinality(childrenCardinalityValue.getInteger().intValue());
        }
        if (null == propCache.getLevelNumberProp()) {
            XMLAAxisIterator.throwMissingHierarchyProperty(hierInfo.getName(), "LEVEL_NUMBER");
        } else {
            ILevel level;
            XMLAValue levelNumberValue = xmlaMember.getProperty(propCache.getLevelNumberProp());
            if (levelNumberValue.isNull()) {
                XMLAAxisIterator.throwMissingHierarchyProperty(hierInfo.getName(), "LEVEL_NUMBER");
            }
            if (null == (level = this.determineLevel(hierInfo.getName(), levelNumberValue.getInteger()))) {
                throw new XMLAException(XMLAMessageKeys.MET_CANNOT_RESOLVE_LEVEL_NUMBER, levelNumberValue.getInteger().toString(), hierInfo.getName());
            }
            member.setLevel(level);
        }
        if (null != propCache.getParentUniqueNameProp() && !(parentUniqueNameValue = xmlaMember.getProperty(propCache.getParentUniqueNameProp())).isNull()) {
            member.setParentUniqueName(parentUniqueNameValue.getString());
        }
        if (null != propCache.getParentLevelProp() && !(parentLevelValue = xmlaMember.getProperty(propCache.getParentLevelProp())).isNull()) {
            member.setParentLevelNumber(parentLevelValue.getInteger().intValue());
        }
        if (null != propCache.getParentCountProp() && !(parentCountValue = xmlaMember.getProperty(propCache.getParentCountProp())).isNull()) {
            member.setNumberOfParents(parentCountValue.getInteger().intValue());
        }
        if (null != propCache.getMemberTypeProp() && !(memberTypeValue = xmlaMember.getProperty(propCache.getMemberTypeProp())).isNull()) {
            MemberTypeEnum memberType = MSASCommonMemberTypes.convertIntToMemberType((int)memberTypeValue.getInteger());
            member.setType(memberType);
        }
        if (null != propCache.getMemberKeyProp() && !((XMLAValue)(memberKeyPropXMLAValue = xmlaMember.getProperty(propCache.getMemberKeyProp()))).isNull()) {
            Value memberKeyPropValue = XMLAValueConverter.convert((XMLAValue)memberKeyPropXMLAValue);
            member.setProperty("MEMBER_KEY", (Object)memberKeyPropValue);
            member.setProperty(propCache.getMemberKeyProp().getFullName(), (Object)memberKeyPropValue);
        }
        for (XMLAPropertyInfo propInfo2 : propCache.getCustomProps()) {
            value = xmlaMember.getProperty(propInfo2);
            IProperty prop = member.getLevel().getMemberProperty(propInfo2.getFullName());
            if (value.isNull()) continue;
            if (null != prop) {
                member.setProperty(propInfo2.getFullName(), (Object)XMLAValueConverter.convert(value, prop.getDataType()));
                continue;
            }
            member.setProperty(propInfo2.getFullName(), (Object)XMLAValueConverter.convert(value));
        }
        IProperty businessKeyProp = MetadataUtil.getPropertyByRole((ILevel)member.getLevel(), (String)RoleTypeEnum.BUSINESS_KEY.toV5Keyword());
        if (null != businessKeyProp && null != (propInfo2 = hierInfo.propertyFromName(businessKeyProp.getUniqueName()))) {
            value = xmlaMember.getProperty(propInfo2);
            member.setBusinessKey(XMLAValueConverter.convert(value));
        }
        if (this.forceRollupToComputed) {
            member.setRollupType(RollupTypeEnum.COMPUTED);
        } else {
            IHierarchy hier = cube.getHierarchy(hierInfo.getName());
            IDimension dim = hier.getDimension();
            DimensionTypeEnum dimType = dim.getType();
            if (dimType == DimensionTypeEnum.ACCOUNT || dimType == DimensionTypeEnum.SCENARIO) {
                member.setRollupType(RollupTypeEnum.COMPUTED);
            } else {
                member.setRollupType(RollupTypeEnum.ROLLUP);
            }
        }
        this.xmlaResultSet.putCachedMember((IMember)member);
        return member;
    }

    private ILevel determineLevel(String hun, int levelNumber) {
        ICube cube = this.xmlaResultSet.getCube();
        IHierarchy aHierarchy = null;
        IDimension aDimension = this.getDimension(hun, cube);
        if (aDimension == null) {
            return null;
        }
        aHierarchy = aDimension.getHierarchy(hun);
        if (aHierarchy == null) {
            aHierarchy = aDimension.getDefaultHierarchy();
        }
        ILevel level = aHierarchy.getLevel(levelNumber);
        if (XMLALog.isOn("DataQuery", LogLevel.TRACE)) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append("Level ").append(level.getUniqueName()).append(" found in hierarchy ");
            logBuf.append(hun).append(" at level number ").append(levelNumber);
            XMLALog.getLogger("DataQuery").log(LogLevel.TRACE, logBuf.toString());
        }
        return level;
    }

    private IDimension getDimension(String hun, ICube cube) {
        IDimension aDimension = null;
        if (this.capabilities.canReturnHierarchiesAsDimensions()) {
            aDimension = cube.getDimension(hun);
        }
        if (aDimension == null) {
            block9: {
                try {
                    String[] parts = UniqueNameParser.parse((String)hun, (int)2);
                    if (parts.length > 1) {
                        String dunPart = parts[0];
                        aDimension = cube.getDimension(UniqueNameGenerator.createUniqueName((String)dunPart));
                        break block9;
                    }
                    if (parts.length != 1) break block9;
                    for (IDimension d : cube.getDimensions()) {
                        IHierarchy aHierarchy = d.getHierarchy(hun);
                        if (null == aHierarchy) continue;
                        aDimension = d;
                        break;
                    }
                }
                catch (UniqueNameParserException e) {
                    if (XMLALog.isOn("DataQuery", LogLevel.ERROR)) {
                        XMLALog.getLogger("DataQuery").log(LogLevel.ERROR, "Unable to resolve the dimension and hierarchy for HUN " + hun);
                    }
                    throw new XMLAException(XMLAMessageKeys.MET_CANNOT_RESOLVE_HUN, e, hun);
                }
            }
            if (aDimension == null) {
                if (XMLALog.isOn("DataQuery", LogLevel.ERROR)) {
                    XMLALog.getLogger("DataQuery").log(LogLevel.ERROR, "Unable to resolve the dimension for HUN " + hun);
                }
                throw new XMLAException(XMLAMessageKeys.MET_CANNOT_RESOLVE_HUN, hun);
            }
        }
        return aDimension;
    }

    private void cacheHierarchyProperties() {
        XMLADataset.AxisInfo axisInfo = this.axis.getAxisInfo();
        for (int i = 0; i < axisInfo.numHierarchies(); ++i) {
            XMLADataset.HierarchyInfo hierInfo = axisInfo.getHierarchy(i);
            XMLAPropertyInfo[] properties = hierInfo.getProperties();
            this.propertyCaches[i] = new HierarchyPropertyCache(hierInfo);
            for (XMLAPropertyInfo propInfo : properties) {
                String unqualifiedName = propInfo.getUnqualifiedName();
                if ("CHILDREN_CARDINALITY".equals(unqualifiedName)) {
                    this.propertyCaches[i].setChildrenCardinalityProp(propInfo);
                    continue;
                }
                if ("DESCRIPTION".equals(unqualifiedName)) {
                    this.propertyCaches[i].setDescriptionProp(propInfo);
                    continue;
                }
                if ("LEVEL_NUMBER".equals(unqualifiedName)) {
                    this.propertyCaches[i].setLevelNumberProp(propInfo);
                    continue;
                }
                if ("LEVEL_UNIQUE_NAME".equals(unqualifiedName)) {
                    this.propertyCaches[i].setLevelUniqueNameProp(propInfo);
                    continue;
                }
                if ("MEMBER_NAME".equals(unqualifiedName)) {
                    this.propertyCaches[i].setMemberNameProp(propInfo);
                    continue;
                }
                if ("MEMBER_CAPTION".equals(unqualifiedName)) {
                    this.propertyCaches[i].setMemberCaptionProp(propInfo);
                    continue;
                }
                if ("MEMBER_TYPE".equals(unqualifiedName)) {
                    this.propertyCaches[i].setMemberTypeProp(propInfo);
                    continue;
                }
                if ("MEMBER_UNIQUE_NAME".equals(unqualifiedName)) {
                    this.propertyCaches[i].setMemberUniqueNameProp(propInfo);
                    continue;
                }
                if ("PARENT_COUNT".equals(unqualifiedName)) {
                    this.propertyCaches[i].setParentCountProp(propInfo);
                    continue;
                }
                if ("PARENT_LEVEL".equals(unqualifiedName)) {
                    this.propertyCaches[i].setParentLevelProp(propInfo);
                    continue;
                }
                if ("PARENT_UNIQUE_NAME".equals(unqualifiedName)) {
                    this.propertyCaches[i].setParentUniqueNameProp(propInfo);
                    continue;
                }
                if ("MEMBER_KEY".equals(unqualifiedName)) {
                    this.propertyCaches[i].setMemberKeyProp(propInfo);
                    continue;
                }
                this.propertyCaches[i].getCustomProps().add(propInfo);
            }
        }
    }

    private static void throwMissingHierarchyProperty(String hierarchyName, String propertyName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.MET_MISSING_HIERARCHY_PROP, propertyName, hierarchyName);
    }

    private static final class HierarchyPropertyCache {
        private final XMLADataset.HierarchyInfo hierarchy;
        private final List<XMLAPropertyInfo> customProps = new ArrayList<XMLAPropertyInfo>();
        private XMLAPropertyInfo childrenCardinalityProp = null;
        private XMLAPropertyInfo descriptionProp = null;
        private XMLAPropertyInfo levelNumberProp = null;
        private XMLAPropertyInfo lunProp = null;
        private XMLAPropertyInfo memberNameProp = null;
        private XMLAPropertyInfo memberCaptionProp = null;
        private XMLAPropertyInfo memberTypeProp = null;
        private XMLAPropertyInfo memberUniqueNameProp = null;
        private XMLAPropertyInfo memberOrdinalProp = null;
        private XMLAPropertyInfo parentCountProp = null;
        private XMLAPropertyInfo parentLevelProp = null;
        private XMLAPropertyInfo parentUniqueNameProp = null;
        private XMLAPropertyInfo memberKeyProp = null;

        HierarchyPropertyCache(XMLADataset.HierarchyInfo theHierarchy) {
            this.hierarchy = theHierarchy;
        }

        public XMLADataset.HierarchyInfo getHierarchy() {
            return this.hierarchy;
        }

        public List<XMLAPropertyInfo> getCustomProps() {
            return this.customProps;
        }

        public XMLAPropertyInfo getChildrenCardinalityProp() {
            return this.childrenCardinalityProp;
        }

        public XMLAPropertyInfo getDescriptionProp() {
            return this.descriptionProp;
        }

        public XMLAPropertyInfo getLevelNumberProp() {
            return this.levelNumberProp;
        }

        public XMLAPropertyInfo getLevelUniqueNameProp() {
            return this.lunProp;
        }

        public XMLAPropertyInfo getMemberNameProp() {
            return this.memberNameProp;
        }

        public XMLAPropertyInfo getMemberCaptionProp() {
            return this.memberCaptionProp;
        }

        public XMLAPropertyInfo getMemberTypeProp() {
            return this.memberTypeProp;
        }

        public XMLAPropertyInfo getMemberUniqueNameProp() {
            return this.memberUniqueNameProp;
        }

        public XMLAPropertyInfo getMemberOrdinalProp() {
            return this.memberOrdinalProp;
        }

        public XMLAPropertyInfo getParentCountProp() {
            return this.parentCountProp;
        }

        public XMLAPropertyInfo getParentLevelProp() {
            return this.parentLevelProp;
        }

        public XMLAPropertyInfo getParentUniqueNameProp() {
            return this.parentUniqueNameProp;
        }

        public XMLAPropertyInfo getMemberKeyProp() {
            return this.memberKeyProp;
        }

        public void setChildrenCardinalityProp(XMLAPropertyInfo theChildrenCardinalityProp) {
            this.childrenCardinalityProp = theChildrenCardinalityProp;
        }

        public void setDescriptionProp(XMLAPropertyInfo theDescriptionProp) {
            this.descriptionProp = theDescriptionProp;
        }

        public void setLevelNumberProp(XMLAPropertyInfo theLevelNumberProp) {
            this.levelNumberProp = theLevelNumberProp;
        }

        public void setLevelUniqueNameProp(XMLAPropertyInfo theLUNProp) {
            this.lunProp = theLUNProp;
        }

        public void setMemberNameProp(XMLAPropertyInfo theMemberNameProp) {
            this.memberNameProp = theMemberNameProp;
        }

        public void setMemberCaptionProp(XMLAPropertyInfo theMemberCaptionProp) {
            this.memberCaptionProp = theMemberCaptionProp;
        }

        public void setMemberTypeProp(XMLAPropertyInfo theMemberTypeProp) {
            this.memberTypeProp = theMemberTypeProp;
        }

        public void setMemberUniqueNameProp(XMLAPropertyInfo theMemberUniqueNameProp) {
            this.memberUniqueNameProp = theMemberUniqueNameProp;
        }

        public void setMemberOrdinalProp(XMLAPropertyInfo theMemberOrdinalProp) {
            this.memberOrdinalProp = theMemberOrdinalProp;
        }

        public void setParentCountProp(XMLAPropertyInfo theParentCountProp) {
            this.parentCountProp = theParentCountProp;
        }

        public void setParentLevelProp(XMLAPropertyInfo theParentLevelProp) {
            this.parentLevelProp = theParentLevelProp;
        }

        public void setParentUniqueNameProp(XMLAPropertyInfo theParentUniqueNameProp) {
            this.parentUniqueNameProp = theParentUniqueNameProp;
        }

        public void setMemberKeyProp(XMLAPropertyInfo theMemberKeyProp) {
            this.memberKeyProp = theMemberKeyProp;
        }
    }
}

