/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.xmla.CancelHintParameter;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConnection;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;

public class XMLACancelListener
implements ICancelable {
    private final XMLAConnection connectionToCancel;
    private final ExecutionEnvironment execEnv;

    public XMLACancelListener(XMLAConnection theConnectionToCancel, ExecutionEnvironment theExecEnv) {
        this.connectionToCancel = theConnectionToCancel;
        this.execEnv = theExecEnv;
    }

    public void cancel() {
        ConnectionParameters connParams = this.connectionToCancel.getConnectionParameters();
        String providerType = (String)connParams.valueOf(ProviderTypeParameter.class, String.class);
        if (DataSourceTypeEnum.isCubingServices((String)providerType) || DataSourceTypeEnum.isROLAP((String)providerType)) {
            this.cancelCubingServices();
        } else if (DataSourceTypeEnum.isMicrosoft((String)providerType) || "XO".equals(providerType)) {
            this.cancelMicrosoft();
        }
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) {
        throw new CancelUnsuccessfulException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelCubingServices() {
        IOLAPDataProvider dataProvider = this.connectionToCancel.getDataProvider();
        ConnectionParameters params = this.connectionToCancel.getConnectionParameters().duplicate();
        params.put((IConnectionParameter)new CancelHintParameter());
        IPooledConnection pooledConnection = dataProvider.borrowConnection(params, (IExecutionEnvironment)this.execEnv);
        XMLAConnection xmlaConnection = (XMLAConnection)((Object)pooledConnection.getConnection());
        try {
            XMLALogContext logCtx = XMLALogContext.enter();
            logCtx.setEnvironment((IExecutionEnvironment)this.execEnv);
            try {
                xmlaConnection.performCancelRequest(this.execEnv);
            }
            finally {
                logCtx.exit();
            }
        }
        finally {
            xmlaConnection.getConnectionParameters().remove(CancelHintParameter.class);
            xmlaConnection.returnToPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelMicrosoft() {
        IOLAPDataProvider dataProvider = this.connectionToCancel.getDataProvider();
        ConnectionParameters params = this.connectionToCancel.getConnectionParameters().duplicate();
        params.put((IConnectionParameter)new CancelHintParameter());
        IPooledConnection pooledConnection = dataProvider.borrowConnection(params, (IExecutionEnvironment)this.execEnv);
        XMLAConnection xmlaConnection = (XMLAConnection)((Object)pooledConnection.getConnection());
        xmlaConnection.setSession(this.connectionToCancel.getSession());
        try {
            XMLALogContext logCtx = XMLALogContext.enter();
            logCtx.setEnvironment((IExecutionEnvironment)this.execEnv);
            try {
                xmlaConnection.performExecuteCancelRequest(this.execEnv);
            }
            finally {
                logCtx.exit();
            }
        }
        finally {
            xmlaConnection.getConnectionParameters().remove(CancelHintParameter.class);
            xmlaConnection.setSession(null);
            xmlaConnection.returnToPool();
        }
    }
}

