/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.DataSubType;
import com.cognos.xqe.data.olap.common.MSASCommonFormatInfo;
import com.cognos.xqe.data.olap.common.MSASTypeGroupEnum;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.ProviderScrollableCellIteratorBase;
import com.cognos.xqe.data.providers.olap.xmla.XMLACapabilities;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfig;
import com.cognos.xqe.data.providers.olap.xmla.XMLACubeResultSet;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.XMLAResultCell;
import com.cognos.xqe.data.providers.olap.xmla.XMLAValueConverter;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLACell;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.format.string.IFormatInfo;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

final class XMLACellIterator
extends ProviderScrollableCellIteratorBase {
    private final XMLADataset dataSet;
    private final BitSet nullStatemap;
    private ICell currentCell = null;
    private final CellPropertyCache propertyCache = new CellPropertyCache();
    private final AtomicBoolean released = new AtomicBoolean(false);
    boolean includeCurrencyUnit = true;
    private String unknownCurr = "*";
    private int unknownLanguage = -1;

    XMLACellIterator(XMLACubeResultSet theResultSet, XDataContext theDataContext, Integer theNodeId, XMLADataset theDataSet, XMLAConfig currConfig) {
        super((ProviderResultSetBase)theResultSet, theDataContext, theNodeId);
        this.dataSet = theDataSet;
        this.nullStatemap = theDataSet.getNullStateMap();
        XMLACapabilities capabilities = theResultSet.getConnection().getCapabilities();
        this.unknownCurr = currConfig.getUnknownCurrencySymbol();
        this.includeCurrencyUnit = capabilities.canSupportCurrencyUnits();
        this.cacheCellProperties();
    }

    public boolean hasNext() {
        if (this.currentOrdinal == (long)(this.dataSet.numCoordinates() - 1)) {
            return false;
        }
        return this.nullStatemap.nextSetBit((int)this.currentOrdinal + 1) != -1;
    }

    public ICell nextImpl() {
        int nextOrdinal = this.nullStatemap.nextSetBit((int)this.currentOrdinal + 1);
        if (nextOrdinal == -1) {
            return null;
        }
        this.currentOrdinal = nextOrdinal;
        this.currentCell = this.convertCell(this.dataSet.getCell(nextOrdinal));
        return this.currentCell;
    }

    public boolean absolute(long index) {
        if (index < 0L || index >= (long)this.dataSet.numCoordinates()) {
            return false;
        }
        this.currentOrdinal = index;
        this.currentCell = this.convertCell(this.dataSet.getCell((int)this.currentOrdinal));
        return true;
    }

    public ICell current() {
        return this.currentCell;
    }

    public boolean hasPrevious() {
        if (this.currentOrdinal <= 0L) {
            return false;
        }
        for (int i = (int)this.currentOrdinal - 1; i > -1; --i) {
            if (!this.nullStatemap.get(i)) continue;
            return true;
        }
        return false;
    }

    public ICell previous() {
        for (int i = (int)this.currentOrdinal - 1; i >= 0; --i) {
            if (!this.nullStatemap.get(i)) continue;
            this.currentOrdinal = i;
            this.currentCell = this.convertCell(this.dataSet.getCell(i));
            return this.currentCell;
        }
        return null;
    }

    public boolean reset() {
        return this.absolute(0L);
    }

    public void releaseImpl() {
        if (!this.released.compareAndSet(false, true)) {
            return;
        }
        this.currentCell = null;
        if (XMLALog.isOn("DataQuery", LogLevel.INFO)) {
            XMLALog.getLogger("DataQuery").log(LogLevel.INFO, "Releasing XMLACellIterator.");
        }
    }

    private void cacheCellProperties() {
        XMLAPropertyInfo[] properties;
        XMLADataset.CellInfo cellInfo = this.dataSet.getCellInfo();
        for (XMLAPropertyInfo propInfo : properties = cellInfo.getProperties()) {
            String propName = propInfo.getFullName();
            if ("VALUE".equals(propName)) {
                this.propertyCache.setValueProp(propInfo);
                continue;
            }
            if ("FORMAT_STRING".equals(propName)) {
                this.propertyCache.setFormatStringProp(propInfo);
                continue;
            }
            if ("LANGUAGE".equals(propName)) {
                this.propertyCache.setLanguageStringProp(propInfo);
                continue;
            }
            this.propertyCache.getCustomProps().add(propInfo);
        }
        if (null == this.propertyCache.getValueProp()) {
            throw new XMLAException(XMLAMessageKeys.MET_MISSING_CELL_PROP, "VALUE");
        }
    }

    private ICell convertCell(XMLACell xmlCell) {
        if (null == xmlCell) {
            return null;
        }
        Value cellValue = null;
        if (null != this.propertyCache.getValueProp()) {
            XMLAValue formatValue;
            XMLAValue value = xmlCell.getProperty(this.propertyCache.getValueProp());
            cellValue = XMLAValueConverter.convert(value);
            if (this.propertyCache.getFormatStringProp() != null && null != (formatValue = xmlCell.getProperty(this.propertyCache.getFormatStringProp()))) {
                XMLAValue language = null;
                if (this.propertyCache.getLanguageStringProp() != null) {
                    language = xmlCell.getProperty(this.propertyCache.getLanguageStringProp());
                }
                this.convertFormat(cellValue, formatValue, language);
            }
        }
        XMLAResultCell resultCell = new XMLAResultCell(xmlCell.getOrdinal(), (IValue)cellValue);
        for (XMLAPropertyInfo propInfo : this.propertyCache.getCustomProps()) {
            XMLAValue value = xmlCell.getProperty(propInfo);
            if (value.isNull() || propInfo.getFullName().equals("FORMATTED_VALUE")) continue;
            resultCell.setCellProperty(propInfo.getFullName(), XMLAValueConverter.convert(value));
        }
        return resultCell;
    }

    private void convertFormat(Value cellValue, XMLAValue formatValue, XMLAValue language) {
        int lang = this.unknownLanguage;
        String value = formatValue.isNull() ? null : formatValue.toString();
        if (language != null && !language.isNull()) {
            lang = language.getInteger();
        }
        this.convertMSASFormat(cellValue, value, lang);
    }

    private void convertMSASFormat(Value cellValue, String formatString, int language) {
        if (XMLALog.isOn("DataQuery", LogLevel.TRACE)) {
            XMLALog.getLogger("DataQuery").log(LogLevel.TRACE, "Converting XMLA format " + formatString + " to IBM format.");
        }
        MSASTypeGroupEnum groupType = MSASTypeGroupEnum.TYPE_GROUP_UNKNOWN;
        if (cellValue.getDataType().getSubType() == DataSubType.NUMERICTYPE) {
            groupType = MSASTypeGroupEnum.TYPE_GROUP_NUMERIC;
        } else if (cellValue.getDataType().getSubType() == DataSubType.STRINGTYPE) {
            groupType = MSASTypeGroupEnum.TYPE_GROUP_STRING;
        } else if (cellValue.getDataType().getSubType() == DataSubType.DATETIMETYPE) {
            groupType = MSASTypeGroupEnum.TYPE_GROUP_DATE;
        }
        MSASCommonFormatInfo info = new MSASCommonFormatInfo(groupType, this.includeCurrencyUnit, this.unknownCurr, formatString, language);
        FormatId id = FormatService.getInstance().registerMSASFormat((IFormatInfo)info, this.getFormatLocale());
        cellValue.setFormatId(id);
    }

    private static final class CellPropertyCache {
        private XMLAPropertyInfo valueProp = null;
        private XMLAPropertyInfo formatStringProp = null;
        private XMLAPropertyInfo languageProp = null;
        private List<XMLAPropertyInfo> customProps = new ArrayList<XMLAPropertyInfo>();

        CellPropertyCache() {
        }

        public void setLanguageStringProp(XMLAPropertyInfo propInfo) {
            this.languageProp = propInfo;
        }

        public XMLAPropertyInfo getLanguageStringProp() {
            return this.languageProp;
        }

        public XMLAPropertyInfo getValueProp() {
            return this.valueProp;
        }

        public void setValueProp(XMLAPropertyInfo theValueProp) {
            this.valueProp = theValueProp;
        }

        public XMLAPropertyInfo getFormatStringProp() {
            return this.formatStringProp;
        }

        public void setFormatStringProp(XMLAPropertyInfo theFormatStringProp) {
            this.formatStringProp = theFormatStringProp;
        }

        public List<XMLAPropertyInfo> getCustomProps() {
            return this.customProps;
        }
    }
}

