/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.olap.common.BiBusHeaderElementParameter;
import com.cognos.xqe.data.olap.common.CAMPassportElementParameter;
import com.cognos.xqe.data.providers.DataSourceTypeEnum;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.connection.parameters.ServerParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.xmla.CancelHintParameter;
import com.cognos.xqe.data.providers.olap.xmla.KeyValueList;
import com.cognos.xqe.data.providers.olap.xmla.UseSSLParameter;
import com.cognos.xqe.data.providers.olap.xmla.XMLACancelListener;
import com.cognos.xqe.data.providers.olap.xmla.XMLACapabilities;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfig;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfigManager;
import com.cognos.xqe.data.providers.olap.xmla.XMLACredentials;
import com.cognos.xqe.data.providers.olap.xmla.XMLADataProvider;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLAFaultCodes;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.XMLASession;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.IPropertyFilter;
import com.cognos.xqe.data.providers.olap.xmla.query.IQueryListener;
import com.cognos.xqe.data.providers.olap.xmla.query.QueryBase;
import com.cognos.xqe.data.providers.olap.xmla.query.XMLACancelQueryCS;
import com.cognos.xqe.data.providers.olap.xmla.query.XMLADiscoverQuery;
import com.cognos.xqe.data.providers.olap.xmla.query.XMLAExecuteCancelQueryX8;
import com.cognos.xqe.data.providers.olap.xmla.query.XMLAExecuteStatementQuery;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARow;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARowset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.LocaleConverter;
import com.ibm.bi.org.apache.hadoop.io.CryptoProvider;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.httpclient.ConnectionPoolTimeoutException;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.dom4j.Element;

public final class XMLAConnection
extends DefaultConnection {
    private static final String HTTP = "http";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final String HTTPS = "https";
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String SCHEME_SEP = "://";
    private static final String CREDENTIALS_SEP = "@";
    private static final String PORT_SEP = ":";
    private static final String CONTEXT_PATH_SEP = "/";
    private static final String EMPTY_STRING = "";
    private static final String CANCEL = "Cancel";
    private static final String ERRMSG_CONNECTION_ALREADY_OPEN = "The connection was already open.";
    private static final String LOGMSG_SESSION_EXPIRED = "Session has expired with SessionId=";
    private static final String LOGMSG_SESSION_REQUIRED = "A new Session is required.";
    private static final String LOGMSG_USING_PROPERTIES = "Using Properties: ";
    private static final char CHAR_10 = '\n';
    private static final char CHAR_13 = '\r';
    private final HostConfiguration hostConfig = new HostConfiguration();
    private String contextPath = "";
    private boolean secureConnection = false;
    private String dataSourceName = null;
    private String dataSourceInfo = null;
    private boolean dataSourceInfoResolved = false;
    private String catalog = "";
    private Locale locale = null;
    private String cachedC8Locale = null;
    private String cachedLCID = null;
    private XMLACredentials credentials = null;
    private String passport = null;
    private Element passportElement = null;
    private Element biBusHeaderElement = null;
    private HttpConnection httpConnection = null;
    private HttpClient httpClient = null;
    private final HttpClientParams httpClientParams = new HttpClientParams();
    private final HttpState httpState = new HttpState();
    private final AtomicBoolean recycleConnection = new AtomicBoolean(true);
    private final XMLAQueryListener queryListener = new XMLAQueryListener();
    private XMLASession session = null;
    private KeyValueList dataSourceProperties = null;
    private XMLACapabilities capabilities = null;
    private final StringBuilder mdxNormalizeBuffer = new StringBuilder();

    XMLAConnection(XMLADataProvider theDataProvider) {
        super((IOLAPDataProvider)theDataProvider);
    }

    public XMLADataProvider getXMLADataProvider() {
        return (XMLADataProvider)this.getDataProvider();
    }

    public String getHostName() {
        return this.hostConfig.getHost();
    }

    public int getHostPort() {
        return this.hostConfig.getPort();
    }

    public void setHost(String theHostName, int theHostPort) {
        this.hostConfig.setHost(theHostName, theHostPort);
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String theContextPath) {
        this.contextPath = theContextPath;
        if (null != this.contextPath && !this.contextPath.startsWith(CONTEXT_PATH_SEP)) {
            this.contextPath = CONTEXT_PATH_SEP + this.contextPath;
        }
    }

    public boolean isSecureConnection() {
        return this.secureConnection;
    }

    public void setSecureConnection(boolean isSecureConnection) {
        this.secureConnection = isSecureConnection;
    }

    public void setURI(String uri) {
        String resolvedHostName;
        int resolvedPort = -1;
        int pos = uri.indexOf(SCHEME_SEP);
        if (pos >= 0) {
            String scheme = uri.substring(0, pos);
            uri = uri.substring(pos + SCHEME_SEP.length());
            if (HTTP.equals(scheme)) {
                resolvedPort = 80;
                this.secureConnection = false;
            } else if (HTTPS.equals(scheme)) {
                resolvedPort = 443;
                this.secureConnection = true;
            } else {
                throw new XMLAException(XMLAMessageKeys.CON_BAD_URI_SCHEME, scheme);
            }
        }
        if ((pos = uri.indexOf(CREDENTIALS_SEP)) >= 0) {
            throw new XMLAException(XMLAMessageKeys.CON_EMBEDDED_CREDENTIALS);
        }
        pos = uri.indexOf(CONTEXT_PATH_SEP);
        if (pos >= 0) {
            this.setContextPath(uri.substring(pos + CONTEXT_PATH_SEP.length()));
            uri = uri.substring(0, pos);
        } else {
            this.setContextPath(null);
        }
        pos = uri.indexOf(PORT_SEP);
        if (pos >= 0) {
            String strPort = uri.substring(pos + PORT_SEP.length());
            try {
                resolvedPort = Integer.parseInt(strPort);
            }
            catch (NumberFormatException ex) {
                throw new XMLAException(XMLAMessageKeys.CON_BAD_URI_PORT, ex, strPort);
            }
            resolvedHostName = uri.substring(0, pos);
        } else {
            resolvedHostName = uri;
        }
        if (resolvedHostName.length() == 0) {
            throw new XMLAException(XMLAMessageKeys.CON_EMPTY_URI_HOST, uri);
        }
        this.setHost(resolvedHostName, resolvedPort);
    }

    public String getDataSourceName() {
        return this.dataSourceInfo;
    }

    public void setDataSourceName(String theDataSourceName) {
        this.dataSourceName = theDataSourceName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String theCatalog) {
        this.catalog = theCatalog;
    }

    public Locale getLocale() {
        if (null == this.locale) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setLocale(Locale theLocale) {
        this.locale = theLocale;
    }

    public String getLCID() {
        if (null == this.cachedLCID) {
            this.cachedLCID = LocaleConverter.toLCID((Locale)this.getLocale());
        }
        return this.cachedLCID;
    }

    public String getC8Locale() {
        if (null == this.cachedC8Locale) {
            this.cachedC8Locale = LocaleConverter.localeToStr((Locale)this.getLocale());
        }
        return this.cachedC8Locale;
    }

    public KeyValueList getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public XMLACapabilities getCapabilities() {
        return this.capabilities;
    }

    public XMLACredentials getCredentials() {
        return this.credentials;
    }

    public String getPassport() {
        return this.passport;
    }

    public void setCredentials(XMLACredentials theCredentials) {
        this.credentials = theCredentials;
        if (null != this.credentials) {
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.credentials.getUsername(), this.credentials.getPassword());
            this.httpState.setCredentials(AuthScope.ANY, (Credentials)defaultcreds);
            this.httpClientParams.setAuthenticationPreemptive(true);
        } else {
            this.httpState.clearCredentials();
            this.httpClientParams.setAuthenticationPreemptive(false);
        }
    }

    public void setPassport(String thePassport) {
        this.passport = thePassport;
    }

    public void setPassportElement(Element thePassportElement) {
        this.passportElement = thePassportElement;
    }

    public void setBiBusHeaderElement(Element theBiBusHeaderElement) {
        this.biBusHeaderElement = theBiBusHeaderElement;
    }

    public XMLASession getSession() {
        return this.session;
    }

    void setSession(XMLASession theSession) {
        this.session = theSession;
    }

    public void open() {
        if (null != this.httpConnection) {
            throw new IllegalStateException(ERRMSG_CONNECTION_ALREADY_OPEN);
        }
        String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        XQELogger logger = XMLALog.getLogger("Connection");
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("XMLAConnection.open() with HostConfig=").append(this.hostConfig).append(", ContextPath=").append(this.contextPath).append(", SecureConnection=").append(this.secureConnection).append(", Catalog=").append(this.catalog).append(", Locale=").append(this.locale).append(", PassportElement=").append(this.passportElement).append(", BiBusHeaderElement=").append(this.biBusHeaderElement).append(", HTTPConnectionTimeout=").append(currConfig.getHTTPConnectionTimeout()).append(", HTTPSoTimeout=").append(currConfig.getHTTPSoTimeout());
            logger.log(LogLevel.INFO, buffer.toString());
        }
        try {
            this.httpConnection = CryptoProvider.createHttpConnection((String)this.hostConfig.getHost(), (int)this.hostConfig.getPort(), (boolean)this.secureConnection);
            this.httpConnection.getParams().setStaleCheckingEnabled(true);
            this.httpConnection.getParams().setConnectionTimeout(currConfig.getHTTPConnectionTimeout());
            this.httpConnection.getParams().setSoTimeout(currConfig.getHTTPSoTimeout());
            this.httpConnection.open();
            this.httpState.clearCookies();
            this.httpClient = new HttpClient(this.httpClientParams, (HttpConnectionManager)new XMLAHttpConnectionManager());
            this.httpClient.setState(this.httpState);
            this.httpClient.setHostConfiguration(this.hostConfig);
        }
        catch (Throwable ex) {
            logger.log(LogLevel.ERROR, ex);
            throw new XMLAException(XMLAMessageKeys.CON_CONNECTION_FAILED, ex, this.getURLString());
        }
    }

    private String getURLString() {
        StringBuilder httpInfo = new StringBuilder();
        if (this.secureConnection) {
            httpInfo.append("https://");
        } else {
            httpInfo.append("http://");
        }
        httpInfo.append(this.hostConfig.getHost());
        httpInfo.append(PORT_SEP);
        httpInfo.append(this.hostConfig.getPort());
        httpInfo.append(this.getContextPath());
        return httpInfo.toString();
    }

    public void open(ConnectionParameters connParams) {
        Element biBusHeaderElement1;
        Element camPassportElement;
        String catalogName;
        this.setConnectionParameters(connParams);
        this.setURI((String)connParams.valueOf(ServerParameter.class, String.class));
        if (connParams.contains(UseSSLParameter.class)) {
            this.setSecureConnection(true);
        }
        if ((catalogName = (String)connParams.valueOf(CatalogParameter.class, String.class)) != null && catalogName.length() > 0) {
            this.setCatalog(catalogName);
        }
        if ((catalogName = (String)connParams.valueOf(UpperCaseCatalogParameter.class, String.class)) != null && catalogName.length() > 0) {
            this.setCatalog(catalogName);
        }
        this.setLocale((Locale)connParams.valueOf(RunLocaleParameter.class, Locale.class));
        String userId = (String)connParams.valueOf(UserIDParameter.class, String.class);
        String password = (String)connParams.valueOf(PasswordParameter.class, String.class);
        if (null != userId && userId.length() > 0) {
            this.setCredentials(new XMLACredentials(userId, password));
        }
        if (null != (camPassportElement = (Element)connParams.valueOf(CAMPassportElementParameter.class, Element.class))) {
            this.setPassportElement(camPassportElement);
        }
        if (null != (biBusHeaderElement1 = (Element)connParams.valueOf(BiBusHeaderElementParameter.class, Element.class))) {
            this.setBiBusHeaderElement(biBusHeaderElement1);
        }
        this.open();
    }

    public void close() {
        if (null == this.httpConnection) {
            return;
        }
        XQELogger logger = XMLALog.getLogger("Connection");
        logger.log(LogLevel.INFO, "XMLAConnection.close()");
        if (this.httpConnection.isOpen()) {
            this.httpConnection.close();
        }
        this.httpConnection = null;
    }

    public XMLARowset performDiscoverRequest(IExecutionEnvironment execEnv, String rowset, KeyValueList restrictions, KeyValueList properties) throws XMLAException {
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("Metadata");
        logCtx.setRequestType(XMLALogContext.RequestType.METADATA);
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("XMLAConnection.performDiscoverRequest() for Rowset=").append(rowset).append(", Restrictions=").append(restrictions);
            logger.log(LogLevel.INFO, buffer.toString());
        }
        for (int i = 0; i < 2; ++i) {
            try {
                logCtx.setRetryCount(i);
                return this.performDiscoverRequestInternal(execEnv, rowset, (KeyValueList)restrictions.copy(), (KeyValueList)properties.copy());
            }
            catch (XMLAException ex) {
                if (null != this.session && XMLASession.SessionState.ESTABLISHED == this.session.getState() && ex.getMessageKey() == XMLAMessageKeys.XMA_SERVER_FAULT && XMLAFaultCodes.isInvalidSessionId((String)ex.getArguments()[0])) {
                    if (logger.isOn(LogLevel.WARN)) {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append(LOGMSG_SESSION_EXPIRED).append(this.session.getSessionId());
                        logger.log(LogLevel.WARN, buffer.toString());
                    }
                } else {
                    logger.log(LogLevel.ERROR, (Throwable)((Object)ex));
                    throw ex;
                }
                this.session.setSessionId(null);
                this.session.setState(XMLASession.SessionState.NONE);
                continue;
            }
        }
        return null;
    }

    private XMLARowset performDiscoverRequestInternal(IExecutionEnvironment execEnv, String rowset, KeyValueList restrictions, KeyValueList properties) throws XMLAException {
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("DataQuery");
        logCtx.setDiscoverRowset(rowset);
        properties.add("Format", "Tabular");
        properties.add("Content", "Data");
        if (this.dataSourceInfo != null) {
            properties.add("DataSourceInfo", this.dataSourceInfo);
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            properties.add("Catalog", this.catalog);
        }
        properties.add("LocaleIdentifier", this.getLCID());
        String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        if (this.capabilities != null && this.capabilities.canSupportTimeout() && currConfig != null && currConfig.getTimeoutMetadataQuery() >= 0) {
            properties.add("Timeout", Integer.toString(currConfig.getTimeoutMetadataQuery()));
        }
        if (this.capabilities != null && this.capabilities.canSupportApplicationName() && currConfig != null && currConfig.getApplicationName() != null) {
            properties.add("SspropInitAppName", currConfig.getApplicationName());
        }
        if (this.capabilities != null && this.capabilities.canSupportUniqueNameStyle()) {
            properties.add("DbpropMsmdMDXUniqueNameStyle", "0");
        }
        XMLADiscoverQuery query = new XMLADiscoverQuery();
        if (null != this.passportElement) {
            logCtx.setCAMPassportElement(this.passportElement);
            query.setCAMPassportElement(this.passportElement);
        }
        if (null != this.biBusHeaderElement) {
            logCtx.setBiBusHeaderElement(this.biBusHeaderElement);
            query.setBiBusHeaderElement(this.biBusHeaderElement);
        }
        if (null != this.credentials) {
            logCtx.setUserId(this.credentials.getUsername());
        }
        if (null != this.session) {
            if (XMLASession.SessionState.ESTABLISHED != this.session.getState()) {
                logger.log(LogLevel.INFO, LOGMSG_SESSION_REQUIRED);
                this.beginSession();
            }
            query.setSession(this.session);
        } else if (this.capabilities != null && this.capabilities.canSupportUniqueNameStyle()) {
            properties.add("DbpropMsmdMDXCompatibility", "2");
        }
        if (logger.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_USING_PROPERTIES).append(properties.toString());
            logger.log(LogLevel.TRACE, buffer.toString());
        }
        query.setHttpClient(this.httpClient);
        query.setContextPath(this.contextPath);
        query.setRequestType(rowset);
        query.setProperties(properties);
        query.setRestrictions(restrictions);
        query.setUseCompression(true);
        query.getHttpMethodParams().setCookiePolicy("compatibility");
        query.registerListener(this.queryListener);
        boolean isCancelQuery = this.getConnectionParameters().contains(CancelHintParameter.class);
        if (!isCancelQuery) {
            execEnv.getCancelManager().addCancelHandler((ICancelable)query);
        }
        XMLARowset result = null;
        try {
            query.execute();
            result = query.getRowset();
        }
        catch (XQERuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XMLAException(XMLAMessageKeys.GEN_UNEXPECTED_ERROR, ex);
        }
        finally {
            if (!isCancelQuery) {
                execEnv.getCancelManager().removeCancelHandler((ICancelable)query);
            }
            XMLALog.dumpDiscoverMetrics(result);
        }
        XMLALog.dumpDiscoverRowset(result);
        return result;
    }

    public XMLADataset performExecuteRequest(ExecutionEnvironment execEnv, String mdx, int nExpectedEdges, KeyValueList properties) {
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("DataQuery");
        logCtx.setRequestType(XMLALogContext.RequestType.DATA);
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("XMLAConnection.performExecuteRequest() for MDX=").append(mdx);
            logger.log(LogLevel.INFO, buffer.toString());
        }
        for (int i = 0; i < 2; ++i) {
            try {
                logCtx.setRetryCount(i);
                return this.performExecuteRequestInternal(execEnv, mdx, nExpectedEdges, (KeyValueList)properties.copy());
            }
            catch (XMLAException ex) {
                if (null != this.session && XMLASession.SessionState.ESTABLISHED == this.session.getState() && ex.getMessageKey() == XMLAMessageKeys.XMA_SERVER_FAULT && XMLAFaultCodes.isInvalidSessionId((String)ex.getArguments()[0])) {
                    if (logger.isOn(LogLevel.WARN)) {
                        StringBuilder buffer = new StringBuilder();
                        buffer.append(LOGMSG_SESSION_EXPIRED).append(this.session.getSessionId());
                        logger.log(LogLevel.WARN, buffer.toString());
                    }
                } else {
                    logger.log(LogLevel.ERROR, (Throwable)((Object)ex));
                    throw ex;
                }
                this.session.setSessionId(null);
                this.session.setState(XMLASession.SessionState.NONE);
                continue;
            }
        }
        return null;
    }

    private XMLADataset performExecuteRequestInternal(ExecutionEnvironment execEnv, String mdx, int nExpectedEdges, KeyValueList properties) {
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("DataQuery");
        properties.add("Format", "Multidimensional");
        properties.add("Content", "Data");
        String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        if (this.capabilities.canSupportClusterFormat() && currConfig.getUseClusterFormat()) {
            properties.add("AxisFormat", "ClusterFormat");
        } else {
            properties.add("AxisFormat", "TupleFormat");
        }
        if (this.capabilities.canSupportTimeout() && currConfig.getTimeoutDataQuery() >= 0) {
            properties.add("Timeout", Integer.toString(currConfig.getTimeoutDataQuery()));
        }
        if (this.capabilities.canSupportApplicationName() && currConfig.getApplicationName() != null) {
            properties.add("SspropInitAppName", currConfig.getApplicationName());
        }
        if (this.capabilities.canSupportDisablePrefetchFacts() && currConfig.getDisablePrefetchFacts() != null) {
            properties.add("false", currConfig.getDisablePrefetchFacts().toString());
        }
        if (this.capabilities.canSupportMDXMissingMemberMode() && currConfig.getMDXMissingMemberMode() != null) {
            properties.add("MDXMissingMemberMode", currConfig.getMDXMissingMemberMode());
        }
        if (this.capabilities.canSupportUniqueNameStyle()) {
            properties.add("DbpropMsmdMDXUniqueNameStyle", "0");
        }
        if (this.dataSourceInfo != null) {
            properties.add("DataSourceInfo", this.dataSourceInfo);
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            properties.add("Catalog", this.catalog);
        }
        properties.add("LocaleIdentifier", this.getLCID());
        XMLAExecuteStatementQuery query = new XMLAExecuteStatementQuery();
        if (null != this.passportElement) {
            logCtx.setCAMPassportElement(this.passportElement);
            query.setCAMPassportElement(this.passportElement);
        }
        if (null != this.biBusHeaderElement) {
            logCtx.setBiBusHeaderElement(this.biBusHeaderElement);
            query.setBiBusHeaderElement(this.biBusHeaderElement);
        }
        if (DataSourceTypeEnum.isMondrian((String)providerType)) {
            String requestID;
            String reportPath = ((RequestEnvironment)execEnv.getRequestEnvironment()).getReportPath();
            if (null != reportPath) {
                query.setReportPath(reportPath);
            }
            if ((requestID = execEnv.getRequestID()) != null) {
                query.setRequestId(requestID);
            }
        }
        if (null != this.credentials) {
            logCtx.setUserId(this.credentials.getUsername());
        }
        if (null != this.session) {
            if (XMLASession.SessionState.ESTABLISHED != this.session.getState()) {
                logger.log(LogLevel.INFO, LOGMSG_SESSION_REQUIRED);
                this.beginSession();
            }
            query.setSession(this.session);
        } else if (this.capabilities.canSupportUniqueNameStyle()) {
            properties.add("DbpropMsmdMDXCompatibility", "2");
        }
        if (logger.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_USING_PROPERTIES).append(properties.toString());
            logger.log(LogLevel.TRACE, buffer.toString());
        }
        query.setHttpClient(this.httpClient);
        query.setContextPath(this.contextPath);
        query.setMDXStatement(this.normalizeMDX(mdx));
        query.setExpectedEdgeCount(nExpectedEdges);
        if ("XI".equals(providerType)) {
            query.setRequestId(((RequestEnvironment)execEnv.getRequestEnvironment()).getRequestID());
        }
        query.setProviderType(providerType);
        query.setProperties(properties);
        query.setUseCompression(true);
        query.getHttpMethodParams().setCookiePolicy("compatibility");
        query.registerListener(this.queryListener);
        query.setHierarchyPropertyFilter(new IPropertyFilter(){

            @Override
            public boolean canRetain(String propertyName) {
                return !propertyName.endsWith("[DISPLAY_INFO]");
            }
        });
        query.setCellPropertyFilter(new IPropertyFilter(){

            @Override
            public boolean canRetain(String propertyName) {
                return !propertyName.endsWith("[FORMATTED_VALUE]");
            }
        });
        XMLADataset result = null;
        if (execEnv.getCancelManager().isRequestCancelled()) {
            logger.log(LogLevel.INFO, "Execute query was canceled before it ran");
            throw new OperationCanceledException();
        }
        execEnv.getCancelManager().addCancelHandler((ICancelable)query);
        XMLACancelListener cancelListener = new XMLACancelListener(this, execEnv);
        execEnv.getCancelManager().addCancelHandler((ICancelable)cancelListener);
        XMLALogContext.get().setNumExpectedEdges(nExpectedEdges);
        try {
            query.execute();
            result = query.getDataset();
        }
        catch (XQERuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new XMLAException(XMLAMessageKeys.GEN_UNEXPECTED_ERROR, ex);
        }
        finally {
            execEnv.getCancelManager().removeCancelHandler((ICancelable)query);
            execEnv.getCancelManager().removeCancelHandler((ICancelable)cancelListener);
            XMLALog.dumpExecuteMetrics(result);
        }
        XMLALog.dumpExecuteDataset(result);
        return result;
    }

    public void performExecuteCancelRequest(ExecutionEnvironment execEnv) {
        if (null == this.session || XMLASession.SessionState.ESTABLISHED != this.session.getState()) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("DataQuery.Cancel");
        logCtx.setRequestType(XMLALogContext.RequestType.CANCEL);
        logCtx.setExecuteHint(CANCEL);
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("XMLAConnection.performExecuteCancelRequest() for SessionId=");
            buffer.append(this.session.getSessionId());
        }
        KeyValueList properties = new KeyValueList();
        properties.add("Format", "Multidimensional");
        properties.add("Content", "Data");
        properties.add("AxisFormat", "TupleFormat");
        properties.add("LocaleIdentifier", this.getLCID());
        if (this.dataSourceInfo != null) {
            properties.add("DataSourceInfo", this.dataSourceInfo);
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            properties.add("Catalog", this.catalog);
        }
        XMLAExecuteCancelQueryX8 query = new XMLAExecuteCancelQueryX8();
        if (null != this.passportElement) {
            logCtx.setCAMPassportElement(this.passportElement);
            query.setCAMPassportElement(this.passportElement);
        }
        if (null != this.biBusHeaderElement) {
            logCtx.setBiBusHeaderElement(this.biBusHeaderElement);
            query.setBiBusHeaderElement(this.biBusHeaderElement);
        }
        if (null != this.credentials) {
            logCtx.setUserId(this.credentials.getUsername());
        }
        if (null != this.session) {
            query.setSession(this.session);
        }
        query.setProperties(properties);
        query.setHttpClient(this.httpClient);
        query.setContextPath(this.contextPath);
        query.setUseCompression(false);
        query.getHttpMethodParams().setCookiePolicy("compatibility");
        query.registerListener(this.queryListener);
        try {
            query.execute();
        }
        catch (XQERuntimeException ex) {
            logger.log(LogLevel.ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            logger.log(LogLevel.ERROR, ex);
            throw new XMLAException(XMLAMessageKeys.GEN_UNEXPECTED_ERROR, ex);
        }
    }

    public void performCancelRequest(ExecutionEnvironment execEnv) {
        XMLALogContext logCtx = XMLALogContext.get();
        logCtx.setRequestType(XMLALogContext.RequestType.CANCEL);
        logCtx.setExecuteHint(CANCEL);
        XQELogger logger = XMLALog.getLogger("DataQuery.Cancel");
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("XMLAConnection.performCancelRequest() for RequestId=");
            buffer.append(execEnv.getRequestID());
        }
        XMLACancelQueryCS query = new XMLACancelQueryCS(((RequestEnvironment)execEnv.getRequestEnvironment()).getRequestID());
        if (null != this.passportElement) {
            logCtx.setCAMPassportElement(this.passportElement);
            query.setCAMPassportElement(this.passportElement);
        }
        if (null != this.biBusHeaderElement) {
            logCtx.setBiBusHeaderElement(this.biBusHeaderElement);
            query.setBiBusHeaderElement(this.biBusHeaderElement);
        }
        if (null != this.credentials) {
            logCtx.setUserId(this.credentials.getUsername());
        }
        if (null != this.session) {
            query.setSession(this.session);
        }
        query.setHttpClient(this.httpClient);
        query.setContextPath(this.contextPath);
        query.setUseCompression(false);
        query.getHttpMethodParams().setCookiePolicy("compatibility");
        query.registerListener(this.queryListener);
        try {
            query.execute();
        }
        catch (XQERuntimeException ex) {
            logger.log(LogLevel.ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            logger.log(LogLevel.ERROR, ex);
            throw new XMLAException(XMLAMessageKeys.GEN_UNEXPECTED_ERROR, ex);
        }
    }

    public void beginSession() {
        if (null == this.session) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("Connection");
        logger.log(LogLevel.INFO, "XMLAConnection.beginSession()");
        this.session.setState(XMLASession.SessionState.BEGIN);
        KeyValueList properties = new KeyValueList();
        properties.add("Format", "Multidimensional");
        properties.add("Content", "Data");
        properties.add("AxisFormat", "TupleFormat");
        String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        if (this.capabilities.canSupportApplicationName() && currConfig.getApplicationName() != null) {
            properties.add("SspropInitAppName", currConfig.getApplicationName());
        }
        if (this.dataSourceInfo != null) {
            properties.add("DataSourceInfo", this.dataSourceInfo);
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            properties.add("Catalog", this.catalog);
        }
        properties.add("LocaleIdentifier", this.getLCID());
        if (this.capabilities.canSupportUniqueNameStyle()) {
            properties.add("DbpropMsmdMDXCompatibility", "2");
        }
        if (logger.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_USING_PROPERTIES).append(properties.toString());
            logger.log(LogLevel.TRACE, buffer.toString());
        }
        XMLAExecuteStatementQuery query = new XMLAExecuteStatementQuery();
        if (null != this.passportElement) {
            logCtx.setCAMPassportElement(this.passportElement);
            query.setCAMPassportElement(this.passportElement);
        }
        if (null != this.biBusHeaderElement) {
            logCtx.setBiBusHeaderElement(this.biBusHeaderElement);
            query.setBiBusHeaderElement(this.biBusHeaderElement);
        }
        if (null != this.credentials) {
            logCtx.setUserId(this.credentials.getUsername());
        }
        query.setProperties(properties);
        query.setSession(this.session);
        query.setMDXStatement(EMPTY_STRING);
        query.setHttpClient(this.httpClient);
        query.setContextPath(this.contextPath);
        query.setUseCompression(true);
        query.getHttpMethodParams().setCookiePolicy("compatibility");
        query.registerListener(this.queryListener);
        try {
            query.execute();
        }
        catch (XQERuntimeException ex) {
            logger.log(LogLevel.ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            logger.log(LogLevel.ERROR, ex);
            throw new XMLAException(XMLAMessageKeys.GEN_UNEXPECTED_ERROR, ex);
        }
        if (XMLASession.SessionState.ESTABLISHED != this.session.getState()) {
            throw new XMLAException(XMLAMessageKeys.CON_SESSION_BEGIN_FAILED);
        }
    }

    public void endSession() {
        if (null == this.session) {
            return;
        }
        if (this.session.getState() != XMLASession.SessionState.ESTABLISHED) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        XQELogger logger = XMLALog.getLogger("Connection");
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("XMLAConnection.endSession() for SessionId=").append(this.session.getSessionId());
            logger.log(LogLevel.INFO, buffer.toString());
        }
        this.session.setState(XMLASession.SessionState.END);
        KeyValueList properties = new KeyValueList();
        properties.add("Format", "Multidimensional");
        properties.add("Content", "Data");
        properties.add("AxisFormat", "TupleFormat");
        String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        if (this.capabilities.canSupportApplicationName() && currConfig.getApplicationName() != null) {
            properties.add("SspropInitAppName", currConfig.getApplicationName());
        }
        if (this.dataSourceInfo != null) {
            properties.add("DataSourceInfo", this.dataSourceInfo);
        }
        if (this.catalog != null && this.catalog.length() > 0) {
            properties.add("Catalog", this.catalog);
        }
        properties.add("LocaleIdentifier", this.getLCID());
        if (logger.isOn(LogLevel.TRACE)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_USING_PROPERTIES).append(properties.toString());
            logger.log(LogLevel.TRACE, buffer.toString());
        }
        XMLAExecuteStatementQuery query = new XMLAExecuteStatementQuery();
        if (null != this.passportElement) {
            logCtx.setCAMPassportElement(this.passportElement);
            query.setCAMPassportElement(this.passportElement);
        }
        if (null != this.biBusHeaderElement) {
            logCtx.setBiBusHeaderElement(this.biBusHeaderElement);
            query.setBiBusHeaderElement(this.biBusHeaderElement);
        }
        if (null != this.credentials) {
            logCtx.setUserId(this.credentials.getUsername());
        }
        query.setProperties(properties);
        query.setSession(this.session);
        query.setMDXStatement(EMPTY_STRING);
        query.setHttpClient(this.httpClient);
        query.setContextPath(this.contextPath);
        query.setUseCompression(true);
        query.getHttpMethodParams().setCookiePolicy("compatibility");
        query.registerListener(this.queryListener);
        try {
            query.execute();
        }
        catch (XQERuntimeException ex) {
            if (ex.getMessageKey() == XMLAMessageKeys.XMA_SERVER_FAULT && XMLAFaultCodes.isInvalidSessionId((String)ex.getArguments()[0])) {
                logger.log(LogLevel.WARN, "Failed to end Session: ", (Throwable)ex);
                return;
            }
            logger.log(LogLevel.ERROR, (Throwable)ex);
            throw ex;
        }
        catch (Throwable ex) {
            logger.log(LogLevel.ERROR, ex);
            throw new XMLAException(XMLAMessageKeys.GEN_UNEXPECTED_ERROR, ex);
        }
        finally {
            this.session.setState(XMLASession.SessionState.NONE);
            this.session.setSessionId(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveDataSourceProperties(IExecutionEnvironment environment) {
        if (null != this.dataSourceProperties) {
            return;
        }
        XQELogger logger = XMLALog.getLogger("Connection");
        logger.log(LogLevel.INFO, "XMLAConnection.resolveDataSourceProperties()");
        this.dataSourceProperties = new KeyValueList();
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment(environment);
        logCtx.setMetadataOp(null);
        try {
            XMLARowset rowset = this.performDiscoverRequest(environment, "DISCOVER_PROPERTIES", xmlaRestrictions, xmlaProperties);
            int numRows = rowset.numRows();
            if (numRows > 0) {
                int nameOrd = rowset.getColumnOrdinal("PropertyName");
                int valueOrd = rowset.getColumnOrdinal("Value");
                String propName = null;
                String propValue = null;
                for (int i = 0; i < numRows; ++i) {
                    XMLARow currentRow = rowset.getRow(i);
                    XMLAValue value = null;
                    value = currentRow.getValue(nameOrd);
                    if (value.isNull()) continue;
                    propName = value.getString();
                    value = currentRow.getValue(valueOrd);
                    if (value.isNull()) continue;
                    propValue = value.getString();
                    this.dataSourceProperties.add(propName, propValue);
                }
                if (logger.isOn(LogLevel.TRACE)) {
                    StringBuilder buffer = new StringBuilder();
                    buffer.append("Discovered Properties: ").append(this.dataSourceProperties);
                    logger.log(LogLevel.TRACE, buffer.toString());
                }
            }
        }
        catch (XMLAException ex) {
            if (XMLALog.isOn("Connection", LogLevel.WARN)) {
                XMLALog.getLogger("Connection").log(LogLevel.WARN, "Exception caught while fetching data source properties: ", (Throwable)((Object)ex));
            }
        }
        finally {
            logCtx.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveDataSourceInfo(IExecutionEnvironment environment) {
        if (null != this.dataSourceInfo || this.dataSourceInfoResolved) {
            return;
        }
        XQELogger logger = XMLALog.getLogger("Connection");
        logger.log(LogLevel.INFO, "XMLAConnection.resolveDataSourceInfo()");
        KeyValueList xmlaProperties = new KeyValueList();
        KeyValueList xmlaRestrictions = new KeyValueList();
        if (null != this.dataSourceName) {
            xmlaRestrictions.add("DataSourceName", this.dataSourceName);
        }
        XMLALogContext logCtx = XMLALogContext.enter();
        logCtx.setEnvironment(environment);
        logCtx.setMetadataOp(null);
        try {
            XMLARowset rowset = this.performDiscoverRequest(environment, "DISCOVER_DATASOURCES", xmlaRestrictions, xmlaProperties);
            this.dataSourceInfoResolved = true;
            if (rowset.numRows() == 0) {
                if (null != this.dataSourceName) {
                    throw new XMLAException(XMLAMessageKeys.CON_DATASOURCE_RESOLUTION, this.dataSourceName);
                }
                return;
            }
            int dataSourceNameOrd = rowset.getColumnOrdinal("DataSourceName");
            int dataSourceInfoOrd = rowset.getColumnOrdinal("DataSourceInfo");
            if (dataSourceInfoOrd < 0) {
                return;
            }
            for (int i = 0; i < rowset.numRows(); ++i) {
                XMLARow currentRow = rowset.getRow(i);
                XMLAValue value = null;
                value = currentRow.getValue(dataSourceNameOrd);
                if (value.isNull() || null != this.dataSourceName && !value.getString().equals(this.dataSourceName) || (value = currentRow.getValue(dataSourceInfoOrd)).isNull()) continue;
                this.dataSourceInfo = value.getString();
                break;
            }
            if (null == this.dataSourceInfo && null != this.dataSourceName) {
                throw new XMLAException(XMLAMessageKeys.CON_DATASOURCE_RESOLUTION, this.dataSourceName);
            }
        }
        finally {
            logCtx.exit();
        }
    }

    void resolveCapabilities(IDataSourceCapabilities dataSourceCapabilities) {
        if (null != this.capabilities) {
            return;
        }
        XQELogger logger = XMLALog.getLogger("Connection");
        logger.log(LogLevel.INFO, "XMLAConnection.resolveCapabilities()");
        this.capabilities = new XMLACapabilities();
        this.capabilities.initializeFrom(dataSourceCapabilities);
        if (this.capabilities.canSupportSessions()) {
            logger.log(LogLevel.INFO, "Data source can support Sessions");
            String providerType = (String)this.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
            XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
            if (currConfig.getUseSessions()) {
                logger.log(LogLevel.INFO, "Provider is configured to use Sessions");
                this.session = new XMLASession();
            } else {
                logger.log(LogLevel.INFO, "Provider is configured not to use Sessions");
            }
        } else {
            logger.log(LogLevel.INFO, "Data source does not support Sessions");
        }
    }

    private String normalizeMDX(String mdx) {
        int n = mdx.length();
        this.mdxNormalizeBuffer.delete(0, this.mdxNormalizeBuffer.length());
        this.mdxNormalizeBuffer.ensureCapacity(n);
        for (int i = 0; i < n; ++i) {
            char c = mdx.charAt(i);
            if (c == '\n' || c == '\r') {
                c = ' ';
            }
            this.mdxNormalizeBuffer.append(c);
        }
        return this.mdxNormalizeBuffer.toString();
    }

    private final class XMLAQueryListener
    implements IQueryListener {
        private XMLAQueryListener() {
        }

        @Override
        public void onError(QueryBase theQuery, Throwable theError) {
            if (XMLALog.isOn(LogLevel.ERROR)) {
                XMLALog.getLogger().log(LogLevel.ERROR, "Error occurred during query execution: ", theError);
            }
            XMLAConnection.this.recycleConnection.set(false);
        }

        @Override
        public void onCancelBegin(QueryBase theQuery) {
        }

        @Override
        public void onCancelEnd(QueryBase theQuery) {
        }

        @Override
        public void onExecuteBegin(QueryBase theQuery) {
        }

        @Override
        public void onExecuteEnd(QueryBase theQuery) {
        }
    }

    private final class XMLAHttpConnectionManager
    implements HttpConnectionManager {
        private HttpConnectionManagerParams params = new HttpConnectionManagerParams();
        private final AtomicBoolean inUse = new AtomicBoolean(false);

        XMLAHttpConnectionManager() {
            this.params.setMaxTotalConnections(1);
        }

        public void closeIdleConnections(long idleTimeout) {
        }

        public HttpConnection getConnection(HostConfiguration theConfiguration) {
            if (this.inUse.get()) {
                throw new XMLAException(XMLAMessageKeys.CON_HTTP_CONNECTION_INUSE);
            }
            XQELogger logger = XMLALog.getLogger("Connection");
            this.inUse.set(true);
            if (!XMLAConnection.this.recycleConnection.get()) {
                logger.log(LogLevel.TRACE, "HTTP connection cannot be recycled - forcing it to close");
                XMLAConnection.this.httpConnection.close();
            }
            if (!XMLAConnection.this.httpConnection.isOpen()) {
                try {
                    logger.log(LogLevel.TRACE, "Re-opening HTTP connection");
                    XMLAConnection.this.httpConnection.open();
                }
                catch (IOException ex) {
                    logger.log(LogLevel.ERROR, (Throwable)ex);
                    throw new XMLAException(XMLAMessageKeys.CON_CONNECTION_FAILED, ex, XMLAConnection.this.getURLString());
                }
            }
            XMLAConnection.this.httpConnection.setHttpConnectionManager((HttpConnectionManager)this);
            XMLAConnection.this.recycleConnection.set(true);
            return XMLAConnection.this.httpConnection;
        }

        public HttpConnection getConnection(HostConfiguration theConfiguration, long theTimeout) throws HttpException {
            return this.getConnection(theConfiguration);
        }

        public HttpConnection getConnectionWithTimeout(HostConfiguration theConfiguration, long theTimeout) throws ConnectionPoolTimeoutException {
            return this.getConnection(theConfiguration);
        }

        public HttpConnectionManagerParams getParams() {
            return this.params;
        }

        public void releaseConnection(HttpConnection theConnection) {
            this.inUse.set(false);
        }

        public void setParams(HttpConnectionManagerParams theParam) {
            throw new UnsupportedOperationException();
        }
    }
}

