/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.connection.parameters.ProviderTypeParameter;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.xmla.XMLAAxisIterator;
import com.cognos.xqe.data.providers.olap.xmla.XMLACellIterator;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfig;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConfigManager;
import com.cognos.xqe.data.providers.olap.xmla.XMLAConnection;
import com.cognos.xqe.data.providers.olap.xmla.XMLADataProvider;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.trace.LogLevel;
import java.util.HashMap;
import java.util.Map;

public final class XMLACubeResultSet
extends ProviderResultSetBase
implements ICubeResultSet {
    private static final String SLICER_AXIS = "SlicerAxis";
    private final XMLAConnection connection;
    protected boolean managesConnection = true;
    private final ICube cube;
    private final XMLADataset dataset;
    private final int slicerAxisOrdinal;
    private final int[] axisOrdinals;
    private final Map<String, IMember> memberCache = new HashMap<String, IMember>();

    XMLACubeResultSet(XMLADataProvider theDataProvider, XMLAConnection theConnection, XDataContext xDataContext, MDXQueryArguments theQueryArguments, ICube theCube, XMLADataset theDataset) {
        super((DataProviderBase)theDataProvider, xDataContext, theQueryArguments.getRunLocale());
        this.connection = theConnection;
        this.cube = theCube;
        this.dataset = theDataset;
        XMLADataset.Axis slicerAxis = this.dataset.getAxis(SLICER_AXIS);
        if (null != slicerAxis) {
            this.slicerAxisOrdinal = slicerAxis.getOrdinal();
            this.axisOrdinals = new int[this.dataset.numAxes() - 1];
        } else {
            this.slicerAxisOrdinal = -1;
            this.axisOrdinals = new int[this.dataset.numAxes()];
        }
        int i = 0;
        for (int ordinal = 0; ordinal < this.dataset.numAxes(); ++ordinal) {
            if (ordinal == this.slicerAxisOrdinal) continue;
            this.axisOrdinals[i++] = ordinal;
        }
    }

    public boolean isManagingConnection() {
        return this.managesConnection;
    }

    public void setManagingConnection(boolean isManagingConnection) {
        this.managesConnection = isManagingConnection;
    }

    public XMLAConnection getConnection() {
        return this.connection;
    }

    public ICube getCube() {
        return this.cube;
    }

    protected void releaseImpl() {
        try {
            if (XMLALog.isOn("DataQuery", LogLevel.INFO)) {
                XMLALog.getLogger("DataQuery").log(LogLevel.INFO, "Releasing result set.");
            }
            this.memberCache.clear();
            this.dataset.release();
            this.returnConnectionToPool();
        }
        catch (Throwable ex) {
            if (XMLALog.isOn("DataQuery", LogLevel.ERROR)) {
                XMLALog.getLogger("DataQuery").log(LogLevel.ERROR, ex);
            }
        }
        finally {
            super.releaseImpl();
        }
    }

    private void returnConnectionToPool() {
        if (this.isManagingConnection()) {
            this.connection.returnToPool();
        }
    }

    public XIterator getAxisIterator(int axisNumber) {
        return new XMLAAxisIterator(this, this.getDataContext(), this.nodeId, this.dataset.getAxis(this.axisOrdinals[axisNumber]));
    }

    public long getAxisSize(int axisNumber) {
        return this.dataset.getAxis(this.axisOrdinals[axisNumber]).numTuples();
    }

    public XCellIterator getCellIterator() {
        String providerType = (String)this.connection.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        return new XMLACellIterator(this, this.getDataContext(), this.nodeId, this.dataset, currConfig);
    }

    public IDimension[] getDimensions(int axisNumber) {
        XMLADataset.Axis axis = this.dataset.getAxis(this.axisOrdinals[axisNumber]);
        XMLADataset.AxisInfo axisInfo = this.dataset.getAxesInfo().getAxisInfo(axis.getOrdinal());
        IDimension[] cubeDimensions = new IDimension[axisInfo.numHierarchies()];
        for (int i = 0; i < axisInfo.numHierarchies(); ++i) {
            XMLADataset.HierarchyInfo hierInfo = axisInfo.getHierarchy(i);
            IHierarchy cubeHierarchy = this.cube.getHierarchy(hierInfo.getName());
            cubeDimensions[i] = cubeHierarchy.getDimension();
        }
        return cubeDimensions;
    }

    public int getNumAxes() {
        return this.axisOrdinals.length;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        String providerType = (String)this.connection.getConnectionParameters().valueOf(ProviderTypeParameter.class, String.class);
        XMLAConfig currConfig = XMLAConfigManager.getConfig(providerType);
        return new XMLACellIterator(this, this.getDataContext(), this.nodeId, this.dataset, currConfig);
    }

    public ITuple getSlicer() {
        if (-1 == this.slicerAxisOrdinal) {
            return null;
        }
        XMLAAxisIterator axisIter = new XMLAAxisIterator(this, this.getDataContext(), this.nodeId, this.dataset.getAxis(this.slicerAxisOrdinal));
        ITuple aTuple = null;
        try {
            aTuple = (ITuple)axisIter.next();
        }
        finally {
            axisIter.release();
        }
        return aTuple;
    }

    void putCachedMember(IMember member) {
        this.memberCache.put(member.getUniqueName(), member);
    }

    IMember getCachedMember(String mun) {
        return this.memberCache.get(mun);
    }
}

