/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARowset;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.StringSubstitutionEngine;
import com.cognos.xqe.util.io.ForwardingInputStream;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.lang.ArrayUtils;

public class XMLALog {
    private static final String OTHER = "OTHER";
    private static final String DISCOVER_REQUEST_FILENAME = "/providers/olap/xmla/$1/$2/DiscoverRequest/$3_$4_$5.xml";
    private static final String DISCOVER_RESPONSE_FILENAME = "/providers/olap/xmla/$1/$2/DiscoverResponse/$3_$4_$5.xml";
    private static final String DISCOVER_METRICS_FILENAME = "/providers/olap/xmla/$1/$2/DiscoverMetrics/$3_$4_$5.txt";
    private static final String DISCOVER_ROWSETS_FILENAME = "/providers/olap/xmla/$1/$2/DiscoverRowsets/$3_$4_$5.xml";
    private static final String EXECUTE_REQUEST_FILENAME = "/providers/olap/xmla/$1/$2/ExecuteRequest/$3_$4.xml";
    private static final String EXECUTE_RESPONSE_FILENAME = "/providers/olap/xmla/$1/$2/ExecuteResponse/$3_$4.xml";
    private static final String EXECUTE_METRICS_FILENAME = "/providers/olap/xmla/$1/$2/ExecuteMetrics/$3_$4.txt";
    private static final String EXECUTE_DATASETS_FILENAME = "/providers/olap/xmla/$1/$2/ExecuteDatasets/$3_$4.xml";
    private static final String CANCEL_REQUEST_FILENAME = "/providers/olap/xmla/$1/$2/CancelRequest/$3_$4.xml";
    private static final String CANCEL_RESPONSE_FILENAME = "/providers/olap/xmla/$1/$2/CancelResponse/$3_$4.xml";
    private static final String BEGIN_SESSION_REQUEST_FILENAME = "/providers/olap/xmla/BeginSessionRequest/$1.xml";
    private static final String BEGIN_SESSION_RESPONSE_FILENAME = "/providers/olap/xmla/BeginSessionResponse/$1.xml";
    private static final String END_SESSION_REQUEST_FILENAME = "/providers/olap/xmla/EndSessionRequest/$1.xml";
    private static final String END_SESSION_RESPONSE_FILENAME = "/providers/olap/xmla/EndSessionResponse/$1.xml";
    private static final char[] ILLEGAL_PATH_CHARS = new char[]{'<', '>', ':', '\"', '/', '\\', '|', '?', '*'};
    public static final String EVENT_GROUP_HTTP_STATE = "Http.State";
    public static final String EVENT_GROUP_HTTP_POST = "Http.Post";
    public static final String EVENT_GROUP_SOAP_REQUEST = "Soap.Request";
    public static final String EVENT_GROUP_SOAP_RESPONSE = "Soap.Response";
    public static final String EVENT_GROUP_METRICS = "Metrics";
    public static final String EVENT_GROUP_ROWSETS = "Rowsets";
    public static final String EVENT_GROUP_DATASETS = "Datasets";
    private static final String UNKNOWN_REQUESTID = "0";
    private static final String MS = " ms";
    private static final String BYTES = " bytes";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String RETRY_COUNT = "RetryCount=";
    private static final String FIRST_RESPONSE_TIME = "FirstResponseTime=";
    private static final String PARSE_TIME = "ParseTime=";
    private static final String RESPONSE_SIZE = "ResponseSize=";
    private static final String NUM_EXPECTED_EDGES = "NumExpectedEdges=";
    private static final String AXIS_COUNT = "AxisCount=";
    private static final String MEMBER_COUNT = "MemberCount=";
    private static final String TUPLE_COUNTS = "TupleCounts=";
    private static final String TUPLE_CARDINALITIES = "TupleCardinalities=";
    private static final String CELL_COUNT = "CellCount=";
    private static final String ROW_COUNT = "RowCount=";
    private static final LogLevel DEFAULT_LOG_LEVEL = LogLevel.INFO;

    private static String getEventGroupFromContext() {
        XMLALogContext logCtx = XMLALogContext.get();
        String logGroup = "Unspecified";
        if (null != logCtx) {
            if (logCtx.isDataRequest()) {
                logGroup = "DataQuery";
            } else if (logCtx.isMetadataRequest()) {
                logGroup = "Metadata";
            } else if (logCtx.isCancelRequest()) {
                logGroup = "Cancel";
            }
        }
        return logGroup;
    }

    public static boolean isOn(String eventGroup, LogLevel logLevel) {
        return XMLALog.getLogger(eventGroup).isOn(logLevel);
    }

    public static boolean isOn(LogLevel logLevel) {
        return XMLALog.getLogger().isOn(logLevel);
    }

    public static XQELogger getLogger() {
        return XMLALog.getLogger(XMLALog.getEventGroupFromContext());
    }

    public static XQELogger getLogger(String eventGroup) {
        return XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"XMLA", (String)eventGroup, (LogLevel)DEFAULT_LOG_LEVEL);
    }

    public static XQELogger getLogger(String eventGroup, LogLevel logLevel) {
        return XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"XMLA", (String)eventGroup, (LogLevel)logLevel);
    }

    public static void logHttpState(HttpState httpState) {
        if (XMLALog.isOn(EVENT_GROUP_HTTP_STATE, LogLevel.INFO)) {
            StringBuilder buf = new StringBuilder();
            Cookie[] cookies = httpState.getCookies();
            UsernamePasswordCredentials cred = (UsernamePasswordCredentials)httpState.getCredentials(AuthScope.ANY);
            buf.append("HTTP State: \n=> Cookies: ").append(ArrayUtils.toString((Object)cookies));
            if (null != cred) {
                buf.append("\n=> HTTP Auth user: ").append(cred.getUserName());
            }
            XMLALog.getLogger(EVENT_GROUP_HTTP_STATE).log(LogLevel.INFO, buf.toString());
        }
    }

    public static void logBeforeHttpPost(PostMethod postMethod, HostConfiguration configuration) {
        if (XMLALog.isOn(EVENT_GROUP_HTTP_POST, LogLevel.INFO)) {
            StringBuilder buf = new StringBuilder();
            ArrayList<Header> filteredHeaders = new ArrayList<Header>();
            for (Header header : postMethod.getRequestHeaders()) {
                if (header.getName().equals("Authorization")) continue;
                filteredHeaders.add(header);
            }
            buf.append("HTTP Post: ").append(configuration.getHost()).append(":").append(configuration.getPort()).append(postMethod.getPath());
            buf.append("\n=> Request Headers: ").append(filteredHeaders);
            XMLALog.getLogger(EVENT_GROUP_HTTP_POST).log(LogLevel.INFO, OperationEnum.START, buf.toString());
        }
    }

    public static void logAfterHttpPost(PostMethod postMethod) {
        if (XMLALog.isOn(EVENT_GROUP_HTTP_POST, LogLevel.TRACE)) {
            StringBuilder buf = new StringBuilder();
            buf.append("HTTP Response: ").append(postMethod.getStatusLine());
            buf.append("\n=> Response Headers: ").append(ArrayUtils.toString((Object)postMethod.getResponseHeaders()));
            buf.append("\n=> Response Footers: ").append(ArrayUtils.toString((Object)postMethod.getResponseFooters()));
            XMLALog.getLogger(EVENT_GROUP_HTTP_POST).log(LogLevel.INFO, OperationEnum.END, buf.toString());
        }
    }

    public static void dumpDiscoverRequest(CharSequence requestBody) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_REQUEST, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String metadataOp = OTHER;
        if (null != logCtx.getMetadataOp()) {
            metadataOp = logCtx.getMetadataOp().toString();
        }
        String fileName = StringSubstitutionEngine.substitute((String)DISCOVER_REQUEST_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), metadataOp, logCtx.getDiscoverRowset()});
        XMLALog.dumpRequestBody(fileName, requestBody, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_REQUEST);
        logger.log(LogLevel.TRACE, "Dumped Discover request to " + fileName);
    }

    public static void dumpExecuteRequest(CharSequence requestBody) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_REQUEST, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String fileName = StringSubstitutionEngine.substitute((String)EXECUTE_REQUEST_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), logCtx.getExecuteHint()});
        XMLALog.dumpRequestBody(fileName, requestBody, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_REQUEST);
        logger.log(LogLevel.TRACE, "Dumped Execute request to " + fileName);
    }

    public static void dumpCancelRequest(CharSequence requestBody) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_REQUEST, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String fileName = StringSubstitutionEngine.substitute((String)CANCEL_REQUEST_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), logCtx.getExecuteHint()});
        XMLALog.dumpRequestBody(fileName, requestBody, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_REQUEST);
        logger.log(LogLevel.TRACE, "Dumped Cancel request to " + fileName);
    }

    public static void dumpBeginSessionRequest(CharSequence requestBody) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_REQUEST, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        String fileName = StringSubstitutionEngine.substitute((String)BEGIN_SESSION_REQUEST_FILENAME, (String[])new String[]{String.valueOf(logCtx.getRequestNumber())});
        XMLALog.dumpRequestBody(fileName, requestBody, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_REQUEST);
        logger.log(LogLevel.TRACE, "Dumped BeginSession request to " + fileName);
    }

    public static void dumpEndSessionRequest(CharSequence requestBody) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_REQUEST, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        String fileName = StringSubstitutionEngine.substitute((String)END_SESSION_REQUEST_FILENAME, (String[])new String[]{String.valueOf(logCtx.getRequestNumber())});
        XMLALog.dumpRequestBody(fileName, requestBody, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_REQUEST);
        logger.log(LogLevel.TRACE, "Dumped EndSession request to " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpRequestBody(String fileName, CharSequence requestBody, XMLALogContext logCtx) {
        String logsFolder = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP).getXqeLogsDirectory();
        File dumpFile = new File(logsFolder + fileName);
        OutputStreamWriter writer = null;
        dumpFile.getParentFile().mkdirs();
        try {
            writer = new OutputStreamWriter(new FileOutputStream(dumpFile));
            ((Writer)writer).append(requestBody);
            ((Writer)writer).flush();
        }
        catch (IOException ex) {
            if (XMLALog.isOn("Exception", LogLevel.WARN)) {
                XMLALog.getLogger("Exception", LogLevel.WARN).log((Throwable)ex);
            }
        }
        finally {
            block14: {
                if (null != writer) {
                    try {
                        ((Writer)writer).close();
                    }
                    catch (IOException ex) {
                        if (!XMLALog.isOn("Exception", LogLevel.WARN)) break block14;
                        XMLALog.getLogger("Exception", LogLevel.WARN).log((Throwable)ex);
                    }
                }
            }
        }
    }

    public static InputStream dumpDiscoverResponse(InputStream responseStream) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_RESPONSE, LogLevel.TRACE)) {
            return responseStream;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String metadataOp = OTHER;
        if (null != logCtx.getMetadataOp()) {
            metadataOp = logCtx.getMetadataOp().toString();
        }
        String fileName = StringSubstitutionEngine.substitute((String)DISCOVER_RESPONSE_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), metadataOp, logCtx.getDiscoverRowset()});
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_RESPONSE);
        logger.log(LogLevel.TRACE, "Dumped Discover response to " + fileName);
        return XMLALog.dumpResponseStream(fileName, responseStream, logCtx);
    }

    public static void dumpDiscoverMetrics(XMLARowset rowset) {
        if (!XMLALog.isOn(EVENT_GROUP_METRICS, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String metadataOp = OTHER;
        if (null != logCtx.getMetadataOp()) {
            metadataOp = logCtx.getMetadataOp().toString();
        }
        String fileName = StringSubstitutionEngine.substitute((String)DISCOVER_METRICS_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), metadataOp, logCtx.getDiscoverRowset()});
        StringBuilder metricsReport = new StringBuilder();
        metricsReport.append(RETRY_COUNT).append(logCtx.getRetryCount()).append(NEWLINE);
        metricsReport.append(FIRST_RESPONSE_TIME).append(logCtx.getFirstResponseTime()).append(MS).append(NEWLINE);
        metricsReport.append(PARSE_TIME).append(logCtx.getParseTime()).append(MS).append(NEWLINE);
        metricsReport.append(RESPONSE_SIZE).append(logCtx.getResponseSize()).append(BYTES).append(NEWLINE);
        metricsReport.append(ROW_COUNT).append(logCtx.getRowCount()).append(NEWLINE);
        XMLALog.dumpRequestBody(fileName, metricsReport, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_METRICS);
        logger.log(LogLevel.TRACE, "Dumped Discover metrics to " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpDiscoverRowset(XMLARowset rowsetData) {
        if (!XMLALog.isOn(EVENT_GROUP_ROWSETS, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String metadataOp = OTHER;
        if (null != logCtx.getMetadataOp()) {
            metadataOp = logCtx.getMetadataOp().toString();
        }
        String fileName = StringSubstitutionEngine.substitute((String)DISCOVER_ROWSETS_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), metadataOp, logCtx.getDiscoverRowset()});
        String logsFolder = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP).getXqeLogsDirectory();
        File dumpFile = new File(logsFolder + fileName);
        dumpFile.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dumpFile);
            XMLStreamWriter writer = StaxUtil.createXMLStreamWriter((OutputStream)fos);
            rowsetData.dumpXML(writer);
            writer.close();
        }
        catch (Exception ex) {
            if (XMLALog.isOn("Exception", LogLevel.ERROR)) {
                XMLALog.getLogger("Exception", LogLevel.ERROR).log((Throwable)ex);
            }
            return;
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    if (XMLALog.isOn("Exception", LogLevel.ERROR)) {
                        XMLALog.getLogger("Exception", LogLevel.ERROR).log((Throwable)ex);
                    }
                    return;
                }
            }
        }
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_ROWSETS);
        logger.log(LogLevel.TRACE, "Dumped Discover rowset to " + fileName);
    }

    public static InputStream dumpExecuteResponse(InputStream responseStream) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_RESPONSE, LogLevel.TRACE)) {
            return responseStream;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String fileName = StringSubstitutionEngine.substitute((String)EXECUTE_RESPONSE_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), logCtx.getExecuteHint()});
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_RESPONSE);
        logger.log(LogLevel.TRACE, "Dumped Execute response to " + fileName);
        return XMLALog.dumpResponseStream(fileName, responseStream, logCtx);
    }

    public static void dumpExecuteMetrics(XMLADataset dataset) {
        if (!XMLALog.isOn(EVENT_GROUP_METRICS, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String fileName = StringSubstitutionEngine.substitute((String)EXECUTE_METRICS_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), logCtx.getExecuteHint()});
        StringBuilder metricsReport = new StringBuilder();
        metricsReport.append(RETRY_COUNT).append(logCtx.getRetryCount()).append(NEWLINE);
        metricsReport.append(FIRST_RESPONSE_TIME).append(logCtx.getFirstResponseTime()).append(MS).append(NEWLINE);
        metricsReport.append(PARSE_TIME).append(logCtx.getParseTime()).append(MS).append(NEWLINE);
        metricsReport.append(RESPONSE_SIZE).append(logCtx.getResponseSize()).append(BYTES).append(NEWLINE);
        metricsReport.append(NUM_EXPECTED_EDGES).append(logCtx.getNumExpectedEdges()).append(NEWLINE);
        metricsReport.append(AXIS_COUNT).append(logCtx.getAxisCount()).append(NEWLINE);
        metricsReport.append(MEMBER_COUNT).append(logCtx.getMemberCount()).append(NEWLINE);
        metricsReport.append(TUPLE_COUNTS).append(logCtx.getTupleCounts().toString()).append(NEWLINE);
        metricsReport.append(TUPLE_CARDINALITIES).append(logCtx.getTupleCardinalities().toString()).append(NEWLINE);
        metricsReport.append(CELL_COUNT).append(logCtx.getCellCount()).append(NEWLINE);
        XMLALog.dumpRequestBody(fileName, metricsReport, logCtx);
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_METRICS);
        logger.log(LogLevel.TRACE, "Dumped Execute metrics to " + fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpExecuteDataset(XMLADataset dataset) {
        if (!XMLALog.isOn(EVENT_GROUP_DATASETS, LogLevel.TRACE)) {
            return;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String fileName = StringSubstitutionEngine.substitute((String)EXECUTE_DATASETS_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), logCtx.getExecuteHint()});
        String logsFolder = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP).getXqeLogsDirectory();
        File dumpFile = new File(logsFolder + fileName);
        dumpFile.getParentFile().mkdirs();
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dumpFile);
            XMLStreamWriter writer = StaxUtil.createXMLStreamWriter((OutputStream)fos);
            dataset.dumpXML(writer);
            writer.close();
        }
        catch (Exception ex) {
            if (XMLALog.isOn("Exception", LogLevel.WARN)) {
                XMLALog.getLogger("Exception", LogLevel.WARN).log((Throwable)ex);
            }
            return;
        }
        finally {
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException ex) {
                    if (XMLALog.isOn("Exception", LogLevel.WARN)) {
                        XMLALog.getLogger("Exception", LogLevel.WARN).log((Throwable)ex);
                    }
                    return;
                }
            }
        }
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_DATASETS);
        logger.log(LogLevel.TRACE, "Dumped Execute dataset to " + fileName);
    }

    public static InputStream dumpCancelResponse(InputStream responseStream) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_RESPONSE, LogLevel.TRACE)) {
            return responseStream;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        IExecutionEnvironment execEnv = logCtx.getEnvironment();
        String fileName = StringSubstitutionEngine.substitute((String)CANCEL_RESPONSE_FILENAME, (String[])new String[]{XMLALog.filterIllegalPathChars(execEnv.getRequestEnvironment().getReportName()), XMLALog.filterIllegalPathChars(XMLALog.extractRequestID(execEnv)), String.valueOf(logCtx.getRequestNumber()), logCtx.getExecuteHint()});
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_RESPONSE);
        logger.log(LogLevel.TRACE, "Dumped Cancel response to " + fileName);
        return XMLALog.dumpResponseStream(fileName, responseStream, logCtx);
    }

    public static InputStream dumpBeginSessionResponse(InputStream responseStream) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_RESPONSE, LogLevel.TRACE)) {
            return responseStream;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        String fileName = StringSubstitutionEngine.substitute((String)BEGIN_SESSION_RESPONSE_FILENAME, (String[])new String[]{String.valueOf(logCtx.getRequestNumber())});
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_RESPONSE);
        logger.log(LogLevel.TRACE, "Dumped BeginSession response to " + fileName);
        return XMLALog.dumpResponseStream(fileName, responseStream, logCtx);
    }

    public static InputStream dumpEndSessionResponse(InputStream responseStream) {
        if (!XMLALog.isOn(EVENT_GROUP_SOAP_RESPONSE, LogLevel.TRACE)) {
            return responseStream;
        }
        XMLALogContext logCtx = XMLALogContext.get();
        String fileName = StringSubstitutionEngine.substitute((String)END_SESSION_RESPONSE_FILENAME, (String[])new String[]{String.valueOf(logCtx.getRequestNumber())});
        XQELogger logger = XMLALog.getLogger(EVENT_GROUP_SOAP_RESPONSE);
        logger.log(LogLevel.TRACE, "Dumped EndSession response to " + fileName);
        return XMLALog.dumpResponseStream(fileName, responseStream, logCtx);
    }

    private static InputStream dumpResponseStream(String fileName, InputStream responseStream, XMLALogContext logCtx) {
        String logsFolder = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP).getXqeLogsDirectory();
        File dumpFile = new File(logsFolder + fileName);
        dumpFile.getParentFile().mkdirs();
        BufferedOutputStream fileStream = null;
        try {
            fileStream = new BufferedOutputStream(new FileOutputStream(dumpFile));
        }
        catch (IOException ex) {
            if (XMLALog.isOn("Exception", LogLevel.ERROR)) {
                XMLALog.getLogger("Exception", LogLevel.ERROR).log((Throwable)ex);
            }
            return responseStream;
        }
        return new ForwardingInputStream(responseStream, (OutputStream)fileStream);
    }

    private static String extractRequestID(IExecutionEnvironment execEnv) {
        if (null == execEnv) {
            return UNKNOWN_REQUESTID;
        }
        RequestEnvironment reqEnv = (RequestEnvironment)execEnv.getRequestEnvironment();
        if (null == reqEnv) {
            return UNKNOWN_REQUESTID;
        }
        String reqId = reqEnv.getRequestID();
        if (null == reqId || reqId.length() == 0) {
            return UNKNOWN_REQUESTID;
        }
        return reqId;
    }

    private static String filterIllegalPathChars(String str) {
        if (null == str) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c <= ' ' || ArrayUtils.contains((char[])ILLEGAL_PATH_CHARS, (char)c)) continue;
            result.append(c);
        }
        return result.toString();
    }
}

