/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla;

import com.cognos.xqe.data.providers.ProviderCellBase;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.util.xml.XMLWriter;
import java.util.Map;

final class XMLAResultCell
extends ProviderCellBase {
    private static final int HASH_BIT_SHIFT = 32;
    private static final int LONG_SIZE = 4;
    private static final IDataType DEFAULT_DATA_TYPE = DataTypeFactory.getDoubleType();
    private String formatString = null;
    private Map<String, Object> properties = null;

    XMLAResultCell() {
        this.value = DEFAULT_DATA_TYPE.createValue();
        this.value.setNull();
    }

    XMLAResultCell(long aOrdinal, IValue aValue) {
        XMLAResultCell.assertValueNotNull(aValue);
        this.ordinal = aOrdinal;
        this.value = aValue;
    }

    public String getFormatString() {
        return this.formatString;
    }

    public void setFormatString(String aFormatString) {
        this.formatString = aFormatString;
    }

    public void copyFrom(IValue aValue) {
        if (aValue instanceof XMLAResultCell) {
            super.copyFrom(aValue);
            XMLAResultCell cellValue = (XMLAResultCell)aValue;
            this.formatString = cellValue.formatString;
        } else if (aValue instanceof ICell) {
            ICell cellValue = (ICell)aValue;
            this.ordinal = cellValue.getOrdinal();
            this.value = cellValue.getValue();
        } else if (null != aValue) {
            this.setValue(aValue);
        }
    }

    public int sizeOf() {
        return 4 + this.value.sizeOf();
    }

    public void toXML(XMLWriter xmlWriter) {
        xmlWriter.beginElement("Cell", -1);
        xmlWriter.attribute("CellOrdinal", this.getOrdinal());
        if (null != this.value) {
            this.value.toXML(xmlWriter);
        } else {
            xmlWriter.attribute("xsi:nil", true);
        }
        if (null != this.formatString) {
            xmlWriter.beginElement("FormatString", -1);
            xmlWriter.data(this.formatString);
            xmlWriter.endElement();
        }
        if (null != this.properties) {
            for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
                xmlWriter.beginElement(entry.getKey(), -1);
                ((IValue)entry.getValue()).toXML(xmlWriter);
                xmlWriter.endElement();
            }
        }
        xmlWriter.endElement();
    }

    public int compareTo(Object other) {
        if (!(other instanceof ICell)) {
            return -1;
        }
        ICell otherCell = (ICell)other;
        long otherOrdinal = otherCell.getOrdinal();
        if (this.ordinal < otherOrdinal) {
            return -1;
        }
        if (this.ordinal > otherOrdinal) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ICell)) {
            return false;
        }
        ICell otherCell = (ICell)other;
        return this.ordinal == otherCell.getOrdinal();
    }

    public int hashCode() {
        return (int)(this.ordinal ^ this.ordinal << 32);
    }

    public int fastHash() {
        return this.hashCode();
    }

    public Object copy() {
        XMLAResultCell clone = new XMLAResultCell();
        clone.copyFrom((IValue)this);
        return clone;
    }

    public void release() {
        super.release();
        this.formatString = null;
    }

    private static void assertValueNotNull(IValue aValue) {
        if (null == aValue) {
            throw new IllegalArgumentException("aValue was null.");
        }
    }
}

