/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser;

import com.cognos.xqe.data.providers.olap.xmla.parser.ComponentHandlerBase;
import com.cognos.xqe.data.providers.olap.xmla.parser.IDelegationAdvisor;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class DelegatingComponentHandler
extends ComponentHandlerBase {
    private String requiredNamespaceURI = null;
    private String requiredLocalName = null;
    private final List<DelegateRegistration> registrations = new ArrayList<DelegateRegistration>();
    private boolean consumed = false;

    public boolean hasConsumed() {
        return this.consumed;
    }

    public String getRequiredNamespaceURI() {
        return this.requiredNamespaceURI;
    }

    public void setRequiredNamespaceURI(String theRequiredNamespaceURI) {
        this.requiredNamespaceURI = theRequiredNamespaceURI;
    }

    public String getRequiredLocalName() {
        return this.requiredLocalName;
    }

    public void setRequiredLocalName(String theRequiredLocalName) {
        this.requiredLocalName = theRequiredLocalName;
    }

    public void registerDelegate(ComponentHandlerBase theHandler, IDelegationAdvisor theAdvisor) {
        if (null == theHandler) {
            throw new IllegalArgumentException("theHandler was null");
        }
        if (null == theAdvisor) {
            throw new IllegalArgumentException("theAdvisor was null");
        }
        this.registrations.add(new DelegateRegistration(theHandler, theAdvisor));
        this.registerSubHandler(theHandler);
    }

    public void unregisterDelegate(ComponentHandlerBase theHandler) {
        Iterator<DelegateRegistration> it = this.registrations.iterator();
        while (it.hasNext()) {
            DelegateRegistration reg = it.next();
            if (!reg.getHandler().equals(theHandler)) continue;
            it.remove();
            break;
        }
        this.unregisterSubHandler(theHandler);
    }

    @Override
    protected void releaseImpl() {
        this.registrations.clear();
    }

    @Override
    protected void resetImpl() {
        this.consumed = false;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        if (null != this.requiredLocalName) {
            if (null != this.requiredNamespaceURI) {
                QName expectedName = new QName(this.requiredNamespaceURI, this.requiredLocalName);
                DelegatingComponentHandler.assertAtStartElement(reader, expectedName);
            } else {
                DelegatingComponentHandler.assertAtStartElement(reader, this.requiredLocalName);
            }
        } else {
            DelegatingComponentHandler.assertAtStartElement(reader);
        }
        this.consumed = true;
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            boolean handled = false;
            for (DelegateRegistration registration : this.registrations) {
                if (!registration.getAdvisor().canDelegate(reader)) continue;
                handled = true;
                registration.getHandler().consume(reader);
                break;
            }
            if (handled) continue;
            StaxUtil.skipElement((XMLStreamReader)reader);
        }
    }

    private static final class DelegateRegistration {
        private final ComponentHandlerBase handler;
        private final IDelegationAdvisor advisor;

        DelegateRegistration(ComponentHandlerBase theHandler, IDelegationAdvisor theAdvisor) {
            this.handler = theHandler;
            this.advisor = theAdvisor;
        }

        public ComponentHandlerBase getHandler() {
            return this.handler;
        }

        public IDelegationAdvisor getAdvisor() {
            return this.advisor;
        }
    }
}

