/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.soap;

import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.parser.DelegatingComponentHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.SimpleQNameAdvisor;
import com.cognos.xqe.data.providers.olap.xmla.parser.soap.SoapEnvelopeHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.soap.SoapFaultHandler;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.xml.stax.IStaxComponentHandler;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SoapDocumentHandler
implements IStaxComponentHandler,
IReleasable {
    private SoapEnvelopeHandler envelopeHandler = new SoapEnvelopeHandler();
    private DelegatingComponentHandler headerHandler = new DelegatingComponentHandler();
    private DelegatingComponentHandler bodyHandler = new DelegatingComponentHandler();
    private SoapFaultHandler faultHandler = new SoapFaultHandler();

    public SoapDocumentHandler() {
        this.installSubHandlers();
    }

    public DelegatingComponentHandler getHeaderHandler() {
        return this.headerHandler;
    }

    public DelegatingComponentHandler getBodyHandler() {
        return this.bodyHandler;
    }

    public SoapFaultHandler getFaultHandler() {
        return this.faultHandler;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        this.envelopeHandler.reset();
        if (StaxUtil.moveToElement((XMLStreamReader)reader)) {
            this.envelopeHandler.consume(reader);
        }
        while (reader.getEventType() != 8) {
            reader.next();
        }
        if (!this.envelopeHandler.hasConsumedEnvelope()) {
            throw new XMLAException(XMLAMessageKeys.SOP_ENVELOPE_NOT_FOUND);
        }
        if (!this.bodyHandler.hasConsumed()) {
            throw new XMLAException(XMLAMessageKeys.SOP_BODY_NOT_FOUND);
        }
    }

    public void release() {
        this.envelopeHandler.release();
    }

    private void installSubHandlers() {
        QName soapFaultName = new QName(null, "Fault");
        this.bodyHandler.registerDelegate(this.faultHandler, new SimpleQNameAdvisor(soapFaultName, true));
        this.envelopeHandler.setSoapHeaderHandler(this.headerHandler);
        this.envelopeHandler.setSoapBodyHandler(this.bodyHandler);
    }
}

