/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.soap;

import com.cognos.xqe.data.providers.olap.xmla.parser.ComponentHandlerBase;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class SoapFaultHandler
extends ComponentHandlerBase {
    private static final String[] EXPECTED_CHILDREN = new String[]{"faultactor", "faultcode", "faultstring", "detail"};
    private ComponentHandlerBase detailsHandler = null;
    private boolean consumedFault = false;
    private String faultCode = null;
    private String faultActor = null;
    private String faultString = null;

    @Override
    protected void releaseImpl() {
        this.setDetailsHandler(null);
        this.faultCode = null;
        this.faultActor = null;
        this.faultString = null;
    }

    @Override
    protected void resetImpl() {
        this.consumedFault = false;
        this.faultCode = null;
        this.faultActor = null;
        this.faultString = null;
    }

    public boolean hasConsumedFault() {
        return this.consumedFault;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public ComponentHandlerBase getDetailsHandler() {
        return this.detailsHandler;
    }

    public void setDetailsHandler(ComponentHandlerBase theHandler) {
        if (null != this.detailsHandler) {
            this.unregisterSubHandler(this.detailsHandler);
        }
        if (null != theHandler) {
            this.registerSubHandler(theHandler);
        }
        this.detailsHandler = theHandler;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        SoapFaultHandler.assertAtStartElement(reader, "Fault");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String localName = reader.getLocalName();
            if ("faultactor".equals(localName)) {
                this.faultActor = reader.getElementText();
                continue;
            }
            if ("faultcode".equals(localName)) {
                this.faultCode = reader.getElementText();
                continue;
            }
            if ("faultstring".equals(localName)) {
                this.faultString = reader.getElementText();
                continue;
            }
            if ("detail".equals(localName)) {
                this.consumeDetail(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            SoapFaultHandler.throwUnexpectedElementException(EXPECTED_CHILDREN, localName);
        }
        this.consumedFault = true;
    }

    private void consumeDetail(XMLStreamReader reader) throws XMLStreamException {
        if (null != this.detailsHandler) {
            this.detailsHandler.consume(reader);
        } else {
            StaxUtil.skipElement((XMLStreamReader)reader);
        }
    }
}

