/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.xmla;

import com.cognos.xqe.data.providers.olap.xmla.StringPool;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.XMLSchemaConstants;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.DatasetAwareComponentHandler;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.CrossProductTupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ListTupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.UnionTupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAMember;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLATuple;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class AxesHandler
extends DatasetAwareComponentHandler {
    private static final String[] EXPECTED_AXIS_CHILDREN = new String[]{"Tuples", "CrossProduct"};
    private static final String[] EXPECTED_UNION_CHILDREN = new String[]{"Tuples", "Members", "CrossProduct", "Union"};
    private static final String[] EXPECTED_CROSS_PRODUCT_CHILDREN = new String[]{"Tuples", "Members", "CrossProduct", "Union"};
    private boolean consumedAxes = false;
    private final ArrayList<XMLAMember> memberList = new ArrayList();
    private final Map<String, XMLAMember> memberCache = new HashMap<String, XMLAMember>();

    public boolean hasConsumedAxes() {
        return this.consumedAxes;
    }

    @Override
    protected void releaseImpl() {
        this.setDataset(null);
        this.memberList.clear();
        this.memberCache.clear();
    }

    @Override
    protected void resetImpl() {
        this.setDataset(null);
        this.memberList.clear();
        this.memberCache.clear();
        this.consumedAxes = false;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        AxesHandler.assertAtStartElement(reader, "Axes");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Axis")) {
                this.consumeAxis(reader);
                continue;
            }
            AxesHandler.throwUnexpectedElementException("Axis", reader.getLocalName());
        }
        XMLALogContext.get().setMemberCount(this.memberCache.size());
        this.consumedAxes = true;
    }

    private void consumeAxis(XMLStreamReader reader) throws XMLStreamException {
        XMLADataset.AxisInfo axisInfo;
        AxesHandler.assertAtStartElement(reader, "Axis");
        String axisName = reader.getAttributeValue(null, "name");
        if (null == axisName) {
            AxesHandler.throwMissingAttributeException("Axis", "name");
        }
        if (null == (axisInfo = this.dataset.getAxesInfo().getAxisInfo(axisName))) {
            StaxUtil.skipElement((XMLStreamReader)reader);
            return;
        }
        LinkedList<ITupleSet> tupleSets = new LinkedList<ITupleSet>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        boolean exceptionFound = false;
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                exceptionFound = true;
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"CrossProduct")) {
                tupleSets.add(this.consumeCrossProduct(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Union")) {
                tupleSets.add(this.consumeUnion(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Tuples")) {
                tupleSets.add(this.consumeTuples(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Members")) {
                tupleSets.add(this.consumeMembers(reader, axisInfo));
                continue;
            }
            AxesHandler.throwUnexpectedElementException(EXPECTED_AXIS_CHILDREN, reader.getLocalName());
        }
        ITupleSet allTupleSet = null;
        allTupleSet = tupleSets.size() == 1 ? (ITupleSet)tupleSets.get(0) : new UnionTupleSet(tupleSets);
        XMLALogContext logCtx = XMLALogContext.get();
        logCtx.getTupleCounts().add(allTupleSet.size());
        logCtx.getTupleCardinalities().add(allTupleSet.cardinality());
        axisInfo.clearTempHierarchyData();
        this.dataset.addAxis(axisName, allTupleSet);
    }

    private ITupleSet consumeTuples(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        AxesHandler.assertAtStartElement(reader, "Tuples");
        LinkedList<XMLATuple> tuples = new LinkedList<XMLATuple>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Tuple")) {
                tuples.add(this.consumeTuple(reader, axisInfo));
                continue;
            }
            AxesHandler.throwUnexpectedElementException("Tuple", reader.getLocalName());
        }
        return new ListTupleSet(tuples);
    }

    private XMLATuple consumeTuple(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        AxesHandler.assertAtStartElement(reader, "Tuple");
        this.memberList.clear();
        this.memberList.ensureCapacity(axisInfo.numHierarchies());
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Member")) {
                this.memberList.add(this.consumeMember(reader, axisInfo));
                continue;
            }
            AxesHandler.throwUnexpectedElementException("Member", reader.getLocalName());
        }
        return new XMLATuple(this.memberList);
    }

    private ITupleSet consumeCrossProduct(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        AxesHandler.assertAtStartElement(reader, "CrossProduct");
        LinkedList<ITupleSet> tupleSets = new LinkedList<ITupleSet>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"CrossProduct")) {
                tupleSets.add(this.consumeCrossProduct(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Union")) {
                tupleSets.add(this.consumeUnion(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Tuples")) {
                tupleSets.add(this.consumeTuples(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Members")) {
                tupleSets.add(this.consumeMembers(reader, axisInfo));
                continue;
            }
            AxesHandler.throwUnexpectedElementException(EXPECTED_CROSS_PRODUCT_CHILDREN, reader.getLocalName());
        }
        return new CrossProductTupleSet(tupleSets);
    }

    private ITupleSet consumeUnion(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        AxesHandler.assertAtStartElement(reader, "Union");
        LinkedList<ITupleSet> tupleSets = new LinkedList<ITupleSet>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"CrossProduct")) {
                tupleSets.add(this.consumeCrossProduct(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Union")) {
                tupleSets.add(this.consumeUnion(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Tuples")) {
                tupleSets.add(this.consumeTuples(reader, axisInfo));
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Members")) {
                tupleSets.add(this.consumeMembers(reader, axisInfo));
                continue;
            }
            AxesHandler.throwUnexpectedElementException(EXPECTED_UNION_CHILDREN, reader.getLocalName());
        }
        return new UnionTupleSet(tupleSets);
    }

    private ITupleSet consumeMembers(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        XMLADataset.HierarchyInfo hierarchyInfo;
        AxesHandler.assertAtStartElement(reader, "Members");
        String hierarchyName = reader.getAttributeValue(null, "Hierarchy");
        if (null == hierarchyName) {
            AxesHandler.throwMissingAttributeException("Members", "Hierarchy");
        }
        if (null == (hierarchyInfo = axisInfo.getHierarchy(hierarchyName))) {
            AxesHandler.throwUnknownHierarchyException(hierarchyName);
        }
        LinkedList<XMLATuple> tuples = new LinkedList<XMLATuple>();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Member")) {
                tuples.add(new XMLATuple(this.consumeMember(reader, hierarchyInfo)));
                continue;
            }
            AxesHandler.throwUnexpectedElementException("Member", reader.getLocalName());
        }
        return new ListTupleSet(tuples);
    }

    private XMLAMember consumeMember(XMLStreamReader reader, XMLADataset.HierarchyInfo hierarchyInfo) throws XMLStreamException {
        AxesHandler.assertAtStartElement(reader, "Member");
        boolean seenMUN = false;
        XMLAMember member = new XMLAMember(hierarchyInfo);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            String xsiNil;
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            String propertyTag = reader.getLocalName();
            XMLAPropertyInfo propertyInfo = hierarchyInfo.propertyFromTag(propertyTag);
            if (null == propertyInfo) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                continue;
            }
            String xsdDataType = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type");
            ValueTypeEnum valueType = ValueTypeEnum.UNKNOWN;
            boolean isNull = false;
            XMLAValue value = null;
            if (null != xsdDataType) {
                valueType = XMLSchemaConstants.convertXSDType(xsdDataType);
            }
            if (null != (xsiNil = reader.getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "nil"))) {
                isNull = xsiNil.equals("true");
            }
            if (isNull) {
                value = XMLAValue.nullOf(valueType);
            } else {
                StringPool stringPool = propertyInfo.getStringPool();
                String stringValue = stringPool.intern(this.readText(reader));
                if (propertyInfo.getUnqualifiedName().equals("MEMBER_UNIQUE_NAME") && !seenMUN) {
                    seenMUN = true;
                    XMLAMember cachedMember = this.memberCache.get(stringValue);
                    if (null != cachedMember) {
                        member = cachedMember;
                        childIter.skipToEnd();
                    } else {
                        this.memberCache.put(stringValue, member);
                    }
                }
                value = XMLAValue.valueOf(stringValue, valueType);
            }
            member.setProperty(propertyInfo, value);
        }
        return member;
    }

    private XMLAMember consumeMember(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        XMLADataset.HierarchyInfo hierarchyInfo;
        AxesHandler.assertAtStartElement(reader, "Member");
        String hierarchyName = reader.getAttributeValue(null, "Hierarchy");
        if (null == hierarchyName) {
            AxesHandler.throwMissingAttributeException("Member", "Hierarchy");
        }
        if (null == (hierarchyInfo = axisInfo.getHierarchy(hierarchyName))) {
            AxesHandler.throwUnknownHierarchyException(hierarchyName);
        }
        return this.consumeMember(reader, hierarchyInfo);
    }

    public static void throwUnknownAxisException(String axisName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.XMA_UNKNOWN_AXIS, axisName);
    }

    public static void throwUnknownHierarchyException(String hierarchyName) throws XMLAException {
        throw new XMLAException(XMLAMessageKeys.XMA_UNKNOWN_HIERARCHY, hierarchyName);
    }
}

