/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.parser.xmla;

import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.DatasetAwareComponentHandler;
import com.cognos.xqe.data.providers.olap.xmla.parser.xmla.IPropertyFilter;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.util.xml.stax.ChildElementIterator;
import com.cognos.xqe.util.xml.stax.StaxUtil;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class OlapInfoHandler
extends DatasetAwareComponentHandler {
    private static final String[] OLAP_INFO_CHILDREN = new String[]{"CubeInfo", "AxesInfo", "CellInfo"};
    private boolean consumedOlapInfo = false;
    private String cubeName = null;
    private IPropertyFilter hierarchyPropertyFilter = null;
    private IPropertyFilter cellPropertyFilter = null;
    private final int expectedEdgeCount;

    public OlapInfoHandler() {
        this.expectedEdgeCount = 0;
    }

    public OlapInfoHandler(int nExpectedEdges) {
        this.expectedEdgeCount = nExpectedEdges;
    }

    public boolean hasConsumedOlapInfo() {
        return this.consumedOlapInfo;
    }

    public String getCubeName() {
        return this.cubeName;
    }

    public void setHierarchyPropertyFilter(IPropertyFilter theHierarchyPropertyFilter) {
        this.hierarchyPropertyFilter = theHierarchyPropertyFilter;
    }

    public void setCellPropertyFilter(IPropertyFilter theCellPropertyFilter) {
        this.cellPropertyFilter = theCellPropertyFilter;
    }

    private boolean canRetainHierarchyProperty(String propertyName) {
        return null == this.hierarchyPropertyFilter || this.hierarchyPropertyFilter.canRetain(propertyName);
    }

    private boolean canRetainCellProperty(String propertyName) {
        return null == this.cellPropertyFilter || this.cellPropertyFilter.canRetain(propertyName);
    }

    @Override
    protected void releaseImpl() {
        this.setDataset(null);
        this.cubeName = null;
        this.hierarchyPropertyFilter = null;
        this.cellPropertyFilter = null;
    }

    @Override
    protected void resetImpl() {
        this.consumedOlapInfo = false;
        this.cubeName = null;
    }

    public void consume(XMLStreamReader reader) throws XMLStreamException {
        OlapInfoHandler.assertAtStartElement(reader, "OlapInfo");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"CubeInfo")) {
                this.consumeCubeInfo(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"AxesInfo")) {
                this.consumeAxesInfo(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"CellInfo")) {
                this.consumeCellInfo(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            OlapInfoHandler.throwUnexpectedElementException(OLAP_INFO_CHILDREN, reader.getLocalName());
        }
        this.consumedOlapInfo = true;
    }

    private void consumeCubeInfo(XMLStreamReader reader) throws XMLStreamException {
        OlapInfoHandler.assertAtStartElement(reader, "CubeInfo");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Cube")) {
                StaxUtil.moveToElement((XMLStreamReader)reader, (String)"CubeName");
                reader.require(1, null, "CubeName");
                this.cubeName = reader.getElementText();
                reader.require(2, null, "CubeName");
                StaxUtil.moveToEndElement((XMLStreamReader)reader, (String)"Cube");
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            OlapInfoHandler.throwUnexpectedElementException("Cube", reader.getLocalName());
        }
    }

    private void consumeAxesInfo(XMLStreamReader reader) throws XMLStreamException {
        OlapInfoHandler.assertAtStartElement(reader, "AxesInfo");
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"AxisInfo")) {
                this.consumeAxisInfo(reader);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            OlapInfoHandler.throwUnexpectedElementException("AxisInfo", reader.getLocalName());
        }
    }

    private void consumeAxisInfo(XMLStreamReader reader) throws XMLStreamException {
        OlapInfoHandler.assertAtStartElement(reader, "AxisInfo");
        XMLALogContext.get().incrementAxisCount();
        if (this.expectedEdgeCount > 0 && this.dataset.getAxesInfo().numAxes() == this.expectedEdgeCount) {
            StaxUtil.skipElement((XMLStreamReader)reader);
            return;
        }
        String axisName = reader.getAttributeValue(null, "name");
        XMLADataset.AxisInfo axisInfo = this.dataset.getAxesInfo().addAxis(axisName);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"HierarchyInfo")) {
                this.consumeHierarchyInfo(reader, axisInfo);
                continue;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            OlapInfoHandler.throwUnexpectedElementException("HierarchyInfo", reader.getLocalName());
        }
    }

    private void consumeHierarchyInfo(XMLStreamReader reader, XMLADataset.AxisInfo axisInfo) throws XMLStreamException {
        OlapInfoHandler.assertAtStartElement(reader, "HierarchyInfo");
        String hierarchyName = reader.getAttributeValue(null, "name");
        XMLADataset.HierarchyInfo hierarchyInfo = axisInfo.addHierarchy(hierarchyName);
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            String tagName = reader.getLocalName();
            String propertyName = reader.getAttributeValue(null, "name");
            XMLAValue defaultValue = null;
            if (!this.canRetainHierarchyProperty(propertyName)) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                continue;
            }
            reader.nextTag();
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Default")) {
                defaultValue = XMLAValue.valueOf(reader.getElementText(), ValueTypeEnum.UNKNOWN);
                reader.require(2, null, "Default");
                StaxUtil.moveToEndElement((XMLStreamReader)reader, (String)tagName);
                reader.require(2, null, tagName);
            } else if (StaxUtil.testOnStartElement((XMLStreamReader)reader)) {
                OlapInfoHandler.throwUnexpectedElementException("Default", reader.getLocalName());
            }
            if (null != defaultValue) {
                hierarchyInfo.associateTagToProperty(tagName, propertyName, defaultValue);
                continue;
            }
            hierarchyInfo.associateTagToProperty(tagName, propertyName);
        }
    }

    private void consumeCellInfo(XMLStreamReader reader) throws XMLStreamException {
        OlapInfoHandler.assertAtStartElement(reader, "CellInfo");
        XMLADataset.CellInfo cellInfo = this.dataset.getCellInfo();
        ChildElementIterator childIter = new ChildElementIterator(reader);
        while (childIter.next()) {
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            String tagName = reader.getLocalName();
            String propertyName = reader.getAttributeValue(null, "name");
            XMLAValue defaultValue = null;
            if (!this.canRetainCellProperty(propertyName)) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                continue;
            }
            reader.nextTag();
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Exception")) {
                StaxUtil.skipElement((XMLStreamReader)reader);
                childIter.skipToEnd();
                break;
            }
            if (StaxUtil.testOnStartElement((XMLStreamReader)reader, (String)"Default")) {
                defaultValue = XMLAValue.valueOf(reader.getElementText(), ValueTypeEnum.UNKNOWN);
                reader.require(2, null, "Default");
                StaxUtil.moveToEndElement((XMLStreamReader)reader, (String)tagName);
                reader.require(2, null, tagName);
            } else if (StaxUtil.testOnStartElement((XMLStreamReader)reader)) {
                OlapInfoHandler.throwUnexpectedElementException("Default", reader.getLocalName());
            }
            if (null != defaultValue) {
                cellInfo.associateTagToProperty(tagName, propertyName, defaultValue);
                continue;
            }
            cellInfo.associateTagToProperty(tagName, propertyName);
        }
    }
}

