/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import java.io.IOException;
import java.io.InputStream;

public final class ByteCountingInputStream
extends InputStream {
    private final InputStream sourceStream;
    private long byteCount = 0L;

    public ByteCountingInputStream(InputStream theSource) {
        this.sourceStream = theSource;
    }

    public long getByteCount() {
        return this.byteCount;
    }

    @Override
    public int read() throws IOException {
        int result = this.sourceStream.read();
        if (result != -1) {
            ++this.byteCount;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result = this.sourceStream.read(b, off, len);
        if (result > 0) {
            this.byteCount += (long)result;
        }
        return result;
    }

    @Override
    public int available() throws IOException {
        return this.sourceStream.available();
    }

    @Override
    public void close() throws IOException {
        XMLALogContext.get().setResponseSize(this.byteCount);
        this.sourceStream.close();
    }
}

