/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.olap.xmla.XMLAException;
import com.cognos.xqe.data.providers.olap.xmla.XMLALog;
import com.cognos.xqe.data.providers.olap.xmla.XMLALogContext;
import com.cognos.xqe.data.providers.olap.xmla.XMLAMessageKeys;
import com.cognos.xqe.data.providers.olap.xmla.query.ByteCountingInputStream;
import com.cognos.xqe.data.providers.olap.xmla.query.QueryBase;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.trace.LogLevel;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.StatusLine;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;

public abstract class HTTPPostQuery
extends QueryBase {
    private HttpClient httpClient = null;
    private String contextPath = null;
    private boolean useCompression = false;
    private final PostMethod httpMethod = new PostMethod();
    private final HttpMethodParams httpMethodParams = this.httpMethod.getParams();
    private StatusLine lastHttpStatus = null;

    public final HttpClient getHttpClient() {
        return this.httpClient;
    }

    public final HttpMethodParams getHttpMethodParams() {
        return this.httpMethodParams;
    }

    public final PostMethod getHttpMethod() {
        return this.httpMethod;
    }

    public final String getContextPath() {
        return this.contextPath;
    }

    public final boolean canUseCompression() {
        return this.useCompression;
    }

    public final StatusLine getLastHttpStatus() {
        return this.lastHttpStatus;
    }

    public final void setHttpClient(HttpClient theHttpClient) {
        this.httpClient = theHttpClient;
    }

    public final void setContextPath(String theContextPath) {
        this.contextPath = theContextPath;
    }

    public final void setUseCompression(boolean canUseCompression) {
        this.useCompression = canUseCompression;
    }

    @Override
    protected void cancelImpl() throws Throwable {
        try {
            this.httpMethod.abort();
        }
        finally {
            this.httpMethod.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void executeImpl() throws OperationCanceledException {
        if (null == this.httpClient) {
            throw new IllegalStateException("HttpClient was null.");
        }
        this.lastHttpStatus = null;
        try {
            this.setupPostMethod(this.httpMethod);
            if (null != this.contextPath) {
                this.httpMethod.setPath(this.contextPath);
            }
            if (this.canUseCompression()) {
                this.httpMethod.setRequestHeader(new Header("Accept-Encoding", "gzip, deflate"));
            }
            XMLALog.logHttpState(this.httpClient.getState());
            XMLALog.logBeforeHttpPost(this.httpMethod, this.httpClient.getHostConfiguration());
            this.checkCancelRequested();
            this.httpMethod.setRequestEntity(this.createRequestEntity());
            int retryCount = 2;
            while (retryCount >= 0) {
                try {
                    long startTime = System.currentTimeMillis();
                    this.httpClient.executeMethod((HttpMethod)this.httpMethod);
                    this.lastHttpStatus = this.httpMethod.getStatusLine();
                    XMLALogContext.get().setFirstResponseTime(System.currentTimeMillis() - startTime);
                    break;
                }
                catch (IOException ex) {
                    this.getListeners().onError(this, ex);
                    if (--retryCount <= 0) {
                        throw ex;
                    }
                    XMLALog.getLogger().log(LogLevel.WARN, "Retrying query ...");
                }
            }
            XMLALog.logAfterHttpPost(this.httpMethod);
            XMLALog.logHttpState(this.httpClient.getState());
            this.checkCancelRequested();
            this.handleHttpStatusLine(this.lastHttpStatus);
            InputStream responseStream = this.prepareResponseStream(this.httpMethod.getResponseBodyAsStream());
            try {
                this.handleHttpResponseBody(responseStream);
            }
            finally {
                block29: {
                    try {
                        responseStream.close();
                    }
                    catch (IOException ex) {
                        if (!XMLALog.isOn(LogLevel.ERROR)) break block29;
                        XMLALog.getLogger().log(LogLevel.ERROR, "Error closing response stream: ", (Throwable)ex);
                    }
                }
            }
        }
        catch (XQERuntimeException ex) {
            this.checkCancelRequested();
            throw ex;
        }
        catch (XMLStreamException ex) {
            this.checkCancelRequested();
            throw new XMLAException(XMLAMessageKeys.CON_IO_ERROR, ex);
        }
        catch (IOException ex) {
            this.checkCancelRequested();
            throw new XMLAException(XMLAMessageKeys.CON_IO_ERROR, ex);
        }
        catch (IllegalStateException ex) {
            if (ex.getMessage().contains("Method has been aborted")) {
                this.checkCancelRequested();
            }
            throw new XMLAException(XMLAMessageKeys.CON_IO_ERROR, ex);
        }
        catch (Throwable ex) {
            this.checkCancelRequested();
            throw new XMLAException(XMLAMessageKeys.CON_IO_ERROR, ex);
        }
        finally {
            block30: {
                try {
                    this.httpMethod.releaseConnection();
                }
                catch (Exception ex) {
                    if (!XMLALog.isOn(LogLevel.ERROR)) break block30;
                    XMLALog.getLogger().log(LogLevel.ERROR, (Throwable)ex);
                }
            }
        }
    }

    @Override
    protected void releaseImpl() throws Throwable {
    }

    protected abstract void setupPostMethod(PostMethod var1);

    protected abstract RequestEntity createRequestEntity() throws Throwable;

    protected abstract void handleHttpStatusLine(StatusLine var1) throws Throwable;

    protected abstract void handleHttpResponseBody(InputStream var1) throws Throwable;

    protected InputStream prepareResponseStream(InputStream responseStream) throws IOException {
        InputStream result = responseStream;
        Header contentEncoding = this.httpMethod.getResponseHeader("Content-Encoding");
        if (null != contentEncoding) {
            if (contentEncoding.getValue().contains("gzip")) {
                result = new GZIPInputStream(result);
            } else if (contentEncoding.getValue().contains("deflate")) {
                result = new InflaterInputStream(result);
            }
        }
        if (XMLALog.isOn("Metrics", LogLevel.TRACE)) {
            result = new ByteCountingInputStream(result);
        }
        return result;
    }
}

