/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.query;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.olap.xmla.query.IQueryListener;
import com.cognos.xqe.data.providers.olap.xmla.query.QueryBase;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.util.LinkedList;
import java.util.List;

public final class QueryListenerList
implements IQueryListener {
    private final List<IQueryListener> listeners = new LinkedList<IQueryListener>();
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"XMLA", (String)"Exception", (LogLevel)LogLevel.ERROR);

    public synchronized void addListener(IQueryListener theListener) {
        this.listeners.add(theListener);
    }

    public synchronized boolean removeListener(IQueryListener theListener) {
        return this.listeners.remove(theListener);
    }

    @Override
    public synchronized void onCancelBegin(QueryBase theQuery) {
        for (IQueryListener listener : this.listeners) {
            try {
                listener.onCancelBegin(theQuery);
            }
            catch (Exception ex) {
                this.logger.log(LogLevel.ERROR, "Error caught from IQueryListener.onCancelBegin(): ", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void onCancelEnd(QueryBase theQuery) {
        for (IQueryListener listener : this.listeners) {
            try {
                listener.onCancelEnd(theQuery);
            }
            catch (Exception ex) {
                this.logger.log(LogLevel.ERROR, "Error caught from IQueryListener.onCancelEnd(): ", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void onExecuteBegin(QueryBase theQuery) {
        for (IQueryListener listener : this.listeners) {
            try {
                listener.onExecuteBegin(theQuery);
            }
            catch (Exception ex) {
                this.logger.log(LogLevel.ERROR, "Error caught from IQueryListener.onExecuteBegin(): ", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void onExecuteEnd(QueryBase theQuery) {
        for (IQueryListener listener : this.listeners) {
            try {
                listener.onExecuteEnd(theQuery);
            }
            catch (Exception ex) {
                this.logger.log(LogLevel.ERROR, "Error caught from IQueryListener.onExecuteEnd(): ", (Throwable)ex);
            }
        }
    }

    @Override
    public synchronized void onError(QueryBase theQuery, Throwable theError) {
        for (IQueryListener listener : this.listeners) {
            try {
                listener.onError(theQuery, theError);
            }
            catch (Exception ex) {
                this.logger.log(LogLevel.ERROR, "Error caught from IQueryListener.onError(): ", (Throwable)ex);
            }
        }
    }
}

