/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.AbstractTupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLATuple;
import java.util.Collection;

public final class UnionTupleSet
extends AbstractTupleSet {
    private static final String NEWLINE = "\n";
    private final ITupleSet[] sets;
    private final int tupleCount;

    public UnionTupleSet(ITupleSet[] theSets) {
        this.sets = theSets;
        int count = 0;
        for (ITupleSet set : this.sets) {
            count += set.size();
        }
        this.tupleCount = count;
    }

    public UnionTupleSet(Collection<? extends ITupleSet> theSets) {
        this(theSets.toArray(new ITupleSet[0]));
    }

    @Override
    public XMLATuple get(int index) throws IndexOutOfBoundsException {
        this.checkBounds(index);
        XMLATuple result = null;
        int count = 0;
        for (ITupleSet set : this.sets) {
            if (index < count + set.size()) {
                result = set.get(index - count);
                break;
            }
            count += set.size();
        }
        return result;
    }

    @Override
    public int size() {
        return this.tupleCount;
    }

    public void release() {
        for (int i = 0; i < this.sets.length; ++i) {
            this.sets[i] = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("UnionTupleSet{");
        for (int i = 0; i < this.size(); ++i) {
            sb.append(NEWLINE).append(this.get(i));
        }
        sb.append(NEWLINE).append('}');
        return sb.toString();
    }
}

