/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.ITupleSet;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLACell;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAPropertyInfo;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.util.IReleasable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class XMLADataset
implements IReleasable {
    public static final String EMPTY_STRING = "";
    public static final String NAME = "name";
    public static final String ORDINAL = "ordinal";
    public static final String NUM_AXES = "numAxes";
    private AxesInfo axesInfo = new AxesInfo();
    private CellInfo cellInfo = new CellInfo();
    private List<Axis> axisList = new ArrayList<Axis>();
    private SortedMap<Integer, XMLACell> cellMap = new TreeMap<Integer, XMLACell>();
    private int numCoordinates = -1;
    private BitSet nullStateMap = null;

    public AxesInfo getAxesInfo() {
        return this.axesInfo;
    }

    public CellInfo getCellInfo() {
        return this.cellInfo;
    }

    public int numAxes() {
        return this.getAxesInfo().numAxes();
    }

    public Axis addAxis(String axisName, ITupleSet tupleSet) {
        AxisInfo axisInfo = this.axesInfo.getAxisInfo(axisName);
        if (null == axisInfo) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Unknown axis: " + axisName);
        }
        Axis result = new Axis(axisInfo, tupleSet);
        this.axisList.add(result);
        return result;
    }

    public Axis getAxis(int axisOrdinal) {
        return this.axisList.get(axisOrdinal);
    }

    public Axis getAxis(String axisName) {
        for (Axis axis : this.axisList) {
            if (!axis.getName().equals(axisName)) continue;
            return axis;
        }
        return null;
    }

    public int numCoordinates() {
        if (this.numCoordinates < 0) {
            if (0 == this.axesInfo.numAxes() || this.axisList.isEmpty()) {
                this.numCoordinates = 0;
                return this.numCoordinates;
            }
            this.numCoordinates = 1;
            for (Axis axis : this.axisList) {
                this.numCoordinates = (int)((long)this.numCoordinates * axis.numTuples());
            }
        }
        return this.numCoordinates;
    }

    public XMLACell getCell(int currentOrdinal) {
        return (XMLACell)this.cellMap.get(currentOrdinal);
    }

    public Iterator<XMLACell> cellIterator() {
        return Collections.unmodifiableCollection(this.cellMap.values()).iterator();
    }

    public void putCell(XMLACell cell) {
        this.cellMap.put(cell.getOrdinal(), cell);
    }

    public BitSet getNullStateMap() {
        if (null == this.nullStateMap) {
            this.nullStateMap = new BitSet(this.numCoordinates());
            for (XMLACell c : this.cellMap.values()) {
                this.nullStateMap.set(c.getOrdinal());
            }
        }
        return this.nullStateMap;
    }

    public void release() {
        if (null != this.axesInfo) {
            this.axesInfo.release();
            this.axesInfo = null;
        }
        if (null != this.cellInfo) {
            this.cellInfo.release();
            this.cellInfo = null;
        }
        if (null != this.axisList) {
            for (Axis axis : this.axisList) {
                axis.release();
            }
            this.axisList.clear();
            this.axisList = null;
        }
        if (null != this.cellMap) {
            this.cellMap.clear();
            this.cellMap = null;
        }
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLADataset");
        this.getAxesInfo().dumpXML(writer);
        this.getCellInfo().dumpXML(writer);
        writer.writeStartElement("Axes");
        writer.writeAttribute(NUM_AXES, Integer.toString(this.numAxes()));
        for (Axis axis : this.axisList) {
            axis.dumpXML(writer);
        }
        writer.writeEndElement();
        writer.writeStartElement("CellData");
        writer.writeAttribute("numCoordinates", Long.toString(this.numCoordinates()));
        Iterator<XMLACell> cellIter = this.cellIterator();
        while (cellIter.hasNext()) {
            XMLACell cell = cellIter.next();
            cell.dumpXML(writer);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private XMLADataset getDatasetRef() {
        return this;
    }

    public final class Axis {
        private final AxisInfo axisInfo;
        private ITupleSet tupleSet = null;

        private Axis(AxisInfo theAxisInfo, ITupleSet theTupleSet) {
            this.axisInfo = theAxisInfo;
            this.tupleSet = theTupleSet;
        }

        public AxisInfo getAxisInfo() {
            return this.axisInfo;
        }

        public int getOrdinal() {
            return this.axisInfo.getOrdinal();
        }

        public String getName() {
            return this.axisInfo.getName();
        }

        public long numTuples() {
            return this.tupleSet.size();
        }

        public ITupleSet getTupleSet() {
            return this.tupleSet;
        }

        public void release() {
            this.tupleSet = null;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Axis)) {
                return false;
            }
            Axis otherAxis = (Axis)other;
            return this.axisInfo == otherAxis.axisInfo;
        }

        public int hashCode() {
            return this.axisInfo.hashCode();
        }

        public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("Axis");
            writer.writeAttribute(XMLADataset.ORDINAL, Integer.toString(this.getOrdinal()));
            writer.writeAttribute(XMLADataset.NAME, this.getName());
            this.getTupleSet().dumpXML(writer);
            writer.writeEndElement();
        }
    }

    public final class CellInfo {
        private Map<String, XMLAPropertyInfo> nameToPropertyMap = new TreeMap<String, XMLAPropertyInfo>();
        private Map<String, XMLAPropertyInfo> tagToPropertyMap = new TreeMap<String, XMLAPropertyInfo>();

        private CellInfo() {
        }

        public void associateTagToProperty(String tagName, String propertyName) {
            XMLAPropertyInfo propertyInfo = new XMLAPropertyInfo(propertyName, null, this.tagToPropertyMap.size());
            this.tagToPropertyMap.put(tagName, propertyInfo);
            this.nameToPropertyMap.put(propertyName, propertyInfo);
        }

        public void associateTagToProperty(String tagName, String propertyName, XMLAValue defaultValue) {
            XMLAPropertyInfo propertyInfo = new XMLAPropertyInfo(propertyName, defaultValue, this.tagToPropertyMap.size());
            this.tagToPropertyMap.put(tagName, propertyInfo);
            this.nameToPropertyMap.put(propertyName, propertyInfo);
        }

        public XMLAPropertyInfo[] getProperties() {
            return this.nameToPropertyMap.values().toArray(new XMLAPropertyInfo[0]);
        }

        public XMLAPropertyInfo propertyFromName(String propertyName) {
            return this.nameToPropertyMap.get(propertyName);
        }

        public XMLAPropertyInfo propertyFromTag(String tagName) {
            return this.tagToPropertyMap.get(tagName);
        }

        public int numProperties() {
            return this.nameToPropertyMap.size();
        }

        public void clearTagMappings() {
            this.tagToPropertyMap.clear();
            this.tagToPropertyMap = null;
        }

        public void clearStringPools() {
            for (XMLAPropertyInfo propInfo : this.nameToPropertyMap.values()) {
                propInfo.getStringPool().clear();
            }
        }

        public void release() {
            if (null != this.tagToPropertyMap) {
                this.tagToPropertyMap.clear();
                this.tagToPropertyMap = null;
            }
            if (null != this.nameToPropertyMap) {
                this.nameToPropertyMap.clear();
                this.nameToPropertyMap = null;
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CellInfo)) {
                return false;
            }
            CellInfo otherCellInfo = (CellInfo)other;
            return this.getDataset() == otherCellInfo.getDataset();
        }

        public int hashCode() {
            return this.getDataset().hashCode();
        }

        public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("CellInfo");
            for (XMLAPropertyInfo propInfo : this.getProperties()) {
                propInfo.dumpXML(writer);
            }
            writer.writeEndElement();
        }

        private XMLADataset getDataset() {
            return XMLADataset.this.getDatasetRef();
        }
    }

    public final class HierarchyInfo {
        private AxisInfo axis = null;
        private String name = "";
        private int ordinal = 0;
        private Map<String, XMLAPropertyInfo> nameToPropertyMap = new TreeMap<String, XMLAPropertyInfo>();
        private Map<String, XMLAPropertyInfo> tagToPropertyMap = new TreeMap<String, XMLAPropertyInfo>();

        private HierarchyInfo(AxisInfo theAxis, String theName, int theOrdinal) {
            this.axis = theAxis;
            this.name = theName;
            this.ordinal = theOrdinal;
        }

        public AxisInfo getAxis() {
            return this.axis;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public void associateTagToProperty(String tagName, String propertyName) {
            this.associateTagToProperty(tagName, propertyName, null);
        }

        public void associateTagToProperty(String tagName, String propertyName, XMLAValue defaultValue) {
            XMLAPropertyInfo propertyInfo = this.nameToPropertyMap.get(propertyName);
            if (null == propertyInfo) {
                propertyInfo = new XMLAPropertyInfo(propertyName, defaultValue, this.nameToPropertyMap.size());
                this.nameToPropertyMap.put(propertyName, propertyInfo);
            }
            this.tagToPropertyMap.put(tagName, propertyInfo);
        }

        public XMLAPropertyInfo[] getProperties() {
            return this.nameToPropertyMap.values().toArray(new XMLAPropertyInfo[0]);
        }

        public XMLAPropertyInfo propertyFromName(String propertyName) {
            XMLAPropertyInfo property = this.nameToPropertyMap.get(propertyName);
            if (property != null) {
                return property;
            }
            for (XMLAPropertyInfo p : this.nameToPropertyMap.values()) {
                if (!p.getUnqualifiedName().equals(propertyName)) continue;
                return p;
            }
            return null;
        }

        public XMLAPropertyInfo propertyFromTag(String tagName) {
            return this.tagToPropertyMap.get(tagName);
        }

        public int numProperties() {
            return this.nameToPropertyMap.size();
        }

        public void clearTagMappings() {
            this.tagToPropertyMap.clear();
            this.tagToPropertyMap = null;
        }

        public void clearStringPools() {
            for (XMLAPropertyInfo propInfo : this.nameToPropertyMap.values()) {
                propInfo.getStringPool().clear();
            }
        }

        public void release() {
            this.axis = null;
            this.name = null;
            if (null != this.tagToPropertyMap) {
                this.tagToPropertyMap.clear();
                this.tagToPropertyMap = null;
            }
            if (null != this.nameToPropertyMap) {
                this.nameToPropertyMap.clear();
                this.nameToPropertyMap = null;
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HierarchyInfo)) {
                return false;
            }
            HierarchyInfo otherHierInfo = (HierarchyInfo)other;
            if (this.axis != otherHierInfo.axis) {
                return false;
            }
            return this.ordinal == otherHierInfo.ordinal;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.axis);
            hcb.append(this.ordinal);
            return hcb.toHashCode();
        }

        public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("HierarchyInfo");
            writer.writeAttribute(XMLADataset.ORDINAL, Integer.toString(this.getOrdinal()));
            writer.writeAttribute(XMLADataset.NAME, this.getName());
            for (XMLAPropertyInfo propInfo : this.getProperties()) {
                propInfo.dumpXML(writer);
            }
            writer.writeEndElement();
        }
    }

    public final class AxisInfo {
        private String name = "";
        private int ordinal = 0;
        private List<HierarchyInfo> hierarchies = new ArrayList<HierarchyInfo>();

        private AxisInfo(String theName, int theOrdinal) {
            this.name = theName;
            this.ordinal = theOrdinal;
        }

        public String getName() {
            return this.name;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public int numHierarchies() {
            return this.hierarchies.size();
        }

        public HierarchyInfo addHierarchy(String hierarchyName) {
            HierarchyInfo result = new HierarchyInfo(this, hierarchyName, this.hierarchies.size());
            this.hierarchies.add(result);
            return result;
        }

        public HierarchyInfo[] getHierarchies() {
            return this.hierarchies.toArray(new HierarchyInfo[0]);
        }

        public HierarchyInfo getHierarchy(int hierarchyOrdinal) {
            return this.hierarchies.get(hierarchyOrdinal);
        }

        public HierarchyInfo getHierarchy(String hierarchyName) {
            for (HierarchyInfo info : this.hierarchies) {
                if (!info.getName().equals(hierarchyName)) continue;
                return info;
            }
            return null;
        }

        public void clearTempHierarchyData() {
            for (HierarchyInfo hierInfo : this.hierarchies) {
                hierInfo.clearTagMappings();
                hierInfo.clearStringPools();
            }
        }

        public void release() {
            this.name = null;
            if (null != this.hierarchies) {
                this.hierarchies.clear();
                this.hierarchies = null;
            }
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AxisInfo)) {
                return false;
            }
            AxisInfo otherAxisInfo = (AxisInfo)other;
            if (this.getDataset() != otherAxisInfo.getDataset()) {
                return false;
            }
            return this.ordinal == otherAxisInfo.ordinal;
        }

        public int hashCode() {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object)this.getDataset());
            hcb.append(this.ordinal);
            return hcb.toHashCode();
        }

        public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("AxisInfo");
            writer.writeAttribute(XMLADataset.ORDINAL, Integer.toString(this.getOrdinal()));
            writer.writeAttribute(XMLADataset.NAME, this.getName());
            writer.writeAttribute("numHierarchies", Integer.toString(this.numHierarchies()));
            for (int hierarchyOrdinal = 0; hierarchyOrdinal < this.numHierarchies(); ++hierarchyOrdinal) {
                HierarchyInfo hierInfo = this.getHierarchy(hierarchyOrdinal);
                hierInfo.dumpXML(writer);
            }
            writer.writeEndElement();
        }

        private XMLADataset getDataset() {
            return XMLADataset.this.getDatasetRef();
        }
    }

    public final class AxesInfo {
        private List<AxisInfo> axisInfoList = new ArrayList<AxisInfo>();

        private AxesInfo() {
        }

        public int numAxes() {
            return this.axisInfoList.size();
        }

        public AxisInfo addAxis(String name) {
            AxisInfo result = new AxisInfo(name, this.axisInfoList.size());
            this.axisInfoList.add(result);
            return result;
        }

        public AxisInfo getAxisInfo(int ordinal) {
            return this.axisInfoList.get(ordinal);
        }

        public AxisInfo getAxisInfo(String name) {
            for (AxisInfo info : this.axisInfoList) {
                if (!info.getName().equals(name)) continue;
                return info;
            }
            return null;
        }

        public void release() {
            if (null != this.axisInfoList) {
                for (AxisInfo info : this.axisInfoList) {
                    info.release();
                }
                this.axisInfoList.clear();
                this.axisInfoList = null;
            }
        }

        public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
            writer.writeStartElement("AxesInfo");
            writer.writeAttribute(XMLADataset.NUM_AXES, Integer.toString(this.numAxes()));
            for (int axisOrdinal = 0; axisOrdinal < this.numAxes(); ++axisOrdinal) {
                AxisInfo axisInfo = this.getAxisInfo(axisOrdinal);
                axisInfo.dumpXML(writer);
            }
            writer.writeEndElement();
        }
    }
}

