/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLARowset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAValue;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class XMLARow {
    private final XMLARowset rowset;
    private XMLAValue[] columnValues = null;

    public XMLARow(XMLARowset theRowset) {
        this.rowset = theRowset;
        this.columnValues = new XMLAValue[theRowset.numColumns()];
    }

    public int numStoredColumns() {
        return this.columnValues.length;
    }

    public XMLAValue getValue(int columnOrdinal) {
        if (columnOrdinal < 0 || columnOrdinal >= this.numStoredColumns() || null == this.columnValues[columnOrdinal]) {
            return XMLAValue.NULL_UNKNOWN;
        }
        return this.columnValues[columnOrdinal];
    }

    public void setValue(int columnOrdinal, XMLAValue value) throws IndexOutOfBoundsException {
        if (columnOrdinal < 0 || columnOrdinal >= this.rowset.numColumns()) {
            throw new IndexOutOfBoundsException();
        }
        if (columnOrdinal >= this.numStoredColumns()) {
            this.resize(columnOrdinal + 1);
        }
        this.columnValues[columnOrdinal] = value;
    }

    private void resize(int capacity) {
        XMLAValue[] oldColumnValues = this.columnValues;
        this.columnValues = new XMLAValue[capacity];
        System.arraycopy(oldColumnValues, 0, this.columnValues, 0, oldColumnValues.length);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int numCols = this.numStoredColumns();
        sb.append("<row>\n");
        for (int col = 0; col < numCols; ++col) {
            String columnName = this.rowset.getColumnName(col);
            XMLAValue columnValue = this.getValue(col);
            sb.append("\t<");
            if (columnValue.isNull()) {
                sb.append(columnName).append("/>\n");
                continue;
            }
            sb.append(columnName).append(">");
            sb.append(columnValue.toString());
            sb.append("</").append(columnName).append(">\n");
        }
        sb.append("</row>");
        return sb.toString();
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLARow");
        for (int ordinal = 0; ordinal < this.rowset.numColumns(); ++ordinal) {
            XMLAValue value = this.getValue(ordinal);
            writer.writeStartElement(this.rowset.getColumnName(ordinal));
            value.dumpXML(writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

