/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLADataset;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAMember;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class XMLATuple {
    private final XMLAMember[] members;
    private int cachedHashCode = Integer.MIN_VALUE;

    public XMLATuple(XMLAMember theMember) {
        this(new XMLAMember[]{theMember});
    }

    public XMLATuple(XMLAMember[] theMembers) {
        this.members = theMembers;
    }

    public XMLATuple(Collection<XMLAMember> theMembers) {
        this(theMembers.toArray(new XMLAMember[0]));
    }

    public int cardinality() {
        return this.members.length;
    }

    public boolean containsHierarchy(String hierarchyName) {
        for (XMLAMember member : this.members) {
            if (!member.getHierarchyInfo().getName().equals(hierarchyName)) continue;
            return true;
        }
        return false;
    }

    public XMLADataset.HierarchyInfo[] getHierarchies() {
        XMLADataset.HierarchyInfo[] result = new XMLADataset.HierarchyInfo[this.size()];
        int i = 0;
        for (XMLAMember member : this.members) {
            result[i++] = member.getHierarchyInfo();
        }
        return result;
    }

    public XMLAMember getMember(String hierarchyName) {
        for (XMLAMember member : this.members) {
            if (!member.getHierarchyInfo().getName().equals(hierarchyName)) continue;
            return member;
        }
        return null;
    }

    public XMLAMember getMember(int index) {
        return this.members[index];
    }

    public int size() {
        return this.members.length;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof XMLATuple)) {
            return false;
        }
        XMLATuple otherTuple = (XMLATuple)other;
        EqualsBuilder eb = new EqualsBuilder();
        eb.append((Object[])this.members, (Object[])otherTuple.members);
        return eb.isEquals();
    }

    public int hashCode() {
        if (Integer.MIN_VALUE == this.cachedHashCode) {
            HashCodeBuilder hcb = new HashCodeBuilder();
            hcb.append((Object[])this.members);
            this.cachedHashCode = hcb.toHashCode();
            if (Integer.MIN_VALUE == this.cachedHashCode) {
                this.cachedHashCode = 0;
            }
        }
        return this.cachedHashCode;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("XMLATuple[");
        if (this.members.length > 0) {
            sb.append(this.members[0]);
            for (int i = 1; i < this.members.length; ++i) {
                sb.append(", ").append(this.members[i]);
            }
        }
        sb.append(']');
        return sb.toString();
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLATuple");
        writer.writeAttribute("size", Integer.toString(this.size()));
        for (XMLAMember member : this.members) {
            member.dumpXML(writer);
        }
        writer.writeEndElement();
    }
}

