/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.xmla.resultsets;

import com.cognos.xqe.data.providers.olap.xmla.resultsets.ValueTypeEnum;
import com.cognos.xqe.data.providers.olap.xmla.resultsets.XMLAErrorValue;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.TimeWithTZValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.builder.HashCodeBuilder;

public final class XMLAValue {
    public static final XMLAValue NULL_UNKNOWN = new XMLAValue(ValueTypeEnum.UNKNOWN);
    public static final XMLAValue NULL_VARIANT = new XMLAValue(ValueTypeEnum.VARIANT);
    public static final XMLAValue NULL_STRING = new XMLAValue(ValueTypeEnum.STRING);
    public static final XMLAValue NULL_BOOLEAN = new XMLAValue(ValueTypeEnum.BOOLEAN);
    public static final XMLAValue NULL_INT16 = new XMLAValue(ValueTypeEnum.INT16);
    public static final XMLAValue NULL_INT32 = new XMLAValue(ValueTypeEnum.INT32);
    public static final XMLAValue NULL_INT64 = new XMLAValue(ValueTypeEnum.INT64);
    public static final XMLAValue NULL_BIG_INTEGER = new XMLAValue(ValueTypeEnum.BIG_INTEGER);
    public static final XMLAValue NULL_FLOAT32 = new XMLAValue(ValueTypeEnum.FLOAT32);
    public static final XMLAValue NULL_FLOAT64 = new XMLAValue(ValueTypeEnum.FLOAT64);
    public static final XMLAValue NULL_BIG_DECIMAL = new XMLAValue(ValueTypeEnum.BIG_DECIMAL);
    public static final XMLAValue NULL_TIME_WITH_TZ = new XMLAValue(ValueTypeEnum.TIME_WITH_TZ);
    public static final XMLAValue NULL_DATE_WITH_TZ = new XMLAValue(ValueTypeEnum.DATE_WITH_TZ);
    public static final XMLAValue NULL_DATETIME_WITH_TZ = new XMLAValue(ValueTypeEnum.DATETIME_WITH_TZ);
    private static final String TRUE_UCASE = "TRUE";
    private static final String TRUE_LCASE = "true";
    private static final String ONE = "1";
    private static final String INDETERMINATE_FORM = "-1.#IND";
    private static final String NAN = "NaN";
    private static final String NAN2 = "NAN";
    private static final String SNAN = "1.#SNAN";
    private static final String QNAN = "1.#QNAN";
    private static final String POS_INFINITY = "Infinity";
    private static final String NEG_INFINITY = "-Infinity";
    private static final String POS_INF = "INF";
    private static final String NEG_INF = "-INF";
    private static final String POS_1_INF = "1.#INF";
    private static final String NEG_1_INF = "-1.#INF";
    private static final String GMT_SUFFIX = "+00:00";
    private static final String SPACE = " ";
    private static DatatypeFactory xmlSchemaTypeFactory = null;
    private ValueTypeEnum dataType;
    private StateEnum state;
    private Object value;

    private XMLAValue() {
        this.dataType = ValueTypeEnum.UNKNOWN;
        this.state = StateEnum.NULL;
        this.value = null;
    }

    private XMLAValue(ValueTypeEnum theDataType) {
        this.dataType = theDataType;
        this.state = StateEnum.NULL;
        this.value = null;
    }

    public ValueTypeEnum getDataType() {
        return this.dataType;
    }

    public boolean isNull() {
        return StateEnum.NULL == this.state;
    }

    public boolean isError() {
        return StateEnum.ERROR == this.state;
    }

    public boolean isNan() {
        if (this.isNull() || this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case FLOAT32: {
                return this.getFloat().isNaN();
            }
            case FLOAT64: {
                return this.getDouble().isNaN();
            }
        }
        return false;
    }

    public boolean isInfinity() {
        if (this.isNull() || this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case FLOAT32: {
                return this.getFloat().isInfinite();
            }
            case FLOAT64: {
                return this.getDouble().isInfinite();
            }
        }
        return false;
    }

    public boolean isPositiveInfinity() {
        if (this.isNull() || this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case FLOAT32: {
                return this.getFloat().floatValue() == Float.POSITIVE_INFINITY;
            }
            case FLOAT64: {
                return this.getDouble() == Double.POSITIVE_INFINITY;
            }
        }
        return false;
    }

    public boolean isNegativeInfinity() {
        if (this.isNull() || this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case FLOAT32: {
                return this.getFloat().floatValue() == Float.NEGATIVE_INFINITY;
            }
            case FLOAT64: {
                return this.getDouble() == Double.NEGATIVE_INFINITY;
            }
        }
        return false;
    }

    public boolean isIntegralType() {
        if (this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case INT16: 
            case INT32: 
            case INT64: 
            case BIG_INTEGER: {
                return true;
            }
        }
        return false;
    }

    public boolean isFloatingPointType() {
        if (this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case FLOAT32: 
            case FLOAT64: {
                return true;
            }
        }
        return false;
    }

    public boolean isNumericType() {
        if (this.isError()) {
            return false;
        }
        switch (this.dataType) {
            case FLOAT32: 
            case FLOAT64: 
            case INT16: 
            case INT32: 
            case INT64: 
            case BIG_INTEGER: 
            case BIG_DECIMAL: {
                return true;
            }
        }
        return false;
    }

    public XMLAErrorValue getError() {
        if (!this.isError()) {
            return null;
        }
        return (XMLAErrorValue)this.value;
    }

    public Object getValue() {
        if (this.isNull()) {
            return null;
        }
        return this.value;
    }

    public String getString() {
        if (this.isNull()) {
            return null;
        }
        if (this.isError()) {
            return this.value.toString();
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                return (String)this.value;
            }
        }
        return this.value.toString();
    }

    public Boolean getBoolean() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return XMLAValue.parseBoolean(tmpStr);
            }
            case BOOLEAN: {
                return (Boolean)this.value;
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return tmpShort != 0;
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return tmpInt != 0;
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return tmpLong != 0L;
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return tmpFloat.intValue() != 0;
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return tmpDbl.longValue() != 0L;
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return tmpBigDec.longValue() != 0L;
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return tmpBigInt.longValue() != 0L;
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.BOOLEAN);
        return null;
    }

    public Short getShort() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return XMLAValue.parseShort(tmpStr);
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return (short)1;
                }
                return (short)0;
            }
            case INT16: {
                return (Short)this.value;
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return tmpInt.shortValue();
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return tmpLong.shortValue();
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return tmpFloat.shortValue();
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return tmpDbl.shortValue();
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return tmpBigDec.shortValue();
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return tmpBigInt.shortValue();
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.INT32);
        return null;
    }

    public Integer getInteger() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return XMLAValue.parseInt(tmpStr);
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return 1;
                }
                return 0;
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return tmpShort.intValue();
            }
            case INT32: {
                return (Integer)this.value;
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return tmpLong.intValue();
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return tmpFloat.intValue();
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return tmpDbl.intValue();
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return tmpBigDec.intValue();
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return tmpBigInt.intValue();
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.INT32);
        return null;
    }

    public Long getLong() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return XMLAValue.parseLong(tmpStr);
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return 1L;
                }
                return 0L;
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return tmpShort.longValue();
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return tmpInt.longValue();
            }
            case INT64: {
                return (Long)this.value;
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return tmpFloat.longValue();
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return tmpDbl.longValue();
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return tmpBigDec.longValue();
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return tmpBigInt.longValue();
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.INT64);
        return null;
    }

    public Float getFloat() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return Float.valueOf(XMLAValue.parseFloat(tmpStr));
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return Float.valueOf(1.0f);
                }
                return Float.valueOf(0.0f);
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return Float.valueOf(tmpShort.floatValue());
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return Float.valueOf(tmpInt.floatValue());
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return Float.valueOf(tmpLong.floatValue());
            }
            case FLOAT32: {
                return (Float)this.value;
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return Float.valueOf(tmpDbl.floatValue());
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return Float.valueOf(tmpBigDec.floatValue());
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return Float.valueOf(tmpBigInt.floatValue());
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.FLOAT32);
        return null;
    }

    public Double getDouble() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return XMLAValue.parseDouble(tmpStr);
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return 1.0;
                }
                return 0.0;
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return tmpShort.doubleValue();
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return tmpInt.doubleValue();
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return tmpLong.doubleValue();
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return tmpFloat.doubleValue();
            }
            case FLOAT64: {
                return (Double)this.value;
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return tmpBigDec.doubleValue();
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return tmpBigInt.doubleValue();
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.FLOAT64);
        return null;
    }

    public BigInteger getBigInteger() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return new BigInteger(tmpStr);
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return BigInteger.valueOf(1L);
                }
                return BigInteger.valueOf(0L);
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return BigInteger.valueOf(tmpShort.longValue());
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return BigInteger.valueOf(tmpInt.longValue());
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return BigInteger.valueOf(tmpLong);
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return BigInteger.valueOf(tmpFloat.longValue());
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return BigInteger.valueOf(tmpDbl.longValue());
            }
            case BIG_DECIMAL: {
                BigDecimal tmpBigDec = (BigDecimal)this.value;
                return tmpBigDec.toBigInteger();
            }
            case BIG_INTEGER: {
                return (BigInteger)this.value;
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.BIG_INTEGER);
        return null;
    }

    public BigDecimal getBigDecimal() {
        if (this.isNull() || this.isError()) {
            return null;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                return new BigDecimal(tmpStr);
            }
            case BOOLEAN: {
                Boolean tmpBool = (Boolean)this.value;
                if (tmpBool.booleanValue()) {
                    return BigDecimal.valueOf(1L);
                }
                return BigDecimal.valueOf(0L);
            }
            case INT16: {
                Short tmpShort = (Short)this.value;
                return BigDecimal.valueOf(tmpShort.longValue());
            }
            case INT32: {
                Integer tmpInt = (Integer)this.value;
                return BigDecimal.valueOf(tmpInt.longValue());
            }
            case INT64: {
                Long tmpLong = (Long)this.value;
                return BigDecimal.valueOf(tmpLong);
            }
            case FLOAT32: {
                Float tmpFloat = (Float)this.value;
                return BigDecimal.valueOf(tmpFloat.doubleValue());
            }
            case FLOAT64: {
                Double tmpDbl = (Double)this.value;
                return BigDecimal.valueOf(tmpDbl);
            }
            case BIG_DECIMAL: {
                return (BigDecimal)this.value;
            }
            case BIG_INTEGER: {
                BigInteger tmpBigInt = (BigInteger)this.value;
                return new BigDecimal(tmpBigInt);
            }
        }
        XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.BIG_DECIMAL);
        return null;
    }

    public TimeWithTZValue getTime() {
        TimeWithTZValue result = DataValueFactory.createTimeWithTZValue();
        if (this.isNull()) {
            result.setNull();
            return result;
        }
        if (this.isError()) {
            result.setState(ValueState.ERROR);
            return result;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                result.set((Calendar)XMLAValue.parseXSDDateTime(tmpStr));
                break;
            }
            case TIME_WITH_TZ: {
                TimeWithTZValue tmpTime = (TimeWithTZValue)this.value;
                result.set((IValue)tmpTime);
                break;
            }
            case DATETIME_WITH_TZ: {
                TimestampWithTZValue tmpTS = (TimestampWithTZValue)this.value;
                result.set(tmpTS.getCalendar());
                break;
            }
            default: {
                XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.TIME_WITH_TZ);
            }
        }
        return result;
    }

    public DateValue getDate() {
        DateValue result = DataValueFactory.createDateValue();
        if (this.isNull()) {
            result.setNull();
            return result;
        }
        if (this.isError()) {
            result.setState(ValueState.ERROR);
            return result;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                String tmpStr = (String)this.value;
                result.set((Calendar)XMLAValue.parseXSDDateTime(tmpStr));
                break;
            }
            case DATE_WITH_TZ: {
                DateValue tmpTime = (DateValue)this.value;
                result.set((IValue)tmpTime);
                break;
            }
            case DATETIME_WITH_TZ: {
                TimestampWithTZValue tmpTS = (TimestampWithTZValue)this.value;
                result.set(tmpTS.getDate());
                break;
            }
            default: {
                XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.DATE_WITH_TZ);
            }
        }
        return result;
    }

    public TimestampWithTZValue getDateTime() {
        TimestampWithTZValue result = DataValueFactory.createTimestampWithTZValue();
        if (this.isNull()) {
            result.setNull();
            return result;
        }
        if (this.isError()) {
            result.setState(ValueState.ERROR);
            return result;
        }
        switch (this.dataType) {
            case UNKNOWN: 
            case STRING: {
                Pattern expression;
                Matcher matcher;
                String tmpStr = (String)this.value;
                if (tmpStr.indexOf(90) == -1 && tmpStr.indexOf(43) == -1 && !(matcher = (expression = Pattern.compile("-[0-9][0-9]:[0-9][0-9]")).matcher(tmpStr)).matches()) {
                    tmpStr = tmpStr + GMT_SUFFIX;
                }
                result.set((Calendar)XMLAValue.parseXSDDateTime(tmpStr));
                break;
            }
            case DATE_WITH_TZ: {
                DateValue tmpTime = (DateValue)this.value;
                result.set(tmpTime.getCalendar());
                break;
            }
            case TIME_WITH_TZ: {
                TimeWithTZValue tmpTime = (TimeWithTZValue)this.value;
                result.set(tmpTime.getCalendar());
                break;
            }
            case DATETIME_WITH_TZ: {
                TimestampWithTZValue tmpTS = (TimestampWithTZValue)this.value;
                result.set((IValue)tmpTS);
                break;
            }
            default: {
                XMLAValue.throwConversionError(this.value, this.dataType, ValueTypeEnum.DATETIME_WITH_TZ);
            }
        }
        return result;
    }

    void set(String valueString, ValueTypeEnum valueType) {
        this.state = StateEnum.OK;
        this.dataType = valueType;
        this.value = null;
        if (null == valueString) {
            this.state = StateEnum.NULL;
            return;
        }
        switch (valueType) {
            case UNKNOWN: 
            case STRING: {
                this.value = valueString;
                break;
            }
            case BOOLEAN: {
                this.value = XMLAValue.parseBoolean(valueString);
                break;
            }
            case INT16: {
                this.value = XMLAValue.parseShort(valueString);
                break;
            }
            case INT32: {
                this.value = XMLAValue.parseInt(valueString);
                break;
            }
            case INT64: {
                this.value = XMLAValue.parseLong(valueString);
                break;
            }
            case FLOAT32: {
                this.value = Float.valueOf(XMLAValue.parseFloat(valueString));
                break;
            }
            case FLOAT64: {
                this.value = XMLAValue.parseDouble(valueString);
                break;
            }
            case BIG_INTEGER: {
                this.value = new BigInteger(valueString);
                break;
            }
            case BIG_DECIMAL: {
                this.value = new BigDecimal(valueString);
                break;
            }
            case DATE_WITH_TZ: {
                this.value = DataValueFactory.createDateValue();
                ((DateValue)this.value).set((Calendar)XMLAValue.parseXSDDateTime(valueString));
                break;
            }
            case TIME_WITH_TZ: {
                this.value = DataValueFactory.createTimeWithTZValue();
                ((TimeWithTZValue)this.value).set((Calendar)XMLAValue.parseXSDDateTime(valueString));
                break;
            }
            case DATETIME_WITH_TZ: {
                this.value = DataValueFactory.createTimestampWithTZValue();
                ((TimestampWithTZValue)this.value).set((Calendar)XMLAValue.parseXSDDateTime(valueString));
                break;
            }
            default: {
                XMLAValue.throwConversionError(this.value, ValueTypeEnum.STRING, valueType);
            }
        }
    }

    void setBoolean(Boolean booleanValue) {
        this.value = booleanValue;
        this.dataType = ValueTypeEnum.BOOLEAN;
        this.state = null == booleanValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setShort(Short shortValue) {
        this.value = shortValue;
        this.dataType = ValueTypeEnum.INT16;
        this.state = null == shortValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setInteger(Integer intValue) {
        this.value = intValue;
        this.dataType = ValueTypeEnum.INT32;
        this.state = null == intValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setLong(Long longValue) {
        this.value = longValue;
        this.dataType = ValueTypeEnum.INT64;
        this.state = null == longValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setFloat(Float floatValue) {
        this.value = floatValue;
        this.dataType = ValueTypeEnum.FLOAT32;
        this.state = null == floatValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setDouble(Double doubleValue) {
        this.value = doubleValue;
        this.dataType = ValueTypeEnum.FLOAT64;
        this.state = null == doubleValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setBigInteger(BigInteger bigIntValue) {
        this.value = bigIntValue;
        this.dataType = ValueTypeEnum.BIG_INTEGER;
        this.state = null == bigIntValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setBigDecimal(BigDecimal bigDecValue) {
        this.value = bigDecValue;
        this.dataType = ValueTypeEnum.BIG_DECIMAL;
        this.state = null == bigDecValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setDate(DateValue dateValue) {
        this.value = dateValue;
        this.dataType = ValueTypeEnum.DATE_WITH_TZ;
        this.state = null == dateValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setTime(TimeWithTZValue timeValue) {
        this.value = timeValue;
        this.dataType = ValueTypeEnum.TIME_WITH_TZ;
        this.state = null == timeValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setDateTime(TimestampWithTZValue tsWithTZValue) {
        this.value = tsWithTZValue;
        this.dataType = ValueTypeEnum.DATETIME_WITH_TZ;
        this.state = null == tsWithTZValue ? StateEnum.NULL : StateEnum.OK;
    }

    void setError(XMLAErrorValue error) {
        this.state = StateEnum.ERROR;
        this.dataType = ValueTypeEnum.UNKNOWN;
        this.value = error;
    }

    public void dumpXML(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("XMLAValue");
        writer.writeAttribute("state", this.state.toString());
        writer.writeAttribute("dataType", this.dataType.toString());
        if (!this.isNull()) {
            writer.writeCharacters(this.getString());
        }
        writer.writeEndElement();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof XMLAValue)) {
            return this.toString().equals(other.toString());
        }
        XMLAValue otherValue = (XMLAValue)other;
        if (this.dataType != otherValue.dataType) {
            return false;
        }
        if (this.state != otherValue.state) {
            return false;
        }
        return this.value.equals(otherValue.value);
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append((Object)this.dataType);
        hcb.append((Object)this.state);
        hcb.append(this.value);
        return hcb.toHashCode();
    }

    public String toString() {
        if (this.isNull()) {
            return "null";
        }
        return this.value.toString();
    }

    public static XMLAValue errorOf(XMLAErrorValue value) {
        XMLAValue result = new XMLAValue();
        result.setError(value);
        return result;
    }

    public static XMLAValue nullOf(ValueTypeEnum type) {
        switch (type) {
            case UNKNOWN: {
                return NULL_UNKNOWN;
            }
            case VARIANT: {
                return NULL_VARIANT;
            }
            case STRING: {
                return NULL_STRING;
            }
            case BOOLEAN: {
                return NULL_BOOLEAN;
            }
            case INT16: {
                return NULL_INT16;
            }
            case INT32: {
                return NULL_INT32;
            }
            case INT64: {
                return NULL_INT64;
            }
            case BIG_INTEGER: {
                return NULL_BIG_INTEGER;
            }
            case FLOAT32: {
                return NULL_FLOAT32;
            }
            case FLOAT64: {
                return NULL_FLOAT64;
            }
            case BIG_DECIMAL: {
                return NULL_BIG_DECIMAL;
            }
            case DATE_WITH_TZ: {
                return NULL_DATE_WITH_TZ;
            }
            case TIME_WITH_TZ: {
                return NULL_TIME_WITH_TZ;
            }
            case DATETIME_WITH_TZ: {
                return NULL_DATETIME_WITH_TZ;
            }
        }
        return null;
    }

    public static XMLAValue valueOf(String value) {
        XMLAValue result = new XMLAValue();
        result.set(value, ValueTypeEnum.STRING);
        return result;
    }

    public static XMLAValue valueOf(String value, ValueTypeEnum type) {
        XMLAValue result = new XMLAValue();
        result.set(value, type);
        return result;
    }

    public static XMLAValue valueOf(Boolean value) {
        XMLAValue result = new XMLAValue();
        result.setBoolean(value);
        return result;
    }

    public static XMLAValue valueOf(Short value) {
        XMLAValue result = new XMLAValue();
        result.setShort(value);
        return result;
    }

    public static XMLAValue valueOf(Integer value) {
        XMLAValue result = new XMLAValue();
        result.setInteger(value);
        return result;
    }

    public static XMLAValue valueOf(Long value) {
        XMLAValue result = new XMLAValue();
        result.setLong(value);
        return result;
    }

    public static XMLAValue valueOf(Float value) {
        XMLAValue result = new XMLAValue();
        result.setFloat(value);
        return result;
    }

    public static XMLAValue valueOf(Double value) {
        XMLAValue result = new XMLAValue();
        result.setDouble(value);
        return result;
    }

    public static XMLAValue valueOf(BigInteger value) {
        XMLAValue result = new XMLAValue();
        result.setBigInteger(value);
        return result;
    }

    public static XMLAValue valueOf(BigDecimal value) {
        XMLAValue result = new XMLAValue();
        result.setBigDecimal(value);
        return result;
    }

    public static XMLAValue valueOf(DateValue value) {
        XMLAValue result = new XMLAValue();
        result.setDate(value);
        return result;
    }

    public static XMLAValue valueOf(TimeWithTZValue value) {
        XMLAValue result = new XMLAValue();
        result.setTime(value);
        return result;
    }

    public static XMLAValue valueOf(TimestampWithTZValue value) {
        XMLAValue result = new XMLAValue();
        result.setDateTime(value);
        return result;
    }

    private static GregorianCalendar parseXSDDateTime(String xsdDateTime) {
        GregorianCalendar parsedValue;
        XMLGregorianCalendar xmlCalendar = xmlSchemaTypeFactory.newXMLGregorianCalendar(xsdDateTime);
        try {
            parsedValue = xmlCalendar.toGregorianCalendar();
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
            sb.append(SPACE);
            sb.append(t.getLocalizedMessage());
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToParseValue, sb.toString());
        }
        return parsedValue;
    }

    private static boolean parseBoolean(String booleanString) {
        if (booleanString.length() == 0) {
            return false;
        }
        return TRUE_LCASE.equals(booleanString) || TRUE_UCASE.equals(booleanString) || ONE.equals(booleanString);
    }

    private static short parseShort(String shortString) {
        short parsedValue;
        if (shortString.length() == 0) {
            return 0;
        }
        try {
            parsedValue = Short.parseShort(shortString);
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
            sb.append(SPACE);
            sb.append(t.getLocalizedMessage());
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToParseValue, sb.toString());
        }
        return parsedValue;
    }

    private static int parseInt(String intString) {
        int parsedValue;
        if (intString.length() == 0) {
            return 0;
        }
        try {
            parsedValue = Integer.parseInt(intString);
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
            sb.append(SPACE);
            sb.append(t.getLocalizedMessage());
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToParseValue, sb.toString());
        }
        return parsedValue;
    }

    private static long parseLong(String longString) {
        long parsedValue;
        if (longString.length() == 0) {
            return 0L;
        }
        try {
            parsedValue = Long.parseLong(longString);
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
            sb.append(SPACE);
            sb.append(t.getLocalizedMessage());
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToParseValue, sb.toString());
        }
        return parsedValue;
    }

    private static float parseFloat(String floatString) {
        float parsedValue;
        if (floatString.length() == 0) {
            return 0.0f;
        }
        if (XMLAValue.stringIsNAN(floatString)) {
            return Float.NaN;
        }
        if (XMLAValue.stringIsNegativeInfinity(floatString)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (XMLAValue.stringIsPositiveInfinity(floatString)) {
            return Float.POSITIVE_INFINITY;
        }
        try {
            parsedValue = Float.parseFloat(floatString);
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
            sb.append(SPACE);
            sb.append(t.getLocalizedMessage());
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToParseValue, sb.toString());
        }
        return parsedValue;
    }

    private static double parseDouble(String doubleString) {
        double parsedValue;
        if (doubleString.length() == 0) {
            return 0.0;
        }
        if (XMLAValue.stringIsNAN(doubleString)) {
            return Double.NaN;
        }
        if (XMLAValue.stringIsNegativeInfinity(doubleString)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (XMLAValue.stringIsPositiveInfinity(doubleString)) {
            return Double.POSITIVE_INFINITY;
        }
        try {
            parsedValue = Double.parseDouble(doubleString);
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder(t.getClass().getSimpleName());
            sb.append(SPACE);
            sb.append(t.getLocalizedMessage());
            throw new XQERuntimeException(XQEMessageKeys.EXE_UnableToParseValue, sb.toString());
        }
        return parsedValue;
    }

    private static boolean stringIsNAN(String valueString) {
        return INDETERMINATE_FORM.equals(valueString) || NAN.equals(valueString) || NAN2.equals(valueString) || QNAN.equals(valueString) || SNAN.equals(valueString);
    }

    private static boolean stringIsPositiveInfinity(String valueString) {
        return POS_INFINITY.equals(valueString) || POS_INF.equals(valueString) || POS_1_INF.equals(valueString);
    }

    private static boolean stringIsNegativeInfinity(String valueString) {
        return NEG_INFINITY.equals(valueString) || NEG_INF.equals(valueString) || NEG_1_INF.equals(valueString);
    }

    private static void throwConversionError(Object theValue, ValueTypeEnum fromType, ValueTypeEnum toType) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.DAT_GeneralConversionError, (Object)fromType.toString(), (Object)theValue.toString(), (Object)toType.toString());
    }

    static {
        try {
            xmlSchemaTypeFactory = DatatypeFactory.newInstance();
        }
        catch (Exception ex) {
            throw XQERuntimeException.wrap((Throwable)ex);
        }
    }

    private static enum StateEnum {
        OK,
        NULL,
        ERROR;

    }
}

