/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp;

import com.cognos.xqe.bibushandler.CancelRequestSourceEnum;
import com.cognos.xqe.bibushandler.CancelUnsuccessfulException;
import com.cognos.xqe.bibushandler.ICancelable;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPTabularResultSet;
import com.cognos.xqe.data.providers.relational.erp.sfdc.SFDCTabularResult;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelTabularResult;
import com.cognos.xqe.resultset.interfaces.ITabularResultSet;
import com.cognos.xqe.trace.LogLevel;

public class ERPCancelHandler
implements ICancelable {
    private ITabularResultSet resultSet;

    public ERPCancelHandler(ITabularResultSet result) {
        this.resultSet = result;
    }

    public void cancel() {
        ERPLog.getLogger(LogLevel.ERROR).log("ERP CancelHandler called");
        if (this.resultSet instanceof SAPTabularResultSet) {
            if (!((SAPTabularResultSet)this.resultSet).isCanceled()) {
                ((SAPTabularResultSet)this.resultSet).setCanceled(true);
            }
        } else if (this.resultSet instanceof SiebelTabularResult) {
            if (!((SiebelTabularResult)this.resultSet).isCanceled()) {
                ((SiebelTabularResult)this.resultSet).setCanceled(true);
            }
        } else if (this.resultSet instanceof SFDCTabularResult && !((SFDCTabularResult)this.resultSet).isCanceled()) {
            ((SFDCTabularResult)this.resultSet).setCanceled(true);
        }
    }

    public synchronized void cancel(CancelRequestSourceEnum cancelSource) throws CancelUnsuccessfulException {
        throw new CancelUnsuccessfulException();
    }
}

