/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp;

import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.connection.parameters.DataSourceParameter;
import com.cognos.xqe.data.providers.connection.parameters.RunLocaleParameter;
import com.cognos.xqe.data.providers.relational.erp.ERPConnection;
import com.cognos.xqe.data.providers.relational.erp.ERPDataProvider;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPConnection;
import com.cognos.xqe.data.providers.relational.erp.sfdc.SFDCConnection;
import com.cognos.xqe.data.providers.relational.erp.siebel.SiebelConnection;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.trace.LogLevel;
import java.util.Locale;

public final class ERPConnectionFactory
implements IConnectionFactory {
    public Object createConnection(ConnectionParameters parameters) {
        IDataSource dataSource = (IDataSource)parameters.valueOf(DataSourceParameter.class, IDataSource.class);
        Locale locale = (Locale)parameters.valueOf(RunLocaleParameter.class, Locale.class);
        ERPConnection connection = null;
        String erpPrefix = "ERP-";
        String dbType = dataSource.getType();
        if (dbType.startsWith(erpPrefix)) {
            String subType = dbType.substring(erpPrefix.length());
            if (ERPDataProvider.ERPDataProviderType.SIEBEL.name().equalsIgnoreCase(subType)) {
                if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
                    ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPConnectionFactory.createConnection SiebelConnection");
                }
                connection = new SiebelConnection(dataSource);
            } else if (ERPDataProvider.ERPDataProviderType.SAP.name().equalsIgnoreCase(subType)) {
                connection = new SAPConnection(dataSource);
            } else if (ERPDataProvider.ERPDataProviderType.SFDC.name().equalsIgnoreCase(subType)) {
                connection = new SFDCConnection(dataSource);
            }
        }
        if (connection != null) {
            try {
                if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
                    ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPConnectionFactory.createConnection connect");
                }
                connection.connect(locale);
            }
            catch (LogonFailureException e) {
                if (ERPLog.getLogger().isOn()) {
                    ERPLog.getLogger().log("Error in login");
                }
                ERPLog.getLogger(LogLevel.ERROR).log((Throwable)e);
                throw e;
            }
        } else if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
            ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPConnectionFactory.createConnection connect is NULL");
        }
        return connection;
    }

    public void destroyConnection(IPooledConnection pooledConnection) {
        try {
            if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
                ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPConnectionFactory.destroyConnection-1 disconnect");
            }
            ((ERPConnection)((Object)pooledConnection.getConnection())).disconnect();
        }
        catch (ERPException e) {
            if (ERPLog.getLogger().isOn()) {
                ERPLog.getLogger().log("Error in destroy connection");
            }
            ERPLog.getLogger(LogLevel.ERROR).log((Throwable)((Object)e));
            Object var2_3 = null;
        }
    }

    public void destroyConnection(ERPConnection erpConnection) {
        try {
            if (ERPLog.getLogger(LogLevel.TRACE).isOn()) {
                ERPLog.getLogger(LogLevel.TRACE).log("ErpLog ERPConnectionFactory.destroyConnection-2 disconnect");
            }
            erpConnection.disconnect();
        }
        catch (ERPException e) {
            ERPLog.getLogger(LogLevel.ERROR).log((Throwable)((Object)e));
        }
    }
}

