/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap;

import com.cognos.xqe.ast.sql.SQLBetween;
import com.cognos.xqe.ast.sql.SQLColumn;
import com.cognos.xqe.ast.sql.SQLComparison;
import com.cognos.xqe.ast.sql.SQLIn;
import com.cognos.xqe.ast.sql.SQLIsNull;
import com.cognos.xqe.ast.sql.SQLLike;
import com.cognos.xqe.ast.sql.SQLLiteral;
import com.cognos.xqe.ast.sql.SQLLogical;
import com.cognos.xqe.ast.sql.SQLQueryNode;
import com.cognos.xqe.ast.sql.SQLValueList;
import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.SAPWhereClauseHandler;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPSelectionField;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class SAPABAPWhereClauseHandler
extends SAPWhereClauseHandler
implements SAPConstants {
    private static final String SAP_SELECTION_EQ = "I";
    private static final String SAP_SELECTION_NOT_EQ = "E";
    private List<SAPSelectionField> filters;
    private Map<String, FieldWrapper> fieldWrapperMap = new HashMap<String, FieldWrapper>();
    private Stack<Boolean> currExpressionType;
    private boolean fieldWrappersProcessed = false;
    private static SAPLogger logger = SAPLoggerFactory.getLogger(SAPABAPWhereClauseHandler.class);

    public SAPABAPWhereClauseHandler(String tabName, List<IMetadata> querySubjectList) {
        super(tabName, querySubjectList);
        this.filters = new ArrayList<SAPSelectionField>();
        this.currExpressionType = new Stack();
    }

    private void processFilters(boolean isInfosetQuery) {
        if (logger.isDebug()) {
            logger.debug("Processing filters for ABAP ");
        }
        ArrayList<SAPSelectionField> processedFilters = new ArrayList<SAPSelectionField>();
        for (SAPSelectionField field : this.filters) {
            String name = field.getSelectName();
            if (!isInfosetQuery && name.charAt(0) != '_') continue;
            String techName = this.getTechnicalName(this.tableName, name);
            field.setSelectName(techName);
            field.setSelectDesc(name);
            processedFilters.add(field);
        }
        if (logger.isDebug()) {
            logger.debug("Processed filters " + this.filters);
        }
        this.filters = processedFilters;
    }

    @Override
    public void handle(SQLLogical logicalExpr) {
        if (logger.isDebug()) {
            logger.debug("Processing SQLLogical " + logicalExpr.dumpToString());
        }
        if (logicalExpr.getNumberChildren() == 1) {
            this.currExpressionType.push(Boolean.TRUE);
            this.handle((SQLQueryNode)logicalExpr.getChild(0));
            this.currExpressionType.pop();
        } else {
            this.currExpressionType.push(Boolean.FALSE);
            this.handle((SQLQueryNode)logicalExpr.getChild(0));
            this.currExpressionType.pop();
            this.currExpressionType.push(Boolean.FALSE);
            this.handle((SQLQueryNode)logicalExpr.getChild(1));
            this.currExpressionType.pop();
        }
    }

    private boolean isNotExpression() {
        if (this.currExpressionType.isEmpty()) {
            return false;
        }
        return this.currExpressionType.peek();
    }

    @Override
    public void handle(SQLLike likeExpr) {
        throw new ERPException(XQEMessageKeys.ERP_OperatorNotSupported, "LIKE", "ABAP/Infoset Queries");
    }

    @Override
    public void handle(SQLIsNull isnullExpr) {
        if (logger.isDebug()) {
            logger.debug("Processing SQLIsNull " + isnullExpr.dumpToString());
        }
        SAPSelectionField field = new SAPSelectionField();
        field.setSelectName(isnullExpr.getChild(0).getPropertyValue("name").toString());
        field.setLow("");
        field.setOption(this.getOption("="));
        this.setSign(field);
        this.filters.add(field);
    }

    private void setSign(SAPSelectionField field) {
        if (this.isNotExpression()) {
            field.setSign(SAP_SELECTION_NOT_EQ);
        } else {
            field.setSign(SAP_SELECTION_EQ);
        }
    }

    @Override
    public void handle(SQLIn inExpr) {
        if (logger.isDebug()) {
            logger.debug("Processing SQLIn " + inExpr.dumpToString());
        }
        SQLColumn column = (SQLColumn)inExpr.getChild(0);
        SQLValueList list = (SQLValueList)inExpr.getChild(1);
        int noOfChildren = list.getNumberChildren();
        for (int index = 0; index < noOfChildren; ++index) {
            SAPSelectionField field = new SAPSelectionField();
            SQLLiteral literal = (SQLLiteral)list.getChild(index);
            field.setSelectName(column.getName());
            field.setOption("EQ");
            field.setLow(literal.getValue().getString());
            this.setSign(field);
            this.filters.add(field);
        }
    }

    @Override
    public void handle(SQLComparison compExpr) {
        if (logger.isDebug()) {
            logger.debug("Processing SQLComparison " + compExpr.dumpToString());
        }
        SQLColumn col = (SQLColumn)compExpr.getChild(0);
        SQLLiteral lit = (SQLLiteral)compExpr.getChild(1);
        String fieldname = col.getName();
        String fieldvalue = lit.getValue().getString();
        double doubleFieldValue = 0.0;
        boolean isNumber = false;
        if (this.tableName != null && this.isDecimalField(this.tableName, fieldname)) {
            doubleFieldValue = Double.parseDouble(fieldvalue);
            if (logger.isDebug()) {
                logger.debug("Double value parsed " + doubleFieldValue);
            }
            isNumber = true;
        }
        String operator = this.getOperator(compExpr.getSubType());
        FieldWrapper cnode = null;
        if (isNumber && (operator.equals("<=") || operator.equals(">=") || operator.equals("<") || operator.equals(">"))) {
            if (operator.equals("<=") || operator.equals("<")) {
                if (this.fieldWrapperMap.containsKey(fieldname)) {
                    cnode = this.fieldWrapperMap.get(fieldname);
                    if (cnode.isUpperLimitSet()) {
                        if (doubleFieldValue < cnode.getUpperLimit()) {
                            cnode.setUpperLimit(doubleFieldValue, operator);
                        }
                    } else {
                        cnode.setUpperLimit(doubleFieldValue, operator);
                    }
                } else {
                    cnode = new FieldWrapper(fieldname, doubleFieldValue, operator);
                    this.fieldWrapperMap.put(fieldname, cnode);
                }
            } else if (operator.equals(">=") || operator.equals(">")) {
                if (this.fieldWrapperMap.containsKey(fieldname)) {
                    cnode = this.fieldWrapperMap.get(fieldname);
                    if (cnode.isLowerLimitSet()) {
                        if (doubleFieldValue > cnode.getLowerLimit()) {
                            cnode.setLowerLimit(doubleFieldValue, operator);
                        }
                    } else {
                        cnode.setLowerLimit(doubleFieldValue, operator);
                    }
                } else {
                    cnode = new FieldWrapper(fieldname, doubleFieldValue, operator);
                    this.fieldWrapperMap.put(fieldname, cnode);
                }
            }
        } else {
            SAPSelectionField field = new SAPSelectionField();
            field.setSelectName(fieldname);
            field.setOption(this.getOption(operator));
            field.setLow(fieldvalue);
            this.setSign(field);
            this.filters.add(field);
        }
    }

    private String getOption(String operator) {
        String option = null;
        if (operator.equals("=")) {
            option = "EQ";
        } else if (operator.equals("<>")) {
            option = "NE";
        } else if (operator.equals("<")) {
            option = "LT";
        } else if (operator.equals("<=")) {
            option = "LE";
        } else if (operator.equals(">")) {
            option = "GT";
        } else if (operator.equals(">=")) {
            option = "GE";
        } else {
            throw new XQERuntimeException();
        }
        return option;
    }

    @Override
    public void handle(SQLBetween betExpr) {
        if (logger.isDebug()) {
            logger.debug("Processing SQLBetween " + betExpr.dumpToString());
        }
        SQLColumn col = (SQLColumn)betExpr.getChild(0);
        SQLLiteral lit1 = (SQLLiteral)betExpr.getChild(1);
        SQLLiteral lit2 = (SQLLiteral)betExpr.getChild(2);
        SAPSelectionField field = new SAPSelectionField();
        field.setSelectName(col.getName());
        this.setSign(field);
        field.setLow(lit1.getValue().getString());
        field.setHigh(lit2.getValue().getString());
        this.filters.add(field);
    }

    public List<SAPSelectionField> getFilters(boolean isInfosetQuery) {
        if (!this.fieldWrappersProcessed) {
            this.processFieldWappers();
            this.processFilters(isInfosetQuery);
            this.fieldWrappersProcessed = true;
        }
        if (logger.isDebug()) {
            logger.debug("Filter List" + this.filters);
        }
        return this.filters;
    }

    private void processFieldWappers() {
        if (logger.isDebug()) {
            logger.debug("Processing field wrappers ");
        }
        for (FieldWrapper fieldWrapper : this.fieldWrapperMap.values()) {
            SAPSelectionField field;
            if (fieldWrapper.isUpperLimitSet() && fieldWrapper.isLowerLimitSet()) {
                field = new SAPSelectionField();
                field.setSelectName(fieldWrapper.getFieldName());
                field.setOption("BT");
                field.setLow("" + fieldWrapper.getLowerLimit());
                field.setHigh("" + fieldWrapper.getUpperLimit());
                field.setSign(SAP_SELECTION_EQ);
                this.filters.add(field);
                if (!fieldWrapper.isLowerLimitInclusive()) {
                    SAPSelectionField f1 = new SAPSelectionField();
                    f1.setSelectName(fieldWrapper.getFieldName());
                    f1.setOption("EQ");
                    f1.setLow("" + fieldWrapper.getLowerLimit());
                    f1.setSign(SAP_SELECTION_NOT_EQ);
                    this.filters.add(f1);
                }
                if (fieldWrapper.isUpperLimitInclusive()) continue;
                SAPSelectionField f2 = new SAPSelectionField();
                f2.setSelectName(fieldWrapper.getFieldName());
                f2.setOption("EQ");
                f2.setLow("" + fieldWrapper.getUpperLimit());
                f2.setSign(SAP_SELECTION_NOT_EQ);
                this.filters.add(f2);
                continue;
            }
            field = new SAPSelectionField();
            field.setSelectName(fieldWrapper.getFieldName());
            field.setSign(SAP_SELECTION_EQ);
            if (fieldWrapper.isUpperLimitSet()) {
                if (fieldWrapper.isUpperLimitInclusive()) {
                    field.setOption("LE");
                } else {
                    field.setOption("LT");
                }
                field.setLow("" + fieldWrapper.getUpperLimit());
                this.filters.add(field);
            } else {
                if (fieldWrapper.isLowerLimitInclusive()) {
                    field.setOption("GE");
                } else {
                    field.setOption("GT");
                }
                field.setLow("" + fieldWrapper.getLowerLimit());
            }
            this.filters.add(field);
        }
    }

    private static class FieldWrapper {
        private String fieldName;
        private double upperLimit;
        private double lowerLimit;
        private boolean upperLimitSet = false;
        private boolean lowerLimitSet = false;
        private boolean upperLimitInclusive = true;
        private boolean lowerLimitInclusive = true;

        FieldWrapper(String name, double value, String operator) {
            this.fieldName = name;
            if (operator.equals("<=") || operator.equals("<")) {
                this.upperLimit = value;
                this.upperLimitSet = true;
            } else if (operator.equals(">=") || operator.equals(">")) {
                this.lowerLimit = value;
                this.lowerLimitSet = true;
            }
            if (operator.equals("<")) {
                this.upperLimitInclusive = false;
            } else if (operator.equals(">")) {
                this.lowerLimitInclusive = false;
            }
        }

        void setLowerLimit(double doubleFieldValue, String operator) {
            if (operator.equals(">")) {
                this.lowerLimitInclusive = false;
            }
            this.lowerLimit = doubleFieldValue;
            this.lowerLimitSet = true;
        }

        void setUpperLimit(double doubleFieldValue, String operator) {
            if (operator.equals("<")) {
                this.upperLimitInclusive = false;
            }
            this.upperLimit = doubleFieldValue;
            this.upperLimitSet = true;
        }

        String getFieldName() {
            return this.fieldName;
        }

        double getUpperLimit() {
            return this.upperLimit;
        }

        double getLowerLimit() {
            return this.lowerLimit;
        }

        boolean isUpperLimitSet() {
            return this.upperLimitSet;
        }

        boolean isLowerLimitSet() {
            return this.lowerLimitSet;
        }

        boolean isUpperLimitInclusive() {
            return this.upperLimitInclusive;
        }

        boolean isLowerLimitInclusive() {
            return this.lowerLimitInclusive;
        }
    }
}

